USE chyt.hahn/taxi-delivery;


--create table "//home/taxi-delivery/analytics/dev/ndd/alert_client_wow" engine=YtTable() as 
insert into "<append=false>//home/taxi-delivery/analytics/dev/ndd/alert_client_wow"
select 
employer_code, corp_client_id,  
coalesce(today_cnt, 0) as today_cnt, 
coalesce(today_cnt_lw, 0) as today_cnt_lw,
coalesce(yesterday_cnt, 0) as yesterday_cnt,
coalesce(yesterday_cnt_lw, 0) as yesterday_cnt_lw, 
coalesce(dby_cnt, 0) as dby_cnt,
coalesce(dby_cnt_lw, 0) as dby_cnt_lw,
(today_cnt < (today_cnt_lw - today_cnt_lw*0.3)) and
(yesterday_cnt < (yesterday_cnt_lw - yesterday_cnt_lw*0.3)) and 
(dby_cnt < (dby_cnt_lw - dby_cnt_lw*0.3))
 as alert
from
(select
employer_code, corp_client_id, avg(case when dt = toDate(today()) then cnt else null end) as today_cnt,
avg(case when dt = toDate(yesterday()) then cnt else null end) as yesterday_cnt,
avg(case when dt = toDate(timestamp_add(today(), interval -2 day)) then cnt else null end) as dby_cnt
from  
(SELECT
-- 
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'smol'
        else employer_code
    end as employer_code,
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'Агрегация по тем, кто платит через ЛК'
        else corp_client_id
    end as corp_client_id,
-- 
    toDate(left(created_dttm, 10)) as dt,
    count(distinct request_code)/count(distinct employer_code) as cnt
FROM `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
group by 
 employer_code,
    corp_client_id, dt 
having dt between toDate(timestamp_add(today(), interval -6 day)) and  toDate(today())
) as raw 
group by 
employer_code, corp_client_id
) as cw
left join 
(select
employer_code, corp_client_id, 
avg(case when dt = toDate(timestamp_add(today(), interval -7 day)) then cnt else null end) as today_cnt_lw,
avg(case when dt = toDate(timestamp_add(today(), interval -8 day)) then cnt else null end) as yesterday_cnt_lw,
avg(case when dt = toDate(timestamp_add(today(), interval -9 day)) then cnt else null end) as dby_cnt_lw
from  
(SELECT
-- 
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'smol'
        else employer_code
    end as employer_code,
    case 
        when creation_method_human = 'ЛК (внешние клиенты)' then 'Агрегация по тем, кто платит через ЛК'
        else corp_client_id
    end as corp_client_id,
-- 
    toDate(left(created_dttm, 10)) as dt,
    count(distinct request_code)/count(distinct employer_code) as cnt
FROM `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
group by 
 employer_code,
    corp_client_id, dt 
having dt between toDate(timestamp_add(today(), interval -13 day)) and  toDate(timestamp_add(today(), interval -7 day))
) as raw 
group by 
employer_code, corp_client_id
) as lw
on lw.employer_code = cw.employer_code
    and lw.corp_client_id = cw.corp_client_id
