use hahn;
PRAGMA yson.DisableStrict;

$parse = DateTime::Parse("%Y-%m-%dT%H:%M:%SZ");
$format = DateTime::Format('%Y-%m-%d %H:%M:%S');
$add_tz = ($datetime, $timezone) -> {
    $tz = AddTimezone(DateTime::MakeDatetime($parse($datetime)), $timezone);
    return $format($tz);
};

$save_to = '//home/taxi-delivery/analytics/dev/ndd/ndd_main_dash';
$requests_datamart = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$client_manager = '//home/taxi-delivery/analytics/production/ndd/client_manager';


$big_select = (
    select
        mapped_event_type
        , $add_tz(created_dttm, 'UTC') as utc_created_dttm
        , $add_tz(created_dttm, 'Europe/Moscow') as msk_created_dttm
        , $add_tz(created_dttm, timezone_A) as a_created_dttm
        , creation_method_human
        , $add_tz(event_instant_ddtm, 'UTC') as utc_event_dttm
        , $add_tz(event_instant_ddtm, 'Europe/Moscow') as msk_event_dttm
        , $add_tz(event_instant_ddtm, timezone_B) as b_event_dttm
        , request_code
        , request_id
        , employer_code
        , brand_name
        , lead_name
        , self_registered_flg
        , manager_login
        , manager_name
        , policy
        , delivery_region_name ?? delivery_region ?? delivery_settlement as delivery_region_name
        , station_location_federal_district
        , station_operator_id
        , operator_id
        , payment_method
        , referal_source
        , t1.corp_client_id as corp_client_id
        , row_number() over (partition by t1.request_id, t1.mapped_event_type, t1.employer_code order by history_event_id) as rn
    from $requests_datamart as t1
    left join $client_manager as t2
        on t1.corp_client_id = t2.corp_client_id
);

INSERT INTO $save_to WITH TRUNCATE 
select 
    mapped_event_type
    , creation_method_human
    , utc_created_dttm
    , msk_created_dttm
    , a_created_dttm
    , utc_event_dttm
    , msk_event_dttm
    , b_event_dttm
    , request_code
    , request_id
    , employer_code
    , brand_name
    , lead_name
    , self_registered_flg
    , manager_login
    , manager_name
    , policy
    , delivery_region_name
    , station_location_federal_district as point_a_region_name
    , station_operator_id
    , operator_id
    , payment_method
    , referal_source
    , corp_client_id
from $big_select
where rn = 1
    and employer_code <> 'Eva'
    and employer_code <> 'akk'
;
