use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;

$todatetime = ($x) -> (
    substring($x, 0, 10)||' '||substring($x, 11, 8)
);

$lom_ord = (
    select
        barcode,
        external_id,
        return_sorting_center_id,
        t3.sc_name as name
    from `//home/cdc/prod/market/logistics_lom/orders` as t1
    left join `//home/market/production/tpl/sc/cdc/sorting_center` as t3
        on t1.return_sorting_center_id = t3.id
    where credentials_inn = "7716760301"
);

-- LRM
$tracker=(
    select
        order_id
        , logistic_point_id
        , partner_name as current_sc_name
        , $todatetime(fact_income_datetime) as fact_income_datetime
        , $todatetime(fact_outcome_datetime) as fact_outcome_datetime
    from
        `//home/market/production/analytics/business/delivery/full_return_segment`
);



$requests_datamart = (
    select distinct
        'LO-'||external_order_id as barcode,
        employer_code,
        brand_name,
        request_code,
        x_coord_A,
        y_coord_A,
        station_location_full_address
    from `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
);

INSERT INTO `//home/taxi-delivery/analytics/dev/ndd/tarny_returns_v2` WITH TRUNCATE
select
    barcode
    , return_sorting_center_id
    , return_sorting_center_nm
    , current_sorting_center_nm
    , fact_income_datetime
    , fact_outcome_datetime
    , employer_code
    , shop_nm
    , request_code
    , x_coord_A
    , y_coord_A
    , station_location_full_address
    , max(c.sc_number) as sc_cell_number
from $lom_ord as lom_ord
left join `home/market/production/tpl/sc/cdc/orders` as ord
    on lom_ord.barcode  = ord.external_id
inner join $tracker as tr
    on lom_ord.external_id = tr.order_id
left JOIN $requests_datamart as t4
    ON lom_ord.barcode = t4.barcode
left join `//home/market/production/tpl/sc/cdc/place` as p
    on ord.id = p.order_id
left join `//home/market/production/tpl/sc/cdc/cell` as c
    on c.id = p.cell_id
where fact_income_datetime >= '2022-01-01 00:00:00'
group by
    lom_ord.barcode as barcode
    , lom_ord.return_sorting_center_id as return_sorting_center_id
    , lom_ord.name as return_sorting_center_nm
    , current_sc_name as current_sorting_center_nm
    , tr.fact_income_datetime as fact_income_datetime
    , case when tr.fact_outcome_datetime = '1970-01-01 00:00:00' then null else tr.fact_outcome_datetime end as fact_outcome_datetime
    , t4.employer_code as employer_code
    , t4.brand_name as shop_nm
    , t4.request_code as request_code
    , t4.x_coord_A as x_coord_A
    , t4.y_coord_A as y_coord_A
    , t4.station_location_full_address as station_location_full_address
;
