use chyt.hahn;


INSERT INTO "<append=false>//home/taxi-delivery/analytics/dev/ndd/not_only_logplatform"
    select
        shiftDate
        , sortingCenterName
        , 'Маркет NDD' as type
        , toUInt64(sum(kgtDelivered+mgtDelivered)) as cnt_deliveries
    from
        concatYtTablesRange(`//home/market/production/tpl/billing/courier/v_user_shift_aggregated_folder`, '2021-01-17')
    where companyName in ('Яндекс.GO', 'Яндекс.Доставка')
    group by
        shiftDate
        , sortingCenterName
union all
    select
        substring(utc_event_dttm, 1, 10) as shiftDate
        , '' as sortingCenterName
        , type
        , count(distinct request_id) as cnt_deliveries
    from `//home/taxi-delivery/analytics/dev/ndd/ndd_main_dash`
    where mapped_event_type in ('Доставлен', 'Доставлен частично')
    group by
        shiftDate,
        case 
            when employer_code = 'tsa' then 'Клиенты: Cainiao'
            else 'Клиенты: прочие (кроме Cainiao)'
          end as type
union all
    select
        date as shiftDate
        , '' as sortingCenterName
        , 'Клиенты: Cainiao (внешняя курьерка)' as type
        , toUInt64(argMax(cnt_deliveries, created)) as cnt_deliveries
    from
        (
        select
            created,
            YPathString(answer, '/data/answer_date_941213/value') as date,
            YPathInt64(answer, '/data/answer_number_941215/value') as cnt_deliveries
        from `//home/forms/answers/forms_int/production/101090/data`
        )
    group by date;
