use hahn;

$save_to_1 = '//home/taxi-delivery/analytics/dev/emilsharafiev/logdata-2855/orders_by_date';
$save_to_2 = '//home/taxi-delivery/analytics/dev/emilsharafiev/logdata-2855/orders_rigid_intervals';

$parsedate = DateTime::Parse('%Y-%m-%d');

$orders_by_date = (
select
    employer_code
    , some(brand_name) as brand_name
    , calendar_dt
    , count(distinct request_id) as cnt_orders
from `//home/taxi-delivery/analytics/production/ndd/requests_datamart`
where created_dttm is not null
    and employer_code <> 'Eva'
group by
    employer_code
    , substring(created_dttm, 0, 10) as calendar_dt
);

select
    count(distinct calendar_dt) as c1
    , min(calendar_dt) as min_
    , max(calendar_dt) as max_
    , max($parsedate(calendar_dt)) - min($parsedate(calendar_dt)) as datediff
    , cast(max($parsedate(calendar_dt)) - min($parsedate(calendar_dt)) as string) as dt
from $orders_by_date
;

INSERT INTO $save_to_1 WITH TRUNCATE 
SELECT * from $orders_by_date;


$dates = (
    select
        employer_code
        , brand_name
        , calendar_dt
        , SUBSTRING(cast(DateTime::MakeDate(DateTime::StartOfWeek(DateTime::MakeDate($parsedate(calendar_dt)))) as string), 0, 10) as week_dt
        , SUBSTRING(cast(DateTime::MakeDate(DateTime::StartOfMonth(DateTime::MakeDate($parsedate(calendar_dt)))) as string), 0, 10) as month_dt
        , SUBSTRING(cast(DateTime::MakeDate(DateTime::StartOfQuarter(DateTime::MakeDate($parsedate(calendar_dt)))) as string), 0, 10) as quarter_dt
        , cnt_orders
    from $orders_by_date
);

$big_union = (
    select
        calendar_dt
        , brand_name
        , employer_code
        , 'week' as interval
        , sum(cnt_orders) as cnt_orders
    from
        $dates
    group by
        week_dt as calendar_dt
        , brand_name
        , employer_code
union all
    select
        calendar_dt
        , brand_name
        , employer_code
        , 'month' as interval
        , sum(cnt_orders) as cnt_orders
    from
        $dates
    group by
        month_dt as calendar_dt
        , brand_name
        , employer_code
union all
    select
        calendar_dt
        , brand_name
        , employer_code
        , 'quarter' as interval
        , sum(cnt_orders) as cnt_orders
    from
        $dates
    group by
        quarter_dt as calendar_dt
        , brand_name
        , employer_code
);

$all_dates = (
    select * 
    from
        (select distinct calendar_dt, interval from $big_union) as t1
    cross join
        (select distinct employer_code from $big_union) as t2
);

INSERT INTO $save_to_2 WITH TRUNCATE
select
    ad.calendar_dt as calendar_dt
    , brand_name 
    , ad.employer_code as employer_code
    , ad.interval as interval
    , cnt_orders ?? 0 as cnt_orders
    , lead(cnt_orders ?? 0) over (partition by ad.employer_code, ad.interval order by ad.calendar_dt) as lead_cnt_orders
from $all_dates as ad 
left join $big_union as bu
    on ad.calendar_dt = bu.calendar_dt
    and ad.interval = bu.interval
    and ad.employer_code = bu.employer_code
;
