use hahn;

$STATION_TAGS = '//home/taxi/testing/export/taxi-logistic-platform-production/station_tags_history';
$POLYGONS = '//home/geotargeting/public/geobase/fallback_borders';
$GEOAREAS = '//home/taxi-delivery/analytics/production/ndd/delivery_regions/top_delivery/geoareas'; 

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/delivery_regions/top_delivery/available_intervals';

$STATION_ID = '60cd2f4b-0011-412a-a6e9-86ef7b57ca12';
$HISTORY_USER_ID = 'tag_generators_watcher';
$TAG_NAME = 'abstract_supply_promise_top-delivery_reservation';

$START_DATE = '2022-04-01';

$extract_regions_with_intervals = ($meta) -> {
    $regions_list = Yson::YPathList($meta, '/dropoff_reservations');

    $names = ListMap(
        $regions_list, ($x) -> {
            return coalesce(
                Yson::YPathString($x, '/area/polygon_area_object/polygon_name'),
                Yson::YPathString($x, '/area/geo_id_area_object/geo_name')
            );
        }  
    );

    $ids = ListMap(
        $regions_list, ($x) -> {
            return Yson::YPathInt64($x, '/area/geo_id_area_object/geo_id');
        }  
    );

    $interval = ListMap(
        $regions_list, ($x) -> {
            return Yson::YPathString($x, '/interval/hr_interval');
        }  
    );

    $deliveries_limit = ListMap(
        $regions_list, ($x) -> {
            return Yson::YPathInt64($x, '/deliveries_limit');
        }  
    );

    return ListZip($names, $ids, $interval, $deliveries_limit);
};

$list_to_tuples = ($list) -> {
    $new_list = ListMap($list, ($x) -> {
        return AsStruct(
            $x.0 AS name,
            $x.1 AS id,
            $x.2 AS hr_interval,
            $x.3 AS deliveries_limit
        );
    });

    return $new_list;
};

$extract_interval = ($interval, $geo_id) -> {
    $timezone = Geo::GetTimezone($geo_id);
    $string_from = ListHead(String::SplitToList($interval, '/'));
    $string_to = ListLast(String::SplitToList($interval, '/'));

    $datetime_from = DateTime::ParseIso8601($string_from);
    $datetime_to = DateTime::ParseIso8601($string_to);

    $datetime_from_tz = AddTimezone(DateTime::MakeDatetime($datetime_from), $timezone);
    $datetime_to_tz = AddTimezone(DateTime::MakeDatetime($datetime_to), $timezone);

    $new_string_from = cast($datetime_from_tz as String);
    $new_string_to = cast($datetime_to_tz as String);

    $time_from = substring($new_string_from, 11, 5);
    $time_to = substring($new_string_to, 11, 5);

    return $time_from || '-' || $time_to;
};

$extract_interval_2 = ($interval) -> {
    $timezone = Geo::GetTimezone(cast(213 as Int32)); -- костыль, чтобы в кастомные полигоны докидывать 3 часа

    $string_from = ListHead(String::SplitToList($interval, '/'));
    $string_to = ListLast(String::SplitToList($interval, '/'));

    $datetime_from = DateTime::ParseIso8601($string_from);
    $datetime_to = DateTime::ParseIso8601($string_to);

    $datetime_from_tz = AddTimezone(DateTime::MakeDatetime($datetime_from), $timezone);
    $datetime_to_tz = AddTimezone(DateTime::MakeDatetime($datetime_to), $timezone);

    $new_string_from = cast($datetime_from_tz as String);
    $new_string_to = cast($datetime_to_tz as String);

    $time_from = substring($new_string_from, 11, 5);
    $time_to = substring($new_string_to, 11, 5);

    return $time_from || '-' || $time_to;
};

$extract_date = ($interval) -> {
    return substring($interval, 0, 10);
};

$script = @@
def list_to_str(my_list):
    string = ''

    for i in my_list:
        string += (i.decode('ascii') + '; \n')

    return string.strip()
@@;

$list_to_str = Python::list_to_str(
    Callable<(List<String>?)->String?>,
    $script
);

$script2 = @@
from shapely import wkt

def transform_wkt(text):
    if text.decode('ascii') == '':
        return None
    multy = wkt.loads(text.decode('ascii'))
    try:
        coords_list = []
        for poly in multy:
            poly_coords_list = []
            poly_coords = list(poly.exterior.coords)

            for coords in poly_coords:
                poly_coords_list.append([coords[1], coords[0]])


            coords_list.append(poly_coords_list)
    except:
        coords_list = []
        poly_coords_list = []
        poly_coords = list(multy.exterior.coords)
        for coords in poly_coords:
            poly_coords_list.append([coords[1], coords[0]])
        coords_list.append(poly_coords_list)
        
    return str(coords_list)
@@;

$transform_wkt = Python::transform_wkt(
    Callable<(String?)->String?>,
    $script2
);

$parse = DateTime::Parse("%Y-%m-%dT%H:%M:%S,%Z");
$format = DateTime::Format('%Y-%m-%d %H:%M:%S');

$tags_raw = (
    select  $list_to_tuples($extract_regions_with_intervals(unpacked_data)) as tuples
        , ListHead($list_to_tuples($extract_regions_with_intervals(unpacked_data))).deliveries_limit as deliveries_limit_proxy
        , Yson::YPathString(unpacked_data, '/pickup_interval') as pickup_interval
        , Yson::YPathString(unpacked_data, '/status') as status
        , history_action
        , history_event_id
        , history_timestamp
        , tag_id
    from range($STATION_TAGS, $START_DATE)
    where 1=1
        and object_id = $STATION_ID
        and history_user_id = $HISTORY_USER_ID
        and tag_name = $TAG_NAME
        -- and tag_id = '02a02327-4ab8-4e94-86b4-a6389abfb519'
);

$tags = (
    select pickup_interval
        , max_by(status, history_event_id) as status
        , max_by(history_timestamp, history_event_id) as history_timestamp
        , max_by(tag_id, history_event_id) as tag_id
        , max_by(tuples, history_event_id) as tuples
    from $tags_raw
    where 1=1
        and history_action != 'remove'
        and deliveries_limit_proxy != 0
        and cast(CurrentUtcTimestamp() as String) < substring(pickup_interval, 0, 27)
    group by pickup_interval
);

$tags_flattened = (
    select *
    from $tags
    flatten list by tuples
);

$intervals = (
    SELECT distinct *
    FROM $tags_flattened
    FLATTEN COLUMNS
);

$intervals_processed = (
    select deliveries_limit
        , history_timestamp
        , hr_interval
        , case 
            when id is null then name 
            else cast(id as String) 
        end as id
        , name 
        , pickup_interval
        , status 
        , tag_id
    from $intervals
);

$available_intervals = (
select id as geo_id
    , name as geo_name
    , hr_interval
    , case 
        when cast(id as Int32) is not null then $extract_interval(hr_interval, cast(id as Int32))
        ELSE $extract_interval_2(hr_interval)
    end as delivery_interval
    , $extract_date(hr_interval) as delivery_date
    , DateTime::GetDayOfWeek(DateTime::Split(cast($extract_date(hr_interval) as Date))) as day_of_week
    , some(history_timestamp) as history_timestamp
    , some(pickup_interval) as pickup_interval
    , DateTime::GetDayOfWeek(DateTime::Split(cast($extract_date(some(pickup_interval)) as Date))) as pickup_day_of_week
    , some(status) as status 
    , some(tag_id) as tag_id
from $intervals_processed
group by id 
    , name
    , hr_interval
);

$available_intervals_min = (
    select geo_id
        , geo_name
        , min(delivery_date) as min_delivery_date
    from $available_intervals 
    group by geo_id
        , geo_name
);

$available_intervals_only_min = (
    SELECT t1.*
    from $available_intervals as t1 
    inner join $available_intervals_min as t2 on t1.geo_id=t2.geo_id and t1.geo_name=t2.geo_name and t1.delivery_date=t2.min_delivery_date
);

$available_intervals_reduced = (
    SELECT geo_name
        , some(geo_id) as geo_id
        , substring(delivery_date,8,2) || '.' || substring(delivery_date, 5, 2) as formatted_delivery_date
        , $list_to_str(coalesce(ListSort(AGGREGATE_LIST(delivery_interval)), '')) as intervals
        , some(day_of_week) as day_of_week
        , some(history_timestamp) as history_timestamp
        , some(pickup_interval) as pickup_interval
        , some(pickup_day_of_week) as pickup_day_of_week
        , some(status) as status
        , some(tag_id) as tag_id
    from $available_intervals_only_min 
    group by geo_name
        , delivery_date
);

insert into $SAVE_TO WITH TRUNCATE 
select r.*
    , $transform_wkt(coalesce(p.geometry_wkt, '')) as geo_poly
    , $format($parse(cast(AddTimezone(CurrentUtcDatetime(), "Europe/Moscow") as String))) as last_update_dttm 
    , g.geometry_poly as geometry_poly
    , case 
        when g.geometry_poly is null then $transform_wkt(coalesce(p.geometry_wkt, ''))
        else g.geometry_poly
    end as poly
from $available_intervals_reduced as r
left join $POLYGONS as p on cast(r.geo_id as Int64) = p.reg_id
left join $GEOAREAS as g on r.geo_id = g.name;
