PRAGMA AnsiInForEmptyOrNullableItemsCollections;
USE hahn;
PRAGMA yson.DisableStrict;

$rmd_orders = '//home/taxi-delivery/analytics/dev/ndd/market_courier_delivery_remade_orders_list';
$pickup_stations_yd = '//home/taxi-delivery/analytics/production/ndd/pickup_stations_yd';
$yt_outlet = '//home/cdc/prod/market/logistics_management_service/yt_outlet';

$delivery_date_changes = (
SELECT order_id
    
    , original_delivery_from_date
    , IF(original_delivery_from_time == '00:00:00', NULL, original_delivery_from_time)
        as original_delivery_from_time
    
    , original_delivery_to_date
    , IF(original_delivery_to_time == '23:59:59', NULL, original_delivery_to_time)
        as original_delivery_to_time
    
    , plan_min_delivery_service_delayed_date
    , IF(plan_min_delivery_service_delayed_time == '00:00:00', NULL, plan_min_delivery_service_delayed_time)
        as plan_min_delivery_service_delayed_time
    
    , plan_max_delivery_service_delayed_date
    , IF(plan_max_delivery_service_delayed_time == '23:59:59', NULL, plan_max_delivery_service_delayed_time)
        as plan_max_delivery_service_delayed_time
FROM
(
    SELECT order_id
        , MIN_BY(SUBSTRING(old_delivery_date_time_from, 0, 10), id) as original_delivery_from_date
        , MIN_BY(SUBSTRING(old_delivery_date_time_from, 11, 8), id) as original_delivery_from_time
        
        , MIN_BY(SUBSTRING(old_delivery_date_time_to, 0, 10), id) as original_delivery_to_date
        , MIN_BY(SUBSTRING(old_delivery_date_time_to, 11, 8), id) as original_delivery_to_time
        
        , MIN_BY(SUBSTRING(old_delivery_date_time_from, 0, 10)
            , IF(delay_reason == 'DELIVERY_SERVICE_DELAYED', id, NULL)) 
            as plan_min_delivery_service_delayed_date
        , MIN_BY(SUBSTRING(old_delivery_date_time_from, 11, 8)
            , IF(delay_reason == 'DELIVERY_SERVICE_DELAYED', id, NULL)) 
            as plan_min_delivery_service_delayed_time
        
        , MIN_BY(SUBSTRING(old_delivery_date_time_to, 0, 10)
            , IF(delay_reason == 'DELIVERY_SERVICE_DELAYED', id, NULL)) 
            as plan_max_delivery_service_delayed_date
        , MIN_BY(SUBSTRING(old_delivery_date_time_to, 11, 8)
            , IF(delay_reason == 'DELIVERY_SERVICE_DELAYED', id, NULL)) 
            as plan_max_delivery_service_delayed_time
    FROM 
    (
        SELECT order_id, CAST(reason as String) as delay_reason, id
            , CAST(old_delivery_date_time_from as String) as old_delivery_date_time_from
            , CAST(old_delivery_date_time_to as String) as old_delivery_date_time_to
        FROM `//home/cdc/prod/market/logistics_lom/change_delivery_date_meta`
    )
    GROUP BY order_id
)
);

$delivery_warehouse = (
    SELECT
        distinct
        external_id, name as delivery_attribute_warehouse_name
    FROM `//home/cdc/prod/market/logistics_management_service/logistics_point`
    where 1=1
        and active
);

$raw_orders = (
SELECT orders.*
    , cps.partner_subtype as partner_subtype
    , cps.tracker_status as  tracker_status
    , cps.cancelled_datetime as cancelled_datetime
    , cps.ss_canc_cancelled_datetime as ss_canc_cancelled_datetime
    , COALESCE(
        COALESCE(changes.original_delivery_from_date, orders.plan_delivery_from_date) || 'T'
        || COALESCE(changes.original_delivery_from_time, orders.plan_delivery_from_time)
        , '1970-01-01T00:00:00') as original_delivery_from_datetime
    , COALESCE(
        COALESCE(changes.original_delivery_to_date, orders.plan_delivery_to_date) || 'T'
        || COALESCE(changes.original_delivery_to_time, orders.plan_delivery_to_time)
        , '1970-01-01T00:00:00') as original_delivery_to_datetime
    , cps.order_logistic_status as order_logistic_status
    , cps.sorting_center_id
    , cps.delivery_service_id
    , LEAST(COALESCE(cp45, '2100-01-01T00:00:00'), COALESCE(cp49, '2100-01-01T00:00:00')
        , COALESCE(cp50, '2100-01-01T00:00:00')) 
        as fact_delivery_datetime
    , IF(COALESCE(cp110, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp110 as String)) as cp110_datetime
    , IF(COALESCE(cp46, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp46 as String)) as cp46_datetime
    , IF(COALESCE(cp47, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp47 as String)) as cp47_datetime
    , IF(COALESCE(cp48, '2100') like '2100%', '1970-01-01T00:00:00', CAST(cp48 as String)) as cp48_datetime
from 
(    SELECT orders.id as order_id
        , SUBSTRING(CAST(orders.delivery_date_min as String), 0, 10) as plan_delivery_from_date
        , COALESCE(SUBSTRING(CAST(orders.delivery_start_time as String), 0, 8), '00:00:00') as plan_delivery_from_time
        , SUBSTRING(CAST(orders.delivery_date_max as String), 0, 10) as plan_delivery_to_date
        , COALESCE(SUBSTRING(CAST(orders.delivery_end_time as String), 0, 8), '00:00:00') as plan_delivery_to_time
        , orders.barcode as barcode
        , orders.created as created
        , orders.credentials_inn as credentials_inn
        , orders.delivery_date_max as delivery_date_max
        , orders.delivery_date_min as delivery_date_min
        , orders.delivery_end_time as delivery_end_time
        , orders.delivery_start_time as delivery_start_time
        , orders.delivery_type as delivery_type
        , orders.external_id as external_id
        , orders.fake as fake 
        , orders.market_id_from as `market_id_from`
        , orders.`pickup_point_id` as `pickup_point_id`
        , orders.`recipient_federal_district` as `recipient_federal_district`
        , orders.`recipient_locality` as `recipient_locality`
        , orders.`recipient_region` as `recipient_region`
        , orders.`recipient_settlement` as `recipient_settlement`
        , orders.`return_registry_id` as `return_registry_id`
        , orders.`return_sorting_center_id` as `return_sorting_center_id`
        , orders.`return_sorting_center_location` as `return_sorting_center_location`
        , orders.`status` as `status`
        , orders.`updated` as `updated`
        , orders.`platform_client_id` as `platform_client_id`
    from `//home/cdc/prod/market/logistics_lom/orders` as orders
    where created >= '2022-01-01'
) as orders
left join 
(
    SELECT segments.order_id as order_id
        --, segments.id as waybill_id
        , segments.partner_subtype as partner_subtype
        , MIN_BY(partner_id, IF(partner_type == 'DELIVERY', waybill_segment_index, NULL)) 
            as delivery_service_id
        , MIN_BY(partner_id, IF(partner_type == 'SORTING_CENTER', waybill_segment_index, NULL)) 
            as sorting_center_id
        , MAX_BY(history.tracker_status, history.id) as order_logistic_status
        
        -- Чекпоинты складов
        , MIN(IF(history.tracker_status == 'SORTING_CENTER_AT_START', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp110
        
        -- Чекпоинты СД
        , MIN(IF(history.tracker_status == 'DELIVERY_UPDATED_BY_SHOP', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp44 -- Доставка перенесена по вине маркетплейса
        , MIN(IF(history.tracker_status == 'DELIVERY_ARRIVED_PICKUP_POINT', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp45 -- В пункте самовывоза
        , MIN(IF(history.tracker_status == 'DELIVERY_UPDATED_BY_RECIPIENT', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp46 -- Доставка перенесена по просьбе клиента
        , MIN(IF(history.tracker_status == 'DELIVERY_UPDATED_BY_DELIVERY', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp47 -- Доставка перенесена по инициативе СД
        , MIN(IF(history.tracker_status == 'DELIVERY_TRANSPORTATION_RECIPIENT', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp48 -- Доставляется по городу
        , MIN(IF(history.tracker_status == 'DELIVERY_TRANSMITTED_TO_RECIPIENT', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp49
        , MIN(IF(history.tracker_status == 'DELIVERY_DELIVERED', history.`date`
            , NULL)) ?? '2100-01-01T00:00:00' as cp50
        , MAX_BY(history.tracker_status, history.id) as tracker_status
        , MAX_BY(history.`date`, history.tracker_checkpoint_id) as `cancelled_datetime`
        , MAX(ss_canc_date) as ss_canc_cancelled_datetime
    from `//home/cdc/prod/market/logistics_lom/waybill_segment` as segments
    left join 
    (
        SELECT CAST(tracker_status as String) as tracker_status
            , tracker_checkpoint_id
            , id
            , SUBSTRING(CAST(`date` as String), 0, 19) as `date`
            , case when tracker_status = "RETURN_PREPARING" then SUBSTRING(CAST(`date` as String), 0, 19) else null end as ss_canc_date
            , waybill_segment_id
        FROM `//home/cdc/prod/market/logistics_lom/waybill_segment_status_history`
        where created >= '2022-01-01'
    ) as history
    on segments.id = history.waybill_segment_id
    where segments.created >= '2022-01-01'  
    GROUP BY segments.order_id, segments.partner_subtype
) as cps
on cps.order_id = orders.order_id
left join $delivery_date_changes as changes
on cps.order_id = changes.order_id
where orders.platform_client_id in (3, 6)
and orders.credentials_inn = "7716760301"
)
;

$tpl = (
select 
    Yson::YPathInt64(raw.doc, '/order_id') as order_id
    , eoi.external_order_id as external_order_id
    , Yson2::ConvertToString(raw.doc.context) as tpl_context
    , Yson::YPathString(raw.doc, '/source') as tpl_source
    , Yson::YPathString(raw.doc, '/type') as tpl_type
    , utc_created_dttm as tpl_dttm
from 
range(`//home/market/production/mstat/dwh/raw/market_tpl/order_history_event`, '2022-01') as raw
left join 
(select id, external_order_id from `//home/market/production/tpl/cdc/market_tpl_production_orders`) as eoi
on eoi.id  = Yson::YPathInt64(raw.doc, '/order_id')
)
;

$tpl_act_status = 
(
    SELECT
        external_order_id
        , MAX_BY(case when tpl_type = 'DELIVERY_RESCHEDULE' then tpl_context else null end, 
            case when tpl_type = 'DELIVERY_RESCHEDULE' then tpl_dttm else null end) as resc_context
        , MAX(case when tpl_type = 'DELIVERY_RESCHEDULE' then tpl_dttm else null end) as resc_dttm
        , count(distinct case when tpl_type = 'DELIVERY_RESCHEDULE' then tpl_dttm else null end) as cnt_resc
        , MAX_BY(case when tpl_type = 'ORDER_POSTPONED' then tpl_context else null end, 
            case when tpl_type = 'ORDER_POSTPONED' then tpl_dttm else null end) as post_context
        , MAX(case when tpl_type = 'ORDER_POSTPONED' then tpl_dttm else null end) as post_dttm

        , MAX_BY(case when tpl_context = 'Заказ выдан курьеру и доставляется клиенту (48)' then tpl_context else null end, 
            case when tpl_context = 'Заказ выдан курьеру и доставляется клиенту (48)' then tpl_dttm else null end) as ad_context
        , MAX(case when tpl_context = 'Заказ выдан курьеру и доставляется клиенту (48)' then tpl_dttm else null end) as ad_dttm
        , count(distinct case when tpl_context = 'Заказ выдан курьеру и доставляется клиенту (48)' then tpl_dttm else null end) as ad_cnt
        , MAX_BY(case when tpl_type = 'CANCELLED' then tpl_context else null end, 
            case when tpl_type = 'CANCELLED' then tpl_dttm else null end) as canc_context
        , MAX(case when tpl_type = 'CANCELLED' then tpl_dttm else null end) as canc_dttm 

        , MAX_BY(case when tpl_type = 'ACCEPTED_BY_COURIER' then tpl_context else null end, 
            case when tpl_type = 'ACCEPTED_BY_COURIER' then tpl_dttm else null end) as acc_context
        , MAX(case when tpl_type = 'ACCEPTED_BY_COURIER' then tpl_dttm else null end) as acc_dttm 
        , MAX_BY(tpl_context, tpl_dttm) as tpl_context
        , MAX_BY(tpl_source, tpl_dttm) as tpl_source
        , MAX_BY(tpl_type, tpl_dttm) as tpl_type
        , MAX(tpl_dttm) as tpl_dttm
    FROM
        $tpl 
    GROUP BY 
        external_order_id
);

INSERT INTO `//home/taxi-delivery/analytics/dev/ndd/market_courier_delivery_1h`
WITH TRUNCATE

SELECT
    sla.*,
    r.employer_code as employer_code,
    r.brand_name as brand_name,
    r.brand_name_ru as brand_name_ru,
    r.payment_method as payment_method,
    r.policy as policy,
    r.weight as lp_weigt,
    r.items_assessed_price as lp_price,
    r.operator_event_type as lp_status,
    r.event_instant_ddtm as lp_status_dttm,
    r.operator_id as operator_id,
    r.request_code as request_code,
    r.delivery_station_id as delivery_station_id,
    delivery_region_name ?? delivery_region ?? delivery_settlement as delivery_region_name,
    cd.new_delivery_date_time_from as new_delivery_date_time_from,
    cd.new_delivery_date_time_to as new_delivery_date_time_to,
    cd.reason as reason,
    cd.date_changed_at as date_changed_at,
    sla.ss_canc_cancelled_datetime as sort_center_cancelled_dttm,
    canc_r.cancel_reason as cancel_reason,
    tpl_act_status.tpl_context as tpl_context,
    tpl_act_status.tpl_source as tpl_source,
    tpl_act_status.tpl_type as tpl_type,
    tpl_act_status.tpl_dttm as tpl_dttm,
    tpl_act_status.canc_dttm as canc_dttm,
    tpl_act_status.canc_context as canc_context,
    tpl_act_status.resc_context as resc_context,
    tpl_act_status.resc_dttm as resc_dttm,
    tpl_act_status.post_context as post_context,
    tpl_act_status.post_dttm as post_dttm,
    tpl_act_status.acc_context as acc_context,
    tpl_act_status.acc_dttm as acc_dttm,
    tpl_act_status.ad_context as ad_context,
    tpl_act_status.cnt_resc as tpl_act_status,
    tpl_act_status.ad_cnt as ad_cnt,
    tpl_act_status.ad_dttm as ad_dttm,
    delivery_attribute_warehouse_name as delivery_warehouse_name,
    yt_outlet.type as market_station_type
FROM $raw_orders as sla
inner JOIN  hahn.`//home/taxi-delivery/analytics/production/ndd/requests_datamart` as r
ON r.external_order_id = cast(sla.order_id as utf8)
LEFT JOIN (
    select 
    MAX_BY(new_delivery_date_time_from, id) as new_delivery_date_time_from,
    MAX_BY(new_delivery_date_time_to, id) as new_delivery_date_time_to, 
    MAX_BY(`date_changed_at`, id) as date_changed_at,
    order_id, reason
from 
 hahn.`//home/cdc/prod/market/logistics_lom/change_delivery_date_meta` as cd 
group by 
    order_id, reason
) as cd
ON cd.order_id = sla.order_id
LEFT JOIN (
    SELECT
     order_id
     , MAX_BY(`reason`, created) as cancel_reason
FROM `//home/cdc/prod/market/logistics_lom/cancellation_order_request`
    group by order_id
) as canc_r 
on canc_r.order_id = sla.order_id
LEFT JOIN
    $tpl_act_status as tpl_act_status
    ON tpl_act_status.external_order_id = sla.barcode
LEFT JOIN 
    $rmd_orders as rmd_orders
    ON rmd_orders.external_id = r.request_code
LEFT JOIN
    $delivery_warehouse as delivery_warehouse
    on delivery_warehouse.external_id = cast(sla.return_sorting_center_id as utf8)
LEFT JOIN
    $pickup_stations_yd as pickup_stations_yd
    on  pickup_stations_yd.station_id = r.delivery_station_id
LEFT JOIN 
    $yt_outlet as yt_outlet
    ON yt_outlet.lms_id = cast(pickup_stations_yd.operator_station_id as Int64)

WHERE
    rmd_orders.external_id is null
