PRAGMA AnsiInForEmptyOrNullableItemsCollections;
USE hahn;
PRAGMA yson.DisableStrict;



$orig_table = '//home/taxi-delivery/analytics/dev/ndd/market_courier_delivery_1h';


$tpl = (
select 
    Yson::YPathInt64(raw.doc, '/order_id') as order_id
    , eoi.external_order_id as external_order_id
    , Yson2::ConvertToString(raw.doc.context) as tpl_context
    , Yson::YPathString(raw.doc, '/source') as tpl_source
    , Yson::YPathString(raw.doc, '/type') as tpl_type
    , utc_created_dttm as tpl_dttm
from 
range(`//home/market/production/mstat/dwh/raw/market_tpl/order_history_event`, '2022-01') as raw
left join 
(select id, external_order_id from `//home/market/production/tpl/cdc/market_tpl_production_orders`) as eoi
on eoi.id  = Yson::YPathInt64(raw.doc, '/order_id')
)
;

$tpl_resc_status = 
(
    SELECT
        distinct
        external_order_id
        , tpl_context as resc_context
        , tpl_dttm as resc_dttm
    FROM
        $tpl 
    where tpl_type = 'DELIVERY_RESCHEDULE'

);


INSERT INTO 
`//home/taxi-delivery/analytics/dev/ndd/market_courier_delivery_1h_reschedules`
WITH TRUNCATE
SELECT
   o.*
   , tpl_resc_status.resc_context as resc_context_full
   , tpl_resc_status.resc_dttm as resc_dttm_full
FROM $orig_table as o
LEFT JOIN
    $tpl_resc_status as tpl_resc_status
    ON tpl_resc_status.external_order_id = o.barcode