use hahn;
PRAGMA yt.InferSchema;
PRAGMA yt.Owners = 'svkorolev';

$start_date = "2021-06-17";


$REQUESTS_DATAMART_VIEW = "//home/taxi-delivery/analytics/production/ndd/requests_datamart";
$PAYMENTS_VIEW = "//home/taxi-delivery/analytics/production/logistic-platform/payment";
$REQUESTS_VIEW = "//home/taxi-delivery/analytics/production/logistic-platform/requests";
$CARGO_PAYMENTS_VIEW = "//home/taxi/production/replica/postgres/cargo_payments/billing_tasks_history";
$CARGO_PAYMENTS_OLD = "//home/taxi/testing/export/taxi-logistic-platform-production/payment_history";

$RESOURCES_ITEMS_HISTORY = "//home/taxi/testing/export/taxi-logistic-platform-production/resource_items_history";

$FINAL_TABLE = "//home/taxi-delivery/analytics/production/ndd/post_pay_table";
$PON_TABLE = "//home/taxi-delivery/analytics/dev/svkorolev/billing_17_29";

$time_cast = ($history_timestamp) -> {
    return CAST($history_timestamp as Uint32) 
};



-- =========

$cargo_payments_new = (
    SElECT
        order_id as request_id
        , amount
        , state as status
        , CAST(history_timestamp as Int64) as history_timestamp
        , CAST(billing_doc_id as Int64) as billing_doc_id
    FROM 
        $CARGO_PAYMENTS_VIEW
    where 
        Datetime::FromSeconds($time_cast(history_timestamp)) >= Timestamp('2021-06-29T00:00:00.000000Z')
);

$cargo_payments_old = (
    SElECT
        request_id
        , amount
        , status
        , CAST(history_timestamp as Int64) as history_timestamp
        , CAST(billing_doc_id as Int64) as billing_doc_id
    FROM 
        RANGE($CARGO_PAYMENTS_OLD, $start_date)
    where 
        Datetime::FromSeconds($time_cast(history_timestamp)) < Timestamp('2021-06-29T00:00:00.000000Z')
);

$cargo_payments = (
    SELECT 
     *
    from $cargo_payments_old
    where status in ('Approved', 'approved')
    union all
    SELECT 
     *
    from $cargo_payments_new
    where status in ('Approved', 'approved')
);

-- ======= payment_order_number ===========

$last_pmt_history_id = 0;

$payment_history_path = "//home/taxi/production/features/oebs/pmt_export/pmt_history";
$tlog_groups_dir = "//home/taxi/production/features/oebs/pmt_export/tlog_groups_history";
$cashless_dir = "//home/taxi/production/export/tlog/payments";

$moscow_date = ($datetime_str_with_tz) -> {
    $make_date_str = DateTime::Format("%Y-%m-%d");
    RETURN $make_date_str(
        AddTimezone(
            DateTime::MakeDatetime(
                DateTime::ParseIso8601($datetime_str_with_tz)
            ),
            "Europe/Moscow"
        )
    )
};

$tlog_payments = (
    SELECT
        T.amount as amount
        , T.currency as currency
        , T.event_time as event_time
        , T.transaction_time as transaction_time
        , T.invoice_date as invoice_date
        , CAST(Yson::LookupString(
                T.payload, "operation_id", Yson::Options(false AS Strict)
            ) AS Utf8) AS operation_id
        , T.client_id as client_id
        , T.service_id as service_id
        , T.transaction_type as transaction_type
        , C.billing_doc_id as billing_doc_id
        , CAST(
                Yson::LookupInt64(T.payload, "terminal_id",
                Yson::Options(false AS Strict)) as String) as terminal_id
        , T.transaction_id as transaction_id
        , T.contract_id as contract_id
    FROM RANGE($cashless_dir, $start_date) AS T
    inner join 
        $cargo_payments as C
        ON C.billing_doc_id = Yson::LookupInt64(T.payload,"base_doc_id")
)
;

$payments_last_history_id=(SELECT
            MAX(PMT_HIST_ID) AS history_id,
        FROM RANGE($payment_history_path, $start_date)
        WHERE
            PMT_HIST_ID > $last_pmt_history_id
        GROUP BY PAYMENT_ID);

$payments_with_last_status = (
    SELECT         
        P1.PAYMENT_ID AS payment_id,
        P1.PMT_HIST_ID AS history_id,
        P1.PAYMENT_AMOUNT AS total,
        P1.FIRST_EXPORT_DATE AS export_date,
        P1.LAST_UPDATE_DATE AS last_update_dt,
        P1.PAYMENT_STATUS as payment_status,
        P1.PAYMENT_ORDER_NUMBER as payment_order_number
    FROM RANGE($payment_history_path, $start_date) as P1
    RIGHT JOIN $payments_last_history_id AS P2 ON
            P1.PMT_HIST_ID = P2.history_id
);

$tlog_group_schema = Struct<
    CLIENT_ID:Int64,
    BILLING_CONTRACT_ID:Int64?,
    SERVICE_ID:Int64?,
    K_CURRENCY_CODE:String,
    STATUS:String,
    SOURCE_TYPE:String,
    SOURCE_TABNAME:String,
    TRANSACTION_ID_MIN:Int64?,
    TRANSACTION_ID_MAX:Int64?,
    TRANSACTION_COUNT:Int64,
    K_ALIAS:String,
    PAYMENT_ID:Int64?,
    PAYMENT_BATCH_ID:Int64?,
    REWARD_DATA_LINE_ID:Int64?,
    TAX_RATE:Double?,
    PROC_AMOUNT_W_VAT_APPLIED:Double?,
    ACCOUNTING_DATE:String?,
    GROUP_ID:Int64?,
    GROUP_TYPE:String,
    GROUP_HISTORY_ID:Int64?,
    TRANSACTION_TYPE:String?,
    TERMINAL_ID:String?,
    ATTRIBUTE1:String?,
    ATTRIBUTE2:String?,
    ATTRIBUTE3:String?,
    ATTRIBUTE4:String?,
    ATTRIBUTE5:String?,
>;
/*
$tlog_payments_scheme=Struct<
            transaction_id:Int64,
            amount:String,
            currency:String,
            payload:Yson,
            product:String,
            detailed_product:String,
            client_id:String,
            contract_id:String?,
            service_id:Int32,
            transaction_type:String,
            event_time:String,
            transaction_time:String,
            invoice_date:String?,
        >;
        */

$tlog_group_max_versions = (
    SELECT
        G.PAYMENT_ID AS PAYMENT_ID,
        G.GROUP_ID AS GROUP_ID,
        MAX(G.GROUP_HISTORY_ID) AS GROUP_HISTORY_ID
    FROM RANGE($tlog_groups_dir, $start_date)
        WITH SCHEMA $tlog_group_schema AS G
    GROUP BY G.PAYMENT_ID, G.GROUP_ID
);

$tlog_groups = (
    SELECT G.*
    FROM RANGE($tlog_groups_dir, $start_date)
        WITH SCHEMA $tlog_group_schema AS G
    RIGHT JOIN $tlog_group_max_versions AS G2 ON
            G.PAYMENT_ID = G2.PAYMENT_ID
        AND G.GROUP_ID = G2.GROUP_ID
        AND G.GROUP_HISTORY_ID = G2.GROUP_HISTORY_ID
    WHERE
            G.PAYMENT_ID IS NOT NULL
        AND G.STATUS LIKE "%_FULL"
);

$filtered_transactions =(
    SELECT
        CAST(G.PAYMENT_ID AS UInt64) AS payment_id,
        CAST(T.amount AS Utf8) AS orig_amount,
        CAST(T.currency AS Utf8) AS currency,
        CAST(T.event_time AS Utf8) AS event_time,
        CAST(T.transaction_time AS Utf8) AS transaction_time,
        CAST(T.invoice_date AS Utf8) AS invoice_time,
        T.operation_id as operation_id
        , T.billing_doc_id as billing_doc_id
    FROM $tlog_groups AS G
    JOIN $tlog_payments AS T
        ON T.client_id = CAST(G.CLIENT_ID AS String)
            AND T.service_id = G.SERVICE_ID
            AND T.currency = G.K_CURRENCY_CODE
            AND T.transaction_type = G.TRANSACTION_TYPE
            AND T.terminal_id = G.TERMINAL_ID
    WHERE
        G.SOURCE_TYPE = "PAYMENT"
    AND T.transaction_id BETWEEN G.TRANSACTION_ID_MIN AND G.TRANSACTION_ID_MAX
    AND (
        COALESCE(T.contract_id, CAST(G.BILLING_CONTRACT_ID as String)) =
            CAST(G.BILLING_CONTRACT_ID as String)
    )
    AND $moscow_date(T.event_time) = $moscow_date(G.ACCOUNTING_DATE)
);

$pon_tmp = (
SELECT 
        T.operation_id AS request_id,
        T.billing_doc_id as billing_doc_id,
        T.orig_amount AS orig_amount,
        P.last_update_dt as last_update_dt,
        P.export_date as export_dt,
        P.payment_status AS payment_status,
        P.payment_order_number as payment_order_number
FROM $filtered_transactions AS T
JOIN $payments_with_last_status AS P ON T.payment_id = P.payment_id
)
;

$pon = (
    select 
     * 
    from $pon_tmp
    union all 
    select 
        ndd_request_id as request_id
        , ndd_billing_doc_id as billing_doc_id
        , ndd_amount as orig_amount
        , event_time as last_update_dt
        , null as export_dt
        , payment_status
        , payment_order_number
    from 
        $PON_TABLE
);

-- ====================

$unit_price = ($meta_data) -> { 
    return Yson::YPathInt64(Yson::Parse($meta_data), "/billing_details/unit_price") 
};

$request_datamart = (
    SElECT
        request_id
        , items_assessed_price
        , request_code
        , items_price
        , delivery_cost
        , planned_delivery_dt
        , payment_method
        , employer_code
        , corp_client_id
        , operator_id
        , external_order_id
        , event_instant_dt
        , mapped_event_type
    FROM
        $REQUESTS_DATAMART_VIEW
    where 
        1=1
        and mapped_event_type in ('Доставлен частично', 'Доставлен')
    group by 
        request_id
        , items_assessed_price
        , items_price
        , request_code
        , delivery_cost
        , planned_delivery_dt
        , payment_method
        , employer_code
        , corp_client_id
        , operator_id
        , external_order_id
        , event_instant_dt
        , mapped_event_type
);

$refused_count_tmp = (
    select 
        request_id
        , internal_item_id
        , history_event_id
        , MAX(history_event_id) over (partition by request_id, internal_item_id) as last_history_id
        , CAST(refused_count as float) as refused_cnt
        , CAST($unit_price(unpacked_data) as float) as price
from 
    RANGE($RESOURCES_ITEMS_HISTORY, $start_date)
where 
    1=1
    and history_action == 'update_data'
    and cast(refused_count as Int32) > 0  
);

$refused_count = (
    select 
        'refused' as status
        , request_id
        , refused_cnt as cnt
        , price
from 
    $refused_count_tmp
where 
    1=1
    and history_event_id == last_history_id   
);

$add_count_tmp = (
    select 
        request_id
        , history_event_id
        , MAX(history_event_id) over (partition by request_id, internal_item_id) as last_history_id
        , CAST(`count` as float) as cnt
        , CAST($unit_price(unpacked_data) as float) as price
from 
    RANGE($RESOURCES_ITEMS_HISTORY, $start_date)
where 
    1=1
    and history_action == 'add'
);

$add_count = (
    select 
        'add' as status
        , request_id
        , cnt
        , price
from 
    $add_count_tmp
where 
    1=1
    and history_event_id == last_history_id   
);

$remove_count_tmp = (
    select 
        request_id
        , internal_item_id
        , history_event_id
        , MAX(history_event_id) over (partition by request_id, internal_item_id) as last_history_id
        , CAST(`count` as float) as cnt
        , CAST($unit_price(unpacked_data) as float) as price
from 
    RANGE($RESOURCES_ITEMS_HISTORY, $start_date)
where 
    1=1
    and history_action == 'remove'
);

$remove_count = (
    select 
        'remove' as status
        , request_id
        , cnt
        , price
from 
    $remove_count_tmp
where 
    1=1
    and history_event_id == last_history_id   
);

$united_counts = (
    select 
        *
    from 
        $add_count
    union all 
    select 
        * 
    from 
        $refused_count
    union all 
    select 
        * 
    from 
        $remove_count
);

$request_datamart_true_price = (
    select 
        request_id
        , SUM(case when status == 'add' then cnt * price else 0 end) as add_price
        , SUM(case when status == 'refused' then cnt * price else 0 end) as refused_price
        , SUM(case when status == 'remove' then cnt * price else 0 end) as removed_price
from 
    $united_counts
group by 
    request_id
);

$payments_tmp = (
    SElECT
        id as payment_id
        , request_id
        , account_type
        , amount
        , history_event_id
        , MAX(history_event_id) over (partition by request_id) as last_history_id
    FROM 
        $PAYMENTS_VIEW
);

$payments = (
    SElECT
        payment_id
        , request_id
        , account_type
        , amount
    FROM 
        $payments_tmp
    where 
        1=1
        and history_event_id == last_history_id
);

$requests_tmp = (
    SElECT
        request_id
        , history_timestamp
        , employer_code
        , status
        , history_event_id
        , MAX(history_event_id) over (partition by request_id) as last_history_id
    FROM 
        $REQUESTS_VIEW   
);

$requests = (
    select 
        request_id
        , history_timestamp
        , employer_code
        , status
    from 
        $requests_tmp
    where 
        1=1
        and history_event_id == last_history_id
);




--select * from $united_counts where request_id = 'cccb4faf-6b94-4e33-b9d2-31f77f92fbee'



$final_table_tmp = (
    SELECT 
        R.corp_client_id as corp_client_id --id клиента
        , R.request_id as request_id --номер заказа
        , R.items_assessed_price as items_assessed_price
        , R.operator_id as operator_id-- Код клиента
        , R.external_order_id as external_order_id
        , R.request_code as request_code
        , R.event_instant_dt as event_instant_dt -- дата доставки
        , R.mapped_event_type as mapped_event_type
        , SUM(R.delivery_cost + R.items_price - RT.refused_price) as total_price --всего 
        , R.items_price as items_price_old --цена из requests_datamart
        , COALESCE(RT.refused_price, 0) as refused_price
        , R.delivery_cost as delivery_cost --цена доставки
        , SUM(R.items_price - COALESCE(RT.refused_price, 0)) as items_price --стоимость заказа с учетом частичного выкупа
        , R.planned_delivery_dt as planned_delivery_dt --дата доставки
        , R.payment_method as payment_method 
        , R.employer_code as employer_code
        , PA.payment_id as payment_id
        , PA.amount as amount_from_payments -- сумма из таблицы платежей
        , MAX(Datetime::FromSeconds($time_cast(RE.history_timestamp))) as history_timestamp --последняя актуральная дата заказа
        , RE.status as request_status_from_requests --последний актуальный статус заказа
        , CP.amount as amount --сумма отправленная в биллинг
        , CP.history_timestamp as cargo_payments_history_tt
        , CP.billing_doc_id as billing_doc_id
        , PON.orig_amount as pon_amount
        , PON.export_dt as export_dt
        , PON.last_update_dt as pon_status_last_update_dt
        , PON.payment_status as pon_status
        , PON.payment_order_number as payment_order_number
        , PON.billing_doc_id as pon_billing_doc_id   
    FROM
        $request_datamart as R
    left join 
         $request_datamart_true_price as RT 
         on RT.request_id == R.request_id
    LEFT JOIN 
        $payments as PA
        on PA.request_id == R.request_id
    LEFT JOIN 
        $requests as RE
        on RE.request_id == R.request_id
    LEFT JOIN 
           $cargo_payments as CP
        on CP.request_id == R.request_id
    LEFT JOIN
        $pon as PON
        ON PON.request_id = R.request_id
        AND CAST(PON.billing_doc_id as Uint64) = CAST(CP.billing_doc_id as Uint64)
    group by 
        R.corp_client_id
        , R.request_id
        , R.request_code
        , R.items_assessed_price
        , R.delivery_cost
        , R.items_price
        , RT.refused_price
        , R.planned_delivery_dt
        , R.payment_method
        , R.employer_code
        , PA.payment_id
        , PA.amount
        , RE.status
        , CP.history_timestamp
        , CP.amount
        , CP.billing_doc_id as billing_doc_id
        , CAST(COALESCE(CP.amount, '0') AS UInt64)
        , Datetime::FromSeconds($time_cast(RE.history_timestamp)) 
        , PON.orig_amount
        , PON.export_dt as export_dt
        , PON.last_update_dt
        , PON.payment_status
        , PON.payment_order_number
        , R.operator_id -- Код клиента
        , R.external_order_id
        , PON.billing_doc_id
        , R.event_instant_dt -- дата доставки
        , R.mapped_event_type
); 

$table_tmp = (
    SELECT
     T.*
     , MIN(T.`event_instant_dt`) OVER (partition by T.`request_id`) as delivery_dt
    from 
    $final_table_tmp as T
)
;

INSERT INTO $FINAL_TABLE
WITH TRUNCATE (
    SELECT 
        *
    from 
    $table_tmp
    where `event_instant_dt` = `delivery_dt`
)
;
