# -*- coding: utf-8 -*-

import logging
import pandas as pd
import yt.wrapper as yt
from datetime import datetime
from projects.common.helpers import build_gdocs 

gdocs = build_gdocs()

SCHEMA = [  
 dict(name='дата', type="string"), 
 dict(name='период', type="string"),
 dict(name='dbid (диспа)', type="string"),
 dict(name='название парка', type="string"),
 dict(name='uuid (водитель)', type="string"),
 dict(name='ФИО', type="string"),
 dict(name='кузов', type="string"),
 dict(name='проект', type="string"),
 dict(name='платеж/день', type="string"),
 dict(name='Штраф на смене', type="string"),
 dict(name='Штраф невыход', type="string"),
 dict(name='Комментарий по штрафу', type="string"),
 dict(name='order_id (фейк заказ)', type="string"),
 dict(name='стоимость фейк-заказа', type="string"),
 dict(name='часы переработки', type="string"),
 dict(name='ставка за переработку, руб/час', type="string"),
 dict(name='Перепробег/иные доплаты', type="string"),
 dict(name='Комментарии', type="string"),
 dict(name='>>> автозаполнение', type="string"),
 dict(name='dt', type="string"),
 dict(name='dbid_uuid_dt', type="string"),
 dict(name='dbid_uuid_период', type="string"),
 dict(name='true_cost', type="string"),
 dict(name='BONUS', type="string"),
 dict(name='order_id', type="string"),
 dict(name='статус выплаты', type="string"),
 dict(name='стажировка', type="string"),
 dict(name='SH', type="string"),
 dict(name='период (справочно)', type="string"),
 dict(name='проверка на дубли', type="string")
]
TABLE_NAME = "//home/taxi-delivery/analytics/production/ndd/cargo_costs"
COLUMNS = [
   "дата",	"период",	"dbid (диспа)",	"название парка",	"uuid (водитель)",	"ФИО",	"кузов",	"проект",	"платеж/день",	"Штраф на смене",	"Штраф невыход",	"Комментарий по штрафу",	"order_id (фейк заказ)", 	"стоимость фейк-заказа", 	"часы переработки", 	"ставка за переработку, руб/час", 	"Перепробег/иные доплаты", 	"Комментарии", 	">>> автозаполнение", 	"dt",	"dbid_uuid_dt", 	"dbid_uuid_период", "true_cost", "BONUS", "order_id", "статус выплаты", "стажировка","SH", "период (справочно)","проверка на дубли"
]

def write_replica_gdocs():
    log = gdocs.read(
        table_name="ВЫХОД НА ЛИНИЮ",
        sheet_id="15_-P_3Zt4IcZ6Acl7fNCQcHodgZZCumeIo5epLF54yY",
        header=1
    ).iloc[:, 0:len(COLUMNS)]
    log.columns = COLUMNS


    data = log.to_dict(orient="records")
    #return log
    yt.write_table(yt.TablePath(TABLE_NAME, schema=SCHEMA), data)
    
def main():
    write_replica_gdocs()


if __name__ == "__main__":
    yt.config.set_proxy("hahn")
    main()
