/*
    Автор: @ikhomyanin 

    Продукт: NDD Яндекс.Доставки

    Применение: 
    Отслеживаем, что ЛогПлатформа правильно прайсит перевозки
    > Какая стоимость должна быть
    > Какая отправилась в cargo_pricing 
    > Что дошло до транзакционного лога

    Тикет: LOGDATA-828

    Потенциальные проблемы:
    Самостоятельный подсчет стоимости сломается, если поменябтся тарифы или полигоны - мы их захардкодили
*/

use hahn;
PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;
PRAGMA yt.InferSchema = '1';
PRAGMA yt.Pool = 'taxi-delivery';

-- Данные ЛП
$REQUESTS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/requests_history';
$RESOURCE_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/resources_history';
$PLANNED_NODES_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history';
$STATIONS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/stations_history';

-- Данные прайсинга
$PAYMENTS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/payment_history';
$BILLING_TASKS_HISTORY = '//home/taxi/production/replica/postgres/cargo_payments/billing_tasks_history';
$TLOG_REVENUES = '//home/taxi/production/export/tlog/revenues';

-- Хардкод тарифов
$TARIFFS = '//home/taxi-delivery/analytics/production/ndd/ndd_tariffs_2021-12-06';

-- Куда сохраняется результат
$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/pricing/datamart';

$START_DATE = '2021-11-10';

$dttm_format = DateTime::Format('%Y-%m-%d %H:%M:%S');

$py_poly = @@
from shapely.geometry import Polygon, Point

mkad = [
    [37.368772, 55.749909]     ,
    [37.368768, 55.749948],
    [37.368778, 55.752189],
    [37.368842, 55.754357],
    [37.368901, 55.757565],
    [37.368922, 55.758231],
    [37.369011, 55.76112],
    [37.36904, 55.762162],
    [37.369043, 55.762305],
    [37.369045, 55.762366],
    [37.369061, 55.762939],
    [37.369062, 55.762981],
    [37.369067, 55.763157],
    [37.369098, 55.764292],
    [37.369107, 55.764591],
    [37.369119, 55.764976],
    [37.36912, 55.764987],
    [37.36912, 55.765011],
    [37.369121, 55.765036],
    [37.369121, 55.765043],
    [37.369135, 55.765481],
    [37.369137, 55.765532],
    [37.369189, 55.767199],
    [37.369193, 55.767346],
    [37.369219, 55.76818],
    [37.369225, 55.76836],
    [37.369239, 55.769379],
    [37.369246, 55.76987],
    [37.369247, 55.769951],
    [37.369248, 55.770044],
    [37.369249, 55.770119],
    [37.369264, 55.771135],
    [37.369267, 55.771224],
    [37.369324, 55.772916],
    [37.369385, 55.774715],
    [37.369412, 55.776142],
    [37.369432, 55.777156],
    [37.369505, 55.779728],
    [37.369564, 55.782169],
    [37.369688, 55.783527],
    [37.369922, 55.784726],
    [37.370036, 55.785084],
    [37.3701, 55.785259],
    [37.370459, 55.786236],
    [37.370664, 55.786699],
    [37.370864, 55.787105],
    [37.3709, 55.78718],
    [37.371096, 55.787544],
    [37.371167, 55.787677],
    [37.371167, 55.7876770001],
    [37.37134, 55.787967],
    [37.371428, 55.788114],
    [37.371822, 55.788661],
    [37.371917, 55.788793],
    [37.371966, 55.788853],
    [37.372235, 55.78919],
    [37.372271, 55.789235],
    [37.372326, 55.789303],
    [37.372375, 55.789365],
    [37.372407, 55.789405],
    [37.372565, 55.789602],
    [37.372577, 55.789615],
    [37.372718, 55.7897749999],
    [37.372718, 55.789775],
    [37.372718, 55.7897760001],
    [37.373061, 55.790153],
    [37.373213, 55.790319],
    [37.373354, 55.790495],
    [37.374446, 55.791676],
    [37.374452, 55.791682],
    [37.374501, 55.791733],
    [37.374603, 55.791839],
    [37.374692, 55.791931],
    [37.374881, 55.792127],
    [37.37529, 55.792551],
    [37.375697, 55.792972],
    [37.376208, 55.7935],
    [37.37635, 55.793652],
    [37.377257, 55.794596],
    [37.378091, 55.79545],
    [37.378354, 55.79572],
    [37.378452, 55.79582],
    [37.378701, 55.796076],
    [37.379015, 55.796398],
    [37.379829, 55.797233],
    [37.381048, 55.798503],
    [37.382263, 55.799795],
    [37.383078, 55.800646],
    [37.383185, 55.800757],
    [37.383216, 55.80079],
    [37.383521, 55.801108],
    [37.38386, 55.801509],
    [37.383877, 55.80153],
    [37.384124, 55.801821],
    [37.384898, 55.802737],
    [37.385825, 55.804017],
    [37.38649, 55.805062],
    [37.38649, 55.8050620001],
    [37.38659, 55.805251],
    [37.386881, 55.8058],
    [37.387066, 55.806189],
    [37.387255, 55.806586],
    [37.387265, 55.806611],
    [37.387317, 55.806728],
    [37.387343, 55.806787],
    [37.387543, 55.807238],
    [37.387575, 55.807311],
    [37.387631, 55.807439],
    [37.387875, 55.807989],
    [37.38793, 55.808151],
    [37.388127, 55.808723],
    [37.388144, 55.808774],
    [37.388158, 55.808814],
    [37.388192, 55.808913],
    [37.388284, 55.80918],
    [37.388307, 55.809246],
    [37.388326, 55.809303],
    [37.388509, 55.809834],
    [37.38851, 55.80984],
    [37.388524, 55.809886],
    [37.388529, 55.809902],
    [37.388772, 55.810738],
    [37.389065, 55.811744],
    [37.389357, 55.812587],
    [37.389555, 55.813156],
    [37.389606, 55.81333],
    [37.38989, 55.814285],
    [37.3899, 55.814318],
    [37.390322, 55.815707],
    [37.390379, 55.815897],
    [37.390795, 55.817179],
    [37.391413, 55.819083],
    [37.391587, 55.81962],
    [37.391961, 55.820799],
    [37.391972, 55.820835],
    [37.392112, 55.821278],
    [37.392121, 55.821305],
    [37.39235, 55.822028],
    [37.393059, 55.824371],
    [37.39321, 55.825064],
    [37.393454, 55.826462],
    [37.393501, 55.826745],
    [37.393665, 55.827414],
    [37.393863, 55.828072],
    [37.393946, 55.828347],
    [37.393984, 55.828472],
    [37.394208, 55.829219],
    [37.394216, 55.829243],
    [37.394588, 55.830371],
    [37.394626, 55.830486],
    [37.394788, 55.830976],
    [37.395146, 55.832062],
    [37.395148, 55.832069],
    [37.395189, 55.832211],
    [37.395276, 55.832511],
    [37.395298, 55.832586],
    [37.395318, 55.832654],
    [37.395345, 55.832745],
    [37.395369, 55.832829],
    [37.395371, 55.832835],
    [37.395448, 55.833161],
    [37.395502, 55.833405],
    [37.395619, 55.833937],
    [37.395628, 55.83398],
    [37.395634, 55.834005],
    [37.395643, 55.834048],
    [37.395717, 55.834473],
    [37.39573, 55.834545],
    [37.395789, 55.834884],
    [37.395827, 55.835661],
    [37.395831, 55.835758],
    [37.395756, 55.83651],
    [37.395687, 55.837203],
    [37.395428, 55.838473],
    [37.395248, 55.839068],
    [37.394718, 55.840381],
    [37.394071, 55.841589],
    [37.394071, 55.8415890001],
    [37.393813, 55.842029],
    [37.393097, 55.842982],
    [37.392814, 55.843359],
    [37.392746, 55.843464],
    [37.392537, 55.843785],
    [37.392204, 55.8443409999],
    [37.392204, 55.844341],
    [37.392051, 55.844686],
    [37.391884, 55.845191],
    [37.391866, 55.845264],
    [37.391773, 55.84566],
    [37.391683, 55.846287],
    [37.391653, 55.847078],
    [37.391749, 55.847745],
    [37.391839, 55.848095],
    [37.392032, 55.848852],
    [37.392393, 55.84964],
    [37.392541, 55.849929],
    [37.392682, 55.850205],
    [37.393482, 55.851649],
    [37.393541, 55.851756],
    [37.3936, 55.851862],
    [37.393614, 55.851887],
    [37.394661, 55.853897],
    [37.394874, 55.854296],
    [37.395363, 55.85521],
    [37.395481, 55.855431],
    [37.395803, 55.856033],
    [37.395807, 55.85604],
    [37.395888, 55.856191],
    [37.39673, 55.857757],
    [37.397315, 55.858806],
    [37.397699, 55.859493],
    [37.397699, 55.8594930001],
    [37.398586, 55.860769],
    [37.398607, 55.860799],
    [37.39981, 55.862226],
    [37.399968, 55.862404],
    [37.400351, 55.862832],
    [37.400429, 55.862912],
    [37.400742, 55.863237],
    [37.401678, 55.864207],
    [37.401813, 55.864347],
    [37.402042, 55.864567],
    [37.403106, 55.865464],
    [37.403804, 55.866013],
    [37.405382, 55.867249],
    [37.40618, 55.867781],
    [37.406436, 55.867937],
    [37.4093619999, 55.86968],
    [37.409362, 55.86968],
    [37.410005, 55.870039],
    [37.410595, 55.870329],
    [37.411827, 55.870937],
    [37.412022, 55.871033],
    [37.412094, 55.871068],
    [37.413506, 55.871697],
    [37.416867, 55.87307],
    [37.418135, 55.873515],
    [37.419362, 55.873907],
    [37.420901, 55.874404],
    [37.422435, 55.874875],
    [37.423305, 55.875142],
    [37.423925, 55.875332],
    [37.424122, 55.875392],
    [37.42437, 55.875468],
    [37.42505, 55.875677],
    [37.425108, 55.875695],
    [37.425579, 55.875839],
    [37.425815, 55.875913],
    [37.425887, 55.875936],
    [37.428045, 55.87661],
    [37.428201, 55.876658],
    [37.428362, 55.876709],
    [37.429407, 55.877035],
    [37.429436, 55.877044],
    [37.429861, 55.877175],
    [37.431583, 55.877707],
    [37.433162, 55.878195],
    [37.433521, 55.878306],
    [37.434555, 55.878634],
    [37.435823, 55.879036],
    [37.436594, 55.87928],
    [37.4368, 55.879345],
    [37.437551, 55.879583],
    [37.437673, 55.879622],
    [37.437977, 55.879718],
    [37.438469, 55.879874],
    [37.438502, 55.879884],
    [37.440781, 55.8806],
    [37.440884, 55.880633],
    [37.442744, 55.88114],
    [37.442825, 55.881162],
    [37.444011, 55.881486],
    [37.444188, 55.881534],
    [37.444504, 55.881601],
    [37.444716, 55.881646],
    [37.445048, 55.881716],
    [37.445537, 55.881819],
    [37.446243, 55.881968],
    [37.446795, 55.882084],
    [37.448648, 55.882368],
    [37.449482, 55.882472],
    [37.451295, 55.882608],
    [37.453118, 55.882714],
    [37.453671, 55.882746],
    [37.454002, 55.882762],
    [37.454253, 55.882774],
    [37.454454, 55.882783],
    [37.455626, 55.882801],
    [37.45593, 55.882806],
    [37.456089, 55.882804],
    [37.456285, 55.882803],
    [37.458056, 55.882788],
    [37.459071, 55.882828],
    [37.459854, 55.882859],
    [37.462355, 55.882959],
    [37.46468, 55.883112],
    [37.465643, 55.883216],
    [37.466865, 55.883435],
    [37.467821, 55.883606],
    [37.468236, 55.88368],
    [37.469215, 55.883892],
    [37.470142, 55.884108],
    [37.470762, 55.884253],
    [37.471175, 55.884349],
    [37.471212, 55.884359],
    [37.473064, 55.884823],
    [37.474358, 55.885148],
    [37.474634, 55.885217],
    [37.475342, 55.885394],
    [37.477827, 55.886018],
    [37.480974, 55.886798],
    [37.48119, 55.886852],
    [37.481393, 55.886902],
    [37.481958, 55.887049],
    [37.482272, 55.887131],
    [37.482681, 55.887237],
    [37.484418, 55.887689],
    [37.485676, 55.888016],
    [37.486834, 55.888348],
    [37.487328, 55.88849],
    [37.487983, 55.888691],
    [37.488208, 55.888765],
    [37.488615, 55.888899],
    [37.490147, 55.889469],
    [37.490244, 55.889507],
    [37.491087, 55.88984],
    [37.491582, 55.890055],
    [37.492663, 55.890534],
    [37.495011, 55.891576],
    [37.495666, 55.891866],
    [37.495764, 55.89191],
    [37.496108, 55.892061],
    [37.496216, 55.892108],
    [37.496366, 55.892174],
    [37.496489, 55.892228],
    [37.496598, 55.892275],
    [37.500661, 55.894059],
    [37.503344, 55.895233],
    [37.505465, 55.896162],
    [37.505611, 55.896226],
    [37.5073, 55.896965],
    [37.509302, 55.897842],
    [37.513215, 55.899582],
    [37.51629, 55.900942],
    [37.518409, 55.901874],
    [37.520363, 55.902734],
    [37.52105, 55.903039],
    [37.521541, 55.903257],
    [37.522009, 55.903464],
    [37.523119, 55.903928],
    [37.524099, 55.904325],
    [37.524122, 55.904333],
    [37.524891, 55.904622],
    [37.525842, 55.904939],
    [37.526235, 55.905061],
    [37.527061, 55.905316],
    [37.528314, 55.905681],
    [37.529197, 55.905912],
    [37.530319, 55.906158],
    [37.531099, 55.906334],
    [37.532443, 55.906593],
    [37.533691, 55.906796],
    [37.534438, 55.906913],
    [37.53534, 55.907036],
    [37.535346, 55.907037],
    [37.535996, 55.90711],
    [37.536524, 55.90717],
    [37.536571, 55.907175],
    [37.537434, 55.907266],
    [37.537656, 55.907274],
    [37.538261, 55.907353],
    [37.540269, 55.907563],
    [37.540949, 55.907634],
    [37.543028, 55.907853],
    [37.543055, 55.907856],
    [37.543492, 55.907902],
    [37.543741, 55.907928],
    [37.544144, 55.90797],
    [37.544784, 55.908038],
    [37.546803, 55.908254],
    [37.551401, 55.908738],
    [37.552002, 55.908801],
    [37.555655, 55.909188],
    [37.563526, 55.910009],
    [37.563629, 55.91002],
    [37.563714, 55.910029],
    [37.563785, 55.910036],
    [37.563855, 55.910044],
    [37.563895, 55.910048],
    [37.567358, 55.910425],
    [37.569257, 55.910632],
    [37.570844, 55.910799],
    [37.571353, 55.91085],
    [37.572471, 55.910952],
    [37.573256, 55.911011],
    [37.574316, 55.91107],
    [37.575523, 55.911109],
    [37.576552, 55.911125],
    [37.576595, 55.911126],
    [37.577959, 55.911113],
    [37.578885, 55.911096],
    [37.579623, 55.911063],
    [37.580232, 55.911034],
    [37.581111, 55.910971],
    [37.581757, 55.910919],
    [37.582616, 55.910846],
    [37.583072, 55.910796],
    [37.583453, 55.910754],
    [37.584355, 55.910636],
    [37.585298, 55.910514],
    [37.585984, 55.910405],
    [37.586816, 55.910257],
    [37.586867, 55.910246],
    [37.587829, 55.910049],
    [37.587887, 55.910037],
    [37.588241, 55.909964],
    [37.588402, 55.909931],
    [37.588624, 55.909885],
    [37.588744, 55.909859],
    [37.589509, 55.909692],
    [37.590224, 55.909517],
    [37.59139, 55.909198],
    [37.593311, 55.908649],
    [37.593632, 55.908561],
    [37.594467, 55.908328],
    [37.596775, 55.907688],
    [37.597333, 55.907533],
    [37.597785, 55.907407],
    [37.598, 55.907347],
    [37.598028, 55.90734],
    [37.598196, 55.907293],
    [37.601365, 55.906408],
    [37.603344, 55.905849],
    [37.604645, 55.905474],
    [37.606747, 55.904881],
    [37.607532, 55.904666],
    [37.608278, 55.904461],
    [37.610344, 55.903894],
    [37.612284, 55.903404],
    [37.613805, 55.903019],
    [37.614878, 55.902749],
    [37.614983, 55.902722],
    [37.614994, 55.90272],
    [37.615092, 55.902695],
    [37.615164, 55.902677],
    [37.61961, 55.901637],
    [37.626275, 55.900245],
    [37.627084, 55.900096],
    [37.628999, 55.899742],
    [37.629565, 55.899637],
    [37.63174, 55.899235],
    [37.635969, 55.898534],
    [37.640968, 55.897812],
    [37.641873, 55.897682],
    [37.642617, 55.89759],
    [37.647648, 55.896974],
    [37.654448, 55.896283],
    [37.658256, 55.895984],
    [37.659509, 55.895885],
    [37.660411, 55.895831],
    [37.662578, 55.8957],
    [37.663813, 55.895642],
    [37.667879, 55.89545],
    [37.6688, 55.895425],
    [37.671594, 55.895347],
    [37.671885, 55.895338],
    [37.672331, 55.895326],
    [37.672971, 55.895307],
    [37.673219, 55.8953],
    [37.673762, 55.895284],
    [37.673824, 55.895282],
    [37.67633, 55.89521],
    [37.676935, 55.895192],
    [37.678913, 55.895134],
    [37.67896, 55.895133],
    [37.679016, 55.895132],
    [37.680356, 55.895095],
    [37.681053, 55.895076],
    [37.681696, 55.895059],
    [37.684133, 55.894988],
    [37.684402, 55.89498],
    [37.684709, 55.89497],
    [37.684801, 55.894968],
    [37.685602, 55.894949],
    [37.686833, 55.894919],
    [37.68717, 55.89491],
    [37.690313, 55.894827],
    [37.692312, 55.894767],
    [37.693591, 55.894699],
    [37.6955, 55.894549],
    [37.696976, 55.894371],
    [37.697026, 55.894365],
    [37.697904, 55.894231],
    [37.698915, 55.894077],
    [37.699154, 55.894029],
    [37.700474, 55.893766],
    [37.702156, 55.893377],
    [37.703877, 55.892889],
    [37.705431, 55.892378],
    [37.705491, 55.892356],
    [37.706205, 55.892094],
    [37.706542, 55.891971],
    [37.707193, 55.891696],
    [37.707354, 55.891628],
    [37.709049, 55.890882],
    [37.710908, 55.890058],
    [37.711139, 55.889947],
    [37.712602, 55.889245],
    [37.713119, 55.888983],
    [37.715186, 55.887937],
    [37.71783, 55.886569],
    [37.718804, 55.886065],
    [37.719166, 55.885878],
    [37.71941, 55.885751],
    [37.719435, 55.885739],
    [37.720143, 55.88539],
    [37.720662, 55.885133],
    [37.721834, 55.884523],
    [37.721934, 55.884469],
    [37.723465, 55.88365],
    [37.723641, 55.883559],
    [37.723814, 55.883463],
    [37.723965, 55.883383],
    [37.724472, 55.883111],
    [37.724546, 55.883072],
    [37.72466, 55.883015],
    [37.724766, 55.882961],
    [37.725044, 55.882814],
    [37.725227, 55.882724],
    [37.725819, 55.882432],
    [37.726058, 55.882312],
    [37.726524, 55.882078],
    [37.726576, 55.882052],
    [37.726616, 55.882032],
    [37.727433, 55.881629],
    [37.727513, 55.881589],
    [37.729173, 55.880771],
    [37.72954, 55.880605],
    [37.730484, 55.880179],
    [37.730664, 55.880098],
    [37.730976, 55.879957],
    [37.732316, 55.87932],
    [37.732788, 55.87907],
    [37.733248, 55.878826],
    [37.733577, 55.878651],
    [37.733874, 55.878494],
    [37.734213, 55.878319],
    [37.735792, 55.877506],
    [37.739121, 55.875804],
    [37.741269, 55.8747],
    [37.752852, 55.868745],
    [37.764787, 55.862606],
    [37.765997, 55.861983],
    [37.767602, 55.861157],
    [37.77664, 55.856505],
    [37.788525, 55.850386],
    [37.800593, 55.844169],
    [37.812625, 55.837967],
    [37.822823, 55.832708],
    [37.824663, 55.831752],
    [37.826536, 55.830778],
    [37.827789, 55.830128],
    [37.82794, 55.830046],
    [37.828477, 55.829754],
    [37.828577, 55.829699],
    [37.828672, 55.829648],
    [37.828771, 55.829594],
    [37.829068, 55.829432],
    [37.829504, 55.829194],
    [37.8295040001, 55.829194],
    [37.830251, 55.82874],
    [37.830779, 55.828418],
    [37.831587, 55.827856],
    [37.831816, 55.827675],
    [37.831996, 55.827533],
    [37.832408, 55.827227],
    [37.832968, 55.826811],
    [37.833349, 55.82648],
    [37.833628, 55.826238],
    [37.834248, 55.825674],
    [37.834652, 55.825281],
    [37.834764, 55.825172],
    [37.834973, 55.82492],
    [37.835484, 55.824305],
    [37.835862, 55.823825],
    [37.836367, 55.823134],
    [37.836976, 55.8221700001],
    [37.836976, 55.82217],
    [37.83735, 55.821433],
    [37.837822, 55.820304],
    [37.837881, 55.820131],
    [37.838022, 55.819716],
    [37.83814, 55.819168],
    [37.838167, 55.819045],
    [37.838271, 55.818434],
    [37.838387, 55.817577],
    [37.838424, 55.817119],
    [37.838471, 55.816955],
    [37.838591, 55.816546],
    [37.83869, 55.816209],
    [37.838784, 55.815729],
    [37.83891, 55.814627],
    [37.83897, 55.814108],
    [37.838984, 55.813986],
    [37.839002, 55.81383],
    [37.839013, 55.813736],
    [37.839053, 55.813383],
    [37.839167, 55.812392],
    [37.839254, 55.811406],
    [37.83935, 55.810773],
    [37.839369, 55.810577],
    [37.83937, 55.810568],
    [37.839421, 55.810038],
    [37.839422, 55.810032],
    [37.839538, 55.80884],
    [37.839708, 55.807655],
    [37.83971, 55.807638],
    [37.839721, 55.807452],
    [37.839723, 55.807424],
    [37.839728, 55.807331],
    [37.839733, 55.807252],
    [37.839752, 55.806918],
    [37.839753, 55.805734],
    [37.839778, 55.80492],
    [37.839786, 55.804835],
    [37.83982, 55.804514],
    [37.839835, 55.804362],
    [37.839865, 55.804089],
    [37.840009, 55.802786],
    [37.840013, 55.802753],
    [37.840013, 55.802748],
    [37.840065, 55.802309],
    [37.840379, 55.799629],
    [37.840509, 55.798315],
    [37.840654, 55.796858],
    [37.840972, 55.793995],
    [37.841007, 55.793655],
    [37.841338, 55.790436],
    [37.841387, 55.790027],
    [37.84149, 55.789179],
    [37.841645, 55.787905],
    [37.841959, 55.785157],
    [37.841987, 55.784912],
    [37.842233, 55.7824],
    [37.842401, 55.781038],
    [37.842452, 55.780629],
    [37.842534, 55.779882],
    [37.84261, 55.779203],
    [37.842639, 55.778934],
    [37.842762, 55.777827],
    [37.842781, 55.777656],
    [37.842808, 55.777407],
    [37.842846, 55.777071],
    [37.842866, 55.776888],
    [37.842907, 55.77652],
    [37.842924, 55.776362],
    [37.84297, 55.775944],
    [37.843094, 55.774769],
    [37.843245, 55.773343],
    [37.843299, 55.772665],
    [37.843421, 55.771142],
    [37.843396, 55.770541],
    [37.843371, 55.769924],
    [37.843367, 55.769832],
    [37.843352, 55.769465],
    [37.843341, 55.769244],
    [37.843338, 55.769185],
    [37.843333, 55.769087],
    [37.843273, 55.767891],
    [37.843229, 55.767003],
    [37.843213, 55.766682],
    [37.843081, 55.763921],
    [37.842924, 55.761135],
    [37.842879, 55.760344],
    [37.842847, 55.759737],
    [37.842788, 55.758613],
    [37.842753, 55.757935],
    [37.84273, 55.757533],
    [37.842628, 55.755723],
    [37.842625, 55.755658],
    [37.8426, 55.755147],
    [37.842461, 55.752293],
    [37.842434, 55.751764],
    [37.842314, 55.749384],
    [37.842287, 55.748837],
    [37.842277, 55.748633],
    [37.842218, 55.747393],
    [37.842211, 55.747251]              ,
    [37.842143, 55.745807],
    [37.842109, 55.745094],
    [37.84209, 55.744692],
    [37.842085, 55.744632],
    [37.842042, 55.744061],
    [37.842033, 55.743943],
    [37.842008, 55.743621],
    [37.842001, 55.743519],
    [37.841986, 55.743331],
    [37.841893, 55.742104],
    [37.841736, 55.740642],
    [37.841578, 55.73917],
    [37.841358, 55.736902],
    [37.841055, 55.734447],
    [37.841006, 55.73405],
    [37.841004, 55.734033],
    [37.840609, 55.730888],
    [37.840591, 55.730727],
    [37.840578, 55.730614],
    [37.840427, 55.729261],
    [37.840308, 55.728193],
    [37.840035, 55.72608],
    [37.839881, 55.724897],
    [37.839522, 55.722022],
    [37.83951, 55.721926],
    [37.839264, 55.719945],
    [37.839117, 55.718758],
    [37.839105, 55.718666],
    [37.839099, 55.718613],
    [37.839075, 55.718424],
    [37.838935, 55.717123],
    [37.838881, 55.716624],
    [37.838858, 55.716403],
    [37.838814, 55.715999],
    [37.838799, 55.715859],
    [37.838745, 55.715522],
    [37.8387, 55.715348],
    [37.838532, 55.714805],
    [37.838247, 55.713888],
    [37.837851, 55.712935],
    [37.837771, 55.712776],
    [37.837406, 55.712049],
    [37.837358, 55.711958],
    [37.837316, 55.711877],
    [37.837284, 55.711815],
    [37.836719, 55.710739],
    [37.836555, 55.710426],
    [37.836443, 55.710222],
    [37.836314, 55.709987],
    [37.836214, 55.709805],
    [37.836049, 55.709505],
    [37.835969, 55.709358],
    [37.835876, 55.709185],
    [37.835441, 55.708373],
    [37.835251, 55.708018],
    [37.835189, 55.707903],
    [37.835125, 55.707783],
    [37.834926, 55.707404],
    [37.834825, 55.707213],
    [37.834035, 55.70571],
    [37.833869, 55.705382],
    [37.833412, 55.704482],
    [37.833319, 55.704314],
    [37.832622, 55.703048],
    [37.832536, 55.702892],
    [37.831322, 55.70056],
    [37.831203, 55.700329],
    [37.831128, 55.700185],
    [37.830748, 55.699453],
    [37.83066, 55.699241],
    [37.830502, 55.698861],
    [37.830454, 55.698744],
    [37.830445, 55.698716],
    [37.830406, 55.698597],
    [37.830294, 55.698245],
    [37.830112, 55.697546],
    [37.830021, 55.697198],
    [37.830004, 55.697124],
    [37.829823, 55.696347],
    [37.829796, 55.696195],
    [37.829718, 55.695775],
    [37.829598, 55.695058],
    [37.829519, 55.694288],
    [37.829456, 55.693495],
    [37.829448, 55.692227],
    [37.829571, 55.691186],
    [37.829643, 55.69074],
    [37.829652, 55.690686],
    [37.829775, 55.690093],
    [37.829819, 55.689939],
    [37.830095, 55.688957],
    [37.830481, 55.687696],
    [37.830507, 55.687613],
    [37.830613, 55.68733],
    [37.830666, 55.68719],
    [37.830764, 55.68693],
    [37.830823, 55.686773],
    [37.830901, 55.686567],
    [37.831159, 55.685816],
    [37.83136, 55.685294],
    [37.831533, 55.684819],
    [37.832132, 55.68317],
    [37.832179, 55.68304],
    [37.832309, 55.682683],
    [37.832386, 55.682484],
    [37.832453, 55.682314],
    [37.832543, 55.682112],
    [37.832765, 55.681639],
    [37.83302, 55.681089],
    [37.833092, 55.680937],
    [37.833203, 55.680702],
    [37.8333, 55.680478],
    [37.833382, 55.680303],
    [37.83354, 55.679929],
    [37.834107, 55.678326],
    [37.834961, 55.675989],
    [37.835442, 55.674684],
    [37.836094, 55.672912],
    [37.836101, 55.672893],
    [37.836332, 55.672269],
    [37.836873, 55.670809],
    [37.83695, 55.670594],
    [37.838456, 55.666374],
    [37.838892, 55.66519],
    [37.83906, 55.664715],
    [37.839168, 55.664409],
    [37.839241, 55.664221],
    [37.839313, 55.664008],
    [37.83937, 55.663792],
    [37.839431, 55.663539],
    [37.839446, 55.663484],
    [37.839502, 55.663284],
    [37.839555, 55.66305],
    [37.839624, 55.662696],
    [37.839684, 55.662349],
    [37.839746, 55.662073],
    [37.83979, 55.661832],
    [37.839833, 55.661544],
    [37.83985, 55.661296],
    [37.839856, 55.661097],
    [37.839866, 55.660777],
    [37.839862, 55.660325],
    [37.839835, 55.659855],
    [37.839807, 55.659428],
    [37.839774, 55.659056],
    [37.839727, 55.658665],
    [37.8397, 55.658515],
    [37.839653, 55.658247],
    [37.839581, 55.657886],
    [37.839542, 55.657676],
    [37.839476, 55.657465],
    [37.839357, 55.65709],
    [37.839336, 55.657023],
    [37.839312, 55.656952],
    [37.839294, 55.656899],
    [37.839157, 55.656504],
    [37.838998, 55.656121],
    [37.83877, 55.655573],
    [37.838717, 55.655452],
    [37.838613, 55.655217],
    [37.838613, 55.6552169999],
    [37.83848, 55.654997],
    [37.83831, 55.654733],
    [37.837587, 55.653633],
    [37.83745, 55.653424],
    [37.837301, 55.653205],
    [37.837174, 55.653018],
    [37.836963, 55.652724],
    [37.836541, 55.652268],
    [37.836056, 55.65172],
    [37.835724, 55.65135],
    [37.835377, 55.651002],
    [37.835337, 55.650969],
    [37.83504, 55.650722],
    [37.834835, 55.650541],
    [37.834439, 55.650192],
    [37.834123, 55.649927],
    [37.833628, 55.649548],
    [37.833328, 55.649322],
    [37.832869, 55.648985],
    [37.83269, 55.648853],
    [37.832661, 55.648834],
    [37.831999, 55.648405],
    [37.83067, 55.647544],
    [37.829687, 55.646897],
    [37.827889, 55.645712],
    [37.827463, 55.645437],
    [37.827011, 55.645146],
    [37.825062, 55.643889],
    [37.824795, 55.643716],
    [37.822345, 55.642101],
    [37.820257, 55.640784],
    [37.820034, 55.640644],
    [37.819969, 55.6406],
    [37.819888, 55.640545],
    [37.819839, 55.640512],
    [37.819612, 55.640358],
    [37.819149, 55.640044],
    [37.817907, 55.639201],
    [37.817367, 55.638835],
    [37.814857, 55.637206],
    [37.812087, 55.635401],
    [37.80911, 55.633449],
    [37.808825, 55.633265],
    [37.807192, 55.632209],
    [37.807012, 55.632093],
    [37.806898, 55.632019],
    [37.80477, 55.630621],
    [37.80248, 55.629135],
    [37.800321, 55.627702],
    [37.799315, 55.627035],
    [37.798464, 55.626423],
    [37.798463, 55.626422],
    [37.798147, 55.626195],
    [37.797815, 55.625958],
    [37.79693, 55.625361],
    [37.795455, 55.624458],
    [37.7954520001, 55.624456],
    [37.795452, 55.624456],
    [37.794239, 55.623758],
    [37.793132, 55.623156],
    [37.791961, 55.622519],
    [37.791651, 55.622356],
    [37.79101, 55.62202],
    [37.789953, 55.621453],
    [37.789229, 55.62109],
    [37.788638, 55.620819],
    [37.788232, 55.62065],
    [37.787773, 55.620459],
    [37.78714, 55.620171],
    [37.786931, 55.620076],
    [37.786447, 55.619857],
    [37.786351, 55.619814],
    [37.785972, 55.619622],
    [37.785271, 55.619256],
    [37.783925, 55.618529],
    [37.783795, 55.618457],
    [37.782465, 55.617722],
    [37.782393, 55.617682],
    [37.780922, 55.616868],
    [37.780447, 55.616607],
    [37.780149, 55.616443],
    [37.779914, 55.616314],
    [37.779715, 55.616204],
    [37.777768, 55.615134],
    [37.775902, 55.614108],
    [37.774874, 55.613542],
    [37.771409, 55.611619],
    [37.76852, 55.610038],
    [37.764952, 55.608062],
    [37.764557, 55.607844],
    [37.764416, 55.607767],
    [37.758988, 55.604819],
    [37.757025, 55.603746],
    [37.756903, 55.603679],
    [37.756029, 55.603201],
    [37.755989, 55.60318],
    [37.754146, 55.602172],
    [37.75395, 55.60208],
    [37.753662, 55.601943],
    [37.75228, 55.601288],
    [37.750415, 55.600461],
    [37.748194, 55.599532],
    [37.747421, 55.599208],
    [37.746678, 55.598895],
    [37.741351, 55.596659],
    [37.741349, 55.596658],
    [37.739416, 55.595847],
    [37.737826, 55.595181],
    [37.736925, 55.5948],
    [37.734997, 55.593983],
    [37.733406, 55.59333],
    [37.733186, 55.593237],
    [37.730786, 55.59222],
    [37.730544, 55.59212],
    [37.729637, 55.591745],
    [37.729409, 55.591651],
    [37.729284, 55.591599],
    [37.729085, 55.591517],
    [37.728693, 55.591352],
    [37.728442, 55.591246],
    [37.726991, 55.590635],
    [37.726052, 55.590239],
    [37.725585, 55.590042],
    [37.723284, 55.589079],
    [37.721326, 55.588232],
    [37.72021, 55.587786],
    [37.719471, 55.587491],
    [37.718334, 55.587068],
    [37.716795, 55.58649],
    [37.715961, 55.586176],
    [37.715531, 55.586014],
    [37.71547, 55.585992],
    [37.714596, 55.585675],
    [37.713665, 55.585338],
    [37.711833, 55.584646],
    [37.70892, 55.583558],
    [37.707757, 55.583118],
    [37.707106, 55.582876],
    [37.706901, 55.5828],
    [37.705592, 55.582313],
    [37.705375, 55.582231],
    [37.704548, 55.58192],
    [37.703669, 55.581589],
    [37.703127, 55.581387],
    [37.702684, 55.581221],
    [37.70133, 55.580717],
    [37.700963, 55.580581],
    [37.700018, 55.580232],
    [37.698868, 55.579808],
    [37.696261, 55.578835],
    [37.695969, 55.578725],
    [37.695803, 55.578662],
    [37.695643, 55.578602],
    [37.694435, 55.578146],
    [37.692544, 55.577452],
    [37.690871, 55.576838],
    [37.690154, 55.57656],
    [37.689576, 55.576343],
    [37.688955, 55.576111],
    [37.688257, 55.57585],
    [37.687894, 55.575714],
    [37.68656, 55.575215],
    [37.686107, 55.575046],
    [37.684494, 55.574475],
    [37.683171, 55.574022],
    [37.681931, 55.573667],
    [37.680743, 55.573342],
    [37.679273, 55.572991],
    [37.678276, 55.572783],
    [37.676224, 55.572424],
    [37.675539, 55.572333],
    [37.67544, 55.57232],
    [37.674624, 55.572211],
    [37.67331, 55.572069],
    [37.672862, 55.572029],
    [37.671783, 55.571933],
    [37.671151, 55.571891],
    [37.670497, 55.57185],
    [37.669522, 55.57182],
    [37.668914, 55.571799],
    [37.667662, 55.571791],
    [37.667028, 55.571807],
    [37.665175, 55.571871],
    [37.664385, 55.571911],
    [37.664081, 55.571926],
    [37.664064, 55.571927],
    [37.6635, 55.571956],
    [37.662032, 55.572048],
    [37.660097, 55.572176],
    [37.659442, 55.572212],
    [37.659288, 55.57222],
    [37.657957, 55.572292],
    [37.655864, 55.572424],
    [37.654411, 55.572512],
    [37.653623, 55.57256],
    [37.652959, 55.572597],
    [37.652935, 55.572598],
    [37.652759, 55.572608],
    [37.652558, 55.572619],
    [37.652536, 55.57262],
    [37.652165, 55.572641],
    [37.651656, 55.572671],
    [37.650603, 55.572734],
    [37.649975, 55.57277],
    [37.647731, 55.5729],
    [37.647555, 55.57291],
    [37.646094, 55.572991],
    [37.64583, 55.573005],
    [37.644087, 55.573118],
    [37.642425, 55.573214],
    [37.642005, 55.573242],
    [37.641345, 55.573285],
    [37.641334, 55.573285],
    [37.640372, 55.57334],
    [37.639565, 55.573385],
    [37.637722, 55.573489],
    [37.636272, 55.573571],
    [37.635616, 55.573608],
    [37.63491, 55.573649],
    [37.633383, 55.573736],
    [37.632519, 55.573786],
    [37.631188, 55.573863],
    [37.629373, 55.573969],
    [37.628084, 55.574043],
    [37.626793, 55.574117],
    [37.62524, 55.574219],
    [37.625218, 55.57422],
    [37.623031, 55.574347],
    [37.620924, 55.574475],
    [37.619539, 55.574562],
    [37.619315, 55.574576],
    [37.618184, 55.574646],
    [37.616727, 55.574732],
    [37.614799, 55.574836],
    [37.613723, 55.574902],
    [37.613157, 55.574936],
    [37.612535, 55.574972],
    [37.609765, 55.575129],
    [37.609358, 55.575152],
    [37.608101, 55.575223],
    [37.607492, 55.575258],
    [37.602576, 55.57555],
    [37.60104, 55.57564],
    [37.600949, 55.575645],
    [37.60054, 55.575667],
    [37.600205, 55.575685],
    [37.598669, 55.575767],
    [37.598427, 55.57578],
    [37.598326, 55.575785],
    [37.59788, 55.575809],
    [37.597067, 55.575875],
    [37.596875, 55.57589],
    [37.596472, 55.575923],
    [37.595778, 55.575979],
    [37.595472, 55.576004],
    [37.593559, 55.576224],
    [37.593364, 55.576247],
    [37.591576, 55.576539],
    [37.590157, 55.576786],
    [37.59013, 55.57679],
    [37.589189, 55.576984],
    [37.583698, 55.578275],
    [37.579204, 55.579344],
    [37.575531, 55.580218],
    [37.574793, 55.580396],
    [37.573835, 55.580621],
    [37.573548, 55.580693],
    [37.573484, 55.580709],
    [37.573451, 55.580717],
    [37.573414, 55.580726],
    [37.57264, 55.580912],
    [37.572517, 55.580942],
    [37.569766, 55.581609],
    [37.566511, 55.582384],
    [37.564557, 55.58285],
    [37.555615, 55.584982],
    [37.549825, 55.586381],
    [37.545913, 55.587325],
    [37.54514, 55.587509],
    [37.543668, 55.58786],
    [37.537509, 55.589325],
    [37.534485, 55.59005],
    [37.530692, 55.590958],
    [37.530178, 55.591082],
    [37.529725, 55.591192],
    [37.529054, 55.591354],
    [37.528925, 55.591386],
    [37.527815, 55.591655],
    [37.525656, 55.592179],
    [37.52457, 55.592443],
    [37.521498, 55.593168],
    [37.519875, 55.593561],
    [37.518866, 55.593805],
    [37.518587, 55.593873],
    [37.517147, 55.594225],
    [37.515968, 55.59457],
    [37.514575, 55.594985],
    [37.513301, 55.595448],
    [37.511996, 55.595956],
    [37.510699, 55.596492],
    [37.509142, 55.597264],
    [37.508382, 55.597693],
    [37.50813, 55.597836],
    [37.507735, 55.598061],
    [37.5077349999, 55.598061],
    [37.507241, 55.598362],
    [37.5072409999, 55.598362],
    [37.506864, 55.598572],
    [37.506522, 55.598763],
    [37.5065219999, 55.598763],
    [37.506384, 55.598845],
    [37.506121, 55.599003],
    [37.505182, 55.599721],
    [37.504582, 55.600211],
    [37.503693, 55.600935],
    [37.501963, 55.602344],
    [37.500621, 55.60353],
    [37.500137, 55.603946],
    [37.497973, 55.605807],
    [37.497954, 55.605823],
    [37.497706, 55.606039],
    [37.494941, 55.608439],
    [37.494712, 55.608638],
    [37.493715, 55.609489],
    [37.492289, 55.610698],
    [37.491896, 55.611032],
    [37.49177, 55.611139],
    [37.491336, 55.611507],
    [37.490744, 55.61201],
    [37.49069, 55.612055],
    [37.49024, 55.612437],
    [37.489225, 55.613308],
    [37.489173, 55.613353],
    [37.486779, 55.615409],
    [37.486701, 55.615477],
    [37.486173, 55.615929],
    [37.486122, 55.615973],
    [37.483456, 55.618257],
    [37.480987, 55.620366],
    [37.480412, 55.620865],
    [37.480362, 55.620907],
    [37.47811, 55.622859],
    [37.474971, 55.625547],
    [37.474759, 55.625728],
    [37.474668, 55.625805],
    [37.474605, 55.625859],
    [37.474093, 55.626295],
    [37.471831, 55.628219],
    [37.471785, 55.628258],
    [37.471384, 55.628599],
    [37.470508, 55.629343],
    [37.469894, 55.629871],
    [37.468554, 55.631023],
    [37.467974, 55.631521],
    [37.46791, 55.631576],
    [37.467585, 55.631856],
    [37.466889, 55.632454],
    [37.464672, 55.634361],
    [37.464641, 55.634387],
    [37.463048, 55.635747],
    [37.462807, 55.635953],
    [37.46203, 55.636616],
    [37.461903, 55.636724],
    [37.461415, 55.63714],
    [37.460064, 55.638289],
    [37.459817, 55.638499],
    [37.459476, 55.638789],
    [37.459335, 55.638909],
    [37.459249, 55.638983],
    [37.458985, 55.639209],
    [37.458696, 55.639458],
    [37.456869, 55.641042],
    [37.455556, 55.642155],
    [37.454395, 55.64314],
    [37.454074, 55.643413],
    [37.453963, 55.643507],
    [37.453803, 55.643643],
    [37.452526, 55.644734],
    [37.451586, 55.645539],
    [37.450487, 55.646477],
    [37.447904, 55.64869],
    [37.445696, 55.650584],
    [37.4456, 55.650666],
    [37.444044, 55.651983],
    [37.443803, 55.652186],
    [37.443709, 55.652261],
    [37.442063, 55.653566],
    [37.441965, 55.653645],
    [37.439086, 55.656012],
    [37.438863, 55.656202],
    [37.438176, 55.656788],
    [37.436975, 55.657812],
    [37.436768, 55.657989],
    [37.435088, 55.659422],
    [37.434984, 55.659515],
    [37.434807, 55.659675],
    [37.434401, 55.660049],
    [37.433697, 55.660747],
    [37.433125, 55.661351],
    [37.43285, 55.661641],
    [37.432778, 55.661717],
    [37.432722, 55.661776],
    [37.432568, 55.661939],
    [37.432193, 55.662321],
    [37.432141, 55.662374],
    [37.432063, 55.662454],
    [37.431782, 55.662739],
    [37.431635, 55.662904],
    [37.430819, 55.663817],
    [37.430715, 55.663951],
    [37.429607, 55.665378],
    [37.429501, 55.665518],
    [37.429152, 55.665978],
    [37.428896, 55.666318],
    [37.428122, 55.66734],
    [37.427974, 55.667535],
    [37.427958, 55.667556],
    [37.42766, 55.66795],
    [37.427634, 55.667986],
    [37.427523, 55.668133],
    [37.426577, 55.669388],
    [37.425658, 55.67063],
    [37.425472, 55.67088],
    [37.423361, 55.67373],
    [37.422768, 55.674531],
    [37.422595, 55.674765],
    [37.4225, 55.674893],
    [37.422249, 55.675221],
    [37.421574, 55.676107],
    [37.421562, 55.676123],
    [37.420465, 55.677563],
    [37.418714, 55.679942],
    [37.418297, 55.68047],
    [37.418135, 55.680686],
    [37.417081, 55.682087],
    [37.417, 55.682214],
    [37.41671, 55.682667],
    [37.41668, 55.682714],
    [37.416662, 55.682742],
    [37.416636, 55.682781],
    [37.416592, 55.682851],
    [37.416399, 55.683152],
    [37.416381, 55.6831809999],
    [37.416381, 55.683181],
    [37.415934, 55.684009],
    [37.415848, 55.684193],
    [37.415667, 55.684583],
    [37.415382, 55.685297],
    [37.415346, 55.685387],
    [37.415191, 55.685877],
    [37.414981, 55.686542],
    [37.414876, 55.686875],
    [37.414405, 55.688105],
    [37.414365, 55.688186],
    [37.414267, 55.688388],
    [37.414181, 55.688564],
    [37.414139, 55.688651],
    [37.414139, 55.6886510001],
    [37.413786, 55.689202],
    [37.413289, 55.689978],
    [37.413207, 55.690106],
    [37.413141, 55.690211],
    [37.41286, 55.690649],
    [37.412745, 55.690781]       ,   
    [37.412308, 55.691286],
    [37.412109, 55.691515],
    [37.412002, 55.691639],
    [37.410764, 55.692872],
    [37.41035, 55.69323],
    [37.408318, 55.694793],
    [37.404672, 55.697497],
    [37.402856, 55.698868],
    [37.402815, 55.698897],
    [37.4028, 55.698908],
    [37.40237, 55.699217],
    [37.400977, 55.700219],
    [37.400346, 55.700672],
    [37.400266, 55.700733],
    [37.399191, 55.701546],
    [37.398992, 55.701697],
    [37.398906, 55.701762],
    [37.398841, 55.70181],
    [37.398393, 55.702149],
    [37.398268, 55.702243],
    [37.397557, 55.70278],
    [37.396974, 55.70322],
    [37.396263, 55.703747],
    [37.395319, 55.704446],
    [37.395038, 55.704654],
    [37.393787, 55.705558],
    [37.39308, 55.706069],
    [37.39301, 55.706119],
    [37.392938, 55.706173],
    [37.391647, 55.707132],
    [37.390826, 55.707732],
    [37.390385, 55.708055],
    [37.389871, 55.708449],
    [37.389516, 55.70877],
    [37.389197, 55.709057],
    [37.388914, 55.70932],
    [37.388664, 55.709565],
    [37.388299, 55.709952],
    [37.387787, 55.710503],
    [37.387353, 55.711013],
    [37.386683, 55.71194],
    [37.386346, 55.712482],
    [37.385991, 55.7130539999],
    [37.385991, 55.713054],
    [37.385962, 55.713106],
    [37.385855, 55.713302],
    [37.385776, 55.713447],
    [37.385701, 55.713584],
    [37.385634, 55.713707],
    [37.385496, 55.713959],
    [37.385452, 55.714045],
    [37.385323, 55.714301],
    [37.384832, 55.715271],
    [37.384665, 55.715585],
    [37.384598, 55.715739],
    [37.384431, 55.716074],
    [37.38435, 55.716228],
    [37.383815, 55.717255],
    [37.38341, 55.718031],
    [37.383288, 55.718276],
    [37.383021, 55.71881],
    [37.383004, 55.718842],
    [37.382907, 55.719037],
    [37.38252, 55.71975],
    [37.381682, 55.72138],
    [37.381273, 55.722177],
    [37.380983, 55.722752],
    [37.38068, 55.723352],
    [37.380657, 55.723397],
    [37.380633, 55.723445],
    [37.380607, 55.723497],
    [37.380582, 55.723546],
    [37.379688, 55.725319],
    [37.379672, 55.725349],
    [37.378033, 55.728528],
    [37.377916, 55.72876],
    [37.377864, 55.728862],
    [37.377711, 55.729166],
    [37.376803, 55.730966],
    [37.376702, 55.731167],
    [37.376382, 55.731801],
    [37.376274, 55.732011],
    [37.376226, 55.732105],
    [37.376182, 55.73219],
    [37.375628, 55.733266],
    [37.374882, 55.734714],
    [37.374658, 55.735149],
    [37.373276, 55.737844],
    [37.371908, 55.740535],
    [37.371766, 55.740813],
    [37.370593, 55.743139],
    [37.370202, 55.744003],
    [37.369913, 55.744752],
    [37.369451, 55.746092],
    [37.369095, 55.747513],
    [37.36888, 55.748808],
    [37.368772, 55.749909]
]

ckad = [
    [37.53227867739887, 56.206025409385994],
    [38.03023809973654, 56.11118365023529],
    [38.56170172278342, 55.95201729289429],
    [38.62761969153341, 55.820034428849326],
    [38.48754400793966, 55.57494850040366],
    [38.39690680090843, 55.358056850452314],
    [37.92724127356466, 55.31422134285912],
    [37.46055166054553, 55.3283571008945],
    [37.31804527896136, 55.35551667999378],
    [36.877218862945746, 55.52726752542835],
    [36.76186241763325, 55.82525531874069],
    [37.1820894684145, 56.17999197714168],
    [37.53227867739887, 56.206025409385994]
]

spb = [
    [30.14976444792315, 60.06655476341536],
    [30.186105010738213, 60.08599364893113],
    [30.239663360347603, 60.099710937446865],
    [30.291848418941345, 60.10656743366661],
    [30.37699246191008, 60.1038250070006],
    [30.390725372066335, 60.0818773452062],
    [30.39347195409761, 60.0674662207815],
    [30.420937774410085, 60.05716869172165],
    [30.449776885738213, 60.03999897685832],
    [30.47724270605072, 60.0186960853314],
    [30.488229034175728, 59.996003666766335],
    [30.54453396581634, 59.982243080648765],
    [30.56238674901946, 59.97191887314247],
    [30.550027129878853, 59.94368288836672],
    [30.536294219722603, 59.91266437528991],
    [30.536294219722603, 59.89403929634329],
    [30.543160674800713, 59.87471332682229],
    [30.537667510738224, 59.86435548969395],
    [30.51569485448821, 59.85054000394465],
    [30.484109161128835, 59.84984907854437],
    [30.466256377925713, 59.84363010222465],
    [30.45115017675384, 59.82496617670831],
    [30.411324737300728, 59.81113427870665],
    [30.361886260738206, 59.81113427870665],
    [30.34001690268621, 59.80307056680336],
    [30.3166709554206, 59.80791356172903],
    [30.27684551596746, 59.830735317094735],
    [30.23976665854559, 59.822438311587646],
    [30.17934185385809, 59.79753485104545],
    [30.160115779639348, 59.79338245907762],
    [30.109304012061205, 59.812064138422485],
    [30.01454693198308, 59.811372411651966],
    [29.99669414877996, 59.81759743405191],
    [29.976781429053354, 59.82122815835286],
    [29.957898677588553, 59.819672182255495],
    [29.912580074072924, 59.81154534468601],
    [29.881509364844415, 59.811458878272504],
    [29.8507819783698, 59.8125829240386],
    [29.832414211035783, 59.82140104007639],
    [29.816106380225285, 59.83194512381211],
    [29.811643184424447, 59.84222670074985],
    [29.803746761084607, 59.85440495055244],
    [29.797910274268197, 59.85932680378841],
    [29.787610591651053, 59.86459324100964],
    [29.77506126693148, 59.86693440624316],
    [29.751981833832257, 59.86783558267052],
    [29.72945578915764, 59.87156610471242],
    [29.70692974448305, 59.87719475913851],
    [29.682210506201763, 59.884097668585504],
    [29.659551204443986, 59.894104332552054],
    [29.657491267920506, 59.912125949885855],
    [29.66435772299864, 59.92458013512174],
    [29.66916424155332, 59.93513450913574],
    [29.69594341635809, 60.00105528762679],
    [29.720662654639327, 60.02099488649355],
    [29.796193660498705, 60.02786781313764],
    [29.9225364339362, 60.039548497301304],
    [30.004933894873723, 60.045043856039385],
    [30.0969443929206, 60.05671844714616],
    [30.14976444792315, 60.06655476341536]
]

def define_poly(lon, lat):
    poly_mkad = Polygon(mkad)
    poly_ckad = Polygon(ckad)
    poly_spb = Polygon(spb)
    point = Point(lat, lon)
    if poly_mkad.contains(point):
        return "Moscow_MKAD"
    elif poly_ckad.contains(point):
        return "Moscow_CKAD"
    elif poly_spb.contains(point):
        return "SPB_KAD"
    else:
        return "ERROR"
@@;

$in_polygon = Python3::define_poly(Callable<(Double?, Double?) -> String?>, $py_poly);

$features = ($meta_data) -> { 
    return Yson::YPath(Yson::Parse($meta_data), "/features") 
};

$billing_features_string = ($meta_data, $feature) -> {
    return Yson::YPathString(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'billing'
    })[0], '/resource_billing_feature/' || $feature)
};

$billing_features_int = ($meta_data, $feature) -> {
    return Yson::YPathInt64(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'billing'
    })[0], '/resource_billing_feature/' || $feature)
};

$get_physical = ($meta_data) -> {
    return ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'physical'
    })
};

$extract_items_from_box = ($meta_data) -> {
    return Yson::YPathList($meta_data, '/resource_physical_feature/items')
};

$extract_weight_from_box = ($meta_data) -> {
    return Yson::YPathInt64($meta_data, '/resource_physical_feature/weight')
};

$get_all_items = ($meta_data) -> {
    return ListFlatten(ListMap($get_physical($meta_data), $extract_items_from_box))
};

$get_all_weight = ($meta_data) -> {
    return (ListMap($get_physical($meta_data), $extract_weight_from_box))
};

$extract_total_price = ($meta_data) -> {
    return Yson::YPathUint64($meta_data, '/unit_price') * Yson::YPathUint64($meta_data, '/count')
};
$extract_total_assessed_price = ($meta_data) -> {
    return Yson::YPathUint64($meta_data, '/assessed_unit_price') * Yson::YPathUint64($meta_data, '/count')
};

$all_prices = ($meta_data) -> {
    return ListMap($meta_data, $extract_total_price);
};

$all_assessed_prices = ($meta_data) -> {
    return ListMap($meta_data, $extract_total_assessed_price);
};

$extract_station_id = ($meta_data) -> {
    return Yson::YPathString($meta_data, '/node_location/station_location/station_id');
};

$extract_station_coord = ($meta_data, $coord) -> {
    return Yson::YPathDouble($meta_data, '/location/' || $coord);
};

$extract_station_location = ($meta_data) -> {
    return Yson::YPathString($meta_data, '/location_details/full_address');
};

$extract_addres = ($meta_data) -> {
    $country = Yson::YPathString($meta_data, '/node_location/temporary_location/details/country'); 
    $settlement = Yson::YPathString($meta_data, '/node_location/temporary_location/details/settlement');
    $street = Yson::YPathString($meta_data, '/node_location/temporary_location/details/street'); 
    $house = Yson::YPathString($meta_data, '/node_location/temporary_location/details/house'); 
    $room = Yson::YPathString($meta_data, '/node_location/temporary_location/details/room'); 

    $full_address = Yson::YPathString($meta_data, '/node_location/temporary_location/details/full_address');

    -- СХЕМА, ПО КОТОРОЙ СКЛЕИВАЕТСЯ АДРЕС
    $address = $country || ', ' || $settlement || ', ' || $street || ', ' || $house || ', ' || $room;

    return if($address is not null, $address, $full_address);
};

$coords_x = ($meta_data) -> { 
    return Yson::YPathDouble(Yson::Parse($meta_data), "/node_location/temporary_location/coord/x") 
};
$coords_y = ($meta_data) -> { 
    return Yson::YPathDouble(Yson::Parse($meta_data), "/node_location/temporary_location/coord/y") 
};

-- Вытаскиваем выплаты, по которым был поход в cargo-pricing
$payed_requests = (
    select request_id
        , 1.0 * cast(amount as Int64) / 100 as payments_history_amount_rub
        , status as payments_history_status
        , $dttm_format(DateTime::FromSeconds(cast(history_timestamp as Uint32))) as payments_history_dttm
        -- , account_id
    from range($PAYMENTS_HISTORY, $START_DATE)
    where 1=1
        and account_type = 'delivery'
        and history_action = 'add'
);

-- Походы в cargo-pricing
$cargo_payments = (
    select order_id as request_id
        , cast(amount as Double) as cargo_payments_amount_rub
        , state as cargo_payments_state
        , $dttm_format(DateTime::FromSeconds(cast(history_timestamp as Uint32))) as cargo_payments_dttm
        , billing_doc_id as cargo_payments_billing_doc_id
    from $BILLING_TASKS_HISTORY
    where 1=1
        and order_id in (select request_id from $payed_requests)
        and state in ('Approved', 'approved')
);

-- Что ушло в транзакционный лог 
$tlog_revenues = (
    select transaction_id as tlog_transaction_id
    , orig_transaction_id as tlog_orig_transaction_id
    , service_transaction_id as tlog_service_transaction_id
    , contract_id as tlog_contract_id
    , event_time as tlog_event_time
    , transaction_time as tlog_transaction_time
    , due as tlog_due
    -- , transaction_type
    -- , service_id    
    -- , client_id
    -- , product
    , cast(amount as Double) as tlog_amount_rub
    , currency as tlog_currency
    -- , detailed_product
    -- , payload
    -- , tariff_class
    , agglomeration as tlog_agglomeration
    , invoice_date as tlog_invoice_date
    , cast(Yson::YPathInt64(payload, '/base_doc_id') as String) as tlog_billing_doc_id
    from range($TLOG_REVENUES, $START_DATE)
    where 1=1
        and cast(Yson::YPathInt64(payload, '/base_doc_id') as String) in (select cargo_payments_billing_doc_id from $cargo_payments)
);

-- Отуда была доставка
$from_nodes = (
    select n.request_id as request_id
    , $extract_addres(n.unpacked_data) as from_address
    , $coords_x(n.unpacked_data) as from_x_coord
    , $coords_y(n.unpacked_data) as from_y_coord
    , n.node_id as node_id
    , $extract_station_id(n.unpacked_data) as station_id
    , $extract_station_coord(s.unpacked_data, 'x') as station_x_coord
    , $extract_station_coord(s.unpacked_data, 'y') as station_y_coord
    , $extract_station_location(s.unpacked_data) as station_location
    from range($PLANNED_NODES_HISTORY, $START_DATE) as n 
    left join range($STATIONS_HISTORY, $START_DATE) as s on $extract_station_id(n.unpacked_data) = s.station_id
    where 1=1
        and (Yson::YPathString(n.unpacked_data, '/node_code') = 'n_from' or 
           Yson::YPathString(n.unpacked_data, '/node_code') = 'node_from')
        and n.history_action = 'add'
        and s.history_action = 'add'
);

-- Куда была доставка
$to_nodes = (
    select request_id
    , $extract_addres(unpacked_data) as delivery_address
    , $coords_x(unpacked_data) as to_x_coord
    , $coords_y(unpacked_data) as to_y_coord
    from range($PLANNED_NODES_HISTORY, $START_DATE)
    where (Yson::YPathString(unpacked_data, '/node_code') = 'n_to' or 
           Yson::YPathString(unpacked_data, '/node_code') = 'node_to')
      and history_action = 'add'
);

-- Наиболее актуальный статус
$last_request = (
    select request_id
        , max(history_timestamp) as max_history_timestamp
    from range($REQUESTS_HISTORY, $START_DATE)
    group by request_id
);

-- Убийственный джойн
insert into $SAVE_TO with truncate
select requests.request_id as request_id
    , requests.status as status
    , $dttm_format(DateTime::FromSeconds(cast(requests.history_timestamp as Uint32))) as requests_last_status_timestamp

    , Math::Round(cp.cargo_payments_amount_rub - Math::Round((tariffs.parcels_included_weight_price + 
      (
        --   cast((cast(if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) < 0, -1, (1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)) as Int32) + 1) as Double)
        --   * 
        --   tariffs.parcels_weight_price_per_kilogram
        if(cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double) < 0, 0.0, cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double))
            * 
            tariffs.parcels_weight_price_per_kilogram
      ) 
      + (1.0*(ListSum($all_assessed_prices($get_all_items(resources.unpacked_data)))) / 100) * (1.0 * tariffs.parcels_add_declared_value_pct / 100)) * 1.2, -2), -2) as cargo_pricing_and_calculation_diff
    , Math::Round(coalesce(tr.tlog_amount_rub, 0) - cp.cargo_payments_amount_rub, -2) as tlog_and_cargo_pricing_diff

    , cp.cargo_payments_amount_rub as cargo_pricing_amount_rub
    , tr.tlog_amount_rub as tlog_amount_rub
    , pr.payments_history_amount_rub as lp_payments_history_amount_rub
    , Math::Round((tariffs.parcels_included_weight_price + 
      (
        --   cast((cast(if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) < 0, -1, (1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)) as Int32) + 1) as Double)
        --   * 
        --   tariffs.parcels_weight_price_per_kilogram
        if(cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double) < 0, 0.0, cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double))
            * 
            tariffs.parcels_weight_price_per_kilogram
      ) 
      + (1.0*(ListSum($all_assessed_prices($get_all_items(resources.unpacked_data)))) / 100) * (1.0 * tariffs.parcels_add_declared_value_pct / 100)) * 1.2, -2) as calculated_by_igor_amount_rub

    , requests.request_code as request_code
    , requests.employer_code as employer_code

    , $billing_features_string(resources.unpacked_data, 'cargo_pricing') as cargo_pricing
    , $billing_features_string(resources.unpacked_data, 'payment_method') as payment_method
    , $billing_features_int(resources.unpacked_data, 'delivery_cost') as delivery_cost
    , $billing_features_int(resources.unpacked_data, 'delivery_n_d_s') as delivery_n_d_s
    , 1.0*(ListSum($all_prices($get_all_items(resources.unpacked_data)))) / 100 as items_price_rub
    , 1.0*(ListSum($all_assessed_prices($get_all_items(resources.unpacked_data)))) / 100 as items_assessed_price_rub
    , 1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 as weight_kg
    -- , fn.node_id as node_id
    -- , fn.station_id as station_id

    , fn.station_y_coord ?? fn.from_y_coord as from_y_coord
    , fn.station_x_coord ?? fn.from_x_coord as from_x_coord
    , fn.station_location ?? fn.from_address as from_address

    , tn.delivery_address as delivery_address
    , tn.to_x_coord as to_x_coord
    , tn.to_y_coord as to_y_coord

    , $in_polygon(fn.station_y_coord ?? fn.from_y_coord, fn.station_x_coord ?? fn.from_x_coord) as zone_source
    , $in_polygon(tn.to_y_coord, tn.to_x_coord) as zone_destination

    , tariffs.delivery_return_price_pct as delivery_return_price_pct
    , tariffs.parcels_add_declared_value_pct as parcels_add_declared_value_pct
    , tariffs.parcels_included_weight_price as parcels_included_weight_price
    , tariffs.parcels_weight_prices_begin as parcels_weight_prices_begin
    , tariffs.parcels_weight_price_per_kilogram as parcels_weight_price_per_kilogram
    , Math::Round((1.0*(ListSum($all_assessed_prices($get_all_items(resources.unpacked_data)))) / 100) * (1.0 * tariffs.parcels_add_declared_value_pct / 100), -2) as `Стоимость за "оценочную стоимость"`
    , Math::Round(
        (
            if(cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double) < 0, 0.0, cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double))
            * 
            tariffs.parcels_weight_price_per_kilogram
        ) 
    , -2) as `Стоимость за доп кг`
    , Math::Round(tariffs.parcels_included_weight_price + 
      (
        --   cast((cast(if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) < 0, -1, (1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)) as Int32) + 1) as Double)
        --   * 
        --   tariffs.parcels_weight_price_per_kilogram
        if(cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double) < 0, 0.0, cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double))
            * 
            tariffs.parcels_weight_price_per_kilogram
      ) 
      + (1.0*(ListSum($all_assessed_prices($get_all_items(resources.unpacked_data)))) / 100) * (1.0 * tariffs.parcels_add_declared_value_pct / 100), -2) as `Общая стомость, без НДС`
    , Math::Round((tariffs.parcels_included_weight_price + 
      (
        --   cast((cast(if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) < 0, -1, (1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)) as Int32) + 1) as Double)
        --   * 
        --   tariffs.parcels_weight_price_per_kilogram
        if(cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double) < 0, 0.0, cast(cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) as Int32)
            + if((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin) - cast((1.0*(ListSum($get_all_weight(resources.unpacked_data))) / 1000 - tariffs.parcels_weight_prices_begin)as Int32) > 0, 1, 0) as Double))
            * 
            tariffs.parcels_weight_price_per_kilogram
      ) 
      + (1.0*(ListSum($all_assessed_prices($get_all_items(resources.unpacked_data)))) / 100) * (1.0 * tariffs.parcels_add_declared_value_pct / 100)) * 1.2, -2) as `Общая стоимость с НДС`
    , case 
        when requests.status = 'returned' then Math::Round(cp.cargo_payments_amount_rub * (1.0 * tariffs.delivery_return_price_pct / 100),2)
        when requests.status = 'finished' then Math::Round(cp.cargo_payments_amount_rub, -2)
        when requests.status = 'processing' then 0
        else -9999
    end as `Оценка стоимости финального заказа`
without pr.request_id
    , cp.request_id  
from range($REQUESTS_HISTORY, $START_DATE) as requests
left join range($RESOURCE_HISTORY, $START_DATE) as resources on requests.request_id=resources.request_id
left join $from_nodes as fn on requests.request_id = fn.request_id
left join $to_nodes as tn on requests.request_id = tn.request_id
inner join $last_request as lr on requests.request_id = lr.request_id and requests.history_timestamp = lr.max_history_timestamp
inner join $payed_requests as pr on pr.request_id = requests.request_id
left join $cargo_payments as cp on pr.request_id=cp.request_id
left join $tlog_revenues as tr on tr.tlog_billing_doc_id=cp.cargo_payments_billing_doc_id
inner join $TARIFFS as tariffs on $in_polygon(fn.station_y_coord ?? fn.from_y_coord, fn.station_x_coord ?? fn.from_x_coord) = tariffs.source_zone 
                                and $in_polygon(tn.to_y_coord, tn.to_x_coord) = tariffs.destination_zone
                                and requests.employer_code = tariffs.employer_id
where 1=1
    and tariffs.tariff_category = 'interval_strict';

-- Если вдруг захочется посмотреть без самостоятельного подсчета чисто на числах, которые были в прайсинге
--
-- select pr.*
--     , cp.*
--     , tr.*
--     , rd.status as status
--     , rd.employer_code as employer_code
--     , rd.delivery_address as delivery_address
--     , rd.external_order_id as external_order_id
--     , 1.0*rd.items_assessed_price/100 as rd_items_assessed_price
--     , 1.0*rd.items_price/100 as rd_items_price
--     , rd.weight as rd_weight
--     , rd.x_coord as x_coord
--     , rd.y_coord as y_coord
-- from $payed_requests as pr 
-- left join $cargo_payments as cp on pr.request_id=cp.request_id
-- left join $tlog_revenues as tr on tr.tlog_billing_doc_id=cp.cargo_payments_billing_doc_id
