from datetime import datetime
import pandas as pd

import yt.wrapper as yt
from business_models.startrek import StartrekWrapper

TICKET_ID = 'LOGDATA-981'

def current_utc_timestamp():
     return datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')

def main():
    print(f'{current_utc_timestamp()} - START')
    today = datetime.utcnow().strftime('%Y-%m-%d')
    
    print(f'{current_utc_timestamp()} - Importing data')
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    DATA_PATH = f'//home/taxi-delivery/analytics/production/ndd/pricing/datamart'
    df = pd.DataFrame(list(yt.read_table(DATA_PATH)))
    
    print(f'{current_utc_timestamp()} - Creating excel')
    FILENAME = f'ndd_lp_pricing_{today}.xlsx'
    df.to_excel(FILENAME, index=False)
    
    print(f'Sending to {TICKET_ID}...')
    st = StartrekWrapper()
    st.comment(TICKET_ID, 
               text=f'Данные для проверки интеграции (выгрузка с 2021-11-10 до {today})', 
               attachments=FILENAME,
               summonees=['artemmigunov'])


if __name__ == '__main__':
    main()
    