USE HAHN;
PRAGMA yt.InferSchema;
PRAGMA yt.Pool="taxi-delivery";


-- ==== КОНСТАНТЫ =======================================================================================

$REQUESTS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/requests_history';
$RESOURCES_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/resources_history';
$RESOURCE_ITEMS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/resource_items_history';
$OPERATOR_EVENTS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/operator_events_history';
$PLANNED_TRANSFERS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history';
$PLANNED_NODES_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history';
$STATION_TAGS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/station_tags_history';
$STATIONS_HISTORY = '//home/delivery-dwh/ods/logistic_platform/station_log';
$EMPLOYERS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/employers_history';

-- ГРАНИЦЫ НА ДАТУ СОЗДАНИЯ ЗАЯВКИ
$START_DAY = '2021-05-01';

-- МАППИНГ, ПО КОТОРОМУ ВНЕШНИЕ СТАТУСЫ ПРИВОДЯТСЯ К ЧЕЛОВЕЧЕСКИМ
/*
$EXTERNAL_STATUS_MAPPING = { 
    "201": "Заказ создан"
  , "222": "Ожидается в службе доставки"
  , "224": "Заказ удален с выдачи на доставку"
  , "221": "Доставляется по городу"
  , "231": "Доставлен"
  , "237": "Доставлен частично"
  , "232": "Доставка перенесена"
  , "236": "Доставка перенесена по просьбе клиента"
  , "238": "Доставка отменена по просьбе клиента"
  , "232": "Доставка перенесена"
  , "235": "Доставка отменена (по просьбе магазина или клиента)"
  , "410": "Заявка на доставку отклонена (до поступления товара на склад)"
  , "301": "Доставлен - подтверждено"
  , "302": "Доставлен частично - подтверждено"
  , "305": "Отмена - подтверждено"
  , "213": "Не поступил на склад"
  , "214": "Ожидается в службе доставки"
  , "212": "Заказ частично на складе"
  , "211": "На складе службы доставки"
  , "218": "Заказ подготовлен на магистраль"
  , "219": "На магистрали"
  , "311": "Готовится к возврату"
  , "314": "Готов для передачи магазину"
  , "312": "Возврат на пути к магазину"
  , "313": "Возвращен в магазин"
};*/

-- КУДА ПИШЕМ РЕЗУЛЬТАТ
$YT_TABLE_PATH = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';

-- ==== ВСПОМОГАТЕЛЬНЫЕ ФУНКЦИИ ========================================================================================
-- ПРЕОБРАЗОВЫВАЮ СТРОКУ В ДЕНЬ
$date_format = DateTime::Format("%Y-%m-%d");

-- ПРЕОБРАЗОВЫВАЮ СТРОКУ В DATETIME
$datetime_parse = DateTime::Parse("%Y-%m-%dT%H:%M:%S");

-- ЭКСТРАКТОР ФИЧЕЙ ИЗ unpacked_data
$features = ($meta_data) -> { 
    return Yson::YPath(Yson::Parse($meta_data), "/features") 
};

-- ЭКСТРАКТОР КООРДИНАТ
$coords_x = ($meta_data) -> { 
    return Yson::YPathDouble(Yson::Parse($meta_data), "/node_location/temporary_location/coord/x") 
};
$coords_y = ($meta_data) -> { 
    return Yson::YPathDouble(Yson::Parse($meta_data), "/node_location/temporary_location/coord/y") 
};

-- ЭКСТРАКТОР ТАЙМCЛОТОВ
$time_max = ($meta_data) -> { 
    return Yson::YPathUint64(Yson::Parse($meta_data), "/node_location/temporary_location/delivering_expectations/planned_interval_time/max") 
};
$time_min = ($meta_data) -> { 
    return Yson::YPathUint64(Yson::Parse($meta_data), "/node_location/temporary_location/delivering_expectations/planned_interval_time/min") 
};
-- 2021-06-02 в 20:30:00 выкатили новый резил ЛП, который изменил стукруту unpacked_data
$time_max_new = ($meta_data) -> { 
    return Yson::YPathUint64(Yson::Parse($meta_data), "/requested_processing_interval/planned_interval_time/max") 
};
$time_min_new = ($meta_data) -> { 
    return Yson::YPathUint64(Yson::Parse($meta_data), "/requested_processing_interval/planned_interval_time/min") 
};

-- ЭКСТРАКТОР ТИПА ДОСТАВКИ
$policy = ($meta_data) -> { 
    return Yson::YPathString(Yson::Parse($meta_data), "/node_location/temporary_location/delivering_expectations/policy") 
};

-- ЭКСТРАКТОР СТАТУСОВ ЛП
$lp_status = ($meta_data) -> { 
    return Yson::YPathString(Yson::Parse($meta_data), "/logistic_platform_status") 
};

-- ЭКСТРАКТОР ОПИСАНИЯ СТАТУСОВ ЛП
$lp_desc_status = ($meta_data) -> { 
    return Yson::YPathString(Yson::Parse($meta_data), "/place_current_info/information/description") 
};

-- ЭКСТРАКТОР ВНУТРЕННИХ СТАТУСОВ ЛП
$lp_int_status = ($meta_data) -> { 
    return Yson::YPathString(Yson::Parse($meta_data), "/place_current_info/information/internal_status") 
};

-- 2021-06-02 в 20:30:00 выкатили новый резил ЛП, который изменил стукруту unpacked_data
$policy_new = ($meta_data) -> { 
    return Yson::YPathString(Yson::Parse($meta_data), "/requested_processing_interval/policy") 
};

-- НЕ ОЧЕНЬ ЖЕСТКИЙ ЭКСТРАКТОР ТАЙМЗОНЫ
$get_tz = ($lat, $lon) -> {
    return Geo::RegionByLocation($lat, $lon).timezone_name
};

-- ОЧЕНЬ ЖЕСТКИЙ ЭКСТРАКТОР МЕТОДА ОПЛАТЫ =)
$pay_method = ($meta_data) -> {
    return Yson::YPathString(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'billing'
    })[0], '/resource_billing_feature/payment_method')
};

-- ОЧЕНЬ ЖЕСТКИЙ ЭКСТРАКТОР ВЕСА =)
$weight = ($meta_data) -> {
    return Yson::YPathUint64(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'physical'
    })[0], '/resource_physical_feature/weight')
};

-- ОЧЕНЬ ЖЕСТКИЙ ЭКСТРАКТОР СТОИМОСТИ ДОСТАВКИ =)
$delivery_cost = ($meta_data) -> {
    return Yson::YPathUint64(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'billing'
    })[0], '/resource_billing_feature/delivery_cost')
};

-- ЭКСТРАКТОР КОРП. АЙДИШНИКА
$corp_client = ($meta_data) -> { 
    return Yson::YPathString(Yson::Parse($meta_data), "/corp_client_id") 
};

-- ЭКСТРАКТОР АДРЕСА
$extract_addres = ($meta_data) -> {
    $country = Yson::YPathString($meta_data, '/node_location/temporary_location/details/country'); 
    $settlement = Yson::YPathString($meta_data, '/node_location/temporary_location/details/settlement');
    $street = Yson::YPathString($meta_data, '/node_location/temporary_location/details/street'); 
    $house = Yson::YPathString($meta_data, '/node_location/temporary_location/details/house'); 
    $room = Yson::YPathString($meta_data, '/node_location/temporary_location/details/room'); 

    $full_address = Yson::YPathString($meta_data, '/node_location/temporary_location/details/full_address');

    -- СХЕМА, ПО КОТОРОЙ СКЛЕИВАЕТСЯ АДРЕС
    $address = $country || ', ' || $settlement || ', ' || $street || ', ' || $house || ', ' || $room;

    return if($address is not null, $address, $full_address);
};

$extract_country = ($meta_data) -> {
    $country = Yson::YPathString($meta_data, '/node_location/temporary_location/details/country'); 

    return $country;
};

$extract_locality = ($meta_data) -> {
    $locality = Yson::YPathString($meta_data, '/node_location/temporary_location/details/locality'); 

    return $locality;
};

$extract_settlement = ($meta_data) -> {
    $settlement = Yson::YPathString($meta_data, '/node_location/temporary_location/details/settlement'); 

    return $settlement;
};

$extract_region = ($meta_data) -> {
    $region = Yson::YPathString($meta_data, '/node_location/temporary_location/details/region'); 

    return $region;
};

-- ЭКСТРАКТОРЫ ОТДЕЛЬНЫХ ТОВАРОВ
$get_physical = ($meta_data) -> {
    return ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'physical'
    })
};


$extract_items_from_box = ($meta_data) -> {
    return Yson::YPathList($meta_data, '/resource_physical_feature/items')
};

$extract_weight_from_box = ($meta_data) -> {
    return Yson::YPathInt64($meta_data, '/resource_physical_feature/weight')
};

$extract_x_from_box = ($meta_data) -> {
    return Yson::YPathInt64($meta_data, '/resource_physical_feature/d_x')
};

$extract_y_from_box = ($meta_data) -> {
    return Yson::YPathInt64($meta_data, '/resource_physical_feature/d_y')
};

$extract_z_from_box = ($meta_data) -> {
    return Yson::YPathInt64($meta_data, '/resource_physical_feature/d_z')
};

-- Экстрактор товаров
$get_all_items = ($meta_data) -> {
    return ListFlatten(ListMap($get_physical($meta_data), $extract_items_from_box))
};

$get_all_weight = ($meta_data) -> {
    return (ListMap($get_physical($meta_data), $extract_weight_from_box))
};

$get_all_x = ($meta_data) -> {
    return (ListMap($get_physical($meta_data), $extract_x_from_box))
};

$get_all_y = ($meta_data) -> {
    return (ListMap($get_physical($meta_data), $extract_y_from_box))
};

$get_all_z = ($meta_data) -> {
    return (ListMap($get_physical($meta_data), $extract_z_from_box))
};

-- МАГИЯ, КОТОРАЯ ПОМОГАЕТ ПРОСУММИРОВАТЬ СТОИМОСТИ ВСЕХ ТОВАРОВ
$extract_total_price = ($meta_data) -> {
    return Yson::YPathUint64($meta_data, '/unit_price') * Yson::YPathUint64($meta_data, '/count')
};
$extract_total_assessed_price = ($meta_data) -> {
    return Yson::YPathUint64($meta_data, '/assessed_unit_price') * Yson::YPathUint64($meta_data, '/count')
};

$extract_promise_id = ($meta_data) -> {
    return Yson::YPathString(Yson::Parse($meta_data), "/promise_id")
};

-- 2021-08-12 выкатили новый резил ЛП, который изменил стукруту unpacked_data
$extract_promise_id_new = ($meta_data) -> { 
    return Yson::YPathString(Yson::Parse($meta_data), "/operator_shipment_tag/shipment_id") 
};

$extract_pickup_date = ($meta_data) -> {
    return cast($date_format(AddTimezone(DateTime::MakeDatetime($datetime_parse(substring(Yson::YPathString(Yson::Parse($meta_data), "/pickup_interval"), 0, 19))), 'Europe/Moscow')) as String)
};

$all_prices = ($meta_data) -> {
    return ListMap($meta_data, $extract_total_price);
};
$all_assessed_prices = ($meta_data) -> {
    return ListMap($meta_data, $extract_total_assessed_price);
};

$all_weight = ($meta_data) -> {
    return ListSum($meta_data)
};

$all_z = ($meta_data) -> {
    return ListSum($meta_data)
};

$all_y = ($meta_data) -> {
    return ListSum($meta_data)
};

$all_x = ($meta_data) -> {
    return ListSum($meta_data)
};

-- Экстрактор источника заказа:
-- add_autodetect_station - маркет по клику
-- ds_api - остальной маркет
-- external_api_add - личный кабинет (внешние клиенты)
-- registry - реестры (внешние клиенты)
-- confirm_platform_offer АПИ (внешние клиенты)
$extract_creation_method = ($unpacked_data) -> {
    return Yson::YPathString($unpacked_data, '/creation_method');
};

-- Экстракт модулей
$extract_referal_source = ($unpacked_data) -> {
    $referal_source = Yson::YPathString($unpacked_data, '/referal_source');
    $referral_source = Yson::YPathString($unpacked_data, '/referral_source');
    return coalesce($referral_source, $referal_source);
};
                                                                                
 -- ОЧЕНЬ ЖЕСТКИЙ ЭКСТРАКТОР Имени =)
$first_name = ($meta_data) -> {
    return Yson::YPathString(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'recipient'
    })[0], '/resource_personal_info_feature/first_name')
};

-- ОЧЕНЬ ЖЕСТКИЙ ЭКСТРАКТОР Фамилии =)
$last_name = ($meta_data) -> {
    return Yson::YPathString(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'recipient'
    })[0], '/resource_personal_info_feature/last_name')
};

$contacts = ($meta_data) -> {
    return Yson::YPath(ListSkipWhile(Yson::ConvertToList($features($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'recipient'
    })[0], '/resource_personal_info_feature/contacts')
};
-- ОЧЕНЬ ЖЕСТКИЙ ЭКСТРАКТОР телефона =)
$phone = ($meta_data) -> {
    return Yson::YPathString(ListSkipWhile(Yson::ConvertToList($contacts($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'phone'
    })[0], '/phone_contact/phone_number')
};                      
-- ОЧЕНЬ ЖЕСТКИЙ ЭКСТРАКТОР имейла =)     
$email = ($meta_data) -> {
    return Yson::YPathString(ListSkipWhile(Yson::ConvertToList($contacts($meta_data)), ($x) -> {
        return Yson::ConvertToString(DictLookup(Yson::ConvertToDict($x), 'class_name')) != 'email'
    })[0], '/email_contact/email_address')
};                                                     

-- ТЕХНИЧЕСКИЕ ФУНКЦИИ ДЛЯ ПРЕОБРАЗОВАНИЯ СЕКУНД В УДОБНЫЕ ДАТЫ
$time_cast = ($history_timestamp) -> {
    return CAST($history_timestamp as Uint32) 
};
$seconds_to_dttm = ($seconds) -> {
    return cast(cast(Datetime::FromSeconds($time_cast($seconds)) as Datetime) as String)
};
$seconds_to_dt = ($seconds) -> {
    return cast(cast(Datetime::FromSeconds($time_cast($seconds)) as Date) as String)
};

-- ==== САМ КОД ========================================================================================================
$requests = (
    SELECT  history_event_id
      , history_action
      , $time_cast(history_timestamp) as history_timestamp
      , status as request_status
      , request_id
      , request_code
      , employer_code
      , $seconds_to_dttm(created_at) as created_dttm
      , $corp_client(unpacked_data) as corp_client_id
      , $extract_creation_method(unpacked_data) as creation_method
      , $extract_referal_source(unpacked_data) as referal_source
    FROM RANGE($REQUESTS_HISTORY, $START_DAY)
    WHERE history_action = 'add'
      and cast(cast(Datetime::FromSeconds($time_cast(created_at)) as Date) as String) >= $START_DAY
      and employer_code != 'beru'
);

$request_meta = (
    SELECT request_id
      , history_action
      , $pay_method(unpacked_data) as payment_method
      , $delivery_cost(unpacked_data) as delivery_cost
      , ListSum($all_prices($get_all_items(unpacked_data))) as items_price
      , ListAggregate($all_prices($get_all_items(unpacked_data)), AggregationFactory("Count")) as items_cnt
      , ListSum($all_assessed_prices($get_all_items(unpacked_data))) as items_assessed_price
      , $all_weight($get_all_weight(unpacked_data)) as weight
      , $weight(unpacked_data) as resource_weight
      , ($all_x($get_all_x(unpacked_data)) / 1000.0) * ($all_y($get_all_y(unpacked_data)) / 1000.0) * ($all_z($get_all_z(unpacked_data)) / 1000.0) as volume
      , $phone(unpacked_data) as phone
      , $email(unpacked_data) as email
      , $first_name(unpacked_data) as first_name
      , $last_name(unpacked_data) as last_name                                                                                                        
    FROM RANGE($RESOURCES_HISTORY, $START_DAY)
    WHERE history_action = 'add' 
);

$requests_with_meta = (
    select t1.created_dttm as created_dttm
      , t1.employer_code as employer_code
      , t1.corp_client_id as corp_client_id
      , t1.request_code as request_code
      , t1.request_id as request_id
      , t1.creation_method as creation_method
      , t1.referal_source as referal_source
      , t1.request_status as request_status
      , case 
            when t1.creation_method = 'add_autodetect_station' then 'Маркет по клику'
            when t1.creation_method = 'ds_api' then 'Остальной Маркет'
            when t1.creation_method = 'external_api_add' then 'ЛК (внешние клиенты)'
            when t1.creation_method = 'registry' then 'Реестры (внешние клиенты)'
            when t1.creation_method = 'confirm_platform_offer' then 'API (внешние клиенты)'
            else 'unknown' -- cainiao и emulator пока не используются (с) Дима Золотарев
        end as creation_method_human
      , t2.delivery_cost as delivery_cost
      , t2.weight as weight
      , t2.resource_weight as resource_weight
      , t2.volume as volume
      , t2.payment_method as payment_method
      , t2.items_price as items_price
      , t2.items_cnt as items_cnt
      , t2.items_assessed_price as items_assessed_price
      , t2.phone as phone
      , t2.email as email
      , t2.first_name as first_name
      , t2.last_name as last_name
    from $requests as t1
    left join $request_meta as t2 on t1.request_id = t2.request_id
);

$STATIONS = (
    select
        station_id,
        maxby(operator_id, event_id) as station_operator_id,
        maxby(station_location_full_address, event_id) as station_location_full_address,
        maxby(station_location_city_name_ru, event_id) as station_location_city_name_ru,
        maxby(station_location_country_name_ru, event_id) as station_location_country_name_ru,
        maxby(station_location_federal_district, event_id) as station_location_federal_district,
        maxby(station_location_lat, event_id) as y_coord_A,
        maxby(station_location_lon, event_id) as x_coord_A
    from range($STATIONS_HISTORY, $START_DAY)
    group by station_id
);

$to_nodes = (
    select request_id
    ,  if(Datetime::FromSeconds($time_cast(history_timestamp)) < Timestamp('2021-06-02T17:30:00.000000Z'), 
           $policy(unpacked_data), 
           $policy_new(unpacked_data)) as policy
    , $seconds_to_dttm(
        if(Datetime::FromSeconds($time_cast(history_timestamp)) < Timestamp('2021-06-02T17:30:00.000000Z'), 
           $time_min(unpacked_data), 
           $time_min_new(unpacked_data))
      ) as planned_interval_time_min
    , $seconds_to_dttm(
        if(Datetime::FromSeconds($time_cast(history_timestamp)) < Timestamp('2021-06-02T17:30:00.000000Z'), 
           $time_max(unpacked_data), 
           $time_max_new(unpacked_data))
      ) as planned_interval_time_max
    , $seconds_to_dt(
        if(Datetime::FromSeconds($time_cast(history_timestamp)) < Timestamp('2021-06-02T17:30:00.000000Z'),        
          $time_min(unpacked_data), 
          $time_min_new(unpacked_data))
      ) as planned_delivery_dt
    , $extract_addres(unpacked_data) ?? station_location_full_address as delivery_address
    , $extract_country(unpacked_data) ?? station_location_country_name_ru as delivery_country
    , $extract_locality(unpacked_data) as delivery_locality
    , $extract_settlement(unpacked_data) ?? station_location_city_name_ru as delivery_settlement
    , $extract_region(unpacked_data) ?? station_location_federal_district as delivery_region
    , Geo::RoundRegionById(cast($extract_region(unpacked_data) as Int32), 'region').name as delivery_region_name
    , $coords_x(unpacked_data) as x_coord
    , $coords_y(unpacked_data) as y_coord
    , $get_tz($coords_y(unpacked_data), $coords_x(unpacked_data)) as timezone_B
    , t2.station_id as delivery_station_id
    from range($PLANNED_NODES_HISTORY, $START_DAY) as t1
    left join $STATIONS as t2
        on Yson::YPathString(t1.unpacked_data, '/node_location/station_location/station_id') = t2.station_id
    where (Yson::YPathString(unpacked_data, '/node_code') = 'n_to' or 
           Yson::YPathString(unpacked_data, '/node_code') = 'node_to')
      and history_action = 'add'
);

$from_nodes = (
    select
        request_id,
        station_operator_id,
        station_location_full_address,
        station_location_city_name_ru,
        station_location_country_name_ru,
        station_location_federal_district,
        y_coord_A,
        x_coord_A,
        $get_tz(y_coord_A, x_coord_A) as timezone_A,
        t2.station_id as source_station_id
    from range($PLANNED_NODES_HISTORY, $START_DAY) as t1
    inner join $STATIONS as t2
        on Yson::YPathString(t1.unpacked_data, '/node_location/station_location/station_id') = t2.station_id
    where
        (
            Yson::YPathString(unpacked_data, '/node_code') = 'n_from' or 
            Yson::YPathString(t1.unpacked_data, '/node_code') = 'node_from'
        )
        and t1.history_action = 'add'
);


$requests_with_nodes = (
    select 
        *
    from $requests_with_meta as t1
    left join $to_nodes as t2 on t1.request_id = t2.request_id
    left join $from_nodes as t3 on t1.request_id = t3.request_id
   
);

$request_operator_order = (
    SELECT  external_order_id,
            SOME(request_id) as request_id
    FROM RANGE($PLANNED_TRANSFERS_HISTORY, $START_DAY)
    GROUP BY external_order_id
);

$get_promise_ids = (
    SELECT  
        t1.request_id as request_id
        , MAX(case when $seconds_to_dt(t1.history_timestamp) >= '2021-08-12' then 
            $extract_promise_id_new(t2.unpacked_data)
            else $extract_promise_id(t2.unpacked_data) end) as promise_id
    FROM RANGE($PLANNED_TRANSFERS_HISTORY, $START_DAY) as t1
    INNER JOIN RANGE($STATION_TAGS_HISTORY, $START_DAY) as t2
        ON t2.tag_id = t1.generation_tag_id
    WHERE 
        1=1
        AND t1.history_action = 'add'
        AND t2.class_name = 'operator_shipment'
        AND case when $seconds_to_dt(t1.history_timestamp) >= '2021-08-12' then 
            $extract_promise_id_new(t2.unpacked_data)
            else $extract_promise_id(t2.unpacked_data) end <> ''
    group by 
        t1.request_id
);

$get_barcodes = (
    SELECT
        request_id 
        , AGGREGATE_LIST(`barcode`) as barcodes
        , AGGREGATE_LIST(`article`) as articles
    FROM 
        range($RESOURCE_ITEMS_HISTORY, $START_DAY)
    group by 
        request_id
);

$external_data = (
    select $seconds_to_dttm(event_instant) as event_instant_ddtm
      , $seconds_to_dt(event_instant) as event_instant_dt 
      , $seconds_to_dttm(history_timestamp) as tech_event_instant_ddtm
      , substring($seconds_to_dttm(event_instant), 11) as event_instant_tm
      , operator_event_type
      , $lp_status(unpacked_data) as operator_lp_status
      , $lp_desc_status(unpacked_data) as operator_lp_status_desc
      , $lp_int_status(unpacked_data) as operator_lp_int_status
      , operator_id
      , external_order_id
      , history_event_id
    from range($OPERATOR_EVENTS_HISTORY, $START_DAY)
);

$emloyer_info = (
    select distinct 
        employer_id
        , employer_code
        , max_by(Yson::ConvertToString(unpacked_data.brand_name), history_event_id) as brand_name
        , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_eng), history_event_id) as brand_name_eng
        , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.brand_name_ru), history_event_id) as brand_name_ru
        -- , max_by(Yson::ConvertToString(unpacked_data.brand_name_new.legal_name), history_event_id) as legal_name
        , max_by(Yson::ConvertToString(unpacked_data.corp_client_id), history_event_id) as corp_client_id
        , max_by(Yson::ConvertToBool(unpacked_data.self_registered), history_event_id) as self_registered_flg
    from range($EMPLOYERS_HISTORY, $START_DAY) as g
    where employer_code != 'beru'
    group by employer_id
            , employer_code
);

$ultimate_select = (
    select *
    from $requests_with_nodes as t1
    left join $request_operator_order as t2 on t1.request_id = t2.request_id
    left join $external_data as t3 on t2.external_order_id = t3.external_order_id
    left join $get_promise_ids as t4 on t1.request_id = t4.request_id
    left join $get_barcodes as t5 on t1.request_id = t5.request_id
    left join $emloyer_info as t6 on t1.corp_client_id = t6.corp_client_id and t1.employer_code = t6.employer_code
);

$statuses = 
(select 
distinct
`final_status` as mapped_event_type
, `code_strizh` as strizh_status
, `code_aggr` as aggr_status
from 
`//home/taxi-delivery/analytics/production/ndd/operator_status_mapping`
);

INSERT INTO $YT_TABLE_PATH WITH TRUNCATE
select t1.*
    , coalesce(st1.mapped_event_type, st2.mapped_event_type, st3.mapped_event_type)
         as mapped_event_type
from $ultimate_select as t1
left join 
$statuses as st1
on case when t1.operator_id = 'strizh' then SUBSTRING(t1.operator_event_type, 0, 3) 
else t1.operator_event_type end  = st1.strizh_status 
left join 
$statuses as st2 
on  case when t1.operator_id = 'strizh' then SUBSTRING(t1.operator_event_type, 0, 3) 
else t1.operator_event_type end  = st2.aggr_status
left join 
$statuses as st3
on  case when t1.operator_id = 'top-delivery' then t1.operator_lp_status 
else t1.operator_event_type end  = st3.aggr_status
                                 
-- ==== ЧТО ЕЩЕ ХОТЕЛОСЬ, НО РЕШИЛИ ДЕЛАТЬ В ДРУГИХ ВИТРИНАХ ============================================================

-- ПО КОРОБКАМ
-- штрихкод                   barcode из $RESOURCE_PLACES_HISTORY

-- ПО ТОВАРАМ
-- название товара            name из $RESOURCE_ITEMS_HISTORY
-- артикул товара             article из $RESOURCE_ITEMS_HISTORY
-- количество товара          count из $RESOURCE_ITEMS_HISTORY
-- стоимость товара           $item_price(unpacked_data) из $RESOURCE_ITEMS_HISTORY
-- оценочная стоимость товара как поле выше, только assessed_unit_price из $RESOURCE_ITEMS_HISTORY
-- НДС товара                 как поле выше, только i_n_n 
-- ИНН товара                 как поле выше, только n_d_s
