-- LOGDATA-1543

use hahn;

$NODES_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history';
$TRANSFERS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history';
$STATION_TAGS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/station_tags_history';
$REQUESTS_HISTORY = '//home/taxi/testing/export/taxi-logistic-platform-production/requests_history';
$REQUESTS_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';

$SAVE_TO = '//home/taxi-delivery/analytics/production/ndd/requests_pickup';

$START_DATE = '2022-02-01';

$format = DateTime::Format('%Y-%m-%d %H:%M:%S');
$sec_to_dttm = ($sec) -> {
    return $format(DateTime::FromSeconds(cast($sec as Uint32)));
};
                                              
$requests_w_nodes = (
    select request_id 
        , node_id 
    from range($NODES_HISTORY, $START_DATE)
    where 1=1
        and (
            Yson::YPathString(unpacked_data, '/node_code') = 'n_from' 
            or 
            Yson::YPathString(unpacked_data, '/node_code') = 'node_from'
        )
);

$requests_with_tags = (
    select requests.request_id as request_id
        , min_by(transfers.generation_tag_id, transfers.history_event_id) as first_generation_tag_id
    from $requests_w_nodes as requests
    left join range($TRANSFERS_HISTORY, $START_DATE) as transfers on requests.request_id = transfers.request_id 
                                                                     and requests.node_id = transfers.node_from_id 
    group by requests.request_id
);

$tags_with_intervals = (
    select tag_id
        , min_by(Yson::YPathString(unpacked_data, '/pickup_interval'), history_event_id) as pickup_interval
    from range($STATION_TAGS_HISTORY, $START_DATE)
    group by tag_id
);

$requests_with_statuses = (
    select request_id
        , min($format(DateTime::ParseIso8601(event_instant_ddtm))) as utc_arrived_to_sc_dttm
        , some(external_order_id) as external_order_id
    from $REQUESTS_DATAMART
    where 1=1
        and (
            operator_event_type = 'SORTING_CENTER_AT_START'
            OR
            operator_lp_status = 'DELIVERY_AT_START'
        )
    group by request_id
);

$last_status = (
    select request_id
        , some(employer_code) as employer_code
        , some(request_code) as request_code
        , max_by(status, history_event_id) as last_status
        , $sec_to_dttm(some(created_at)) as utc_created_dttm
        , $sec_to_dttm(max_by(history_timestamp, history_event_id)) as utc_last_status_dttm
    from range($REQUESTS_HISTORY, $START_DATE)
    group by request_id
);

$df = (
    select *
    from $requests_with_tags as requests 
    left join $tags_with_intervals as tags on requests.first_generation_tag_id = tags.tag_id
    left join $requests_with_statuses as statuses on requests.request_id = statuses.request_id
    left join $last_status as last_status on requests.request_id = last_status.request_id
);

INSERT INTO $SAVE_TO WITH TRUNCATE 
select t1.*
    , CASE 
        when t1.utc_arrived_to_sc_dttm is not null then 'Принят на СЦ'
        when t1.utc_arrived_to_sc_dttm is null then 'Не принят на СЦ'
        else 'ERROR'
    end as arrived_to_sc_flg
    , substring(t1.pickup_interval, 0, 10) as pickup_date
from $df as t1
where 1=1
    and t1.first_generation_tag_id is not null;
    
