-- https://st.yandex-team.ru/LOGDATA-411
-- https://tableau.taxi.yandex-team.ru/#/workbooks/6562/views

use hahn;

$REQUESTS = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$SAVE_TO_PATH = '//home/taxi-delivery/analytics/production/ndd/time_interval_dash';

$delivered_orders = (
    select request_id
      , corp_client_id
      , employer_code
      , operator_id
      , external_order_id
      , event_instant_ddtm
      , planned_interval_time_max
      , planned_interval_time_min
    from $REQUESTS
    where mapped_event_type in ('Доставлен - подтверждено', 'Доставлен частично - подтверждено')
);

$orders_w_min_delivery = (
    select request_id
      , min(event_instant_ddtm) as first_delivered_dttm
    from $REQUESTS
    where mapped_event_type in ('Доставлен', 'Доставлен частично')
    group by request_id
);

INSERT INTO $SAVE_TO_PATH WITH TRUNCATE 
SELECT t1.request_id as request_id
  , operator_id
  , corp_client_id
  , external_order_id
  , employer_code
  , substring(t1.event_instant_ddtm, 0, 10) as delivered_confirmed_dt
  , substring(t2.first_delivered_dttm, 0, 10) as delivered_dt
  , t1.planned_interval_time_min as planned_interval_time_min
  , t1.planned_interval_time_max as planned_interval_time_max
  , t2.first_delivered_dttm as first_delivered_dttm
  , CASE 
      when substring(t2.first_delivered_dttm, 0, 10) = substring(t1.planned_interval_time_max, 0, 10) then 1
      else 0
    end as correct_date_flg
  , CASE 
      when t2.first_delivered_dttm <= t1.planned_interval_time_max 
        and substring(t2.first_delivered_dttm, 0, 10) = substring(t1.planned_interval_time_max, 0, 10) then 1
      else 0
    end as correct_time_flg
from $delivered_orders as t1
left join $orders_w_min_delivery as t2 on t1.request_id=t2.request_id;