-- https://st.yandex-team.ru/LOGDATA-411

use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$REQUESTS = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$SAVE_LATE = '//home/taxi-delivery/analytics/production/ndd/late_requests';
$SAVE_NOT_DELIVERED_YET = '//home/taxi-delivery/analytics/production/ndd/not_delivered_yet_requests';

$current_time = CurrentUtcDatetime();

$extract_msc_dt = ($utc_dttm) -> {
    return substring(cast(AddTimezone(cast($utc_dttm as Datetime), 'Europe/Moscow') as String), 0, 10)
};

$extract_msc_tm = ($utc_dttm) -> {
    return substring(cast(AddTimezone(cast($utc_dttm as Datetime), 'Europe/Moscow') as String), 11, 8)
};

$extract_msc_dttm = ($utc_dttm) -> {
    return $extract_msc_dt($utc_dttm) || ' ' || $extract_msc_tm($utc_dttm)
};

$delivered_orders = (
    select request_id
      , min(tech_event_instant_ddtm) as first_delivered_dttm
      , max(history_event_id) as last_status_id
    from $REQUESTS
    where mapped_event_type in ('Доставлен', 
                                'Доставлен частично')--, 
                                --'Доставлен - подтверждено', 
                                --'Доставлен частино - подтверждено')
    group by request_id
);

$not_delivered_yet = (
    select request_id
      , max(history_event_id) as last_status_id
    from $REQUESTS
    where cast(planned_interval_time_max as Datetime) < $current_time
      and request_id not in (
        select request_id from $delivered_orders
      )
    group by request_id
);

$not_delivered_requests = (
    select t1.request_id as request_id
    , t1.request_code as request_code
    , t1.external_order_id as external_order_id
    , t1.corp_client_id as corp_client_id
    , t1.employer_code as employer_code
    , t1.operator_id as operator_id
    , t1.mapped_event_type as last_status
    , t1.tech_event_instant_ddtm as utc_last_status_update_dttm
    , $extract_msc_dt(t1.tech_event_instant_ddtm) as msc_last_status_update_dt
    , $extract_msc_tm(t1.tech_event_instant_ddtm) as msc_last_status_update_tm
    , $extract_msc_dttm(t1.tech_event_instant_ddtm) as msc_last_status_update_dttm

    , t1.planned_interval_time_max as utc_planned_interval_max_dttm
    , $extract_msc_dt(t1.planned_interval_time_max) as msc_planned_interval_max_dt
    , $extract_msc_tm(t1.planned_interval_time_max) as msc_planned_interval_max_tm
    , $extract_msc_dttm(t1.planned_interval_time_max) as msc_planned_interval_max_dttm

    , cast(AddTimezone(cast($current_time as Datetime), 'Europe/Moscow') as String) as msc_current_dttm
    from $REQUESTS as t1
    inner join $not_delivered_yet as t2 on t1.request_id=t2.request_id and t1.history_event_id=t2.last_status_id
);

$late_requests = (
    select t1.request_id as request_id
    , t1.request_code as request_code
    , t1.external_order_id as external_order_id
    , t1.corp_client_id as corp_client_id
    , t1.employer_code as employer_code
    , t1.operator_id as operator_id
    , t1.mapped_event_type as last_status

    , t1.tech_event_instant_ddtm as utc_last_status_update_dttm
    , $extract_msc_dt(t1.tech_event_instant_ddtm) as msc_last_status_update_dt
    , $extract_msc_tm(t1.tech_event_instant_ddtm) as msc_last_status_update_tm
    , $extract_msc_dttm(t1.tech_event_instant_ddtm) as msc_last_status_update_dttm

    , t1.planned_interval_time_max as utc_planned_interval_max
    , $extract_msc_dt(t1.planned_interval_time_max) as msc_planned_interval_max_dt
    , $extract_msc_tm(t1.planned_interval_time_max) as msc_planned_interval_max_tm
    , $extract_msc_dttm(t1.planned_interval_time_max) as msc_planned_interval_max_dttm

    , t2.first_delivered_dttm as utc_first_delivered_dttm
    , $extract_msc_dt(t2.first_delivered_dttm) as msc_first_delivered_dt
    , $extract_msc_tm(t2.first_delivered_dttm) as msc_first_delivered_tm
    , $extract_msc_dttm(t2.first_delivered_dttm) as msc_first_delivered_dttm
    from $REQUESTS as t1
    inner join $delivered_orders as t2 on t1.request_id=t2.request_id and t1.history_event_id=t2.last_status_id
    where t2.first_delivered_dttm > t1.planned_interval_time_max
);

INSERT INTO $SAVE_NOT_DELIVERED_YET WITH TRUNCATE 
SELECT *
from $not_delivered_requests; 

INSERT INTO $SAVE_LATE WITH TRUNCATE 
SELECT *
from $late_requests; 
