/*
    Зачем нужен этот скрипт?
    Костылями считаем CPO заборной логистики силами "Грузового" для Яндекс Доставки
    
    Автор:
    @ikhomyanin
    
    Тикет:
    LOGDATA-984
*/

use hahn;
pragma yson.DisableStrict = '1';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma SimpleColumns;

$REQUESTS_DATAMART = '//home/taxi-delivery/analytics/production/ndd/requests_datamart';
$TRANSFERS = '//home/taxi/testing/export/taxi-logistic-platform-production/planned_transfers_history';
$NODES = '//home/taxi/testing/export/taxi-logistic-platform-production/planned_nodes_history';
$SAVE_TO_DASH = '//home/taxi-delivery/analytics/production/ndd/ndd_zaborka_cpo/cpo_results/for_dash';

$STATION_ROUTES = '//home/taxi-delivery/analytics/production/ndd/ndd_zaborka_cpo/station_routes';
$ROUTE_DETAILS = '//home/taxi-delivery/analytics/production/ndd/ndd_zaborka_cpo/route_details';

$today = CurrentUtcDate();
$yesterday = cast($today - Interval('P1D') as String);
$save_to = '//home/taxi-delivery/analytics/production/ndd/ndd_zaborka_cpo/cpo_results/last_routes_' || $yesterday;

$START_DATE = '2021-11-10';

$format_dttm = DateTime::Format('%Y-%m-%d %H:%M:%S');

$convert_utc_to_moscow = ($utc_dttm) -> {
    return $format_dttm(DateTime::Split(AddTimezone(cast($utc_dttm as Datetime), "Europe/Moscow")))
};

$calculate_slot = ($msk_dttm) -> {
    $time = substring($msk_dttm, 11, 9);
    $date = substring($msk_dttm, 0, 10);

    $day_before = cast(cast($date as Date) - Interval('P1D') as String);
    $day_after = cast(cast($date as Date) + Interval('P1D') as String);

    $slot = case
        when $time between '09:00:01' and '15:59:59' then $date || ' 09:00:01 - ' || $date || ' 15:59:59'
        when $time between '00:00:00' and '09:00:00' then $day_before || ' 16:00:00 - ' || $date || ' 09:00:00'
        when $time between '16:00:00' and '23:59:59' then $date || ' 16:00:00 - ' || $day_after || ' 09:00:00'
        else 'error'
    end;

    return $slot;
};

$format = DateTime::Format('%Y-%m-%d %H:%M:%S');

$requests_data_raw = (
    select request_id
        , min($convert_utc_to_moscow(event_instant_ddtm)) as msk_arrived_to_storage_dttm
        , some(employer_code) as employer_code
    from $REQUESTS_DATAMART
    where 1=1
        and mapped_event_type = 'На складе службы доставки'
        and substring($convert_utc_to_moscow(event_instant_ddtm), 0, 10) >= $START_DATE
    group by request_id
);

$requests_data = (
    select request_id
        , employer_code
        , $calculate_slot(msk_arrived_to_storage_dttm) as msk_arrived_to_storage_dttm
    from $requests_data_raw
);

$transfers_data = (
    select request_id
        , node_from_id
        , some(resource_id) as resource_id
        , some(transfer_id) as transfer_id
        , some(external_order_id) as external_order_id
        , min($format(DateTime::FromSeconds(cast(history_timestamp as Uint32)))) as utc_transfer_dttm
    from range($TRANSFERS, $START_DATE)
    where 1=1
        and status = 'current'
    group by request_id
        , node_from_id
);

$node_data = (
    select distinct request_id
        , node_id
        , Yson::YPathString(unpacked_data,'/node_location/class_name') as node_class_name
        , Yson::YPathString(unpacked_data,'/node_location/station_location/station_id') as node_station_id
    from range($NODES)
    where 1=1
        and Yson::YPathString(unpacked_data,'/node_code') in ('node_from', 'n_from')
);

$df = (
    select *
    from $requests_data as r 
    left join $node_data as n on n.request_id = r.request_id
    left join $transfers_data as t on r.request_id = t.request_id and n.node_id = t.node_from_id
);

$groupped_requests = (
    select msk_arrived_to_storage_dttm 
        , employer_code
        , node_station_id
        , AGG_LIST(request_id) as requests 
        , AGG_LIST(external_order_id) as external_order_ids 
        , count(request_id) as requests_cnt
    from $df
    group by msk_arrived_to_storage_dttm
        , employer_code
        , node_station_id
);
                                            
$final = (
    select r.*
        , sr.*
        , rd.* 
    from $groupped_requests as r
    inner join $STATION_ROUTES as sr on r.msk_arrived_to_storage_dttm = sr.utc_arrived_to_storage_dt 
                                       and r.employer_code = sr.employer_code
                                       and r.node_station_id = sr.station_id
    inner join $ROUTE_DETAILS as rd on sr.utc_arrived_to_storage_dt = rd.utc_arrived_to_storage_dt
                                       and rd.route_id = sr.route_id
);
                                            
$visited_points_cnt = (
    select utc_arrived_to_storage_dt
        , route_id
        , count(station_id) as visited_points_cnt
    from $final
    group by utc_arrived_to_storage_dt
        , route_id
);

insert into $save_to WITH TRUNCATE 
select f.*
    , vp.visited_points_cnt as visited_points_cnt
    , coalesce(f.cost_per_point, 1.0 * f.cost_per_route / vp.visited_points_cnt) as calculated_cost_per_point
    , coalesce(f.cost_per_point, 1.0 * f.cost_per_route / vp.visited_points_cnt) / f.requests_cnt as cpo
from $final as f
left join $visited_points_cnt as vp on f.utc_arrived_to_storage_dt = vp.utc_arrived_to_storage_dt
                                       and f.route_id = vp.route_id;
                                            
insert into $SAVE_TO_DASH with truncate
select f.*
    , vp.visited_points_cnt as visited_points_cnt
    , coalesce(f.cost_per_point, 1.0 * f.cost_per_route / vp.visited_points_cnt) as calculated_cost_per_point
    , coalesce(f.cost_per_point, 1.0 * f.cost_per_route / vp.visited_points_cnt) / f.requests_cnt as cpo
from $final as f
left join $visited_points_cnt as vp on f.utc_arrived_to_storage_dt = vp.utc_arrived_to_storage_dt
                                       and f.route_id = vp.route_id;
