use hahn;
PRAGMA yt.InferSchema = '1';

$STATION_TAGS = '//home/taxi/testing/export/taxi-logistic-platform-production/station_tags_history';
$STATIONS = '//home/taxi/testing/export/taxi-logistic-platform-production/stations_history';

$START_DAY = '2021-01-01';

$YT_TABLE_PATH = '//home/taxi-delivery/analytics/production/ndd/zaborka_volumes';

$time_cast = ($history_timestamp) -> {
    return CAST($history_timestamp as Uint32) 
};

$seconds_to_dttm = ($seconds) -> {
    return cast(cast(Datetime::FromSeconds($time_cast($seconds)) as Datetime) as String)
};

$format_interval = ($string) -> {
    return cast((cast(substring($string,0,2) as Int32) + 3)%24 as String) || ':' ||cast((cast(substring($string,3,2) as Int32)) as String) || '/' || cast((cast(substring($string,12,2) as Int32) + 3)%24 as String) || ':' ||cast((cast(substring($string,15,2) as Int32)) as String)
};

$current_object_id = (
    select object_id
    , max($time_cast(history_timestamp)) as max_history_timestamp
    from range($STATION_TAGS, $START_DAY) as t0
    where Yson::Contains(t0.unpacked_data, 'pickup_volume_tag') 
    and Yson::Contains(t0.unpacked_data.pickup_volume_tag, 'volume_by_day')
    and ListSum(Yson::ConvertToUint64List(t0.unpacked_data.pickup_volume_tag.volume_by_day)) > 0
    and t0.class_name = 'pickup_volume'
    group by t0.object_id as object_id
); 

$object_w_info = (
    select t0.history_timestamp as history_timestamp
    , t0.object_id as object_id
    , t0.comments as comments
    , Yson::ConvertToString(t0.unpacked_data.pickup_interval) as pickup_interval
    , Yson::ConvertToUint64(t0.unpacked_data.pickup_volume_tag.volume_by_day[0]) as monday
    , Yson::ConvertToUint64(t0.unpacked_data.pickup_volume_tag.volume_by_day[1]) as tuesday
    , Yson::ConvertToUint64(t0.unpacked_data.pickup_volume_tag.volume_by_day[2]) as wednesday
    , Yson::ConvertToUint64(t0.unpacked_data.pickup_volume_tag.volume_by_day[3]) as thursday
    , Yson::ConvertToUint64(t0.unpacked_data.pickup_volume_tag.volume_by_day[4]) as friday
    , Yson::ConvertToUint64(t0.unpacked_data.pickup_volume_tag.volume_by_day[5]) as saturday
    , Yson::ConvertToUint64(t0.unpacked_data.pickup_volume_tag.volume_by_day[6]) as sunday
    from range($STATION_TAGS, $START_DAY) as t0
    inner join $current_object_id as t1 on t0.object_id=t1.object_id and $time_cast(t0.history_timestamp) = t1.max_history_timestamp
    where Yson::Contains(t0.unpacked_data, 'pickup_volume_tag') 
        and Yson::Contains(t0.unpacked_data.pickup_volume_tag, 'volume_by_day')
        and ListSum(Yson::ConvertToUint64List(t0.unpacked_data.pickup_volume_tag.volume_by_day)) > 0
        and t0.class_name = 'pickup_volume'
);

$objects_mapping = (
    select station_id
      , MAX_BY(operator_station_id, history_event_id) as operator_station_id
      , MAX_BY(station_name, history_event_id) as station_name
    from range($STATIONS, $START_DAY)
    group by 
        station_id
);

INSERT INTO $YT_TABLE_PATH WITH TRUNCATE
select operator_station_id
  , station_id
  , station_name
  , pickup_interval
  , $format_interval(pickup_interval) as pickup_interval_formatted
  , monday
  , tuesday
  , wednesday
  , thursday
  , friday
  , saturday
  , sunday
  , $seconds_to_dttm($time_cast(history_timestamp)) as last_obj_update_dttm
  , object_id
  , comments
from $object_w_info as t1
left join $objects_mapping as t2 on t1.object_id=t2.station_id
