import pandas as pd
from nile.api.v1 import filters as nf

from projects.common.nile import test_utils
from projects.cpo_model import project_config


INPUT = '//home/taxi-delivery/analytics/dev/cpo_model/lavka_places_moscow'
OUTPUT = '//home/taxi-delivery/analytics/dev/test_nirvana_operations/test_py'

if __name__ == '__main__':
    cluster = project_config.get_project_cluster(
        parallel_operations_limit=5,
    )

    job = cluster.job()

    (
        job.table(INPUT)
        .filter(nf.equals('address_city', test_utils.to_bytes('Москва')))
        .put(OUTPUT)
    )

    job.run()

    df = test_utils.decode_dataframe(
        cluster
        .read(OUTPUT)
        .as_dataframe()
    )
    df = df[
        pd.isnull(df['disable_details_status'])
    ].reset_index()

    print(df.shape)
