PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;
PRAGMA SimpleColumns;
PRAGMA yson.DisableStrict;
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA yt.Owners = 'shamilalburin';
PRAGMA yt.InferSchema = '1';

USE hahn; 

-- Working directory for this task

$WORKING_DIRECTORY = '//home/taxi-delivery/analytics/dev/shamilalburin/LOGDATA-2440';

-- List of tables

$DBPROCESSING_ORDERS = '//home/taxi-dwh/ods/dbprocessing/order';
$SMB_MAPPING = '//home/taxi-delivery/analytics/production/smb_model/users_smb_flgs/for_dashboards_f1_max';
$INDUSTRY_MAPPING = '//home/taxi-delivery/analytics/production/marketing/industries_final';
$PHOENIX_USERS = $WORKING_DIRECTORY || '/phoenix_phones';
$CLAIMS = '//home/delivery-dwh/ods/cargo_claims/claim';
$C2C_ORDERS = '//home/delivery-dwh/ods/cargo_c2c/order';
$USER_DATA = '//home/taxi-dwh/ods/dbusers/user/user';

-- Dates
$DT_START = '2022-06-06';
$MTH_START = SUBSTRING($DT_START, 0, 7) || '-01';
$YEAR_START = SUBSTRING($DT_START, 0, 4) || '-01-01';

-- Result path

$RESULT_PATH = $WORKING_DIRECTORY || '/metrics';

$script = @@#py
import hashlib
import sys
import datetime

def exp3_hash(arg, salt):
    sha1 = hashlib.sha1()
    sha1.update(salt)
    sha1.update(arg)
    res = sha1.hexdigest()[:16]
    return int(res, 16)%100
@@;

$exp_flg = Python::exp3_hash(Callable<(String?, String?) -> Int64?>, $script);
$salt = 'sdd_go_exp_moscow_2022_06';

$orders = (
    SELECT
        CASE
            WHEN $exp_flg(user_phone_id, $salt) < 10 THEN 'test, no disc'
            WHEN $exp_flg(user_phone_id, $salt) < 20 THEN 'test, 30% disc'
            WHEN $exp_flg(user_phone_id, $salt) < 30 THEN 'test, 10% disc'
            WHEN $exp_flg(user_phone_id, $salt) < 40 THEN 'test, 40% disc'
            WHEN $exp_flg(user_phone_id, $salt) < 50 THEN 'test, 20% disc'
            WHEN $exp_flg(user_phone_id, $salt) < 60 THEN 'ctrl, 50-60'
            ELSE 'ctrl, 60-100'
        END AS salt_group_type,
        user_phone_pd_id,
        user_phone_id,
        tariff_class_id,
        order_source_code,
        order_id,
        success_order_flg,
        tariff_cost_w_discount,
        pricing_discount_value,
        pricing_tariff_cost_wo_discount,
        utc_order_created_dttm,
        app_name,
        app_version_code
    FROM RANGE($DBPROCESSING_ORDERS, $MTH_START) AS T1
    WHERE TRUE
        AND tariff_zone = 'moscow'
        AND SUBSTRING(utc_order_created_dttm, 0, 10) >= $DT_START
        AND tariff_class_id IN ['cargo', 'courier', 'express', 'sdd']
        AND order_source_code IN ['yandex', 'cargo']
        AND NOT mqc_order_flg
        AND NOT corp_order_flg
);

$industries = (
    SELECT
        user_phone_pd_id,
        industry
    FROM $INDUSTRY_MAPPING
);

$smb_flg = (
    SELECT
        user_phone_pd_id,
        is_smb
    FROM $SMB_MAPPING
    WHERE utc_valid_to_dt = '9999-12-31'
);

$claims_data = (
    SELECT
        cargo_ref_id,
        taxi_order_id AS order_id
    FROM RANGE($CLAIMS, $MTH_START)
    WHERE TRUE
        AND SUBSTRING(utc_created_dttm, 0, 10) >= $DT_START
        AND api_source_type = 'c2c'
);

$c2c_orders_data = (
    SELECT
        user_client_id AS user_id,
        public_claim_id AS cargo_ref_id
    FROM RANGE($C2C_ORDERS, $YEAR_START)
);

$users = (
    SELECT
        user_id,
        application_platform,
        application_version
    FROM $USER_DATA
);

$c2c_orders_data_w_app = (
    SELECT
        order_id,
        application_platform,
        application_version
    FROM $claims_data AS T1 
        INNER JOIN $c2c_orders_data AS T2 ON T1.cargo_ref_id = T2.cargo_ref_id
        LEFT JOIN $users AS T3 ON T2.user_id = T3.user_id
);

INSERT INTO $RESULT_PATH WITH TRUNCATE
SELECT
    T1.*,
    COALESCE(industry, 'No industry') AS industry,
    COALESCE(is_smb, 0) AS is_smb,
    COALESCE(application_platform, app_name) AS app_name,
    COALESCE(application_version, app_version_code) AS app_version
    WITHOUT
        T1.app_name,
        T1.app_version_code
FROM $orders AS T1
    LEFT ONLY JOIN $PHOENIX_USERS AS T2 ON T1.user_phone_id = T2.user_phone_pd_id
    LEFT JOIN $industries AS T3 ON T1.user_phone_pd_id = T3.user_phone_pd_id
    LEFT JOIN $smb_flg AS T4 ON T1.user_phone_pd_id = T4.user_phone_pd_id
    LEFT JOIN $c2c_orders_data_w_app AS T5 ON T1.order_id = T5.order_id
WHERE FALSE
    OR (
        COALESCE(application_platform, app_name) = 'iphone'
        AND COALESCE(application_version, app_version_code) >= '650.42.0'
    )
    OR (
        COALESCE(application_platform, app_name) = 'android'
        AND COALESCE(application_version, app_version_code) >= '4.87.0'
    )
