/*
    Назначение скрипта:
    Удалить ежедневные таблицы за прошлый месяц, и заменить все одной

    Автор:
    @shamilalburin

    Тикет:
    LOGDATA-1450
*/

PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;

USE hahn; 

-- Working directory for this task

$WORKING_DIRECTORY = '//home/taxi-delivery/analytics/production/product/sms_and_go_sharing';

-- List of tables

$APPMETRICA = '//home/taxi-dwh/ods/appmetrica/taxi';
$USERS = '//home/taxi-dwh/ods/dbusers/user/user';
$USER_PHONES = '//home/taxi-dwh/ods/dbusers/user_phone/user_phone';

-- DateTime format

$dt_format = DateTime::Format('%Y-%m-%d');

-- Dates

$DT_START = $dt_format(DateTime::StartOfMonth(DateTime::ShiftMonths(CurrentUtcDate(), -1)));
$DT_END = $dt_format(
    DateTime::MakeDatetime((DateTime::StartOfMonth(CurrentUtcDateTime())))
    - DateTime::IntervalFromDays(1)
);

-- Result path

$RESULT_PATH = $WORKING_DIRECTORY || '/sharing_from_appmetrica/' || $DT_START;

-- User ids for events from metrica

$user_to_phone_pd = (
    SELECT
        user_id,
        phone_pd_id,
        T1.user_phone_id AS phone_id
    FROM (
        SELECT
            user_id,
            user_phone_id
        FROM $USERS
    ) AS T1
        INNER JOIN (
            SELECT
                user_phone_id,
                phone_pd_id
            FROM $USER_PHONES
        ) AS T2 ON T1.user_phone_id = T2.user_phone_id
);

-- Go sharing

$parse_order = ($val) -> {RETURN String::SplitToList(Yson::ConvertToString($val), '/')};

-- Collecting data for the last month

$preview_order_list_raw = (
    SELECT
        user_id,
        utc_event_dttm,
        session_id,
        app_platform,
        device_type,
        app_version_name,
        device_manufacturer,
        device_model,
        event_name,
        $parse_order(state.order_id)[0] AS order_provider_id,
        $parse_order(state.order_id)[1] AS order_id
    FROM (
        SELECT
            user_id,
            session_id,
            app_platform,
            device_type,
            app_version_name,
            device_manufacturer,
            device_model,
            utc_event_dttm,
            event_name,
            Yson::ConvertToList(event_value.state) AS state
        FROM RANGE($APPMETRICA, $DT_START, $DT_END)
        WHERE event_name LIKE '%PreviewOrderList%'
    )
    FLATTEN BY state
    WHERE Yson::ConvertToString(state.order_id) LIKE '%/%'
);

$preview_order_list = (
    SELECT
        T1.*,
        phone_pd_id
    FROM $preview_order_list_raw AS T1
        INNER JOIN $user_to_phone_pd AS T2 ON T1.user_id = T2.user_id
);

$shared_order_raw = (
    SELECT
        user_id,
        utc_event_dttm,
        session_id,
        app_platform,
        device_type,
        app_version_name,
        device_manufacturer,
        device_model,
        event_name,
        COALESCE(
            $parse_order(event_value.commonparams.order_key)[0],
            $parse_order(event_value.deliverymetrics.order_key)[0]
        ) AS order_provider_id,
        COALESCE(
            $parse_order(event_value.commonparams.order_key)[1],
            $parse_order(event_value.deliverymetrics.order_key)[1]
        ) AS order_id
    FROM RANGE($APPMETRICA, $DT_START, $DT_END)
    WHERE FALSE
        OR event_name LIKE '%SharedOrderPush%'
        OR event_name LIKE '%SharedOrderCard%'
);

$shared_order = (
    SELECT
        T1.*,
        phone_pd_id
    FROM $shared_order_raw AS T1
        INNER JOIN $user_to_phone_pd AS T2 ON T1.user_id = T2.user_id
    WHERE TRUE
        AND order_id IS NOT NULL
        AND order_provider_id IS NOT NULL
);

$go_sharing = (
    SELECT *
    FROM $preview_order_list
    UNION ALL
    SELECT *
    FROM $shared_order
);

-- Delete daily tables

$DATE_START = CAST($DT_START AS Date);
$DATE_END = CAST($DT_END AS Date);

$tables_idx = ListFromRange(1, Unwrap(DateTime::ToDays($DATE_END - $DATE_START)) + 1);

EVALUATE FOR $table_idx IN $tables_idx DO BEGIN
    $table_name = CAST(CAST($DATE_START + DateTime::IntervalFromDays($table_idx) AS Date) AS String);
    $TABLE_PATH = $WORKING_DIRECTORY || '/sharing_from_appmetrica/' || $table_name;
    
    DROP TABLE $TABLE_PATH;

END DO;

INSERT INTO $RESULT_PATH WITH TRUNCATE 
SELECT *
FROM $go_sharing;
