use hahn;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;
PRAGMA SimpleColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;


$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$CLAIM = '//home/delivery-dwh/ods/cargo_claims/claim';
$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$ACTUAL_TAGS = '//home/taxi/production/replica/postgres/tags/actual_tags';
$ORDER_PROC = '//home/taxi-dwh/raw/dbprocessing/order_proc';
$ORDER_CANDIDATE = '//home/taxi-dwh/ods/dbprocessing/order_candidate';
$FCT_ORDER_CANDIDATE = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$CLAIM_SEGMENT = '//home/delivery-dwh/ods/cargo_claims/claim_segment';
$FCT_STATE_HIST = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$TAG_LIST_HIST = '//home/taxi-dwh/cdm/executor/dim_executor_profile_tag_list_hist';
$PDA_DRIVERS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_drivers';
$UNIQUE_DRIVER_HIST = '//home/taxi-dwh/ods/mdb/unique_driver_hist/unique_driver_hist';
$C2C_CLIENTS_ORDERS = '//home/taxi/production/replica/postgres/cargo_c2c/clients_orders';
$C2C_CLIENTS_FEEDBACKS = '//home/taxi/production/replica/postgres/cargo_c2c/clients_feedbacks';


$AUTOACCEPT_LOGS = '//home/logfeller/logs/taxi/production/taxi-autoaccept-yandex-taxi-autoaccept-driver-options-log/1d';


$SAVE_TO = '//home/taxi-delivery/analytics/production/product/autoaccept/autoaccept_tableau_dashboard_data';



-- списки
$LOG_TARIFFS = (
    'courier'
    , 'express'
    --, 'cargo'
    --, 'ubernight'
    --, 'cargocorp'
);


--Парсинг и форматы времени
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$date_dots_parse = DateTime::Parse("%d.%m.%Y");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_month_short_format = Datetime::Format('%Y-%m');
$date_year_format = Datetime::Format('%Y-01-01');


-- Константы для времени
$START_DTTM = Datetime::MakeDatetime($datetime_parse('2021-11-01 00:00:00'));
$END_DTTM = CurrentUtcDatetime()- Interval('P1D');

$START_DTTM_STR = $datetime_format($START_DTTM);
$START_DT_STR = $date_format($START_DTTM);
$START_MONTH_STR = $date_month_format($START_DTTM);
$START_MONTH_SHORT_STR = $date_month_short_format($START_DTTM);
$START_YEAR_STR = $date_year_format($START_DTTM);

$END_DTTM_STR = $datetime_format($END_DTTM);
$END_DT_STR = $date_format($END_DTTM);
$END_MONTH_STR = $date_month_format($END_DTTM);
$END_MONTH_SHORT_STR = $date_month_short_format($END_DTTM);
$END_YEAR_STR = $date_year_format($END_DTTM);


$get_datetime_from_timestamp_sec = ($x) ->
{RETURN DateTime::MakeDatetime(DateTime::FromSeconds(CAST($x as Uint32)))};


$diff_minutes_dttm = (($end_dttm, $start_dttm) -> {
    $start = DateTime::MakeDatetime($datetime_parse($start_dttm));
    $end = DateTime::MakeDatetime($datetime_parse($end_dttm));
    RETURN 1.0*Datetime::ToSeconds($end - $start)/(60);
    --RETURN Datetime::Format('%H:%M:%S')$end - $start;
});

$geo =
(
    select tariff_zone, some(population_group) as population_group,
    some(tz_country_name_ru) as tz_country_name_ru,
    some(name_ru) as agglomeration
    from $GEO
    where root_node_id = 'br_root'
        and node_type = 'agglomeration'
    group by tariff_zone
);

$our_supply_group = (
    select distinct entity as dbid_uuid
    from $ACTUAL_TAGS
    where active  and entity_type =="dbid_uuid"
    and tag="walking_courier" or tag="auto_courier"
    group by entity
);

$autoaccept_enabled_group = (
    select distinct entity as dbid_uuid
    from $ACTUAL_TAGS
    where active  and entity_type =="dbid_uuid"
    and tag="autoaccept_delivery"
    group by entity
);





$try_autoaccept = (
    SELECT dbid_uuid, dt,
        count_if(autoaccept_enabled_flg) as autoaccept_orders_cnt,
        True as autoaccept_enabled_today_flg
    from RANGE($ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as oc
    where autoaccept_enabled_flg
    group by oc.park_taximeter_id || '_' || oc.executor_profile_id as dbid_uuid,
    SUBSTRING(utc_candidate_created_dttm, 0, 10) as dt
);



$support_data = (
    SELECT
    order_id,

    count(distinct st.ticket_id) as ticket_cnt,
    --unique_driver_id, db_id
    FROM
        `//home/taxi-analytics/hickinbottom/support/dwh/summary/support_tickets` as st --инфо о тикетах
    GROUP BY  order_id
);


$fct_order_data = (
    select dbid_uuid,
        utc_candidate_created_dt as dt,
        autoaccept_used_today_flg,
        country_name_ru,
        tariff_geo_zone_code,

        count(fo.order_id) as order_cnt,
        count_if(success_order_flg)  as success_order_cnt,
        count_if(user_status = 'cancelled' or driver_status = 'cancelled') as cancelled_cnt,
        count_if(user_status = 'cancelled') as cancelled_by_user_cnt,
        count_if(driver_status = 'cancelled') as cancelled_by_driver_cnt,
        sum(ticket_cnt) as ticket_cnt,

    from RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as fo
    left join $try_autoaccept as aa_od
    on aa_od.dbid_uuid == fo.taximeter_park_id || '_' || fo.executor_profile_id and aa_od.dt == fo.utc_order_created_dt
    left join $support_data as sup
    on sup.order_id == fo.order_id
    where fo.tariff_class_code in $LOG_TARIFFS
        and utc_order_created_dt between $START_DT_STR and $END_DT_STR
        and country_name_ru in ['Белоруссия',
                        'Узбекистан',
                        'Казахстан', 'Россия'
                        ]
        --and fo.taximeter_park_id || '_' || fo.executor_profile_id in $autoaccept_enabled_group
        --and fo.taximeter_park_id || '_' || fo.executor_profile_id in $our_supply_group
    group by fo.taximeter_park_id || '_' || fo.executor_profile_id as dbid_uuid,
        substring(fo.utc_order_created_dttm, 0, 10) as utc_candidate_created_dt,
        coalesce(aa_od.autoaccept_enabled_today_flg, False) as autoaccept_used_today_flg,
        fo.country_name_ru as country_name_ru,
        fo.tariff_geo_zone_code as tariff_geo_zone_code
);

$cr = (
    select dt, country_name_ru,
        autoaccept_used_today_flg,
        tariff_geo_zone_code,

        count(distinct dbid_uuid) as executor_cnt,

        sum(order_cnt) as order_cnt,
        sum(success_order_cnt)  as order_success_cnt,
        sum(cancelled_cnt) as order_cancelled_cnt,
        sum(cancelled_by_user_cnt) as order_cancelled_by_user_cnt,
        sum(cancelled_by_driver_cnt) as order_cancelled_by_driver_cnt,
        sum(ticket_cnt) as ticket_cnt,
    from $fct_order_data as fo
    group by dt,
        autoaccept_used_today_flg, country_name_ru,
        tariff_geo_zone_code
);


$ar_data = (
select dbid_uuid,
        utc_candidate_created_dt as dt,
        country_name_ru,
        tariff_geo_zone_code,
        autoaccept_used_today_flg,
        --autoaccept_enabled_flg,


        count(foc.utc_offered_dttm) as offered_cnt,
        count(foc.utc_seen_dttm) as seen_cnt,
        count(foc.utc_assigned_dttm) as assigned_cnt,




    from RANGE($FCT_ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as foc
    --left join RANGE($ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as oc
    --on foc.park_taximeter_id || '_' || foc.executor_profile_id == oc.park_taximeter_id || '_' || oc.executor_profile_id
        --and foc.order_id == oc.order_id
    left join $try_autoaccept as aa_od
    on aa_od.dbid_uuid == foc.park_taximeter_id || '_' || foc.executor_profile_id
        and aa_od.dt == substring(foc.utc_candidate_created_dttm, 0, 10)
    left join RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as fo
    on fo.order_id == foc.order_id
    where fo.tariff_class_code in $LOG_TARIFFS
        and utc_candidate_created_dt between $START_DT_STR and $END_DT_STR
        --and foc.park_taximeter_id || '_' || foc.executor_profile_id in $autoaccept_enabled_group
        --and foc.park_taximeter_id || '_' || foc.executor_profile_id in $our_supply_group
        and country_name_ru in ['Белоруссия',
                        'Узбекистан',
                        'Казахстан', 'Россия'
                        ]
    group by foc.park_taximeter_id || '_' || foc.executor_profile_id as dbid_uuid,
        substring(foc.utc_candidate_created_dttm, 0, 10) as utc_candidate_created_dt,
        coalesce(aa_od.autoaccept_enabled_today_flg, False) as autoaccept_used_today_flg,
        fo.country_name_ru as country_name_ru,
        fo.tariff_geo_zone_code as tariff_geo_zone_code
        --coalesce(oc.autoaccept_enabled_flg, False) as autoaccept_enabled_flg
);

$ar = (
    select dt, autoaccept_used_today_flg, country_name_ru,
        tariff_geo_zone_code,
        count(distinct dbid_uuid) as executor_cnt,

        SUM(offered_cnt) as offered_cnt,
        SUM(seen_cnt) as seen_cnt,
        SUM(assigned_cnt) as assigned_cnt,
    from $ar_data
    group by dt, autoaccept_used_today_flg, country_name_ru,
        tariff_geo_zone_code
);

insert into $SAVE_TO with TRUNCATE
select cr.*,
    --ar.executor_cnt as executor_cnt2,
    ar.offered_cnt as offered_cnt,
    ar.assigned_cnt as assigned_cnt,
    ar.seen_cnt as seen_cnt,

    geo.population_group as population_group,
    geo.agglomeration as agglomeration,
from $cr as cr
left join $ar as ar
on ar.dt == cr.dt
    and ar.autoaccept_used_today_flg == cr.autoaccept_used_today_flg
    and ar.country_name_ru == cr.country_name_ru
    and ar.tariff_geo_zone_code == cr.tariff_geo_zone_code
left join $geo as geo
on geo.tariff_zone == cr.tariff_geo_zone_code
where cr.dt between $START_DT_STR and $END_DT_STR
;
