--- число ребят с тегом
-- число ребят с автопринятием (у кого было включено хотя бы раз с начала экспа)
-- число ребят, у которых включено на день Х
--и все это по дням

-- какая доля курьеров включила автопринятие
-- распределение по времени работы в опции по типам саплая


use hahn;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;
PRAGMA SimpleColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;

-- my datasources

$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$CLAIM = '//home/delivery-dwh/ods/cargo_claims/claim';
$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$ACTUAL_TAGS = '//home/taxi/production/replica/postgres/tags/actual_tags';
$ORDER_PROC = '//home/taxi-dwh/raw/dbprocessing/order_proc';
$ORDER_CANDIDATE = '//home/taxi-dwh/ods/dbprocessing/order_candidate';
$FCT_ORDER_CANDIDATE = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$CLAIM_SEGMENT = '//home/delivery-dwh/ods/cargo_claims/claim_segment';
$FCT_STATE_HIST = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$TAG_LIST_HIST = '//home/taxi-dwh/cdm/executor/dim_executor_profile_tag_list_hist';
$PDA_DRIVERS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_drivers';
$UNIQUE_DRIVER_HIST = '//home/taxi-dwh/ods/mdb/unique_driver_hist/unique_driver_hist';
$C2C_CLIENTS_ORDERS = '//home/taxi/production/replica/postgres/cargo_c2c/clients_orders';
$C2C_CLIENTS_FEEDBACKS = '//home/taxi/production/replica/postgres/cargo_c2c/clients_feedbacks';

$AUTOACCEPT_LOGS = '//home/logfeller/logs/taxi/production/taxi-autoaccept-yandex-taxi-autoaccept-driver-options-log/1d';
--my tables



-- Куда сохранить результат
$AR_DATA_SAVE_TO = '//home/taxi-delivery/analytics/dev/product/autoaccept/ar_per_executor';
$CR_SAVE_TO = '//home/taxi-delivery/analytics/dev/product/autoaccept/cr_per_executor';
$OPTION_DATA_SAVE_TO = '//home/taxi-delivery/analytics/dev/product/autoaccept/option_data_per_executor';




-- списки
$LOG_TARIFFS = (
    'courier'
    , 'express'
    --, 'cargo'
    --, 'ubernight'
    --, 'cargocorp'
);


--Парсинг и форматы времени
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$date_dots_parse = DateTime::Parse("%d.%m.%Y");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_month_short_format = Datetime::Format('%Y-%m');
$date_year_format = Datetime::Format('%Y-01-01');


-- Константы для времени
$START_DTTM = Datetime::MakeDatetime($datetime_parse('2021-12-16 00:00:00'));
$END_DTTM = CurrentUtcDatetime()- Interval('P1D');

$START_DTTM_STR = $datetime_format($START_DTTM);
$START_DT_STR = $date_format($START_DTTM);
$START_MONTH_STR = $date_month_format($START_DTTM);
$START_MONTH_SHORT_STR = $date_month_short_format($START_DTTM);
$START_YEAR_STR = $date_year_format($START_DTTM);

$END_DTTM_STR = $datetime_format($END_DTTM);
$END_DT_STR = $date_format($END_DTTM);
$END_MONTH_STR = $date_month_format($END_DTTM);
$END_MONTH_SHORT_STR = $date_month_short_format($END_DTTM);
$END_YEAR_STR = $date_year_format($END_DTTM);


-- my func

$get_datetime_from_timestamp_sec = ($x) ->
{RETURN DateTime::MakeDatetime(DateTime::FromSeconds(CAST($x as Uint32)))};


$diff_minutes_dttm = (($end_dttm, $start_dttm) -> {
    $start = DateTime::MakeDatetime($datetime_parse($start_dttm));
    $end = DateTime::MakeDatetime($datetime_parse($end_dttm));
    RETURN 1.0*Datetime::ToSeconds($end - $start)/(60);
    --RETURN Datetime::Format('%H:%M:%S')$end - $start;
});

$dates = (
    select distinct TableName() as dt
    from RANGE('//home/logfeller/logs/taxi-tags-tag-event-log/1d', $START_DT_STR, $END_DT_STR)
);


-- инфо об участниках эксперимента
$test_group = (
    select distinct entity as dbid_uuid,
        'test' as group_name
    from $ACTUAL_TAGS
    where active  and entity_type =="dbid_uuid"
    and tag="logistics_autoaccept_exp_test"
    group by entity
);

$control_group = (
    select distinct entity as dbid_uuid,
        'control' as group_name
    from $ACTUAL_TAGS
    where active  and entity_type =="dbid_uuid"
    and tag="logistics_autoaccept_exp_control"
    group by entity
);

$exp_execs = (select * from $control_group union all select * from $test_group);

$exp_execs_daily = (select exp.*, d.dt as dt from $exp_execs as exp cross join $dates as d);

$executor_info = (
    select distinct dbid_uuid, country_name, tz_mode_orders, population_group, dt
    from RANGE(`//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_executors_monthly`, $START_MONTH_SHORT_STR)
);

--кто хотя бы раз включил автопринятие
$autoaccept_at_least_once = (
    select dbid_uuid
    from RANGE($AUTOACCEPT_LOGS,'2021-01-01') as al
    where switch_name = 'all_orders' and max(checked) = TRUE
    group by park_id || '_' || driver_profile_id as dbid_uuid
    having max(checked) = TRUE
);

--кто включил автопринятие хотя бы раз по дням
$autoaccept_at_least_once_daily = (
    select dbid_uuid, dt, max(checked) as autoaccept_once_flg,
    from RANGE($AUTOACCEPT_LOGS,'2021-01-01') as al
    cross join $dates as d
    where switch_name = 'all_orders' and  dt >= substring(iso_eventtime,0,10)
    group by park_id || '_' || driver_profile_id as dbid_uuid, d.dt as dt
);

--у кого включено автопринятие по дням
$autoaccept_on_daily = (
    select dbid_uuid, dt, max_by(checked, iso_eventtime) as autoaccept_on_flg,
    from RANGE($AUTOACCEPT_LOGS,'2021-01-01') as al
    cross join $dates as d
    where switch_name = 'all_orders' and dt >= substring(iso_eventtime,0,10)
    group by park_id || '_' || driver_profile_id as dbid_uuid, d.dt as dt
);

$try_autoaccept = (
    SELECT dbid_uuid, dt, count_if(substring(utc_candidate_created_dttm,0,10)<=dt and autoaccept_enabled_flg) as autoaccept_orders_cum_cnt,
        count_if(substring(utc_candidate_created_dttm,0,10)=dt and autoaccept_enabled_flg) as autoaccept_orders_cnt,
    from RANGE($ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as oc
    cross join $dates as d
    group by oc.park_taximeter_id || '_' || oc.executor_profile_id as dbid_uuid,
     d.dt as dt
);

$option_data = (
    select exp_execs.dbid_uuid as dbid_uuid,
        exp_execs.group_name as group_name,
        exp_execs.dt as dt,

        country_name, tz_mode_orders, population_group,

        coalesce(autoaccept_on_flg, False) as autoaccept_on_flg,
        coalesce(autoaccept_once_flg, False) as autoaccept_once_flg,
        coalesce(autoaccept_orders_cum_cnt, 0) as autoaccept_orders_cum_cnt,
        coalesce(autoaccept_orders_cnt, 0) as autoaccept_orders_cnt
    from $exp_execs_daily as exp_execs
    left join $autoaccept_at_least_once_daily as once
    on once.dbid_uuid == exp_execs.dbid_uuid and once.dt == exp_execs.dt
    left join $autoaccept_on_daily as on
    on on.dbid_uuid == exp_execs.dbid_uuid and on.dt == exp_execs.dt
    left join $try_autoaccept as try
    on try.dbid_uuid == exp_execs.dbid_uuid and try.dt == exp_execs.dt
    left join $executor_info as info
    on info.dt == exp_execs.dt and info.dbid_uuid == exp_execs.dbid_uuid
    where exp_execs.dt >= $START_DT_STR
);

insert into $OPTION_DATA_SAVE_TO WITH TRUNCATE
select *
from $option_data;

$support_data = (
    SELECT
    order_id,

    count(distinct st.ticket_id) as ticket_cnt,
    --unique_driver_id, db_id
    FROM
        `//home/taxi-analytics/hickinbottom/support/dwh/summary/support_tickets` as st --инфо о тикетах
    GROUP BY  order_id
);


$fct_order_data = (
    select dbid_uuid,
        utc_candidate_created_dt as dt,
        autoaccept_once_flg,
        autoaccept_enabled_flg,
        group_name,

        country_name, tz_mode_orders, population_group,

        count(fo.order_id) as order_cnt,
        count_if(success_order_flg)  as success_order_cnt,
        count_if(user_status = 'cancelled' or driver_status = 'cancelled') as cancelled_flg,
        sum(ticket_cnt) as ticket_cnt,

    from RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as fo
    left join $autoaccept_at_least_once_daily as aa_od
    on aa_od.dbid_uuid == fo.taximeter_park_id || '_' || fo.executor_profile_id and aa_od.dt == fo.utc_order_created_dt
    left join RANGE($ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as oc
    on fo.taximeter_park_id || '_' || fo.executor_profile_id == oc.park_taximeter_id || '_' || oc.executor_profile_id and fo.order_id == oc.order_id
    left join $exp_execs as exp
    on exp.dbid_uuid == fo.taximeter_park_id || '_' || fo.executor_profile_id
    left join $support_data as sup
    on sup.order_id == fo.order_id
    left join $executor_info as info
    on info.dt == substring(fo.utc_order_created_dttm, 0, 10)  and info.dbid_uuid == fo.taximeter_park_id || '_' || fo.executor_profile_id
    where fo.tariff_class_code in $LOG_TARIFFS and utc_order_created_dt between $START_DT_STR and $END_DT_STR
    group by fo.taximeter_park_id || '_' || fo.executor_profile_id as dbid_uuid,
        substring(fo.utc_order_created_dttm, 0, 10) as utc_candidate_created_dt,
        coalesce(aa_od.autoaccept_once_flg, False) as autoaccept_once_flg,
        coalesce(oc.autoaccept_enabled_flg, False) as autoaccept_enabled_flg,
        coalesce(exp.group_name, 'no group') as group_name,
        info.country_name as country_name,
        info.tz_mode_orders as tz_mode_orders,
        info.population_group as population_group
);

INSERT INTO $CR_SAVE_TO WITH TRUNCATE
select * from $fct_order_data;

--AR
$ar_data = (
select dbid_uuid,
        utc_candidate_created_dt as dt,
        autoaccept_once_flg,
        autoaccept_enabled_flg,
        group_name,

        country_name, tz_mode_orders, population_group,

        count(foc.utc_offered_dttm) as offered_cnt,
        count(foc.utc_seen_dttm) as seen_cnt,
        count(foc.utc_assigned_dttm) as assigned_cnt,


from RANGE($FCT_ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as foc
    left join $autoaccept_at_least_once_daily as aa_od
    on aa_od.dbid_uuid == foc.park_taximeter_id || '_' || foc.executor_profile_id and aa_od.dt == substring(foc.utc_candidate_created_dttm, 0, 10)
    left join RANGE($ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as oc
    on foc.park_taximeter_id || '_' || foc.executor_profile_id == oc.park_taximeter_id || '_' || oc.executor_profile_id and foc.order_id == oc.order_id
    left join $exp_execs as exp
    on exp.dbid_uuid == foc.park_taximeter_id || '_' || foc.executor_profile_id
    left join $executor_info as info
    on info.dt == substring(foc.utc_candidate_created_dttm, 0, 10) and info.dbid_uuid == foc.park_taximeter_id || '_' || foc.executor_profile_id
where tariff_class_code in $LOG_TARIFFS and utc_candidate_created_dt between $START_DT_STR and $END_DT_STR
group by foc.park_taximeter_id || '_' || foc.executor_profile_id as dbid_uuid,
        substring(foc.utc_candidate_created_dttm, 0, 10) as utc_candidate_created_dt,
        coalesce(aa_od.autoaccept_once_flg, False) as autoaccept_once_flg,
        coalesce(oc.autoaccept_enabled_flg, False) as autoaccept_enabled_flg,
        coalesce(exp.group_name, 'no group') as group_name,
        info.country_name as country_name,
        info.tz_mode_orders as tz_mode_orders,
        info.population_group as population_group
);



insert into $AR_DATA_SAVE_TO with TRUNCATE
select * from $ar_data;
