-- LOGDATA-777
use hahn;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;
PRAGMA SimpleColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- Используемые таблицы
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$FCT_ORDER_CANDIDATE = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
--$ACTUAL_TAGS = '//home/taxi/production/replica/postgres/tags/actual_tags';
$ORDER_CANDIDATE = '//home/taxi-dwh/ods/dbprocessing/order_candidate';

-- Куда сохранить результат
$SAVE_TO = '//home/taxi-delivery/analytics/dev/product/autoaccept/seen_timeout_data_regular';

$LOG_TARIFFS = (
    'courier'
    , 'express'
    --, 'cargo'
    --, 'ubernight'
    --, 'cargocorp'
);

--Парсинг и форматы времени 
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_year_format = Datetime::Format('%Y-01-01');


-- Константы для времени
$START_DTTM = CurrentUtcDatetime()- Interval('P30D');
$END_DTTM = CurrentUtcDatetime()- Interval('P1D');

$START_DTTM_STR = $datetime_format($START_DTTM);
$START_DT_STR = $date_format($START_DTTM);
$START_MONTH_STR = $date_month_format($START_DTTM);
$START_YEAR_STR = $date_year_format($START_DTTM);

$END_DTTM_STR = $datetime_format($END_DTTM);
$END_DT_STR = $date_format($END_DTTM);
$END_MONTH_STR = $date_month_format($END_DTTM);
$END_YEAR_STR = $date_year_format($END_DTTM);

-- Функции
$get_datetime_from_timestamp_sec = ($x) -> 
{RETURN DateTime::MakeDatetime(DateTime::FromSeconds(CAST($x as Uint32)))};


$full_geo = (
    select tariff_zone, some(population_group) as population_group, some(tz_country_name_ru) as country_name
    from $GEO
    where root_node_id = 'br_root' 
    --and updated <= $datetime_format($DT_END)
    group by tariff_zone
);

/*
$auto_courier_tag = (
    select entity as dbid_uuid, 
        max(updated) as auto_courier_updated_dttm, 
        TRUE as auto_courier_flg
    from $ACTUAL_TAGS
    where active  and entity_type =="dbid_uuid"
    and tag="auto_courier"
    group by entity
);


$walking_courier_tag = (
    select entity as dbid_uuid, 
        max(updated) as walking_courier_updated_dttm, 
        1 as walking_courier_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="walking_courier"
    group by entity
);*/

--1) доля заказов seen_timeout со штрафами активности в разрезе всех заказов с seen_timeout

-- seen_timeout штрафы 
$activity_seen_timeout = (
SELECT      --entity_id, event_id, event_type, event_name, Yson::ConvertToInt64(rules.action_result) as action_result, Yson::ConvertToString(extra_data.order_id) as order_id, `timestamp`, rules, context, rule_name, rule_type,  event_zone
    event_id, Yson::ConvertToInt64(rules.action_result) as action_result, Yson::ConvertToString(extra_data.order_id) as order_id, `timestamp`, event_zone, event_type,
        String::SplitToList(Yson::ConvertToString(context.event.extra_data.driver_id), '_')[1] as executor_profile_id,
        event_name,


FROM        RANGE(`//home/logfeller/logs/taxi-stq3-yandex-taxi-metrics-stq3-rule-logger-log/1d`, $START_DT_STR, $END_DT_STR)
WHERE       TRUE
AND         rule_name == "ActivityOT"
--AND         rule_type == 'activity'
AND         entity_type == "driver"
--AND         event_name == 'seen_timeout'
AND         Yson::ConvertToInt64(rules.action_result) < 0
AND         $date_format($get_datetime_from_timestamp_sec(`timestamp`)) between $START_DT_STR and $END_DT_STR
);


$activity_seen_timeout_by_offer = (
    select executor_profile_id, order_id, 
        max(`timestamp`) as `timestamp`,
        max_by(action_result, `timestamp`) as action_result, 
        max_by(event_zone, `timestamp`) as event_zone,
        max_by(event_type, `timestamp`) as event_type,
        max_by(event_name, `timestamp`) as event_name,
    from $activity_seen_timeout 
    group by executor_profile_id, order_id
);

-- все заказы доставки с seen_timeout
$delivery_offers = (
    select foc.park_taximeter_id || '_' || foc.executor_profile_id as dbid_uuid,
        foc.park_taximeter_id as park_taximeter_id,
        foc.executor_profile_id as executor_profile_id,
        foc.order_id as order_id,

        fo.tariff_class_code as tariff_class_code,
        fo.utc_order_created_dt as utc_order_created_dt,
        fo.utc_order_created_dttm as utc_order_created_dttm,
        fo.tariff_geo_zone_code as tariff_geo_zone_code,

        foc.utc_assigned_dttm is not null as assigned_flg, --принятие предложения водителем 
        foc.utc_seen_timeout_dttm is not null as seen_timeout_flg, --таймаут на просмотр предложения водителем 
        foc.utc_cancelled_dttm is not null as cancelled_flg, --отмена пользователем
        foc.utc_offer_timeout_dttm is not null as offer_timeout_flg, --таймаут на принятие заказа 
        foc.utc_rejected_dttm is not null as rejected_flg, -- отказ водителя 
        foc.utc_multioffer_accepted_dttm is not null as multioffer_accepted_flg, -- принятие мультиоффера водителем 

        foc.utc_finished_dttm is not null as finished_flg, --заполнено поле о завершении (может быть у разных статусов)
        candidate_status,
        rejected_reason_code,


        ListHas(Yson::ConvertToStringList(tag_id_list), 'walking_courier') as walking_courier_flg,
        ListHas(Yson::ConvertToStringList(tag_id_list), 'auto_courier') as auto_courier_flg,
    from RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as fo 
    inner join RANGE($FCT_ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as foc 
    on fo.order_id == foc.order_id 
    inner join RANGE($ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as oc 
    on oc.order_id == foc.order_id and oc.executor_profile_id == foc.executor_profile_id
    where fo.tariff_class_code in $LOG_TARIFFS
        and fo.utc_order_created_dt <= $END_DT_STR and fo.utc_order_created_dt >= $START_DT_STR
);

insert into `//home/taxi-delivery/analytics/dev/drmks/test/activity_seen_timeout` with truncate 
select * from $activity_seen_timeout;

insert into `//home/taxi-delivery/analytics/dev/drmks/test/seen_timeout_delivery_offers` with truncate 
select * from $delivery_offers;


$result = (
    select o.*,
         action_result, event_name, event_type, a.order_id is not null as activity_found_flg,
         geo.population_group as population_group, geo.country_name as country_name
    from $delivery_offers as o 
    left join $activity_seen_timeout_by_offer as a 
    on a.order_id == o.order_id and o.executor_profile_id == a.executor_profile_id
    left join $full_geo as geo 
    on geo.tariff_zone == o.tariff_geo_zone_code
);



select utc_order_created_dt, 
    tariff_geo_zone_code,
    population_group,
    walking_courier_flg, auto_courier_flg,

    count_if(seen_timeout_flg) as offer_seen_timeout_cnt, 
    count_if(seen_timeout_flg and activity_found_flg) as offer_seen_timeout_activity_cnt,
    count_if(seen_timeout_flg and activity_found_flg and event_name == 'seen_timeout') as offer_seen_timeout_activity_specific_cnt,

    count_if(offer_timeout_flg) as offer_offer_timeout_cnt, 
    count_if(offer_timeout_flg and activity_found_flg) as offer_offer_timeout_activity_cnt,

    count(*) as offers_del_cnt,
    count_if(assigned_flg) as offers_del_assigned_cnt,

from $result 
where country_name == 'Россия' and population_group in ['RU_1M+', 'RU_MSC', 'RU_SPB']
group by utc_order_created_dt, 
    tariff_geo_zone_code,
    population_group,
    auto_courier_flg,
    walking_courier_flg
;



insert into $SAVE_TO with truncate 
select * from $result;


;
