use hahn;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;
PRAGMA SimpleColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;
PRAGMA yt.pool='taxi-delivery';

$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$SUPPLY_OVERVIEW_LCL = '//home/taxi-delivery/analytics/production/product/supply_overview_lcl';

--Парсинг и форматы времени 
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$date_parse = DateTime::Parse("%Y-%m-%d");
$date_dots_parse = DateTime::Parse("%d.%m.%Y");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_month_short_format = Datetime::Format('%Y-%m');
$date_year_format = Datetime::Format('%Y-01-01');

-- Константы для времени


$START_DTTM = CurrentUtcDatetime()- Interval('P17D');
$END_DTTM = CurrentUtcDatetime()- Interval('P0D');


--$START_DTTM = CurrentUtcDatetime()- Interval('P99D');
--$END_DTTM = CurrentUtcDatetime()- Interval('P59D');

$START_DTTM_STR = $datetime_format($START_DTTM);
$START_DT_STR = $date_format($START_DTTM);
$START_MONTH_STR = $date_month_format($START_DTTM);
$START_MONTH_SHORT_STR = $date_month_short_format($START_DTTM);
$START_YEAR_STR = $date_year_format($START_DTTM);

$END_DTTM_STR = $datetime_format($END_DTTM);
$END_DT_STR = $date_format($END_DTTM);
$END_MONTH_STR = $date_month_format($END_DTTM);
$END_MONTH_SHORT_STR = $date_month_short_format($END_DTTM);
$END_YEAR_STR = $date_year_format($END_DTTM);

$LAST_FULL_WEEK = $date_format(Datetime::StartOfWeek(Datetime::MakeDatetime(CurrentUtcDatetime()- Interval('P7D'))));


$week = ($d) -> {
    return $date_format(DateTime::StartOfWeek($date_parse($d)));
};

$month = ($d) -> {
    return $date_format(DateTime::StartOfMonth($date_parse($d)));
};

$geo =
(
    select tariff_zone, some(population_group) as population_group,
    some(tz_country_name_ru) as tz_country_name_ru,
    some(name_ru) as agglomeration,
    some(time_zone_code) as time_zone_code
    from $GEO
    where root_node_id = 'br_root'
        and node_type = 'agglomeration'
    group by tariff_zone
);

$src = (SELECT fct.*
 , CASE
 WHEN success_order_flg THEN gross_commission_revenue_amt - incentives_amt + b2b_decoupling_amt
 ELSE 0
 END AS net_inflow_amt
FROM (
SELECT fct.*
 , CASE
 WHEN success_order_flg THEN rider_incentives_amt + driver_incentives_amt + fee_branding_chargeback_amt
 ELSE 0
 END AS incentives_amt
FROM (SELECT tariff_geo_zone_code
 , basic_class_code
 , order_id
 , order_sk
 , utc_order_created_dttm
 , msk_order_created_dttm
 , currency_code
 , currency_rate
 , mqc_order_flg
 , success_order_flg
 , decoupling_user_cost
 , decoupling_driver_cost
 , decoupling_success_flg
 , cashback_effect_value
 , tariff_class_code
 , CASE WHEN success_order_flg THEN fct.order_cost ELSE 0 END AS gmv_amt
 , CASE WHEN success_order_flg THEN order_commission_discount_wo_vat_value ELSE 0 END AS fee_branding_chargeback_amt
 , CASE
 WHEN success_order_flg THEN
 subsidy_value + holded_subsidy_value + dms_value + holded_dms_value +
 subsidy_commission_discount_value - subsidy_commission_value
 ELSE 0
 END AS driver_incentives_amt
 , CASE
 WHEN decoupling_success_flg AND success_order_flg THEN decoupling_user_cost - decoupling_driver_cost
 ELSE 0
 END AS b2b_decoupling_amt
 , CASE
 WHEN success_order_flg THEN discount_compensation_value + promocode_compensation_value +
 holded_discount_value + dmd_value + holded_dmd_value
 ELSE 0
 END AS rider_incentives_amt
 , CASE
 WHEN success_order_flg THEN order_commission_w_discount_wo_vat_value +
 order_commission_discount_wo_vat_value + shift_commission_wo_vat_value +
 acquiring_commission_value + agency_commission_wo_vat_value +
 call_center_commission_wo_vat_value + hiring_commission_wo_vat_value +
 hiring_shift_commission_wo_vat_value + childchair_rent_wo_vat_value +
 driver_fix_comission_wo_vat_amt + driver_fix_comission_for_fraud_wo_vat_amt +
 rebate_w_vat_value + voucher_commission_wo_vat_value
 ELSE 0
 END AS gross_commission_revenue_amt
 , CASE
 WHEN success_order_flg OR fct.paid_cancel_order_flg THEN fct.driver_cost + fct.subsidy_value +
 fct.holded_subsidy_value
 ELSE 0
 END AS driver_income_incl_paid_cancel_amt
 , CASE
 WHEN success_order_flg OR fct.paid_cancel_order_flg THEN
 fct.driver_cost + subsidy_value + fct.holded_subsidy_value +
 subsidy_commission_discount_value - order_commission_w_discount_wo_vat_value -
 order_commission_vat_value - shift_commission_w_vat_value - call_center_commission_w_vat_value -
 childchair_rent_w_vat_value - voucher_commission_wo_vat_value - holded_subsidy_commission_value -
 subsidy_commission_value - driver_fix_comission_wo_vat_amt -
 driver_fix_comission_for_fraud_wo_vat_amt - acquiring_commission_value - rebate_w_vat_value -
 agency_commission_w_vat_value
 ELSE 0
 END AS driver_net_income_incl_paid_cancel_amt

 , acquiring_commission_value
 , agency_commission_w_vat_value
 , user_locale
 , app_platform_name
 , app_version_code
 , balance_rate
 , brand_name
 , calc_method_code
 , call_center_commission_w_vat_value
 , car_profile_sk
 , agglomeration_node_id
 , corp_client_id
 , corp_user_id
 , country_name_ru
 , promocode_id
 , promocode_compensation_value
 , promocode_nominal_value
 , decoupling_flg
 , discount_compensation_value
 , dmd_value
 , dms_value
 , driver_license_pd_id
 , executor_profile_sk
 --, experiment_code_list
 , expired_order_flg
 , antisurge_flg
 , fake_order_flg
 , fixed_price_order_flg
 , promotion_code
 , hiring_commission_wo_vat_value
 , holded_discount_value
 , holded_dmd_value
 , holded_dms_value
 , holded_subsidy_commission_value
 , holded_subsidy_commission_discount_value
 , holded_subsidy_value
 , msk_order_created_dt
 , msk_order_due_dttm
 , offer_id
 , taximeter_order_id
 , order_comment
 , order_commission_w_discount_wo_vat_value
 , order_commission_discount_wo_vat_value
 , order_commission_vat_value
 , order_cost_for_commission_value
 , destination_plan_address
 , destination_fact_geohash
 , order_requirement_list
 , order_source_code
 , source_address
 , source_geohash
 , order_type
 , paid_supply_flg
 , park_client_sk
 , request_payment_type
 , tariff_plan_cost
 , destination_plan_geohash
 , destination_plan_geohash_cnt
 , destination_plan_geohash_list
 , transporting_distance_plan_km
 , transporting_time_plan_mnt
 , rebate_w_vat_value
 , user_status
 , subsidy_commission_value
 , subsidy_commission_discount_value
 , subsidy_value
 , tariff_id
 , tariff_sk
 , driver_status
 , travel_time_mnt
 , unique_driver_id
 , unrealized_commission_w_discount_wo_vat_value
 , unrealized_commission_discount_wo_vat_value
 , unrealized_commission_wo_discount_wo_vat_value
 , unrealized_subsidy_commission_value
 , app_user_agent
 , user_client_id
 , user_phone_id
 , utc_order_created_dt
 , utc_order_due_dttm
 , voucher_commission_wo_vat_value
 , tariff_class_sk
 , tariff_class_fallback_flg
 , user_tariff_class_code_list
 , from_airport_flg
 , to_airport_flg
 , transfer_flg
 , suburban_flg
 , user_phone_pd_id
 , last_cargo_order_id
 , app_name
 , childchair_rent_wo_vat_value
 , childchair_rent_w_vat_value
 , shift_commission_w_vat_value
 , shift_commission_wo_vat_value
 , hiring_shift_commission_w_vat_value
 , hiring_shift_commission_wo_vat_value
 , fact_payment_type
 , payment_card_number
 , payment_system_name
 , debt_order_flg
 , corp_order_flg
 , coop_account_id
 , coop_account_type
 , user_w_vat_cost
 , tip_w_vat_amt
 , yandex_uid
 , work_mode_code
 , driver_fix_comission_wo_vat_amt
 , driver_fix_comission_for_fraud_wo_vat_amt
 , driver_fix_subsidy_wo_vat_amt
 , cashback_spend_amt
 , cashback_get_amt
 , cashback_type
 , rating_reason_list
 , cancel_reason_list
 , rating_comment
 , rating_value
 , order_cost
 , order_wo_limit_cost
 , paid_cancel_order_flg
 , has_ya_plus_flg
 , has_cashback_plus_flg
 , driver_cost
 , order_before_surge_cost
 , agency_commission_wo_vat_value
 , call_center_commission_wo_vat_value
 , first_order_flg
 , first_uber_order_flg
 , first_yandex_order_flg
 , park_sk
 , order_completion_time_mnt
 , tariff_class_unnest_id
 , appmetrica_device_id
 , delivery_point_cnt
 , lcl_order_created_dt
 , lcl_order_created_dttm
 , lcl_order_due_dttm
 , childchair_flg
 , workshift_flg
 , extra_tariff_flg

 , taximeter_park_id as park_taximeter_id
 , executor_profile_id
 , lcl_order_created_dt as lcl_date
 , $week(lcl_order_created_dt) as lcl_week_date
 , agglomeration_name_ru
 , taximeter_park_id || '_' || executor_profile_id as dbid_uuid

 FROM RANGE(`//home/taxi-dwh/cdm/marketplace/fct_order`, $START_MONTH_STR, $END_MONTH_STR) AS fct
 where tariff_class_code in ['express', 'courier'] 
    and executor_profile_id is not null 
) AS fct
) AS fct);

/*
$tags_data = (
    select park_taximeter_id || '_' || executor_profile_id as dbid_uuid, order_id,
        case when ListHas(Yson::ConvertToStringList(tag_id_list), 'bike_courier') then 'bike courier'
        when ListHas(Yson::ConvertToStringList(tag_id_list), 'walking_courier') then 'walking courier'
        when ListHas(Yson::ConvertToStringList(tag_id_list), 'scooter_courier') then 'scooter courier'
        when ListHas(Yson::ConvertToStringList(tag_id_list), 'auto_courier') then 'auto courier'
        else 'unknown' end as courier_type,
    from `//home/taxi-dwh/ods/dbprocessing/order_candidate/2021-09-01`
);

$src_new = (select t.*, courier_type from $src as t left join $tags_data as tag on tag.dbid_uuid == t.dbid_uuid and tag.order_id == t.order_id);
*/

--sh 

$src_agg = (
    select dbid_uuid, park_taximeter_id, executor_profile_id, lcl_week_date, sum(driver_net_income_incl_paid_cancel_amt) as driver_net_income_incl_paid_cancel_amt, count(order_id) as order_cnt, count_if(success_order_flg) as order_success_cnt,
    from $src 
    group by dbid_uuid, park_taximeter_id, executor_profile_id, lcl_week_date
);


$sh_agg = (
    select dbid_uuid, park_taximeter_id, executor_profile_id, sum(delivery_sh) as sh_delivery,
     lcl_week_date, agglomeration, country, 
     TryMember(Mode(case when String::Contains(transport_type, 'Грузовой') then 'Грузовой' 
                         when String::Contains(transport_type, 'Такси') or String::Contains(transport_type, 'Авто') then 'Авто'
                         else transport_type end)[0], "Value", null) as weekly_transport_type,

    max(allow_heavy_delivery) as allow_heavy_delivery,
    max(has_thermobag) as has_thermobag,
    max(has_thermopack) as has_thermopack,
    max(has_medical_card) as has_medical_card,
    max(post_payment) as post_payment,
    max(profi_courier) as profi_courier,
    max(bike_courier) as bike_courier,
    from RANGE($SUPPLY_OVERVIEW_LCL, $START_MONTH_STR, $END_MONTH_STR) 
    group by dbid_uuid, String::SplitToList(dbid_uuid,'_')[0] as park_taximeter_id, String::SplitToList(dbid_uuid,'_')[1] as executor_profile_id, $week(lcl_date) as lcl_week_date, agglomeration, country 
);



$data_final_raw = (
select src.lcl_week_date as lcl_week_date, 
    sh.country as country, agglomeration, 
    src.park_taximeter_id as park_taximeter_id, src.executor_profile_id as executor_profile_id, src.dbid_uuid as dbid_uuid,
    driver_net_income_incl_paid_cancel_amt, order_cnt, order_success_cnt, sh_delivery,
    weekly_transport_type,

    allow_heavy_delivery,
    has_thermobag,
    has_thermopack,
    has_medical_card,
    post_payment,
    profi_courier,
    bike_courier,
from $src_agg as src 
left join $sh_agg as sh 
on sh.dbid_uuid == src.dbid_uuid and sh.lcl_week_date == src.lcl_week_date 
);

$data_final_agg = (
    select lcl_week_date, country, agglomeration, weekly_transport_type,
    park_taximeter_id, executor_profile_id, dbid_uuid, 
    driver_net_income_incl_paid_cancel_amt,
    order_cnt, order_success_cnt, sh_delivery,

    allow_heavy_delivery,
    has_thermobag,
    has_thermopack,
    has_medical_card,
    post_payment,
    profi_courier,
    bike_courier,

    ROW_NUMBER() over w as position 
    from $data_final_raw 
    WINDOW w AS (PARTITION BY lcl_week_date, country, agglomeration, weekly_transport_type ORDER BY driver_net_income_incl_paid_cancel_amt DESC)
);

insert into `//home/taxi-delivery/analytics/production/product/courier_profit_rating/couriers_profit_rating_by_agglomeration_russia_weekly` with truncate
select * from $data_final_agg
where position <= 10 and lcl_week_date == $LAST_FULL_WEEK
and country == 'Россия';
