use hahn; 
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;

$end_dt = CAST((CurrentUtcDate()) as String);
$start_dt = '2021-08-30';;

$source_path = '//home/taxi-delivery/analytics/dev/product/adhocs/panel_notification_events_all';
$agg_exec_daily_path = '//home/taxi-delivery/analytics/dev/product/adhocs/panel_notification_events_agg_by_day';


INSERT INTO $source_path 
WITH TRUNCATE 
select  
    (park_taximeter_id || '_' || executor_profile_id) as dbid_uuid,
    park_taximeter_id, executor_profile_id,
    api_key,
    app_platform,
    app_version_name,
    application_id,
    appmetrica_uuid as user_id, 
    Yson::ConvertToString(event_value.commonparams.`timestamp`) ?? 'null' as time,
    event_name, event_value,
    session_event_number as session_event_number,
    event_name || 
    case event_name
        when 'ui_event' then 
            -- case when not Yson::Contains(event_value, 'afterordermetricaparams') then 
            --     '.' || (Yson::ConvertToString(event_value.uiaspectparams.ui)  ?? 'null') ||
            --     ' ' || (Yson::ConvertToString(event_value.uiaspectparams.state)  ?? 'null')
            -- else 
            '.' || (Yson::ConvertToString(event_value.`panelnotificationparams`.`category`)  ?? 'null') ||
            '.' || (Yson::ConvertToString(event_value.`panelnotificationparams`.`type`)  ?? 'null')
            --'.' || (Yson::ConvertToString(Yson::YPath(Yson::Parse(event_value), '/uiparams/panelnotificationparams/category'))  ?? 'null') ||
            --'.' || (Yson::ConvertToString(Yson::YPath(Yson::Parse(event_value), '/uiparams/panelnotificationparams/type'))  ?? 'null') 
            -- card_id
            -- end
        ELSE 'empty'
    end
            as event_name_full, 
    utc_event_dttm,
    substring(utc_event_dttm, 0, 10) as utc_event_dt,
    (Yson::ConvertToString(event_value.`panelnotificationparams`.`category`)  ?? 'null') as category,
    (Yson::ConvertToString(event_value.`panelnotificationparams`.`type`)  ?? 'null') as type 

    from
    range(`//home/taxi-dwh/ods/appmetrica/taximeter`, $start_dt, $end_dt)
    where  

    event_name == 'ui_event' 
    and Yson::ConvertToString(event_value.`uiparams`.`uicomponentname`)=='panel_notification/click_item'
    and Yson::ConvertToString(event_value.`panelnotificationparams`.`category`) == 'logistics_shifts'
    --and (Yson::ConvertToString(Yson::YPath(Yson::Parse(event_value), '/uiparams/uicomponentname'))=='panel_notification/click_item' )
    --and (Yson::ConvertToString(Yson::YPath(Yson::Parse(event_value), '/uiparams/panelnotificationparams/category')) == 'logistics_shifts')
    --and appmetrica_uuid is not null
    -- )

;
COMMIT;

select distinct event_name_full as ev from $source_path
ORDER BY ev;



insert into $agg_exec_daily_path WITH TRUNCATE 
select country_name, agglomeration_name, utc_event_dt,  type,
    count(distinct t.dbid_uuid) as executors_cnt, 
    count(*) as events_cnt
    --count_if(type=='notification') as type_notification_cnt,
    --count_if(type=='widget') as type_widget_cnt,
from $source_path as t 
left join  `//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_executors_supply_actual` as abt 
    on abt.dbid_uuid = t.dbid_uuid
group by coalesce(abt.country_name, 'null') as country_name, 
    coalesce(abt.agglomeration_name, 'null') as agglomeration_name, 
    coalesce(t.utc_event_dt, 'null') as utc_event_dt,
    t.type as type 
