/*
флаттер не флаттер
корп не корп
логапи не логапи
платформа (андроид ios)
версия аппа

CR AR cancels (user driver)
sh executors
orders claims
contact rate
*/

use hahn;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;
PRAGMA SimpleColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;

--datasources
$TAG_LIST_HIST = '//home/taxi-dwh/cdm/executor/dim_executor_profile_tag_list_hist';
$FCT_STATE_HIST = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$DIM_PARK_HIST = '//home/taxi-dwh/cdm/supply/dim_park_hist/dim_park_hist';
$PARKS = '//home/taxi/production/replica/mongo/struct/parks_private/parks';
$CONTRACTS = '//home/taxi-delivery/parks/contracts';
$ORDER_CANDIDATE = '//home/taxi-dwh/ods/dbprocessing/order_candidate';
$FCT_ORDER_CANDIDATE = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$CARS_TABLE = '//home/taxi-dwh/raw/taximeter/cars/cars';
$PDA_CARS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_cars';
$PDA_DRIVERS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_drivers';
$CLAIM = '//home/delivery-dwh/ods/cargo_claims/claim';

$SUPPORT_TICKETS = '//home/taxi-dwh/ods/chatterbox_support_taxi/ticket';
$DM_EXECUTOR_PROFILE_HIST = '//home/taxi-dwh/cdm/supply/dim_executor_profile_hist';
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$LINK_UNIQUE_DRIVER_ID = '//home/taxi-dwh/cdm/supply/link_old_current_unique_driver_act/link_old_current_unique_driver_act';
$FCT_DELIVERY = '//home/delivery-dwh/cdm/delivery/fct_delivery';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$SUPPLY_OVERVIEW = '//home/taxi-delivery/analytics/production/product/supply_overview';

--Парсинг и форматы времени
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$date_parse = DateTime::Parse("%Y-%m-%d");
$date_dots_parse = DateTime::Parse("%d.%m.%Y");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_month_short_format = Datetime::Format('%Y-%m');
$date_year_format = Datetime::Format('%Y-01-01');


--$START_DTTM = Datetime::MakeDatetime($datetime_parse('2022-05-01 00:00:00'));
$START_DTTM = CurrentUtcDatetime()-Interval('P31D');
$END_DTTM = CurrentUtcDatetime()-Interval('P1D');


$START_DTTM_STR = $datetime_format($START_DTTM);
$START_DT_STR = $date_format($START_DTTM);
$START_MONTH_STR = $date_month_format($START_DTTM);
$START_MONTH_SHORT_STR = $date_month_short_format($START_DTTM);
$START_YEAR_STR = $date_year_format($START_DTTM);

$END_DTTM_STR = $datetime_format($END_DTTM);
$END_DT_STR = $date_format($END_DTTM);
$END_MONTH_STR = $date_month_format($END_DTTM);
$END_MONTH_SHORT_STR = $date_month_short_format($END_DTTM);
$END_YEAR_STR = $date_year_format($END_DTTM);

$LOG_TARIFFS = ['express', 'courier', 'sdd', 'cargo', 'cargocorp', 'night'];

$contact_rate_data = (
    SELECT
    order_id,

    count(distinct chatterbox_ticket_id) as ticket_cnt,

    FROM
        RANGE($SUPPORT_TICKETS, $START_MONTH_STR) as st
    GROUP BY String::RemoveAll(order_id, '-') as order_id
);


$geo =
(
    select tariff_zone, some(population_group) as population_group,
    some(tz_country_name_ru) as tz_country_name_ru,
    some(name_ru) as agglomeration,
    some(time_zone_code) as time_zone_code
    from $GEO
    where root_node_id = 'br_root'
        and node_type = 'agglomeration'
    group by tariff_zone
);

/*
$dates = (
select $date_format(Datetime::FromSeconds(ls)) as dt from (
SELECT ListFromRange(nvl(DateTime::ToSeconds($START_DTTM),0), nvl(DateTime::ToSeconds($END_DTTM),0),86400) as ls)
flatten by ls
);
*/



$couriers_app_and_sh_data = (
select
    utc_date,
    tariff_zone,
    country, agglomeration, population_group,

    --courier_type,
    case when String::Contains(courier_type, 'cargo') then 'cargo' else courier_type end as courier_type,

    transport_type,
    taximeter_platform,
    taximeter_version_code,
    String::SplitToList(taximeter_version_code, ' ')[0]  as taximeter_version,
    case when CAST(String::SplitToList(taximeter_version_code, '.')[0] as Int64) >= 11 then 'X'
      else 'taximeter' end as application_id,
    delivery_sh,
    dbid_uuid, unique_driver_id,
from RANGE($SUPPLY_OVERVIEW, $START_MONTH_STR)
);

$couriers_sh_data_agg = (
select
    utc_date,
    tariff_zone,
    country, agglomeration, population_group,
    courier_type,
    transport_type,
    taximeter_platform,
    taximeter_version_code,
    taximeter_version, application_id,
    sum(delivery_sh) as delivery_sh,
    count(dbid_uuid) as executor_cnt,
    count(distinct unique_driver_id) as executor_unique_cnt,
from RANGE($SUPPLY_OVERVIEW, $START_MONTH_STR)
group by utc_date,
    tariff_zone,
    country, agglomeration, population_group,

    --courier_type,
    case when String::Contains(courier_type, 'cargo') then 'cargo' else courier_type end as courier_type,

    transport_type,
    taximeter_platform,
    taximeter_version_code,
    String::SplitToList(taximeter_version_code, ' ')[0]  as taximeter_version,
    case when CAST(String::SplitToList(taximeter_version_code, '.')[0] as Int64) >= 11 then 'X'
      else 'taximeter' end as application_id
);

$executor_order_mapping = (
    select distinct order_id, executor_profile_id, taximeter_park_id as park_taximeter_id,
        taximeter_park_id || '_' || executor_profile_id as dbid_uuid,
    from RANGE($FCT_ORDER, $START_MONTH_STR)
);


$fct_delivery_raw = (
    select dbid_uuid, executor_profile_id, park_taximeter_id,
        coalesce(taxi_corp_order_flg, false) as corp_order_flg,
        case when taxi_corp_order_flg = True and taxi_order_source_code = 'yandex' then 'corp_taxiapi'
            when taxi_corp_order_flg = True and taxi_order_source_code in ['cargo', 'corp_cabinet'] then 'corp_logapi'
            when taxi_corp_order_flg = False and taxi_order_source_code = 'yandex' then 'app_taxiapi'
            when taxi_corp_order_flg = False and taxi_order_source_code = 'cargo' then 'app_logapi'
            else 'NA'
        end as order_type,

        df.order_id as order_id,
        claim_uuid as claim_uuid,
        point_id,
        taxi_tariff_geo_zone_code,
        taxi_tariff_class_code,
        country_name_ru,
        city_name_ru,
        final_claim_status,
        final_delivery_status,

        ticket_cnt,

        True as delivery_flg,

        final_delivery_status = 'completed' as successful_flg,
        final_claim_status in ['cancelled_by_client', 'cancelled_by_performer'] as cancel_flg,
        final_claim_status = 'cancelled_by_client' as cancel_client_flg,
        final_claim_status = 'cancelled_by_performer' as cancel_performer_flg,

        utc_created_dttm,
        String::SplitToList(utc_created_dttm, ' ')[0] as utc_created_dt,




    from RANGE($FCT_DELIVERY, $START_MONTH_STR) as df
    left join $executor_order_mapping as ex
    on ex.order_id == df.order_id
    left join $contact_rate_data as s
    on s.order_id == df.order_id
    where taxi_tariff_class_code in $LOG_TARIFFS
);


$fct_delivery_by_order_id = (
    select dbid_uuid, executor_profile_id, park_taximeter_id, order_id,
        country_name_ru,
        city_name_ru,
        some(final_claim_status) as final_claim_status,

        logapi_flg,
        corp_flg,
        taxiapi_flg,
        app_flg,

        utc_created_dttm,
        utc_created_dt,

        some(ticket_cnt) as ticket_cnt,
        max(corp_order_flg) as corp_order_flg,
        some(order_type) as order_type,

        count(distinct df.claim_uuid) as claim_cnt,
        count_if(delivery_flg) as delivery_cnt,
        some(taxi_tariff_geo_zone_code) as taxi_tariff_geo_zone_code,
        some(taxi_tariff_class_code) as taxi_tariff_class_code,

        count_if(final_delivery_status = 'completed') as delivery_successful_cnt,
        count_if(final_claim_status in ['cancelled_by_client', 'cancelled_by_performer']) as delivery_cancel_cnt,
        count_if(final_claim_status = 'cancelled_by_client') as delivery_cancel_client_cnt,
        count_if(final_claim_status = 'cancelled_by_performer') as delivery_cancel_performer_cnt,





    from $fct_delivery_raw as df
    where taxi_tariff_class_code in $LOG_TARIFFS
    group by df.dbid_uuid as dbid_uuid,
        df.executor_profile_id as executor_profile_id,
        df.park_taximeter_id as park_taximeter_id,
        df.order_id as order_id,
        df.country_name_ru as country_name_ru,
        df.city_name_ru as city_name_ru,

        String::Contains(df.order_type, 'logapi') as logapi_flg,
        String::Contains(df.order_type, 'corp') as corp_flg,
        String::Contains(df.order_type, 'taxiapi') as taxiapi_flg,
        String::Contains(df.order_type, 'app') as app_flg,

        df.utc_created_dttm as utc_created_dttm,
        String::SplitToList(df.utc_created_dttm, ' ')[0] as utc_created_dt

);

/*
$fct_delivery_agg = (
    select dbid_uuid, executor_profile_id, park_taximeter_id, --order_id,

        logapi_flg,
        corp_flg,
        taxiapi_flg,
        app_flg,
        order_type,

        utc_created_dt,
        taxi_tariff_geo_zone_code,
        taxi_tariff_class_code,


        sum(ticket_cnt) as ticket_cnt,
        count(*) as taxi_order_cnt,
        sum(claim_cnt) as claim_cnt,
        sum(delivery_cnt) as delivery_cnt,
        sum(delivery_successful_cnt) as delivery_success_cnt,
        sum(delivery_cancel_cnt) as delivery_cancel_cnt,
        sum(delivery_cancel_client_cnt) as delivery_cancel_client_cnt,
        sum(delivery_cancel_performer_cnt) as delivery_cancel_performer_cnt,


    from $fct_delivery_by_order_id
    group by dbid_uuid, executor_profile_id, park_taximeter_id,
        taxi_tariff_geo_zone_code,
        taxi_tariff_class_code,
        final_claim_status,

        logapi_flg,
        corp_flg,
        taxiapi_flg,
        app_flg,

        utc_created_dt,
        order_type
);
*/

$fct_order_candidate_raw = (
    select
            foc.order_id as order_id, foc.executor_profile_id as executor_profile_id,
            foc.park_taximeter_id as park_taximeter_id,
            foc.park_taximeter_id || '_' || foc.executor_profile_id as dbid_uuid,
            taxi_tariff_class_code,
            utc_offered_dttm, utc_seen_dttm, utc_assigned_dttm,
            utc_offered_dttm is not null as offer_flg,
            utc_assigned_dttm is not null as assigned_flg,
            fo.dbid_uuid == foc.park_taximeter_id || '_' || foc.executor_profile_id  and fo.order_id == foc.order_id as taxi_order_flg,


            --order info
            String::SplitToList(utc_offered_dttm, ' ')[0] as utc_date,

            final_claim_status,

            logapi_flg,
            corp_flg,
            taxiapi_flg,
            app_flg,

            utc_created_dttm,
            utc_created_dt,

            ticket_cnt,
            corp_order_flg,
            order_type,

            claim_cnt,
            delivery_cnt,
            taxi_tariff_geo_zone_code,

            delivery_successful_cnt,
            delivery_cancel_cnt,
            delivery_cancel_client_cnt,
            delivery_cancel_performer_cnt,

            -- exec data
            case when String::Contains(courier_type, 'cargo') then 'cargo' else courier_type end as courier_type,

            transport_type,
            taximeter_platform,
            taximeter_version_code,
            String::SplitToList(taximeter_version_code, ' ')[0]  as taximeter_version,
            case when CAST(String::SplitToList(taximeter_version_code, '.')[0] as Int64) >= 11 then 'taximeter.x'
                else 'taximeter' end as application_id,
            unique_driver_id,

            --geo
            geo.tariff_zone as tariff_zone,
            tz_country_name_ru as country,
            geo.agglomeration as agglomeration,
            geo.population_group as population_group


    from RANGE($FCT_ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as foc
    left join $fct_delivery_by_order_id as fo
    on fo.order_id == foc.order_id
    left join $couriers_app_and_sh_data as app
    on app.dbid_uuid == foc.park_taximeter_id || '_' || foc.executor_profile_id
         and app.utc_date == String::SplitToList(foc.utc_offered_dttm, ' ')[0]
    left join $geo as geo
    on geo.tariff_zone == fo.taxi_tariff_geo_zone_code
    where  1==1
        and fo.taxi_tariff_class_code in $LOG_TARIFFS
);



/*
$final_sh_and_ar = (
    select utc_date,
    tariff_zone,
    country, agglomeration, population_group,
    courier_type, transport_type,
    taximeter_platform,
    taximeter_version_code,
    taximeter_version,
    application_id,

    --dbid_uuid, current_unique_driver_id,
    count(sh.dbid_uuid) as executor_cnt,
    sum(delivery_sh) as sh_delivery,


    from $couriers_app_and_sh_data as sh
    left join $fct_delivery_agg as fd
    on fd.dbid_uuid == sh.dbid_uuid
        and fd.utc_created_dt == sh.utc_date
    group by sh.utc_date as utc_date,
    sh.tariff_zone as tariff_zone,
    sh.country as country,
    sh.agglomeration as agglomeration,
    sh.population_group as population_group,
    sh.courier_type as courier_type,
    sh.transport_type as transport_type,
    sh.taximeter_platform as taximeter_platform,
    sh.taximeter_version_code as taximeter_version_code,
    sh.taximeter_version as taximeter_version,
    sh.application_id as application_id

);
*/

$final_orders = (
select utc_date,
    tariff_zone,
    country, agglomeration, population_group,
    courier_type,

    --case when String::Contains(courier_type, 'cargo') then 'cargo'
    --    else courier_type end as courier_type,
    transport_type,
    taximeter_platform,
    taximeter_version_code,
    taximeter_version,
    application_id,

    count(*) as offers_cnt,
    count_if(assigned_flg) as assigned_cnt,

    --dbid_uuid, executor_profile_id, park_taximeter_id, --order_id,


    logapi_flg,
    corp_flg,
    taxiapi_flg,
    app_flg,

    utc_created_dt,

    order_type,


    --fd

    sum(ticket_cnt) as ticket_cnt,
    count_if(taxi_order_flg) as taxi_order_cnt,
    sum(claim_cnt) as claim_cnt,
    sum(delivery_cnt) as delivery_cnt,
    sum(delivery_successful_cnt) as delivery_success_cnt,

    sum(delivery_cancel_cnt) as cancel_cnt,
    sum(delivery_cancel_client_cnt) as cancel_client_cnt,
    sum(delivery_cancel_performer_cnt) as cancel_performer_cnt,

    --sh and execs
    case when order_type = 'corp_logapi' then some(delivery_sh) else 0 end as delivery_sh,
    case when order_type = 'corp_logapi' then some(executor_cnt) else 0 end as executor_cnt,
    case when order_type = 'corp_logapi' then some(executor_unique_cnt) else 0 end as executor_unique_cnt,


    from $fct_order_candidate_raw as sh
    left join $couriers_sh_data_agg as c
    on c.utc_date=sh.utc_date and
        c.tariff_zone=sh.tariff_zone and c.courier_type=sh.courier_type
        and c.transport_type = sh.transport_type
        and c.taximeter_platform == sh.taximeter_platform
        and c.taximeter_version_code == sh.taximeter_version_code
        and c.application_id == sh.application_id

    group by sh.utc_date as utc_date,
    sh.tariff_zone as tariff_zone,
    sh.country as country,
    sh.agglomeration as agglomeration,
    sh.population_group as population_group,
    sh.courier_type as courier_type,
    sh.transport_type as transport_type,
    sh.taximeter_platform as taximeter_platform,
    sh.taximeter_version_code as taximeter_version_code,
    sh.taximeter_version as taximeter_version,
    sh.application_id as application_id,

    sh.logapi_flg as logapi_flg,
    sh.corp_flg as corp_flg,
    sh.taxiapi_flg as taxiapi_flg,
    sh.app_flg as app_flg,

    sh.utc_created_dt as utc_created_dt,

    sh.order_type as order_type

);



insert into `//home/taxi-delivery/analytics/production/product/pro/release_dash/logdata_2032_dash_src_orders` with truncate
select * from $final_orders
where utc_date between $START_DT_STR and $END_DT_STR
union all
select *
from `//home/taxi-delivery/analytics/production/product/pro/release_dash/logdata_2032_dash_src_orders`
;

