use hahn;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;
PRAGMA SimpleColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;


--datasources
$TAG_LIST_HIST = '//home/taxi-dwh/cdm/executor/dim_executor_profile_tag_list_hist';
$FCT_STATE_HIST = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$FCT_DELIVERY = '//home/delivery-dwh/cdm/delivery/fct_delivery';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$DIM_PARK_HIST = '//home/taxi-dwh/cdm/supply/dim_park_hist/dim_park_hist';
$PARKS = '//home/taxi/production/replica/mongo/struct/parks_private/parks';
$CONTRACTS = '//home/taxi-delivery/parks/contracts';
$ORDER_CANDIDATE = '//home/taxi-dwh/ods/dbprocessing/order_candidate';
$FCT_ORDER_CANDIDATE = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$APPMETRICA_FACETS = '//home/taxi-analytics/denchashch/driver_metrics_dashboard/appmetrica_facets';
$CARS_TABLE = '//home/taxi-dwh/raw/taximeter/cars/cars';
$PDA_CARS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_cars';
$PDA_DRIVERS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_drivers';
$CLAIM = '//home/delivery-dwh/ods/cargo_claims/claim';
$CLAIMS_REPLICA = '//home/taxi/production/replica/postgres/cargo_claims/claims';
$CLAIM_POINT = '//home/delivery-dwh/ods/cargo_claims/claim_point';
$RAW_TAXI_PERFORMER_INFO = '//home/taxi/production/replica/postgres/cargo_claims/raw/taxi_performer_info';
$TAXI_PERFORMER_INFO = '//home/delivery-dwh/ods/cargo_claims/taxi_performer_info';
$CLAIM_SEGMENT = '//home/delivery-dwh/ods/cargo_claims/claim_segment';
$MDB_ORDER = '//home/taxi-dwh/ods/mdb/order';

$COURIER_TYPE_TABLE = '//home/taxi-delivery/analytics/production/product/supply_overview';


$SAVE_TO_DATA = '//home/taxi-delivery/analytics/production/product/ops_metrics/abt_demand_metrics';
$SAVE_TO_DASH = '//home/taxi-delivery/analytics/production/product/ops_metrics/ops_demand_dash_datasource';


--Парсинг и форматы времени
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$date_dots_parse = DateTime::Parse("%d.%m.%Y");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_month_short_format = Datetime::Format('%Y-%m');
$date_year_format = Datetime::Format('%Y-01-01');


-- Константы для времени
--$START_DTTM = Datetime::MakeDatetime($datetime_parse('2021-12-01 00:00:00'));
$START_DTTM = CurrentUtcDatetime()- Interval('P15D');
$END_DTTM = CurrentUtcDatetime()- Interval('P1D');

$START_DTTM_STR = $datetime_format($START_DTTM);
$START_DT_STR = $date_format($START_DTTM);
$START_MONTH_STR = $date_month_format($START_DTTM);
$START_MONTH_SHORT_STR = $date_month_short_format($START_DTTM);
$START_YEAR_STR = $date_year_format($START_DTTM);

$END_DTTM_STR = $datetime_format($END_DTTM);
$END_DT_STR = $date_format($END_DTTM);
$END_MONTH_STR = $date_month_format($END_DTTM);
$END_MONTH_SHORT_STR = $date_month_short_format($END_DTTM);
$END_YEAR_STR = $date_year_format($END_DTTM);





$get_special_requirements = ($x) -> (
    ListMap(
         Yson::ConvertToList($x.special_requirements),
        ($y) -> (Yson::ConvertToString($y.id))
    )
);

$parse_special = ($special_requirements) -> (
    ListUniq(
        ListFlatten(
            ListMap(
                Yson::ConvertToList(
                    Yson::ParseJson(
                        Yson::ConvertToString(
                            $special_requirements)
                    ).virtual_tariffs
                ),
                $get_special_requirements
            )
        )
    )
 );

$diff_seconds_dttm = (($end_dttm, $start_dttm) -> {
    $start = DateTime::MakeDatetime($datetime_parse($start_dttm));
    $end = DateTime::MakeDatetime($datetime_parse($end_dttm));
    RETURN 1.0*Datetime::ToSeconds($end - $start);
    --RETURN Datetime::Format('%H:%M:%S')$end - $start;
});


$LOG_TARIFFS = AsList('express', 'courier', 'cargo', 'cargocorp', 'ubernight');

$INTERNAL_CORPS = [--eda rest
                '4decd14f25424e8b82b6d3e4f56d23b2',
                '87cda4c03d60416bb522e83fe24b3d50',
                '162b9899216246f7a1ba9fc14a479e87',
                '3fbec49a491248328a0d9ab1c8ba7891',
            --eda retail
                'b2dc2b2e96f8482ba2d1582bd1445184',
                '370be78f439446a1b833a8fcc1234133',
            --lavka
                'dc28c565829e48cca458b5feb161d5d6', -- есть
                '4ee0ceca18ce41e3895786796a967e78', -- есть
                'bfd05979e380486d9181b62fa05d1fc9', -- есть, но не актуальный
                '8183ed5340e14ea1ab061b0df7f0cd32', -- вывоз продуктов
                'c2bc0b6f9c364ba7a198166de216ae95', -- К2
                '10e0550610254cdab46c28cda5efff15'  -- грузовой
            ];


$geo =
(
    select tariff_zone, some(population_group) as population_group,
    some(tz_country_name_ru) as tz_country_name_ru,
    some(name_ru) as agglomeration
    from $GEO
    where root_node_id = 'br_root'
        and node_type = 'agglomeration'
    group by tariff_zone
);

--$tariff_initial = ()
$executor_type_per_day = (
    select distinct dbid_uuid,
        utc_date,
        courier_type,

        case
            when String::Contains(courier_type , 'cargo')
                then 'cargo_courier'
            when String::Contains(courier_type, 'bike') or String::Contains(courier_type , 'scooter') or String::Contains(courier_type , 'walking')
                then 'not_auto_courier'
        else
                courier_type
        end as courier_type_general,


    from RANGE($COURIER_TYPE_TABLE, $START_MONTH_STR, $END_MONTH_STR) as today


);


$time_metric = (
    select claim_id, --claim_point_id,
       max(bf_06_performer_found_ts - bf_04_performer_lookup_ts) as time_performer_found_sec,
       max(bf_07_pickup_arrived_ts - bf_06_performer_found_ts) as time_to_a_sec,
       max(bf_08_ready_for_pickup_confirmation_ts - bf_07_pickup_arrived_ts) as time_at_a_sec,
       max(bf_10_delivery_arrived_ts - bf_08_ready_for_pickup_confirmation_ts) as time_a_to_b_sec,
       max(coalesce(bf_12_delivered_ts, claim_point_terminal_ts, terminal_status_ts) - bf_10_delivery_arrived_ts) as time_at_b_sec,
       max(coalesce(claim_point_terminal_ts, terminal_status_ts)-bf_04_performer_lookup_ts)  as time_total_sec,

    from `//home/taxi-delivery/analytics/dev/drmks/claim_status_ts` as ct
    left join `//home/taxi-delivery/analytics/dev/drmks/claim_point_status_ts`  as ctp
    on ctp.claim_id == ct.claim_id
    group by ct.claim_id as claim_id--, ctp.claim_point_id as claim_point_id
);

$claim_spec_data = (
    select
        claim_id,
        some(taxi_order_id) as taxi_order_id,
        max(ListHas($parse_special(special_requirement_text), 'cargo_postpayment_link')
            or ListHas($parse_special(special_requirement_text), 'cargo_postpayment_card')) as sq_postpayment,
        max(ListHas($parse_special(special_requirement_text),'cargo_multipoints')) as sq_multipoints,
        max(ListHas($parse_special(special_requirement_text),'max_point_weight_requirement')) as sq_max_point_weight_requirement,
        max(ListHas($parse_special(special_requirement_text),'thermobag_confirmed')) as sq_thermobag_confirmed,
        max(ListHas($parse_special(special_requirement_text),'thermopack_confirmed')) as sq_thermopack_confirmed,
        max(ListHas($parse_special(special_requirement_text),'allowed_pro_courier')) as sq_profi_courier,
        --some(segment_status) as claim_status,
    from RANGE($CLAIM_SEGMENT, $START_MONTH_STR, $END_MONTH_STR) as c
    group by claim_id
);

/*
$executor_claims_data = (
    select claim_id,
        some(park_id) as park_taximeter_id,
        some(driver_id) as executor_profile_id,
        some(tariff_class) as tariff_class,
    from (select Yson::LookupInt64(doc, "claim_id") as claim_id,
        Yson::LookupString(doc, "park_id") as park_id,
        Yson::LookupString(doc, "driver_id") as driver_id,
        Yson::LookupString(doc, "tariff_class") as tariff_class,
        from $RAW_TAXI_PERFORMER_INFO)
    group by claim_id
);*/

$executor_claims_data = (
    select claim_id,
        some(park_taximeter_id || '_' || executor_profile_id) as dbid_uuid,
        some(park_taximeter_id) as park_taximeter_id,
        some(executor_profile_id) as executor_profile_id,
        some(tariff_class_code) as tariff_class_code,
    from RANGE($TAXI_PERFORMER_INFO, $START_MONTH_STR,  $END_MONTH_STR)
    group by claim_id
);


$fct_order_filtered = (
    select --executor_profile_id, taximeter_park_id,
        order_id, driver_status, user_status, executor_profile_id, taximeter_park_id as park_taximeter_id, tariff_class_code, utc_order_created_dt  as utc_created_dt
    from RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR)
    where tariff_class_code in $LOG_TARIFFS
);

$mdb_order_filtered = (
    select *
    from RANGE($MDB_ORDER, $START_MONTH_STR, $END_MONTH_STR)
    where driver_tariff_class in $LOG_TARIFFS
);

$admin_cancel_data = (
    select id as claim_id, admin_cancel_reason is not null as admin_cancel_flg,
    from $CLAIMS_REPLICA
);

$claims_data = (
    select

    d.order_code is not null as order_code_flg,
    d.order_id is not null as fct_order_flg,
    d.claim_id is not null as cargo_claims_flg,
    lavka_order_id is not null or d.brand_id is not null as external_flg,
    taxi_corp_order_flg,

    1 as delivery_cnt,

    -- order
    utc_created_dttm,
    SUBSTRING(d.utc_created_dttm, 0, 10) as utc_created_dt,
    d.utc_claim_created_dttm as utc_claim_created_dttm,
    SUBSTRING(d.utc_claim_created_dttm, 0, 10) as utc_claim_created_dt,

    d.claim_id as claim_id,
    d.claim_uuid as claim_uuid,
    d.order_id as taxi_order_id,
    d.order_code as order_code,
    CAST(d.point_id as Int64) as point_id,
    --d.claim_point_id as claim_point_id,

    coalesce(d.country_name_ru, 'unknown') as country_name_ru,
    coalesce(d.city_name_ru, 'unknown') as city_name_ru,
    coalesce(d.claim_tariff_zone_code, d.taxi_tariff_geo_zone_code, 'unknown') as tariff_zone_delivery,
    coalesce(geo.population_group, 'unknown') as population_group,
    coalesce(d.corp_client_id, 'null') as corp_client_id,



    coalesce(d.status_code, 'null') as claim_status_code,
    coalesce(d.claim_dst_point_status, 'null') as visit_status,
    String::Contains(d.status_code, 'cancel')
        or String::Contains(fo.driver_status, 'cancel')
        or String::Contains(fo.user_status, 'cancel') as cancelled_flg,

    case when (String::Contains(d.status_code, 'cancel')
        or String::Contains(fo.driver_status, 'cancel')
        or String::Contains(fo.user_status, 'cancel'))
        and (d.status_code ='cancelled_by_taxi' or String::Contains(fo.driver_status, 'cancel'))
    then 'performer related cancel'
    when (String::Contains(d.status_code, 'cancel')
        or String::Contains(fo.driver_status, 'cancel')
        or String::Contains(fo.user_status, 'cancel'))
        and (d.status_code != 'cancelled_by_taxi' or String::Contains(fo.user_status, 'cancel'))
    then
        'client related cancel'
    else 'not cancelled' end as cancel_type_by_initiator,
    coalesce(admin_cancel_flg, False) as admin_cancel_flg,
    /* в будущем надо будет подробнее: отмена парком, отмена водителем, отмена саппортом, отмена клиентом;
                                    отмена до найденного исполнителя, отмена до точки А, отмена в А, отмена от А до Б...
    */

    d.status_code in ['returned_finish', 'delivered_finish'] and d.claim_dst_point_status = 'skipped' as returned_flg,

    (d.status_code in ['returned_finish', 'delivered_finish'] and d.claim_dst_point_status = 'visited')
        or taxi_success_order_flg as delivered_flg,

    -- additional
    coalesce(taxi_success_order_flg, False) as taxi_success_order_flg,
    coalesce(d.claim_dst_point_status, 'null') as claim_dst_point_status,
    coalesce(fo.driver_status, 'null') as driver_status,
    coalesce(fo.user_status, 'null') as user_status,

    coalesce(sq_postpayment, False) as sq_postpayment,
    coalesce(sq_multipoints, False) as sq_multipoints,
    coalesce(sq_max_point_weight_requirement, False) as sq_max_point_weight_requirement,
    coalesce(sq_thermobag_confirmed, False) as sq_thermobag_confirmed,
    coalesce(sq_thermopack_confirmed, False) as sq_thermopack_confirmed,
    coalesce(sq_profi_courier, False) as sq_profi_courier,


    coalesce(time_performer_found_sec, $diff_seconds_dttm(mdb.utc_assigned_dttm, mdb.utc_start_pending_dttm)) as time_performer_found_sec,
    coalesce(time_to_a_sec, $diff_seconds_dttm(utc_start_waiting_dttm, utc_assigned_dttm)) as time_to_a_sec,
    coalesce(time_at_a_sec, $diff_seconds_dttm(utc_start_transporting_dttm,utc_start_waiting_dttm,)) as time_at_a_sec,
    coalesce(time_a_to_b_sec, $diff_seconds_dttm(utc_finished_dttm, utc_start_transporting_dttm)) as time_a_to_b_sec,
    coalesce(time_at_b_sec, $diff_seconds_dttm(utc_complete_dttm,utc_finished_dttm)) as time_at_b_sec,
    coalesce(time_total_sec, $diff_seconds_dttm(utc_complete_dttm,mdb.utc_start_pending_dttm)) as time_total_sec,

    -- пытаемся придумать статусы через mdb_order
    --utc_assigned_dttm - mdb.utc_start_pending_dttm as time_taxi_performer_found_sec,
    --utc_start_waiting_dttm = utc_assigned_dttm
    --utc_start_driving_dttm - utc_start_waiting_dttm
    --utc_finished_dttm - utc_start_driving_dttm
    --utc_completed_dttm - utc_finished_dttm



    --batch ??? wait for dm_deliveriery

    coalesce(exec.park_taximeter_id, fo.park_taximeter_id) as park_taximeter_id,
    coalesce(exec.executor_profile_id, fo.executor_profile_id) as executor_profile_id,
    exec.executor_profile_id is not null or fo.executor_profile_id is not null as executor_found_flg,
    (coalesce(exec.park_taximeter_id, fo.park_taximeter_id) || '_' || coalesce(exec.executor_profile_id, fo.executor_profile_id)) as dbid_uuid,
    coalesce(exec.tariff_class_code, 'no executor') as executor_tariff_class,

    case when (coalesce(exec.park_taximeter_id, fo.park_taximeter_id) || '_' || coalesce(exec.executor_profile_id, fo.executor_profile_id)) is null then 'no executor' else coalesce(exec_type.courier_type, 'unknown') end as courier_type,
    case when (coalesce(exec.park_taximeter_id, fo.park_taximeter_id) || '_' || coalesce(exec.executor_profile_id, fo.executor_profile_id)) is null then 'no executor' else coalesce(exec_type.courier_type_general, 'unknown') end as courier_type_general,

    d.corp_client_id in $INTERNAL_CORPS as internal_corp_flg,



    FROM RANGE($FCT_DELIVERY, $START_MONTH_STR, $END_MONTH_STR) as d
    left join $executor_claims_data as exec
        on d.claim_id == exec.claim_id
    left join $claim_spec_data as sq
        on d.claim_id == sq.claim_id
    left join $fct_order_filtered as fo
        on fo.order_id == d.order_id
    left join $executor_type_per_day as exec_type
       on exec_type.dbid_uuid == fo.park_taximeter_id || '_' || fo.executor_profile_id
            and exec_type.utc_date = fo.utc_created_dt
    left join $time_metric as tm
        on tm.claim_id == d.claim_id --and tm.claim_point_id = d.claim_point_id
    left join $mdb_order_filtered as mdb
        on mdb.order_id == d.order_id
    left join $geo as geo
        on geo.tariff_zone == coalesce(d.claim_tariff_zone_code, d.taxi_tariff_geo_zone_code)
    left join $admin_cancel_data as admin
        on admin.claim_id == d.claim_id

    --left join `//home/taxi/production/replica/postgres/cargo_claims/claims` as cl
      --  on cl.id == d.claim_id
    WHERE
        --`p_on_d.flow` == 'service_usage' and
        --c.corp_client_id in $payments_logistics_clients
        --and
        SUBSTRING(d.utc_created_dttm, 0, 10) >= $START_DT_STR and SUBSTRING(d.utc_created_dttm, 0, 10) <=  $END_DT_STR
        and (d.claim_id is not null or d.order_id is not null)
        and taxi_tariff_class_code in $LOG_TARIFFS
        --and (lavka_order_id is null and d.brand_id is null) --or (exec.tariff_class in $LOG_TARIFFS))
        --and ((c.corp_client_id in $payments_logistics_clients) -- наши клиенты логистики
            --or (c.corp_client_id in $payments_eda_clients and p_on_d.id is not null
                --and (exec.tariff_class in ['courier', 'express'])) -- еда и наш исполнитель
            --or (c.uuid_id in (select claim_ref_id from $pp_eda_with_fallback) and (exec.tariff_class != 'eda' or exec.tariff_class is null)))
);

insert into $SAVE_TO_DATA with truncate
--select * from $claims_data;
-- or
select * from $claims_data
union all
(select * from $SAVE_TO_DATA
where utc_created_dt < $START_DT_STR)
;
commit;



insert into $SAVE_TO_DASH with truncate
select
    fct_order_flg,
    cargo_claims_flg,
    external_flg,
    taxi_corp_order_flg,

    utc_created_dt,
    utc_claim_created_dt,
    utc_claim_accepted_dt,

    country_name_ru,
    city_name_ru,
    population_group,
    tariff_zone_delivery,
    --corp_client_id,


    claim_status_code,
    visit_status,
    cancelled_flg,
    cancel_type_by_initiator,
    returned_flg,
    delivered_flg,
    admin_cancel_flg,

    taxi_success_order_flg,
    claim_dst_point_status,
    driver_status,
    user_status,

    sq_postpayment,
    sq_multipoints,
    sq_max_point_weight_requirement,
    sq_thermobag_confirmed,
    sq_thermopack_confirmed,
    sq_profi_courier,

    executor_found_flg,
    executor_tariff_class,
    courier_type,
    courier_type_general,

    count(1) as del_cnt,
    count(distinct claim_id) as claim_cnt,
    count(distinct taxi_order_id) as taxi_order_cnt,
    --count(claim_point_id) as claim_point_id,


    sum(time_performer_found_sec) as time_performer_found_sec_sum,
    count(time_performer_found_sec) as time_performer_found_sec_cnt,
    sum(time_to_a_sec) as time_to_a_sec_sum,
    count(time_to_a_sec) as time_to_a_sec_cnt,
    sum(time_at_a_sec) as time_at_a_sec_sum,
    count(time_at_a_sec) as time_at_a_sec_cnt,
    sum(time_a_to_b_sec) as time_a_to_b_sec_sum,
    count(time_a_to_b_sec) as time_a_to_b_sec_cnt,
    sum(time_at_b_sec) as time_at_b_sec_sum,
    count(time_at_b_sec) as time_at_b_sec_cnt,
    sum(time_total_sec) as time_total_sec_sum,
    count(time_total_sec) as time_total_sec_cnt,

    count(distinct dbid_uuid) as executor_cnt,


    --batch ??? wait for dm_deliveriery
from $SAVE_TO_DATA
group by fct_order_flg,
    cargo_claims_flg,
    external_flg,
    taxi_corp_order_flg,

    utc_claim_created_dt,
    utc_claim_accepted_dt,
    utc_created_dt,

    country_name_ru,
    city_name_ru,
    population_group,
    tariff_zone_delivery,
    --corp_client_id,


    claim_status_code,
    visit_status,
    cancelled_flg,
    cancel_type_by_initiator,
    returned_flg,
    delivered_flg,
    admin_cancel_flg,

    taxi_success_order_flg,
    claim_dst_point_status,
    driver_status,
    user_status,

    sq_postpayment,
    sq_multipoints,
    sq_max_point_weight_requirement,
    sq_thermobag_confirmed,
    sq_thermopack_confirmed,
    sq_profi_courier,

    executor_found_flg,
    executor_tariff_class,
    courier_type,
    courier_type_general
;
