use hahn;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;
PRAGMA SimpleColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;


--ОПС-метрики

---- Метрики курьеров
------ Саплай часы
------ Тип курьера
------ Среднее время смены
------ Спец требования
------ Добавить доп поле с последней доставкой до текущей даты (?)


--datasources
$TAG_LIST_HIST = '//home/taxi-dwh/cdm/executor/dim_executor_profile_tag_list_hist';
$FCT_STATE_HIST = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$DIM_PARK_HIST = '//home/taxi-dwh/cdm/supply/dim_park_hist/dim_park_hist';
$PARKS = '//home/taxi/production/replica/mongo/struct/parks_private/parks';
$CONTRACTS = '//home/taxi-delivery/parks/contracts';
$ORDER_CANDIDATE = '//home/taxi-dwh/ods/dbprocessing/order_candidate';
$FCT_ORDER_CANDIDATE = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$APPMETRICA_FACETS = '//home/taxi-analytics/denchashch/driver_metrics_dashboard/appmetrica_facets';
$CARS_TABLE = '//home/taxi-dwh/raw/taximeter/cars/cars';
$PDA_CARS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_cars';
$PDA_DRIVERS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_drivers';
$CLAIM = '//home/delivery-dwh/ods/cargo_claims/claim';
$SUPPORT_TICKETS = '//home/taxi-analytics/hickinbottom/support/dwh/summary/support_tickets';

$COURIER_SEGMENTATION = '//home/taxi-delivery/analytics/dev/product/courier_data_with_segmentation/courier_segmentation_fortagging'; --витрина Арсения
$COURIER_TYPE_TABLE = '//home/taxi-delivery/analytics/production/product/supply_overview'; --витрина Макара


$SAVE_DATA_TO = '//home/taxi-delivery/analytics/production/product/ops_metrics/abt_executor_metrics';
$SAVE_DASH_DAY_TO = '//home/taxi-delivery/analytics/production/product/ops_metrics/ops_supply_dash_datasource_day';
$SAVE_DASH_WEEK_TO = '//home/taxi-delivery/analytics/production/product/ops_metrics/ops_supply_dash_datasource_week';
$SAVE_DASH_MONTH_TO = '//home/taxi-delivery/analytics/production/product/ops_metrics/ops_supply_dash_datasource_month';
$SAVE_METRIC_LIST_TO = '//home/taxi-delivery/analytics/production/product/ops_metrics/ops_supply_dash_datametrics';


--Парсинг и форматы времени
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$date_parse = DateTime::Parse("%Y-%m-%d");
$date_dots_parse = DateTime::Parse("%d.%m.%Y");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_month_short_format = Datetime::Format('%Y-%m');
$date_year_format = Datetime::Format('%Y-01-01');


-- Константы для времени
--$START_DTTM = Datetime::MakeDatetime($datetime_parse('2020-01-01 00:00:00'));
$START_DTTM = CurrentUtcDatetime()- Interval('P45D');
$END_DTTM = CurrentUtcDatetime()- Interval('P1D');

$START_DTTM_STR = $datetime_format($START_DTTM);
$START_DT_STR = $date_format($START_DTTM);
$START_MONTH_STR = $date_month_format($START_DTTM);
$START_MONTH_SHORT_STR = $date_month_short_format($START_DTTM);
$START_YEAR_STR = $date_year_format($START_DTTM);

$END_DTTM_STR = $datetime_format($END_DTTM);
$END_DT_STR = $date_format($END_DTTM);
$END_MONTH_STR = $date_month_format($END_DTTM);
$END_MONTH_SHORT_STR = $date_month_short_format($END_DTTM);
$END_YEAR_STR = $date_year_format($END_DTTM);

$to_int64  = ($data) -> {
    return Yson::ConvertToInt64($data)
};
$LOG_TARIFFS = AsList('express', 'courier', 'cargo', 'cargocorp', 'night', 'ubernight');

$courier_segmentation_data = (
    select cs.unique_driver_id as unique_driver_id, current_dt as dt,
        courier_segmentation_label,
        weekly_courier_segmentation_label, monthly_courier_segmentation_label,

        $date_format(Datetime::StartOfMonth($date_parse(current_dt))) as month_dt,
        $date_format(Datetime::StartOfWeek($date_parse(current_dt))) as week_dt
        --is_newbie,
        --is_exclusive,
        --is_experienced,
        --is_fulltimer,
        --is_core
    from $COURIER_SEGMENTATION as cs
    left join (select unique_driver_id, week_dt, TryMember(mode(courier_segmentation_label)[0], "Value", null) as weekly_courier_segmentation_label
                from $COURIER_SEGMENTATION
                group by unique_driver_id, $date_format(Datetime::StartOfWeek($date_parse(current_dt))) as week_dt) as csw
    on csw.unique_driver_id == cs.unique_driver_id and  $date_format(Datetime::StartOfWeek($date_parse(cs.current_dt))) == csw.week_dt
    left join (select unique_driver_id, month_dt, TryMember(mode(courier_segmentation_label)[0], "Value", null) as monthly_courier_segmentation_label
                FROM $COURIER_SEGMENTATION
                group by unique_driver_id, $date_format(Datetime::StartOfMonth($date_parse(current_dt))) as month_dt) as csm
    on csm.unique_driver_id == cs.unique_driver_id and  $date_format(Datetime::StartOfMonth($date_parse(cs.current_dt))) == csm.month_dt
);

$courier_type_by_makar = (
    select distinct dbid_uuid,
        utc_date,
        courier_type,
        weekly_courier_type,
       monthly_courier_type,

    from RANGE($COURIER_TYPE_TABLE, $START_MONTH_STR, $END_MONTH_STR) as today

);

$geo =
(
    select tariff_zone, some(population_group) as population_group,
    some(tz_country_name_ru) as tz_country_name_ru,
    some(name_ru) as agglomeration
    from $GEO
    where root_node_id = 'br_root'
        and node_type = 'agglomeration'
    group by tariff_zone
);


$dates = (
    select DISTINCT utc_order_created_dt as utc_dt
    from RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as fo
    where utc_order_created_dt between $START_DT_STR and $END_DT_STR
);


$exec_exp_data = (
    select executor_profile_id, utc_order_created_dt,
        ROW_NUMBER() OVER w as order_cum_sum,
        DENSE_RANK() OVER w as day_num,
    from RANGE($FCT_ORDER, '2019-01-01') as fo
    where tariff_class_code in $LOG_TARIFFS and success_order_flg
    WINDOW w AS (PARTITION BY executor_profile_id ORDER BY utc_order_created_dt)
);



$fct_order_filtered = (
    select --executor_profile_id, taximeter_park_id,
        order_id, driver_status, user_status, executor_profile_id, taximeter_park_id as park_taximeter_id, tariff_class_code, utc_order_created_dt  as utc_created_dt, unique_driver_id
    from RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR)
    where tariff_class_code in $LOG_TARIFFS
);

$tags_data = (
    select
    sh.executor_status_code as executor_status_code,
    sh.executor_profile_id as executor_profile_id,
    sh.park_taximeter_id as park_taximeter_id,
    sh.profile_status_rank as profile_status_rank,
    sh.old_unique_driver_id as unique_driver_id,
    tlh.tag_code_list as tag_code_list,
    sh.enabled_tariff_class_code_list as enabled_tariff_class_code_list,
    case when sh.utc_valid_from_dttm < tlh.utc_valid_from_dttm
        then tlh.utc_valid_from_dttm
    else sh.utc_valid_from_dttm end as utc_valid_from_dttm,
    case when sh.utc_valid_to_dttm > tlh.utc_valid_to_dttm
        then tlh.utc_valid_to_dttm
    else sh.utc_valid_to_dttm end as utc_valid_to_dttm,
    --unique_driver_id,

    FROM RANGE($FCT_STATE_HIST, $START_DT_STR, $END_DT_STR) as sh
    LEFT JOIN RANGE($TAG_LIST_HIST, $START_MONTH_SHORT_STR) as tlh
    ON sh.executor_profile_sk=tlh.executor_profile_sk
    WHERE sh.utc_valid_from_dttm<tlh.utc_valid_to_dttm
    AND tlh.utc_valid_from_dttm<sh.utc_valid_to_dttm
);


$tags_daily_data = (
    select
    dbid_uuid,
    utc_date,
    unique_driver_id,

    --unique_driver_id,

    max(ListHas(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?), 'cargo') or ListHas(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?), 'cargocorp')) as cargo_courier,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'taxi_courier')) as taxi_courier,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'auto_courier')) as auto_courier,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'scooter_courier')) as scooter_courier,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'bike_courier')) as bike_courier,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'walking_courier') and not ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'scooter_courier') and not ListHas(Yson::ConvertTo(tag_code_list, List<String?>?),  'bike_courier')) as walking_courier,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'thermobag_confirmed')) as thermobag_confirmed,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'thermopack_confirmed')) as thermopack_confirmed,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'allow_heavy_delivery')) as allow_heavy_delivery,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'allow_profi_courier')) as allow_profi_courier,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'profi_courier')) as profi_courier,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'logistic_workshift_subscribed')) as logistic_workshift_subscribed,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'post_payment')) as post_payment,
    max(ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'cargo_postpayment_diagnostics_allow_card')) as cargo_postpayment_diagnostics_allow_card,



    from $tags_data as a
    where 1=1
    --and profile_status_rank == 1
    --and not SetIsDisjoint(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS))
    --and executor_status_code in ('driving', 'waiting', 'transporting', 'free')
    and utc_date between $START_DT_STR and $END_DT_STR
group by a.park_taximeter_id || '_' || a.executor_profile_id as dbid_uuid,
String::SplitToList(utc_valid_from_dttm,' ')[0] as utc_date,
unique_driver_id
);


-- sh
-- приводим данные в красивый вид чтобы потом легко считать sh по тарифам и определять тип курьера

$sh_data = (
    SELECT
    a.park_taximeter_id || '_' || a.executor_profile_id as dbid_uuid,
    a.park_taximeter_id as park_taximeter_id,
    a.executor_profile_id as executor_profile_id,

    TableName() as utc_date,
    tariff_geo_zone_code,
    executor_status_code,
    utc_valid_from_dttm,
    utc_valid_to_dttm,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'express') as tariff_express_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'courier') as tariff_courier_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'cargo') as tariff_cargo_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'cargocorp') as tariff_cargocorp_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'night') as tariff_night_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'ubernight') as tariff_ubernight_on,

    not SetIsDisjoint(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS)) as tariff_any_delivery_on,
    ListHasItems(SetDifference(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS))) as tariff_any_not_delivery_on,

    duration_sec,

    from RANGE($FCT_STATE_HIST, $START_DT_STR, $END_DT_STR) as a
    where a.profile_status_rank == 1
    --and a.executor_status_code in ('driving', 'waiting', 'transporting', 'free')
    and not SetIsDisjoint(ToSet(Yson::ConvertTo(a.enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS))
    and (a.executor_status_code = 'free'
            or (a.order_id in (select order_id from $fct_order_filtered)
                and a.executor_status_code in ('driving', 'waiting', 'transporting')))
);

$sh_geo_by_executor_and_day = (
    select dbid_uuid, utc_date, coalesce(MAX_BY(tariff_geo_zone_code, duration_sec), TryMember(mode(tariff_geo_zone_code)[0], "Value", null), some(tariff_geo_zone_code)) as tariff_geo_zone_code,
    coalesce(MAX_BY(agglomeration, duration_sec), TryMember(mode(agglomeration)[0], "Value", null), some(agglomeration)) as agglomeration,
    coalesce(MAX_BY(tz_country_name_ru, duration_sec), TryMember(mode(tz_country_name_ru)[0], "Value", null), some(tz_country_name_ru)) as tz_country_name_ru,
    coalesce(MAX_BY(population_group, duration_sec), TryMember(mode(population_group)[0], "Value", null), some(population_group)) as population_group,
    from (select dbid_uuid,
        utc_date,
        tariff_geo_zone_code,
        sum(duration_sec) as duration_sec,
        from $sh_data
        group by dbid_uuid,
        utc_date,
        coalesce(tariff_geo_zone_code, 'null') as tariff_geo_zone_code) as tz
    left join $geo as geo
    on geo.tariff_zone == tz.tariff_geo_zone_code
    group by tz.dbid_uuid as dbid_uuid, tz.utc_date as utc_date
);


$sh_and_tariff_by_executor_and_day = (
    select dbid_uuid, utc_date,
    --tariff_geo_zone_code,

    --sh
    sum(duration_sec)/(60*60.0) as sh,
    sum_if(duration_sec, tariff_any_delivery_on and not tariff_any_not_delivery_on)/(60*60.0) as sh_delivery_only,
    sum_if(duration_sec, tariff_any_delivery_on and not tariff_any_not_delivery_on) >= 0.8*sum(duration_sec) as executor_delivery_flg,
    if(sum(duration_sec)>0,1.0*sum_if(duration_sec, tariff_any_delivery_on and not tariff_any_not_delivery_on)/sum(duration_sec), null) as sh_delivery_only_frac,

    -- sh per status
    sum_if(duration_sec,executor_status_code='free')/(60*60.0) as sh_free,
    sum_if(duration_sec, tariff_any_delivery_on and not tariff_any_not_delivery_on and executor_status_code='free')/(60*60.0) as sh_free_delivery_only,

    sum_if(duration_sec,executor_status_code='waiting')/(60*60.0) as sh_waiting,
    sum_if(duration_sec, tariff_any_delivery_on and not tariff_any_not_delivery_on and executor_status_code='waiting')/(60*60.0) as sh_waiting_delivery_only,

    sum_if(duration_sec,executor_status_code='driving')/(60*60.0) as sh_driving,
    sum_if(duration_sec, tariff_any_delivery_on and not tariff_any_not_delivery_on and executor_status_code='driving')/(60*60.0) as sh_driving_delivery_only,

    sum_if(duration_sec,executor_status_code='transporting')/(60*60.0) as sh_transporting,
    sum_if(duration_sec, tariff_any_delivery_on and not tariff_any_not_delivery_on and executor_status_code='transporting')/(60*60.0) as sh_transporting_delivery_only,

    --sh per tariff
    sum_if(duration_sec, tariff_express_on)/(60*60.0) as sh_express,
    sum_if(duration_sec,tariff_courier_on)/(60*60.0) as sh_courier,
    sum_if(duration_sec,tariff_cargo_on)/(60*60.0) as sh_cargo,
    sum_if(duration_sec,tariff_cargocorp_on)/(60*60.0) as sh_cargocorp,
    sum_if(duration_sec,tariff_night_on)/(60*60.0) as sh_night,
    sum_if(duration_sec,tariff_ubernight_on)/(60*60.0) as sh_ubernight,


    max(tariff_express_on) as tariff_express_on,
    max(tariff_night_on) as tariff_night_on,
    max(tariff_ubernight_on) as tariff_ubernight_on,
    max(tariff_cargo_on) as tariff_cargo_on,
    max(tariff_cargocorp_on) as tariff_cargocorp_on,
    max(tariff_courier_on) as tariff_courier_on,
    max(tariff_any_not_delivery_on) as tariff_any_not_delivery_on,
    max(tariff_any_delivery_on) as tariff_any_delivery_on,



    from $sh_data
    group by dbid_uuid, utc_date
    --, tariff_geo_zone_code
);


-- тип парка
$park_data = (
select taximeter_park_id, max_by(city, utc_valid_from_dttm) as park_city, max_by(executor_employment_type, utc_valid_from_dttm) as executor_employment_type
from $DIM_PARK_HIST
group by taximeter_park_id
);


-- данные по успешности заказов из fct_order по курьерам + данные по тикетам на заказ

$support_data = (
    SELECT
    order_id,

    count(distinct st.ticket_id) as ticket_cnt,
    --unique_driver_id, db_id
    FROM
        $SUPPORT_TICKETS as st --инфо о тикетах
    GROUP BY  order_id
);


$claim_data = (
    select some(status_code) as claim_status, order_id
    from RANGE($CLAIM, $START_MONTH_STR, $END_MONTH_STR) as c
    group by taxi_order_id as order_id
);

$fct_order_data = (
    select dbid_uuid,
        utc_date,

        count(fo.order_id) as order_cnt,
        count_if(success_order_flg)  as success_order_cnt,
        count_if(user_status = 'cancelled' or driver_status = 'cancelled') as cancelled_flg,
        count_if(user_status = 'cancelled') as cancelled_user_flg,
        count_if(driver_status = 'cancelled') as cancelled_driver_flg,
        sum(ticket_cnt) as ticket_cnt,

        count_if(claim_status in ['returned_finish']) as claim_returned_cnt,
        count_if(claim_status in ['delivered_finish']) as claim_delivered_cnt,

    from RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as fo
    left join $support_data as sup
    on sup.order_id == fo.order_id
    left join $claim_data as cl
    on cl.order_id == fo.order_id
    where fo.tariff_class_code in $LOG_TARIFFS and utc_order_created_dt between $START_DT_STR and $END_DT_STR
    group by fo.taximeter_park_id || '_' || fo.executor_profile_id as dbid_uuid,
        fo.utc_order_created_dt as utc_date
);


-- данные по принятию заказов из fcr_order_candidate

$ar_data = (
select dbid_uuid,
        utc_candidate_created_dt as utc_date,


        count(foc.utc_offered_dttm) as offered_cnt,
        count(foc.utc_seen_dttm) as seen_cnt,
        count(foc.utc_assigned_dttm) as assigned_cnt,


    from RANGE($FCT_ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as foc
    left join RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as fo
    on foc.order_id == fo.order_id
    where tariff_class_code in $LOG_TARIFFS and utc_candidate_created_dt between $START_DT_STR and $END_DT_STR
    group by foc.park_taximeter_id || '_' || foc.executor_profile_id as dbid_uuid,
        substring(foc.utc_candidate_created_dttm, 0, 10) as utc_candidate_created_dt
);

$app_data_daily_for_executor = (
    select executor_profile_id, dt, some(app_platform) as app_platform, some(app_version_name) as app_version_name
    from $APPMETRICA_FACETS
    group by executor_profile_id, dt
);



-- vans type

$cars_loaders_amount = (
    select park_id, car_id
    ,
        max(cargo_loaders_amount) as cargo_loaders_amount
    from $PDA_CARS as pc
    group by park_id, car_id
);

$cars_size_data  =(
SELECT distinct
    park_id, car_id
    , max(Yson::ConvertToInt64(doc.carrying_capacity)) as cc
    , max(Yson::ConvertToInt64(doc.cargo_hold_dimensions.height)) as h
    , max(Yson::ConvertToInt64(doc.cargo_hold_dimensions.length)) as l
    , max(Yson::ConvertToInt64(doc.cargo_hold_dimensions.width)) as w
    , max(cargo_loaders_amount) as cargo_loaders_amount
FROM $CARS_TABLE as ct
LEFT JOIN $cars_loaders_amount as cl
on Yson::ConvertToString(ct.doc.park_id) == cl.park_id and cl.car_id == Yson::ConvertToString(ct.doc.car_id)
WHERE Yson::ConvertToBool(doc.category.cargo) = true
group by Yson::ConvertToString(doc.park_id) as park_id, Yson::ConvertToString(doc.car_id) as car_id
);




$executor_type_and_sh_and_tags = (
    select sh_geo.*,

    tag.unique_driver_id as unique_driver_id,

    courier_segmentation_label,
    weekly_courier_segmentation_label,
    monthly_courier_segmentation_label,

    coalesce(cargo_courier, False) as cargo_courier,
    coalesce(taxi_courier, False) as taxi_courier,
    coalesce(auto_courier, False) as auto_courier,
    coalesce(scooter_courier, False) as scooter_courier,
    coalesce(bike_courier, False) as bike_courier,
    coalesce(walking_courier, False) as walking_courier,

    coalesce(thermobag_confirmed, False) as thermobag_confirmed,
    coalesce(thermopack_confirmed, False) as thermopack_confirmed,
    coalesce(allow_heavy_delivery, False) as allow_heavy_delivery,
    coalesce(allow_profi_courier, False) as allow_profi_courier,
    coalesce(profi_courier, False) as profi_courier,
    coalesce(logistic_workshift_subscribed, False) as logistic_workshift_subscribed,
    coalesce(post_payment, False) as post_payment,
    coalesce(cargo_postpayment_diagnostics_allow_card, False) as cargo_postpayment_diagnostics_allow_card,


    coalesce(st.sh, 0) as sh,
    coalesce(sh_delivery_only, 0) as sh_delivery_only,
    coalesce(executor_delivery_flg, False) as executor_delivery_flg,
    coalesce(sh_delivery_only_frac, 0) as sh_delivery_only_frac,

    coalesce(sh_free, 0) as sh_free,
    coalesce(sh_free_delivery_only, 0) as sh_free_delivery_only,
    coalesce(sh_waiting, 0) as sh_waiting,
    coalesce(sh_waiting_delivery_only, 0) as sh_waiting_delivery_only,

    coalesce(sh_driving, 0) as sh_driving,
    coalesce(sh_driving_delivery_only, 0) as sh_driving_delivery_only,

    coalesce(sh_transporting, 0) as sh_transporting,
    coalesce(sh_transporting_delivery_only, 0) as sh_transporting_delivery_only,

    --sh per tariff
    coalesce(sh_express, 0) as sh_express,
    coalesce(sh_courier, 0) as sh_courier,
    coalesce(sh_cargo, 0) as sh_cargo,
    coalesce(sh_cargocorp, 0) as sh_cargocorp,
    coalesce(sh_night, 0) as sh_night,
    coalesce(sh_ubernight, 0) as sh_ubernight,


    coalesce(tariff_express_on, False) as tariff_express_on,
    coalesce(tariff_night_on, False) as tariff_night_on,
    coalesce(tariff_ubernight_on, False) as tariff_ubernight_on,
    coalesce(tariff_cargo_on, False) as tariff_cargo_on,
    coalesce(tariff_cargocorp_on, False) as tariff_cargocorp_on,
    coalesce(tariff_courier_on, False) as tariff_courier_on,
    coalesce(tariff_any_not_delivery_on, False) as tariff_any_not_delivery_on,
    coalesce(tariff_any_delivery_on, False) as tariff_any_delivery_on,

    --coalesce(cl.car_size, 'unknown') as car_size,
    courier_type,
    weekly_courier_type,
    monthly_courier_type,


case
    when String::Contains(courier_type, 'cargo')
        then 'cargo_courier'
    when String::Contains(courier_type, 'bike') or String::Contains(courier_type, 'scooter') or String::Contains(courier_type, 'walking')
        then 'not_auto_courier'
    else
        courier_type
end as courier_type_general,

case
    when String::Contains(weekly_courier_type, 'cargo')
        then 'cargo_courier'
    when String::Contains(weekly_courier_type, 'bike') or String::Contains(weekly_courier_type, 'scooter') or String::Contains(weekly_courier_type, 'walking')
        then 'not_auto_courier'
    else
        weekly_courier_type
end as weekly_courier_type_general,

case
    when String::Contains(monthly_courier_type, 'cargo')
        then 'cargo_courier'
    when String::Contains(monthly_courier_type, 'bike') or String::Contains(monthly_courier_type, 'scooter') or String::Contains(monthly_courier_type, 'walking')
        then 'not_auto_courier'
    else
        monthly_courier_type
end as monthly_courier_type_general,


coalesce(executor_employment_type, 'unknown') as executor_employment_type,
coalesce(park_city, 'unknown') as park_city,

coalesce(app_platform, 'unknown') as app_platform,
coalesce(CAST(app_version_name as String), 'unknown') as app_version_name,

coalesce(offered_cnt, 0) as offered_cnt,
coalesce(seen_cnt, 0) as seen_cnt,
coalesce(assigned_cnt, 0) as assigned_cnt,

coalesce(order_cnt, 0) as order_cnt,
coalesce(success_order_cnt, 0)  as order_success_cnt,
coalesce(cancelled_flg, 0) as order_cancel_cnt,
coalesce(cancelled_user_flg, 0) as order_cancel_user_cnt,
coalesce(cancelled_driver_flg, 0) as order_cancel_driver_cnt,
coalesce(ticket_cnt, 0) as ticket_cnt,

coalesce(claim_delivered_cnt, 0) as claim_delivered_cnt,
coalesce(claim_returned_cnt, 0) as claim_returned_cnt,


from $sh_geo_by_executor_and_day as sh_geo
left join $sh_and_tariff_by_executor_and_day as st
on st.dbid_uuid == sh_geo.dbid_uuid and st.utc_date == sh_geo.utc_date
left join $tags_daily_data as tag
on tag.dbid_uuid == sh_geo.dbid_uuid and tag.utc_date == sh_geo.utc_date
left join $park_data as park
on park.taximeter_park_id == substring(sh_geo.dbid_uuid,0,32)
left join $app_data_daily_for_executor as app
on app.executor_profile_id == String::SplitToList(sh_geo.dbid_uuid, '_')[1] and app.dt == sh_geo.utc_date
left join $ar_data as ar
on ar.dbid_uuid == sh_geo.dbid_uuid and ar.utc_date == sh_geo.utc_date
left join $fct_order_data as fo
on fo.dbid_uuid == sh_geo.dbid_uuid and fo.utc_date == sh_geo.utc_date
left join $courier_segmentation_data as segm
on segm.unique_driver_id == tag.unique_driver_id and segm.dt == tag.utc_date
left join $courier_type_by_makar as type
on type.dbid_uuid == sh_geo.dbid_uuid and type.utc_date == sh_geo.utc_date
where sh_geo.utc_date <= $END_DT_STR and sh_geo.utc_date >= $START_DT_STR

);

--select * from $sh_geo_by_executor_and_day;
insert into $SAVE_DATA_TO with truncate
--IF calculate all
--select * from $executor_type_and_sh_and_tags;
--IF add new info
(select * from $executor_type_and_sh_and_tags)
union all
(select * from $SAVE_DATA_TO
where utc_date < $START_DT_STR)
;
commit;
/*
insert into `//home/taxi-delivery/analytics/dev/product/supply_analytics/ops_metrics_test_tags` with truncate
select * from $tags_data;
insert into `//home/taxi-delivery/analytics/dev/product/supply_analytics/ops_metrics_test_tags_daily` with truncate
select * from $tags_daily_data;
insert into `//home/taxi-delivery/analytics/dev/product/supply_analytics/ops_metrics_test_sh_geo` with truncate
select * from $sh_geo_by_executor_and_day;
insert into `//home/taxi-delivery/analytics/dev/product/supply_analytics/ops_metrics_test_sh_tariff` with truncate
select * from $sh_and_tariff_by_executor_and_day;
insert into `//home/taxi-delivery/analytics/dev/product/supply_analytics/ops_metrics_test_sh_source` with truncate
select * from $sh_data;
insert into `//home/taxi-delivery/analytics/dev/product/supply_analytics/ops_metrics_test_cars_labels` with truncate
select * from $cars_labeled;
insert into `//home/taxi-delivery/analytics/dev/product/supply_analytics/ops_metrics_test_cars_loaders_amt` with truncate
select * from $cars_loaders_amount;
insert into `//home/taxi-delivery/analytics/dev/product/supply_analytics/ops_metrics_test_cars_size` with truncate
select * from $cars_size_data;*/



insert into $SAVE_DASH_DAY_TO with truncate
select 'day' as scale,
    utc_date,

    courier_type, courier_type_general,
    executor_delivery_flg,

    executor_employment_type,
    park_city,
    app_platform, app_version_name,

    tariff_geo_zone_code,
    agglomeration, tz_country_name_ru,
    population_group,

    experienced_flg,

    courier_segmentation_label,


    max(thermobag_confirmed) as thermobag_confirmed,
    max(thermopack_confirmed) as thermopack_confirmed,
    max(allow_heavy_delivery) as allow_heavy_delivery,
    max(allow_profi_courier) as allow_profi_courier,
    max(profi_courier) as profi_courier,
    max(logistic_workshift_subscribed) as logistic_workshift_subscribed,
    max(post_payment) as post_payment,
    max(cargo_postpayment_diagnostics_allow_card) as cargo_postpayment_diagnostics_allow_card,

    max(tariff_express_on) as tariff_express_on,
    max(tariff_night_on) as tariff_night_on,
    max(tariff_ubernight_on) as tariff_ubernight_on,
    max(tariff_cargo_on) as tariff_cargo_on,
    max(tariff_cargocorp_on) as tariff_cargocorp_on,
    max(tariff_courier_on) as tariff_courier_on,
    --tariff_any_not_delivery_on,
    --tariff_any_delivery_on,

    count(distinct dbid_uuid) as executors_cnt,


    SUM(coalesce(sh, 0)) AS SH,
    SUM(coalesce(sh_delivery_only, 0)) as sh_delivery_only,

    SUM(coalesce(sh_free, 0)) as sh_free,
    SUM(coalesce(sh_free_delivery_only, 0)) as sh_free_delivery_only,
    SUM(coalesce(sh_waiting, 0)) as sh_waiting,
    SUM(coalesce(sh_waiting_delivery_only, 0)) as sh_waiting_delivery_only,

    SUM(coalesce(sh_driving, 0)) as sh_driving,
    SUM(coalesce(sh_driving_delivery_only, 0)) as sh_driving_delivery_only,

    SUM(coalesce(sh_transporting, 0)) as sh_transporting,
    SUM(coalesce(sh_transporting_delivery_only, 0)) as sh_transporting_delivery_only,

    --sh per tariff
    SUM(coalesce(sh_express, 0)) as sh_express,
    SUM(coalesce(sh_courier, 0)) as sh_courier,
    SUM(coalesce(sh_cargo, 0)) as sh_cargo,
    SUM(coalesce(sh_cargocorp, 0)) as sh_cargocorp,
    SUM(coalesce(sh_night, 0)) as sh_night,
    SUM(coalesce(sh_ubernight, 0)) as sh_ubernight,


    SUM(coalesce(offered_cnt, 0)) as offered_cnt,
    SUM(coalesce(seen_cnt, 0)) as seen_cnt,
    SUM(coalesce(assigned_cnt, 0)) as assigned_cnt,

    SUM(coalesce(order_cnt, 0)) as order_cnt,
    SUM(coalesce(order_success_cnt, 0))  as order_success_cnt,
    SUM(coalesce(order_cancel_cnt, 0)) as order_cancel_cnt,
    SUM(coalesce(order_cancel_user_cnt, 0)) as order_cancel_user_cnt,
    SUM(coalesce(order_cancel_driver_cnt, 0)) as order_cancel_driver_cnt,
    SUM(coalesce(ticket_cnt, 0)) as ticket_cnt,

    SUM(coalesce(claim_delivered_cnt, 0)) as claim_delivered_cnt,
    SUM(coalesce(claim_returned_cnt, 0)) as claim_returned_cnt,

    $date_format(CurrentUtcTimestamp()) as etl_update_dt,
    $date_format(CurrentUtcTimestamp()) as etl_update

from $SAVE_DATA_TO as t
where utc_date >= $date_format(CurrentUtcDatetime()- Interval('P91D'))
group by utc_date,
    courier_type, courier_type_general,
    executor_delivery_flg,

    executor_employment_type,
    park_city,
    app_platform, app_version_name,

    tariff_geo_zone_code,
    agglomeration, tz_country_name_ru,
    population_group,

    experienced_flg,

    courier_segmentation_label
;

insert into $SAVE_DASH_WEEK_TO with truncate
select 'week' as scale,
    utc_date,

    courier_type, courier_type_general,
    executor_delivery_flg,

    executor_employment_type,
    park_city,
    app_platform, app_version_name,

    tariff_geo_zone_code,
    agglomeration, tz_country_name_ru,
    population_group,

    experienced_flg,

    courier_segmentation_label,


    max(thermobag_confirmed) as thermobag_confirmed,
    max(thermopack_confirmed) as thermopack_confirmed,
    max(allow_heavy_delivery) as allow_heavy_delivery,
    max(allow_profi_courier) as allow_profi_courier,
    max(profi_courier) as profi_courier,
    max(logistic_workshift_subscribed) as logistic_workshift_subscribed,
    max(post_payment) as post_payment,
    max(cargo_postpayment_diagnostics_allow_card) as cargo_postpayment_diagnostics_allow_card,

    max(tariff_express_on) as tariff_express_on,
    max(tariff_night_on) as tariff_night_on,
    max(tariff_ubernight_on) as tariff_ubernight_on,
    max(tariff_cargo_on) as tariff_cargo_on,
    max(tariff_cargocorp_on) as tariff_cargocorp_on,
    max(tariff_courier_on) as tariff_courier_on,
    --tariff_any_not_delivery_on,
    --tariff_any_delivery_on,

    count(distinct dbid_uuid) as executors_cnt,


    SUM(coalesce(sh, 0)) AS SH,
    SUM(coalesce(sh_delivery_only, 0)) as sh_delivery_only,

    SUM(coalesce(sh_free, 0)) as sh_free,
    SUM(coalesce(sh_free_delivery_only, 0)) as sh_free_delivery_only,
    SUM(coalesce(sh_waiting, 0)) as sh_waiting,
    SUM(coalesce(sh_waiting_delivery_only, 0)) as sh_waiting_delivery_only,

    SUM(coalesce(sh_driving, 0)) as sh_driving,
    SUM(coalesce(sh_driving_delivery_only, 0)) as sh_driving_delivery_only,

    SUM(coalesce(sh_transporting, 0)) as sh_transporting,
    SUM(coalesce(sh_transporting_delivery_only, 0)) as sh_transporting_delivery_only,

    --sh per tariff
    SUM(coalesce(sh_express, 0)) as sh_express,
    SUM(coalesce(sh_courier, 0)) as sh_courier,
    SUM(coalesce(sh_cargo, 0)) as sh_cargo,
    SUM(coalesce(sh_cargocorp, 0)) as sh_cargocorp,
    SUM(coalesce(sh_night, 0)) as sh_night,
    SUM(coalesce(sh_ubernight, 0)) as sh_ubernight,


    SUM(coalesce(offered_cnt, 0)) as offered_cnt,
    SUM(coalesce(seen_cnt, 0)) as seen_cnt,
    SUM(coalesce(assigned_cnt, 0)) as assigned_cnt,

    SUM(coalesce(order_cnt, 0)) as order_cnt,
    SUM(coalesce(order_success_cnt, 0))  as order_success_cnt,
    SUM(coalesce(order_cancel_cnt, 0)) as order_cancel_cnt,
    SUM(coalesce(order_cancel_user_cnt, 0)) as order_cancel_user_cnt,
    SUM(coalesce(order_cancel_driver_cnt, 0)) as order_cancel_driver_cnt,
    SUM(coalesce(ticket_cnt, 0)) as ticket_cnt,

    SUM(coalesce(claim_delivered_cnt, 0)) as claim_delivered_cnt,
    SUM(coalesce(claim_returned_cnt, 0)) as claim_returned_cnt,

    $date_format(CurrentUtcTimestamp()) as etl_update_dt,
    $date_format(CurrentUtcTimestamp()) as etl_update

from $SAVE_DATA_TO as t
where $date_format(DateTime::StartOfWeek($date_parse(utc_date))) >= $date_format(CurrentUtcDatetime()- Interval('P365D'))
group by $date_format(DateTime::StartOfWeek($date_parse(utc_date))) as utc_date,
    weekly_courier_type as courier_type, weekly_courier_type_general as courier_type_general,
    executor_delivery_flg,

    executor_employment_type,
    park_city,
    app_platform, app_version_name,

    tariff_geo_zone_code,
    agglomeration, tz_country_name_ru,
    population_group,

    experienced_flg,

    weekly_courier_segmentation_label as courier_segmentation_label
;


insert into $SAVE_DASH_MONTH_TO with truncate
select 'month' as scale,
    utc_date,

    courier_type, courier_type_general,
    executor_delivery_flg,

    executor_employment_type,
    park_city,
    app_platform, app_version_name,

    tariff_geo_zone_code,
    agglomeration, tz_country_name_ru,
    population_group,

    experienced_flg,

    courier_segmentation_label,


    max(thermobag_confirmed) as thermobag_confirmed,
    max(thermopack_confirmed) as thermopack_confirmed,
    max(allow_heavy_delivery) as allow_heavy_delivery,
    max(allow_profi_courier) as allow_profi_courier,
    max(profi_courier) as profi_courier,
    max(logistic_workshift_subscribed) as logistic_workshift_subscribed,
    max(post_payment) as post_payment,
    max(cargo_postpayment_diagnostics_allow_card) as cargo_postpayment_diagnostics_allow_card,

    max(tariff_express_on) as tariff_express_on,
    max(tariff_night_on) as tariff_night_on,
    max(tariff_ubernight_on) as tariff_ubernight_on,
    max(tariff_cargo_on) as tariff_cargo_on,
    max(tariff_cargocorp_on) as tariff_cargocorp_on,
    max(tariff_courier_on) as tariff_courier_on,
    --tariff_any_not_delivery_on,
    --tariff_any_delivery_on,

    count(distinct dbid_uuid) as executors_cnt,


    SUM(coalesce(sh, 0)) AS SH,
    SUM(coalesce(sh_delivery_only, 0)) as sh_delivery_only,

    SUM(coalesce(sh_free, 0)) as sh_free,
    SUM(coalesce(sh_free_delivery_only, 0)) as sh_free_delivery_only,
    SUM(coalesce(sh_waiting, 0)) as sh_waiting,
    SUM(coalesce(sh_waiting_delivery_only, 0)) as sh_waiting_delivery_only,

    SUM(coalesce(sh_driving, 0)) as sh_driving,
    SUM(coalesce(sh_driving_delivery_only, 0)) as sh_driving_delivery_only,

    SUM(coalesce(sh_transporting, 0)) as sh_transporting,
    SUM(coalesce(sh_transporting_delivery_only, 0)) as sh_transporting_delivery_only,

    --sh per tariff
    SUM(coalesce(sh_express, 0)) as sh_express,
    SUM(coalesce(sh_courier, 0)) as sh_courier,
    SUM(coalesce(sh_cargo, 0)) as sh_cargo,
    SUM(coalesce(sh_cargocorp, 0)) as sh_cargocorp,
    SUM(coalesce(sh_night, 0)) as sh_night,
    SUM(coalesce(sh_ubernight, 0)) as sh_ubernight,


    SUM(coalesce(offered_cnt, 0)) as offered_cnt,
    SUM(coalesce(seen_cnt, 0)) as seen_cnt,
    SUM(coalesce(assigned_cnt, 0)) as assigned_cnt,

    SUM(coalesce(order_cnt, 0)) as order_cnt,
    SUM(coalesce(order_success_cnt, 0))  as order_success_cnt,
    SUM(coalesce(order_cancel_cnt, 0)) as order_cancel_cnt,
    SUM(coalesce(order_cancel_user_cnt, 0)) as order_cancel_user_cnt,
    SUM(coalesce(order_cancel_driver_cnt, 0)) as order_cancel_driver_cnt,
    SUM(coalesce(ticket_cnt, 0)) as ticket_cnt,

    SUM(coalesce(claim_delivered_cnt, 0)) as claim_delivered_cnt,
    SUM(coalesce(claim_returned_cnt, 0)) as claim_returned_cnt,

    $date_format(CurrentUtcTimestamp()) as etl_update_dt,
    $date_format(CurrentUtcTimestamp()) as etl_update

from $SAVE_DATA_TO as t
group by $date_format(DateTime::StartOfMonth($date_parse(utc_date))) as utc_date,
    monthly_courier_type as courier_type, monthly_courier_type_general as courier_type_general,
    executor_delivery_flg,

    executor_employment_type,
    park_city,
    app_platform, app_version_name,

    tariff_geo_zone_code,
    agglomeration, tz_country_name_ru,
    population_group,

    experienced_flg,

    monthly_courier_segmentation_label as courier_segmentation_label
;


insert into $SAVE_METRIC_LIST_TO with truncate
/*select 'SH' as kpi_name, 'Количество саплай часов исполнителя' as description, '' as source
union all
select 'SH в Доставке' as kpi_name, 'Саплай часов в тарифах Доставки' as description, '' as source
union all
select 'SH_driving' as kpi_name, 'Часов в статусе driving' as description, '' as source
union all
select 'SH_driving в Доставке' as kpi_name, 'Часов в статусе driving в Доставке' as description, '' as source
union all
select 'SH_waiting' as kpi_name, 'Часов в статусе waiting' as description, '' as source
union all
select 'SH_waiting в Доставке' as kpi_name, 'Часов в статусе waiting в Доставке' as description, '' as source
union all
select 'SH_free' as kpi_name, 'Часов в статусе free' as description, '' as source
union all
select 'SH_free в Доставке' as kpi_name, 'Часов в статусе free в Доставке' as description, '' as source
union all
select 'SH_transporting' as kpi_name, 'Часов в статусе transporting' as description, '' as source
union all
select 'SH_transporting в Доставке' as kpi_name, 'Часов в статусе transporting в Доставке' as description, '' as source
union all
select 'SH в тарифе cargo' as kpi_name, 'Саплай часов в тарифе cargo' as description, '' as source
union all
select 'SH в тарифе cargocorp' as kpi_name, 'Саплай часов в тарифе cargocorp' as description, '' as source
union all
select 'SH в тарифе night' as kpi_name, 'Саплай часов в тарифе night' as description, '' as source
union all
select 'SH в тарифе ubernight' as kpi_name, 'Саплай часов в тарифе ubernight' as description, '' as source
union all
select 'SH в тарифе express' as kpi_name, 'Саплай часов в тарифе express' as description, '' as source
union all
select 'SH в тарифе courier' as kpi_name, 'Саплай часов в тарифе courier' as description, '' as source
union all
select 'Количество офферов' as kpi_name, 'Количество офферов' as description, '' as source
union all
select 'Количество увиденных офферов' as kpi_name, 'Количество увиденных офферов' as description, '' as source
union all
select 'Количество назначений' as kpi_name, 'Количество назначений' as description, '' as source
union all
select 'Количество заказов' as kpi_name, 'Количество заказов' as description, '' as source
union all
select 'Количество успешных заказов' as kpi_name, 'Количество успешных заказов' as description, '' as source
union all
select 'Количество тикетов' as kpi_name, 'Количество тикетов' as description, '' as source
*/
select 'Executors' as kpi_name, 'Количество исполнителей' as description, '' as source
union all
select 'SH' as kpi_name, 'Саплай часы (суммарное время на линии)' as description, '' as source
union all
select 'Efficiency' as kpi_name, 'Отношение суммарного времени всех исполнителей в статусе transporting (на заказе с клиентом) к суммарному времени на линии (Supply hours).' as description, '' as source
union all
select 'Free, %' as kpi_name, 'Отношение суммарного времени исполнителей в статусе free (свободен) к суммарному времени на линии (sh)' as description, '' as source
union all
select 'Utilization' as kpi_name, 'Отношение суммарного времени исполнителей в статусах waiting, driving и transporting к суммарному времени на линии (sh)' as description, '' as source
union all
select 'Orders' as kpi_name, 'Количество заказов' as description, '' as source
union all
select 'Succesful orders' as kpi_name, 'Количество успешных доставок' as description, '' as source --переименовать в Deliveries и сделать Deliveries per hour
union all
select 'Succesful orders per hour' as kpi_name, 'Среднее число успешных доставок за час' as description, '' as source --переименовать в Deliveries и сделать Deliveries per hour
union all
select 'CR' as kpi_name, 'Доля успешных заказов' as description, '' as source
union all
select 'AR' as kpi_name, 'Доля назначений среди всех офферов' as description, '' as source
union all
select 'Returned claims, %' as kpi_name, 'Отношение числа клеймов с возвратами к числу клеймов с возвратами и без них (доля возвратов среди успешных клеймов)' as description, '' as source
union all
select 'Cancelled by executor, %' as kpi_name, 'Отношение числа водительских отмен к общему числу заказов' as description, '' as source
union all
select 'Cancelled by user, %' as kpi_name, 'Отношение числа пользовательских отмен к общему числу заказов' as description, '' as source
union all
select 'Tickets per order' as kpi_name, 'Число уникальных тикетов, приходящихся на один заказ' as description, '' as source
union all
select 'Executors without experience' as kpi_name, 'Число исполнителей без опыта' as description, '' as source
;
