USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.UseNativeYtTypes;
--PRAGMA yt.InferSchema = '1';
PRAGMA OrderedColumns;


$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
--$B2B_DT_END = $date_month_format(CurrentUtcDate());
$DT_END = CurrentUtcDate();
$DT_START = Date('2021-05-01');

$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$diff_minutes_dttm = (($end_dttm, $start_dttm) -> {
    $start = DateTime::MakeDatetime($datetime_parse($start_dttm));
    $end = DateTime::MakeDatetime($datetime_parse($end_dttm));
    RETURN 1.0*Datetime::ToSeconds($end - $start)/(60);
    --RETURN Datetime::Format('%H:%M:%S')$end - $start;
});

--YT input


-- YT constants for output data 
$insert_status_path = '//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/control_script_claims/claims_points_and_payments_status_list';



$result = (
select $date_format(Datetime::FromSeconds(Cast(claim_created_ts AS Uint32))) as claim_created_dt,
    c.claim_ref_id as claim_ref_id,
    claim_zone_id, 
    `cc.corp_client_name` as corp_client_name,
    IF(claim_status="returned_finish" AND visit_status="visited", "delivered_finish",
        IF(claim_status='returned_finish' AND visit_status='skipped', 'returned_finish',
        IF(claim_status='returned_finish' AND visit_status='pending', 'unknown', 
        IF(claim_status='delivered_finish' AND visit_status='skipped', 'unknown',
        IF(claim_status='delivered_finish' AND visit_status='pending', 'unknown',
        IF(claim_status='delivered_finish' AND visit_status='visited', 'delivered_finish',
        IF(claim_status='performer_not_found' AND visit_status='visited', 'unknown',
        IF(claim_status='cancelled' AND visit_status='visited', 'unknown', 
        IF(claim_status='cancelled' AND visit_status!='visited', 'cancelled_by_client_free', 
        IF(claim_status='cancelled_by_taxi', 'cancelled_by_performer', 
        IF(claim_status='cancelled_with_payment', 'cancelled_by_client_paid', 
                claim_status))))))))))) as claim_point_status,
            
    `b.payment_method` as payment_method,
    
    -- Время поиска до отмены
    if(String::Contains(claim_status, 'cancel')
        and bf_03_accepted_dttm is not null,
        $diff_minutes_dttm(coalesce(bf_06_performer_found_dttm, claim_point_terminal_dttm, terminal_status_dttm), bf_03_accepted_dttm), 
        null) as performer_search_time_bfr_cancel_in_minutes,

    -- 	Время поиска 	
    if(bf_03_accepted_dttm is not null, $diff_minutes_dttm(bf_06_performer_found_dttm, bf_03_accepted_dttm), null) as performer_found_time_in_minutes,


    

    -- Время оплаты в смысле нахождения на точки Б 
    $diff_minutes_dttm(bf_10a_pay_waiting_dttm, bf_10_delivery_arrived_dttm) as delivery_arrived_to_pay_waiting_time_in_minutes, 
    $diff_minutes_dttm(coalesce(claim_point_terminal_dttm, terminal_status_dttm), bf_10a_pay_waiting_dttm) as pay_waiting_to_terminal_point_status_time_in_minutes,

    --Полное время доставки 
    $diff_minutes_dttm(coalesce(claim_point_terminal_dttm, terminal_status_dttm), bf_03_accepted_dttm) as total_time_in_minutes,

    $datetime_format(Datetime::FromSeconds(Cast(claim_created_ts AS Uint32))) as claim_created_dttm,

    bf_00_new_dttm,
    bf_01_estimating_dttm,
    bf_02_ready_for_approval_dttm,
    bf_03_accepted_dttm,
    bf_04_performer_lookup_dttm,
    bf_05_performer_draft_dttm,
    bf_06_performer_found_dttm,
    bf_07_pickup_arrived_dttm,
    bf_08_ready_for_pickup_confirmation_dttm,
    bf_09_pickuped_dttm,
    bf_10_delivery_arrived_dttm,
    bf_10a_pay_waiting_dttm	,
    bf_11_ready_for_delivery_confirmation_dttm	,
    bf_12_delivered_dttm	,
    bf_13_delivered_finish_dttm	,
    
    billing_amount,
    
    cf_cancelled_by_client_free_dttm,
    cf_cancelled_by_client_paid_dttm,
    cf_cancelled_by_performer_dttm,
    
    claim_id,
    claim_point_id,
    claim_point_updated_dt,
    claim_point_updated_dttm,
    corp_client_id,
    eda_flg,
                                                
    claim_tariff_class_code,
    executor_tariff_class_code,
    
    ff_failed_dttm,
    ff_performer_not_found_dttm,
    String::ReplaceAll(`p.fiscal_datetime`, 'T', ' ') as fiscal_datetime,
    `geo.population_group` as population_group,
    `geo.tz_country_name_ru` as country_name_ru,
    
    payment_id,
    `p.payment_updated_dttm` as payment_updated_dttm,
    
    rf_00_returning_dttm,
    rf_01_return_arrived_dttm,
    rf_02_ready_for_return_confirmation_dttm,
    rf_03_returned_dttm,
    rf_04_returned_finish_dttm,
    taxi_order_id,
    terminal_status_dttm,
    claim_point_terminal_dttm,

    --  статусы оплат
    `p.pf_00_new_dttm` as payment_00_new_dttm,
    `p.pf_01_confirmed_dttm` as payment_01_confirmed_dttm,
    `p.pf_02_authorized_dttm` as payment_02_authorized_dttm,
    `p.pf_03_finished_dttm` as payment_03_finished_dttm,

    --Время оплаты	
    $diff_minutes_dttm(`p.pf_02_authorized_dttm`, `p.pf_01_confirmed_dttm`) as payment_confirmed_to_authorized_time_in_minutes,
    $diff_minutes_dttm(`p.pf_03_finished_dttm`, `p.pf_02_authorized_dttm`) as payment_authorized_to_finish_time_in_minutes,


    --dm_order 

--from $postpayment_claims_data as c
--left join $payments_logistics as p 
--on p.claim_ref_id == c.claim_ref_id and p.claim_point_id == c.claim_point_id 
/*from $payments_logistics as p 
left join $postpayment_claims_data as c
on p.claim_ref_id == c.claim_ref_id and p.claim_point_id == c.claim_point_id 
left join $corp_clients_data as cc 
on cc.client_id == p.client_id
left join $geo as geo 
on geo.tariff_zone = c.claim_zone_id*/ 
from `//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_demand/abt_claims_points_not_pp_only` as c 
--left join $b2b_status_data as b2b_status 
--on b2b_status.claim_id = c.claim_id and b2b_status.point_id = c.point_id
--left join $claim_terminal_status_data as terminal
--on terminal.claim_id = c.claim_id 



where claim_point_updated_dt is not null and postpayment_flg=1
order by claim_created_dttm)
;

insert into $insert_status_path with truncate
select *
from $result;
