-- когда и сколько получили денег от получателя

USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.UseNativeYtTypes;
PRAGMA yt.InferSchema = '1';
PRAGMA yson.DisableStrict;


-- Datetime constants.


--$alena_demand_orders = '//home/taxi-analytics/alena-lukina/express/demand/orders';
$TODAY = CurrentUtcDate();
$TODAY_STR = cast($TODAY as String);
$DT_START = Date('2021-05-01');
$DT_END = $TODAY;
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_month_short_format = Datetime::Format('%Y-%m');
$date_year_format = Datetime::Format('%Y-01-01');

$date_format_dm_order = DateTime::Format("%Y-%m");
$date_format_first_day_month = DateTime::Format("%Y-%m-01");

$ORDER_CANDIDATE_START = $date_format_first_day_month($DT_START);
$ORDER_CANDIDATE_END = $date_format_first_day_month($DT_END);


$START_DTTM_STR = $datetime_format($DT_START);
$START_DT_STR = $date_format($DT_START);
$START_MONTH_STR = $date_month_format($DT_START);
$START_MONTH_SHORT_STR = $date_month_short_format($DT_START);
$START_YEAR_STR = $date_year_format($DT_START);

$END_DTTM_STR = $datetime_format($DT_END);
$END_DT_STR = $date_format($DT_END);
$END_MONTH_STR = $date_month_format($DT_END);
$END_MONTH_SHORT_STR = $date_month_short_format($DT_END);
$END_YEAR_STR = $date_year_format($DT_END);

--YT input

--cargo_claims folder
$claims_path = '//home/taxi/production/replica/postgres/cargo_claims/claims';
$claim_points_path = '//home/taxi/production/replica/postgres/cargo_claims/claim_points';
$payment_on_delivery_path = '//home/taxi/production/replica/postgres/cargo_claims/payment_on_delivery';
$taxi_order_changes_path = '//home/taxi/production/replica/postgres/cargo_claims/taxi_order_changes';
$taxi_performer_info_path = '//home/taxi/production/replica/postgres/cargo_claims/taxi_performer_info';
$raw_taxi_performer_info_path = '//home/taxi/production/replica/postgres/cargo_claims/raw/taxi_performer_info';
$CLAIM = '//home/delivery-dwh/ods/cargo_claims/claim';
$CLAIM_ADD_MANUAL_SELECT = '//home/delivery-dwh/ods/cargo_claims/claim_add_info_manual_select'; --year scale

--cargo_payments folder
$billing_path = '//home/taxi/production/replica/postgres/cargo_payments/billing_tasks_history';
--$transactions_path = '//home/taxi/production/replica/postgres/cargo_payments/transactions';
--$payment_performers_history_path = '//home/taxi/production/replica/postgres/cargo_payments/payments_performers_history';
$payments_path = '//home/taxi/production/replica/postgres/cargo_payments/payments';

--dim
$b2b_deals_info = '//home/taxi-delivery/analytics/production/b2b/dict/niksm_b2b_deals_info_ltd';
$corp_clients = '//home/taxi/production/replica/mongo/struct/corp/corp_clients';
$fct_order_candidate_path = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$order_candidate_path = '//home/taxi-dwh/ods/dbprocessing/order_candidate';
$executor_profile_path = '//home/taxi-dwh/cdm/supply/dim_executor_profile_hist';
--$dm_order_path = '//home/taxi-dwh/summary/dm_order';
--$b2b_claims_monthly_path = '//home/taxi-delivery/analytics/production/b2b_claims_monthly';

-- YT constants for output data
--$insert_path = '//home/taxi-delivery/analytics/dev/product/postpayment/test/r4';
--$insert_claims_path = '//home/taxi-delivery/analytics/dev/product/postpayment/test/r4_claims';
$claim_point_status_ts_path = '//home/taxi-delivery/analytics/dev/drmks/claim_point_status_ts';
$claim_status_ts_path = '//home/taxi-delivery/analytics/dev/drmks/claim_status_ts';

--EDA
$DM_ORDER_EDA = '//home/eda-dwh/cdm/order/dm_order';
$COURIER_EDA = '//home/eda-dwh/ods/bigfood/courier/courier';
$PAYMENTS_EDA = '//home/eda-dwh/ods/bigfood/finance_payment_confirmation_task';



$insert_path = '//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_demand/abt_claims_points_not_pp_only';
$insert_claims_path = '//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_demand/abt_pp_claims_not_pp_only';

$LOG_TARIFFS = ['express', 'courier', 'cargo', 'cargocorp', 'night', 'ubernight'];

$payments_logistics_clients = (
select distinct
    client_id
from $payments_path
where --status in ('finished', 'authorized') --где уже списали деньги
    virtual_client_id == '176a4fcc-90f3-4ddc-909f-a8acdd5fe818' --заказы Доставки
    and FIND(external_id, '/') is not null --external_id хороший
    and client_id is not null
);


$payments_eda_clients = ['4decd14f25424e8b82b6d3e4f56d23b2',
                           'b2dc2b2e96f8482ba2d1582bd1445184', -- есть
                           '87cda4c03d60416bb522e83fe24b3d50', -- есть, Казахстан. Будет еще Беларусь в еде
                           '162b9899216246f7a1ba9fc14a479e87', -- Беларусь, новый договор -  это все Еда
                           -- 'dc28c565829e48cca458b5feb161d5d6', -- Лавка
                           --'4ee0ceca18ce41e3895786796a967e78', -- Лавка
                           --'bfd05979e380486d9181b62fa05d1fc9' -- Лавка
];



--реплика
/*
$executor_claims_data = (
    select claim_id,
        some(park_id) as park_taximeter_id, some(driver_id) as executor_profile_id,
    from $taxi_performer_info_path
    group by claim_id
);*/
--raw

$executor_claims_data = (
    select claim_id,
        some(park_id) as park_taximeter_id,
        some(driver_id) as executor_profile_id,
        some(tariff_class) as tariff_class,
    from (select Yson::LookupInt64(doc, "claim_id") as claim_id,
        Yson::LookupString(doc, "park_id") as park_id,
        Yson::LookupString(doc, "driver_id") as driver_id,
        Yson::LookupString(doc, "tariff_class") as tariff_class,
        from $raw_taxi_performer_info_path)
    group by claim_id
);

/*
$dm_order_data = (
    select *
    from range($dm_order_path, '2021-06-01', '2021-07-14')

);
*/

/*
$order_candidate_data = (
    select order_id as taxi_order_id, count(*) as candidates_cnt
    from RANGE($order_candidate_path, $ORDER_CANDIDATE_START, $ORDER_CANDIDATE_END)
    group by order_id
);*/


/*
$claim_status = (
    select
        claim_id,
        max(bf_00_new_ts) as bf_00_new_ts,
        max(bf_01_estimating_ts) as bf_01_estimating_ts,
        max(bf_02_ready_for_approval_ts) as bf_02_ready_for_approval_ts,
        max(bf_03_accepted_ts) as bf_03_accepted_ts,
        max(bf_04_performer_lookup_ts) as bf_04_performer_lookup_ts,
        max(bf_05_performer_draft_ts) as bf_05_performer_draft_ts,
        max(bf_06_performer_found_ts) as bf_06_performer_found_ts,
        max(bf_07_pickup_arrived_ts) as bf_07_pickup_arrived_ts,
        max(bf_08_ready_for_pickup_confirmation_ts) as bf_08_ready_for_pickup_confirmation_ts,
        max(bf_09_pickuped_ts) as bf_09_pickuped_ts,
        max(bf_10_delivery_arrived_ts) as bf_10_delivery_arrived_ts,
        max(bf_10a_pay_waiting_ts) as bf_10a_pay_waiting_ts,
        max(bf_11_ready_for_delivery_confirmation_ts) as bf_11_ready_for_delivery_confirmation_ts,
        max(bf_12_delivered_ts) as bf_12_delivered_ts,
        max(bf_13_delivered_finish_ts) as bf_13_delivered_finish_ts,
        max(rf_00_returning_ts) as rf_00_returning_ts,
        max(rf_01_return_arrived_ts) as rf_01_return_arrived_ts,
        max(rf_02_ready_for_return_confirmation_ts) as rf_02_ready_for_return_confirmation_ts,
        max(rf_03_returned_ts) as rf_03_returned_ts,
        max(rf_04_returned_finish_ts) as rf_04_returned_finish_ts,
        max(cf_cancelled_by_client_free_ts) as cf_cancelled_by_client_free_ts,
        max(cf_cancelled_by_client_paid_ts) as cf_cancelled_by_client_paid_ts,
        max(cf_cancelled_by_performer_ts) as cf_cancelled_by_performer_ts,
        max(ff_performer_not_found_ts) as ff_performer_not_found_ts,
        max(ff_failed_ts) as ff_failed_ts,
        from
        (SELECT
            claim_id,
            case when new_status == 'new' then time else null end as bf_00_new_ts,
            case when new_status == 'estimating' then time else null end as bf_01_estimating_ts,
            case when new_status == 'ready_for_approval' then time else null end as bf_02_ready_for_approval_ts,
            case when new_status == 'accepted' then time else null end as bf_03_accepted_ts,
            case when new_status == 'performer_lookup' then time else null end as bf_04_performer_lookup_ts,
            case when new_status == 'performer_draft' then time else null end as bf_05_performer_draft_ts,
            case when new_status == 'performer_found' then time else null end as bf_06_performer_found_ts,
            case when new_status == 'pickup_arrived' then time else null end as bf_07_pickup_arrived_ts,
            case when new_status == 'ready_for_pickup_confirmation' then time else null end as bf_08_ready_for_pickup_confirmation_ts,
            case when new_status == 'pickuped' then time else null end as bf_09_pickuped_ts,
            case when new_status == 'delivery_arrived' then time else null end as bf_10_delivery_arrived_ts,
            case when new_status == 'pay_waiting' then time else null end as bf_10a_pay_waiting_ts,
            case when new_status == 'ready_for_delivery_confirmation' then time else null end as bf_11_ready_for_delivery_confirmation_ts,
            case when new_status == 'delivered' then time else null end as bf_12_delivered_ts,
            case when new_status == 'delivered_finish' then time else null end as bf_13_delivered_finish_ts,
            case when new_status == 'returning' then time else null end as rf_00_returning_ts,
            case when new_status == 'return_arrived' then time else null end as rf_01_return_arrived_ts,
            case when new_status == 'ready_for_return_confirmation' then time else null end as rf_02_ready_for_return_confirmation_ts,
            case when new_status == 'returned' then time else null end as rf_03_returned_ts,
            case when new_status == 'returned_finish' then time else null end as rf_04_returned_finish_ts,
            case when new_status == 'cancelled_with_payment' then time else null end as cf_cancelled_by_client_paid_ts,
            case when new_status == 'cancelled' then time else null end as cf_cancelled_by_client_free_ts,
            case when new_status == 'cancelled_by_taxi' then time else null end as cf_cancelled_by_performer_ts,
            case when new_status == 'performer_not_found' then time else null end as ff_performer_not_found_ts,
            case when new_status == 'failed' then time else null end as ff_failed_ts
            from
            (SELECT
                claim_id,
                new_status,
                max(event_time) as time
                from
                `home/taxi/production/replica/postgres/cargo_claims/claim_audit`
                where Datetime::FromSeconds(Cast(event_time AS Uint32)) BETWEEN $DT_START AND $DT_END
                group by claim_id, (new_status??'NULL') as new_status
            ) as s0
        ) as s1
        group by claim_id
);
*/
$ar_for_taxi_orders_data = (
    select order_id as taxi_order_id,
    count(utc_seen_dttm) as seen_cnt,
    count(utc_assigned_dttm) as assigned_cnt,
    from RANGE($fct_order_candidate_path, $ORDER_CANDIDATE_START, $ORDER_CANDIDATE_END)
    group by order_id
);



$ar_for_claims_data = (
    select claim_id,
    sum(coalesce(seen_cnt, 0)) as seen_cnt,
    sum(coalesce(assigned_cnt,0)) as assigned_cnt,
    from $taxi_order_changes_path as toc
    left join $ar_for_taxi_orders_data as ar_taxi
    on toc.taxi_order_id = ar_taxi.taxi_order_id
    group by toc.claim_id as claim_id
);

$claim_tariff_info = (
    select claim_id, some(tariff_class_code) as tariff_class_code
    from RANGE($CLAIM_ADD_MANUAL_SELECT, $START_YEAR_STR, $END_YEAR_STR) as cams
    group by claim_id
);

$order_candidate_data = (
    select taxi_order_id,
        dbid_uuid,
        some(taximeter_version) as taximeter_version,
        some(line_dist_m) as line_dist_m,
        some(router_dist_m) as router_dist_m,
        some(time_to_dest_sec) as time_to_dest_sec,

        --order_allowed_tariff_class_list,
        some(tag_id_list) as tag_id_list,
        max(ListHas(Yson::ConvertToStringList(tag_id_list), 'post_payment')) as exec_post_payment_tag,
        max(ListHas(Yson::ConvertToStringList(tag_id_list), 'auto_courier')) as exec_auto_courier_tag,
        max(ListHas(Yson::ConvertToStringList(tag_id_list), 'walking_courier')) as exec_walking_courier_tag,
        max(ListHas(Yson::ConvertToStringList(tag_id_list), 'cargo_courier_knows_about_postpayment')) as exec_knows_about_pp_tag,
        max(ListHas(Yson::ConvertToStringList(tag_id_list), 'cargo_postpayment_diagnostics_allow_card')) as exec_dianostics_allow_card_tag,
        some(tariff_class_code) as tariff_class_code
    from RANGE($order_candidate_path, $ORDER_CANDIDATE_START, $ORDER_CANDIDATE_END) as oc
    where tariff_class_code in $LOG_TARIFFS
    group by order_id as taxi_order_id,
        (park_taximeter_id || '_' || executor_profile_id) as dbid_uuid
);

/*
$claim_terminal_status = (
    SELECT
        claim_id,
        max(event_time) as terminal_status_ts,
        max_by(statuses.old_status, event_time) as pre_terminal_status
        from
        `home/taxi/production/replica/postgres/cargo_claims/claims` as claims
        left outer join
        `home/taxi/production/replica/postgres/cargo_claims/claim_audit` as statuses
        on claims.id = statuses.claim_id and claims.status = statuses.new_status
        where Datetime::FromSeconds(Cast(created_ts AS Uint32)) BETWEEN $DT_START AND $DT_END
        and Datetime::FromSeconds(Cast(event_time AS Uint32)) BETWEEN $DT_START AND $DT_END
        group by claims.id as claim_id

);*/

/*
$performer_found_time = (
    select claim_id,
        some(bf_06_performer_found_ts-bf_00_new_ts) as performer_found_time,
        some(terminal_status_ts - bf_00_new_ts) as terminal_status_time,
    from $claim_status as status
    left outer join $claim_terminal_status as terminal_status
        on status.claim_id = terminal_status.claim_id
    group by coalesce(status.claim_id, terminal_status.claim_id) as claim_id
);*/

--EDA
-- извлекаем claim_ref_id и соответствующие едовые айдишники
$order_nr_claim_id = (
    SELECT SUBSTRING(idempotency_token_id, 0, 13) as order_nr, claim_id, cargo_ref_id, status_code as claim_status, utc_created_dttm
    FROM RANGE($CLAIM, $START_MONTH_STR, $END_MONTH_STR) AS c
    WHERE corp_client_id in $payments_eda_clients
);
-- достаем едовые постоплатные заказы и смотрим их claim_ref_id
$pp_eda_orders = (
SELECT distinct
    ord.order_nr as order_nr,
    ord.courier_id as courier_id,
    ord.taxi_dispatch_reason_code as taxi_dispatch_reason_code,
    ord.place_delivery_zone_courier_type_code as place_delivery_zone_courier_type_code,
    ord.cancel_reason_code as cancel_reason_code,
    claim_id, cargo_ref_id as claim_ref_id,
    claim_status
from RANGE($PAYMENTS_EDA, $START_YEAR_STR, $END_YEAR_STR) as payment_task
join RANGE($DM_ORDER_EDA, $START_MONTH_SHORT_STR, $END_MONTH_SHORT_STR) as ord
        on ord.order_nr = payment_task.order_nr
join $order_nr_claim_id as cl
        on cl.order_nr == ord.order_nr
where payment_task.payment_type_code = 'postpayment'
);

$pp_eda_with_fallback = (
SELECT o.*, c.source as source
from $pp_eda_orders as o
LEFT JOIN $COURIER_EDA as c
on c.id == o.courier_id

where ((o.taxi_dispatch_reason_code is not null and o.taxi_dispatch_reason_code != 'redirected_by_supply') and o.place_delivery_zone_courier_type_code != 'yandex_taxi' -- тут используется taxi_dispatch_reason_code, по идее у тебя должны быть данные о нем. + здесь так же требуется, чтобы заказ был не из такси зоны. Но для постоплаты нет такси зон, поэтому на это условие можешь забить)
         or o.cancel_reason_code='courier.taxi_supply_not_available' -- это причина отмены наша
         or (o.taxi_dispatch_reason_code = 'redirected_by_supply'
                 and (c.source = 'virtual'))) -- тут проверка ответа диспатча и то, что курьер, который был назначен является виртуальным. По сути это успешный фоллбек как раз
);





-- достаем клеймы и точки с постоплатой
$postpayment_claims_data = (
    select
    c.id as claim_id,
    c.status as claim_status,
    c.uuid_id as claim_ref_id,
    c.taxi_order_id as taxi_order_id,
    c.current_point as claim_current_point,
    c.zone_id as claim_zone_id,
    c.revision as claim_revision,
    c.created_ts as claim_created_ts,
    c.updated_ts as claim_updated_ts,
    $datetime_format(Datetime::FromSeconds(Cast(c.created_ts AS Uint32))) as claim_created_dttm,
    $datetime_format(Datetime::FromSeconds(Cast(c.updated_ts AS Uint32)))  as claim_updated_dttm,
    c.corp_client_id as corp_client_id,

    CAST(cp.point_id as Int64) as point_id,
    cp.type,
    visit_status,
    cp.id as claim_point_id,
    cp.updated_ts as claim_point_updated_ts,
    $datetime_format(Datetime::FromSeconds(Cast(cp.updated_ts AS Uint32))) as claim_point_updated_dttm,
    $date_format(Datetime::FromSeconds(Cast(cp.updated_ts AS Uint32)))  as claim_point_updated_dt,

    p_on_d.payment_ref_id as payment_id,
    p_on_d.is_paid as is_paid,
    p_on_d.client_order_id as client_order_id,
    p_on_d.cost as cost,
    p_on_d.created_ts as payment_created_ts,
    p_on_d.updated_ts as payment_updated_ts,
    p_on_d.tax_system_code as tax_system_code,
    p_on_d.customer_email_id as customer_email_id,
    p_on_d.customer_phone_id as customer_phone_id,
    p_on_d.customer_full_name as customer_full_name,
    p_on_d.customer_inn as customer_inn,
    p_on_d.payment_method as general_payment_method,
    `p_on_d.flow` as `flow`,

    park_taximeter_id, executor_profile_id,
    (park_taximeter_id || '_' || executor_profile_id) as dbid_uuid,
    if(p_on_d.id is null, 0, 1) as postpayment_flg,
    if(c.corp_client_id in $payments_eda_clients, 1, 0) as eda_flg,

    FROM $claims_path as c
    left JOIN $claim_points_path as cp
        ON cp.claim_id = c.id
    left JOIN $payment_on_delivery_path as p_on_d
        ON p_on_d.claim_point_id = cp.id
    left join $executor_claims_data as exec
        on c.id == exec.claim_id
    WHERE
        --`p_on_d.flow` == 'service_usage' and
        --c.corp_client_id in $payments_logistics_clients
        --and
        cp.type =  'destination'
        and Datetime::FromSeconds(Cast(c.created_ts AS Uint32)) >= $DT_START
        and ((c.corp_client_id in $payments_logistics_clients) -- наши клиенты логистики
            or (c.corp_client_id in $payments_eda_clients and p_on_d.id is not null
                and (exec.tariff_class in $LOG_TARIFFS)) -- еда и наш исполнитель
            or (c.uuid_id in (select claim_ref_id from $pp_eda_with_fallback) and (exec.tariff_class != 'eda' or exec.tariff_class is null)))
);


$payment_status_data = (
    select
        payment_id,

        max(cf_cancelled_ts) as cf_cancelled_ts,
        max(pf_00_new_ts) as pf_00_new_ts,
        max(pf_01_confirmed_ts) as pf_01_confirmed_ts,
        max(pf_02_authorized_ts) as pf_02_authorized_ts,
        max(pf_03_finished_ts) as pf_03_finished_ts,

        from
        (SELECT
            payment_id,
            case when new_status == 'canceled' then time else null end as cf_cancelled_ts,
            case when new_status == 'new' then time else null end as pf_00_new_ts,
            case when new_status == 'confirmed' then time else null end as pf_01_confirmed_ts,
            case when new_status == 'authorized' then time else null end as pf_02_authorized_ts,
            case when new_status == 'finished' then time else null end as pf_03_finished_ts,
            from
            (SELECT
                payment_id,
                new_status,
                max(history_timestamp) as time
                from
                `home/taxi/production/replica/postgres/cargo_payments/payments_history`
                where Datetime::FromSeconds(Cast(history_timestamp AS Uint32)) BETWEEN $DT_START AND $DT_END
                group by String::RemoveAll(id, '-') as payment_id, (status??'NULL') as new_status
            ) as s0
        ) as s1
        group by payment_id
);

-- данные по платежам логистики
$payments_logistics = (
select
    client_id_type, client_id,
    String::RemoveAll(id, "-") as payment_id,

    external_id,
    SUBSTRING(external_id, NULL, COALESCE(FIND(external_id, '/'), 0)) as claim_ref_id,
    --SUBSTRING(external_id, COALESCE(FIND(external_id, '/'), LENGTH(external_id))+CAST(1 as Uint32)) as point_id_str,
    CAST(SUBSTRING(external_id, COALESCE(FIND(external_id, '/'), LENGTH(external_id))+CAST(1 as Uint32)) AS Int64) as claim_point_id,

    status,

    transaction_data,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/transaction_id')) as transaction_id,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/rrn')) as rrn,

    fiscal_data,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(fiscal_data, Yson::Options(false as Strict))), '/invoice')) as invoice,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(fiscal_data, Yson::Options(false as Strict))), '/datetime')) as fiscal_datetime,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(fiscal_data, Yson::Options(false as Strict))), '/document_mark')) as document_mark,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(fiscal_data, Yson::Options(false as Strict))), '/storage_number')) as storage_number,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(fiscal_data, Yson::Options(false as Strict))), '/document_number')) as document_number,

    created_at as payment_created_at,
    updated_ts as payment_updated_ts,
    last_status_changed_ts,
    $datetime_format(Datetime::FromSeconds(Cast(updated_ts AS Uint32))) as payment_updated_dttm,
    $date_format(Datetime::FromSeconds(Cast(updated_ts AS Uint32)))  as payment_updated_dt,
    $datetime_format(Datetime::FromSeconds(Cast(created_at AS Uint32))) as payment_created_dttm,
    $date_format(Datetime::FromSeconds(Cast(created_at AS Uint32)))  as payment_created_dt,

    cf_cancelled_ts,
    pf_00_new_ts,
    pf_01_confirmed_ts,
    pf_02_authorized_ts,
    pf_03_finished_ts,
    $datetime_format(Datetime::FromSeconds(Cast(cf_cancelled_ts AS Uint32))) as cf_cancelled_dttm,
    $datetime_format(Datetime::FromSeconds(Cast(pf_00_new_ts AS Uint32))) as pf_00_new_dttm,
    $datetime_format(Datetime::FromSeconds(Cast(pf_01_confirmed_ts AS Uint32))) as pf_01_confirmed_dttm,
    $datetime_format(Datetime::FromSeconds(Cast(pf_02_authorized_ts AS Uint32))) as pf_02_authorized_dttm,
    $datetime_format(Datetime::FromSeconds(Cast(pf_03_finished_ts AS Uint32))) as pf_03_finished_dttm,

from $payments_path as payments
left join $payment_status_data as  payments_status
on String::RemoveAll(payments.id, "-") = payments_status.payment_id
--where --status in ('finished', 'authorized') --где уже списали деньги
    --virtual_client_id == '176a4fcc-90f3-4ddc-909f-a8acdd5fe818' --заказы Доставки
    --and FIND(external_id, '/') is not null --external_id хороший
);





-- биллинг
$billing_data =(
select
    String::RemoveAll(order_id, "-") as payment_id,
    state,
    corp_client_id,
    amount,
    currency,
    billing_doc_id,
    refund,
    payment_instant,
    order_instant,

    meta,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(meta)), '/tariff')) as tariff,
    Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(meta)), '/payment_method')) as payment_method,
from $billing_path
where type == "user_on_delivery_payment" -- наложенный платеж
);

--потом поделить на части
$claim_terminal_status_data = (
    select claim_id,
        some(terminal_status_ts) as terminal_status_ts,
        some(terminal_status_dttm) as terminal_status_dttm
from $claim_point_status_ts_path
);

/*
$claims_payments_joined = (
    select cd.taxi_order_id as taxi_order_id,
    pl.*
    from $claims_data as cd
    inner join $payments_logistics as pl
    on String::RemoveAll(pl.payment_id, "-") == String::RemoveAll(cd.payment_id, "-")
);
*/
/*
$sum_transactions_for_payment_id = (
select payment_id, currency,
    sum(if(type=='reverse',-1,1)*CAST(amount as Double)) as transactions_amount
from $transactions_path
group by payment_id, currency
);*/

$corp_clients_data = (
    select client_id,
        maxby(name, created) as corp_client_name,
        some(c.contract_id) as contract_id,
        some(market_segment) as market_segment
    from $corp_clients as c
    left join $b2b_deals_info as b2b
    on c.contract_id = b2b.contract_id
    group by id as client_id
);

$geo =
(
    select tariff_zone, some(population_group) as population_group,
    some(tz_country_name_ru) as tz_country_name_ru,
    from `//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy`
    where root_node_id = 'br_root'
    group by tariff_zone

);

$claims_points_final = (select c.*,


    --t.transactions_amount,
    p.status,
    p.transaction_data,
    p.fiscal_data,
    p.payment_id,
    p.external_id,
    p.client_id,
    p.client_id_type,
    p.payment_updated_dttm,
    p.payment_created_dttm,
    p.fiscal_datetime,
    --coalesce(c.postpayment_flg, 0) as postpayment_flg,

    p.cf_cancelled_ts, p.cf_cancelled_dttm,
    p.pf_00_new_ts, p.pf_00_new_dttm,
    p.pf_01_confirmed_ts, p.pf_01_confirmed_dttm,
    p.pf_02_authorized_ts, p.pf_02_authorized_dttm,
    p.pf_03_finished_ts, p.pf_03_finished_dttm,

    c_status.bf_00_new_ts as bf_00_new_ts,
    c_status.bf_01_estimating_ts as bf_01_estimating_ts,
    c_status.bf_02_ready_for_approval_ts as bf_02_ready_for_approval_ts,
    c_status.bf_03_accepted_ts as bf_03_accepted_ts,
    c_status.bf_04_performer_lookup_ts as bf_04_performer_lookup_ts,
    c_status.bf_05_performer_draft_ts as bf_05_performer_draft_ts,
    c_status.bf_06_performer_found_ts as bf_06_performer_found_ts,
    c_status.bf_07_pickup_arrived_ts as bf_07_pickup_arrived_ts,
    c_status.bf_08_ready_for_pickup_confirmation_ts as bf_08_ready_for_pickup_confirmation_ts,
    cp_status.bf_09_pickuped_ts as bf_09_pickuped_ts,
    cp_status.bf_10_delivery_arrived_ts as bf_10_delivery_arrived_ts,
    cp_status.bf_10a_pay_waiting_ts as bf_10a_pay_waiting_ts,
    cp_status.bf_11_ready_for_delivery_confirmation_ts as bf_11_ready_for_delivery_confirmation_ts,
    cp_status.bf_12_delivered_ts as bf_12_delivered_ts,
    c_status.bf_13_delivered_finish_ts as bf_13_delivered_finish_ts,
    c_status.rf_00_returning_ts as rf_00_returning_ts,
    c_status.rf_01_return_arrived_ts as rf_01_return_arrived_ts,
    c_status.rf_02_ready_for_return_confirmation_ts as rf_02_ready_for_return_confirmation_ts,
    c_status.rf_03_returned_ts as rf_03_returned_ts,
    c_status.rf_04_returned_finish_ts as rf_04_returned_finish_ts,
    c_status.cf_cancelled_by_client_free_ts as cf_cancelled_by_client_free_ts,
    c_status.cf_cancelled_by_performer_ts as cf_cancelled_by_performer_ts,
    c_status.cf_cancelled_by_client_paid_ts as cf_cancelled_by_client_paid_ts,
    c_status.ff_performer_not_found_ts as ff_performer_not_found_ts,
    c_status.ff_failed_ts as ff_failed_ts,

    c_status.terminal_status_ts as terminal_status_ts,
    cp_status.claim_point_terminal_ts as claim_point_terminal_ts,


    /*
        c_status.bf_06_performer_found_ts-claim_created_ts as claim_performer_found_time,
        c_status.terminal_status_ts - claim_created_ts as claim_terminal_status_time,
        c_status.bf_06_performer_found_ts - claim_created_ts as time_to_find_performer,
        cp_status.bf_09_pickuped_ts - c_status.bf_06_performer_found_ts as time_performer_found_to_pickedup,
        cp_status.bf_10_delivery_arrived_ts - c_status.bf_09_pickuped_ts as time_pickuped_to_arrived,
        cp_status.bf_10a_pay_waiting_ts - cp_status.bf_10_delivery_arrived_ts as time_arrived_to_pay_waiting,
        case when cp_status.bf_12_delivered_ts is not null then cp_status.bf_12_delivered_ts-cp_status.bf_10a_pay_waiting_ts
            else c_status.bf_13_delivered_finish_ts- cp_status.bf_10a_pay_waiting_ts end as time_pay_waiting_to_delivery,
        case when cp_status.bf_12_delivered_ts is not null then cp_status.bf_12_delivered_ts-cp_status.bf_10_delivery_arrived_ts
            else c_status.bf_13_delivered_finish_ts- cp_status.bf_10_delivery_arrived_ts end as time_arrived_to_delivery,
    */

    c_status.bf_00_new_dttm as bf_00_new_dttm,
    c_status.bf_01_estimating_dttm as bf_01_estimating_dttm,
    c_status.bf_02_ready_for_approval_dttm as bf_02_ready_for_approval_dttm,
    c_status.bf_03_accepted_dttm as bf_03_accepted_dttm,
    c_status.bf_04_performer_lookup_dttm as bf_04_performer_lookup_dttm,
    c_status.bf_05_performer_draft_dttm as bf_05_performer_draft_dttm,
    c_status.bf_06_performer_found_dttm as bf_06_performer_found_dttm,
    c_status.bf_07_pickup_arrived_dttm as bf_07_pickup_arrived_dttm,
    c_status.bf_08_ready_for_pickup_confirmation_dttm as bf_08_ready_for_pickup_confirmation_dttm,
    cp_status.bf_09_pickuped_dttm as bf_09_pickuped_dttm,
    cp_status.bf_10_delivery_arrived_dttm as bf_10_delivery_arrived_dttm,
    cp_status.bf_10a_pay_waiting_dttm as bf_10a_pay_waiting_dttm,
    cp_status.bf_11_ready_for_delivery_confirmation_dttm as bf_11_ready_for_delivery_confirmation_dttm,
    cp_status.bf_12_delivered_dttm as bf_12_delivered_dttm,
    c_status.bf_13_delivered_finish_dttm as bf_13_delivered_finish_dttm,
    c_status.rf_00_returning_dttm as rf_00_returning_dttm,
    c_status.rf_01_return_arrived_dttm as rf_01_return_arrived_dttm,
    c_status.rf_02_ready_for_return_confirmation_dttm as rf_02_ready_for_return_confirmation_dttm,
    c_status.rf_03_returned_dttm as rf_03_returned_dttm,
    c_status.rf_04_returned_finish_dttm as rf_04_returned_finish_dttm,
    c_status.cf_cancelled_by_client_free_dttm as cf_cancelled_by_client_free_dttm,
    c_status.cf_cancelled_by_performer_dttm as cf_cancelled_by_performer_dttm,
    c_status.cf_cancelled_by_client_paid_dttm as cf_cancelled_by_client_paid_dttm,
    c_status.ff_performer_not_found_dttm as ff_performer_not_found_dttm,
    c_status.ff_failed_dttm as ff_failed_dttm,
    c_status.terminal_status_dttm as terminal_status_dttm,
    cp_status.claim_point_terminal_dttm as claim_point_terminal_dttm,



    b.state,
    b.tariff,
    b.payment_method,
    CAST(b.amount as Double) as billing_amount,
    b.currency as billing_currency,
    b.billing_doc_id,
    b.refund,
    b.payment_instant,
    b.order_instant,
    --b.corp_client_id,
    b.meta,

    cc.corp_client_name,
    cc.contract_id,
    cc.market_segment,
    --cc.cargo_contract_id,

    geo.tz_country_name_ru,
    geo.population_group,

    --executor data
    taximeter_version,
    line_dist_m,
    router_dist_m,
    time_to_dest_sec,
    exec_post_payment_tag,
    exec_auto_courier_tag,
    exec_walking_courier_tag,
    exec_knows_about_pp_tag,
    exec_dianostics_allow_card_tag,
    exec.tariff_class_code as executor_tariff_class_code,
    cti.tariff_class_code as claim_tariff_class_code,
    tag_id_list,

    coalesce(assigned_cnt, 0) as claim_candidates_assigned_cnt,
    coalesce(seen_cnt, 0) as claim_candidates_seen_cnt,

--from $postpayment_claims_data as c
--left join $payments_logistics as p
--on p.claim_ref_id == c.claim_ref_id and p.claim_point_id == c.claim_point_id
from $postpayment_claims_data as c
left join $payments_logistics as p
on p.payment_id == c.payment_id
left join $billing_data as b
on c.payment_id==b.payment_id
--left join $sum_transactions_for_payment_id as t
--on b.payment_id = t.payment_id
left join $corp_clients_data as cc
on cc.client_id == c.corp_client_id
left join $geo as geo
on geo.tariff_zone = c.claim_zone_id
left join $claim_point_status_ts_path as cp_status
on cp_status.claim_id = c.claim_id and cp_status.claim_point_id = c.claim_point_id
left join $claim_status_ts_path as c_status
on c_status.claim_id = c.claim_id
left join $ar_for_claims_data as ar_claims
on ar_claims.claim_id = c.claim_id
left join $order_candidate_data as exec
on exec.taxi_order_id = c.taxi_order_id and exec.dbid_uuid = c.dbid_uuid
left join $claim_tariff_info as cti
on cti.claim_id == c.claim_id
--left join $dm_order_data as dm
--on dm.order_id == c.taxi_order_id
where claim_created_dttm is not null
);

$claims_final = (
select cpf.claim_id as claim_id,
cpf.claim_ref_id as claim_ref_id,
some(claim_status) as claim_status,
some(claim_zone_id) as claim_zone_id,
some(`p.client_id`) as corp_client_id,
some(`cc.corp_client_name`) as corp_client_name,
some(`cc.contract_id`) as contract_id,
some(`cc.market_segment`) as market_segment,
some(`claim_zone_id`) as tariff_zone,
some(`geo.population_group`) as population_group,
some(`geo.tz_country_name_ru`) as tz_country_name_ru,
some(executor_tariff_class_code) as executor_tariff_class_code,
some(claim_tariff_class_code) as claim_tariff_class_code,
    some(claim_created_dttm) as claim_created_dttm,
    some(claim_updated_dttm) as claim_updated_dttm,
    some(claim_candidates_seen_cnt) as candidates_seen_cnt,
    some(claim_candidates_assigned_cnt) as candidates_assigned_cnt,
    some(terminal_status_ts) as terminal_status_ts,
    some(bf_00_new_ts) as bf_00_new_ts,
    some(bf_01_estimating_ts) as bf_01_estimating_ts,
    some(bf_02_ready_for_approval_ts) as bf_02_ready_for_approval_ts,
    some(bf_03_accepted_ts) as bf_03_accepted_ts,
    some(bf_04_performer_lookup_ts) as bf_04_performer_lookup_ts,
    some(bf_05_performer_draft_ts) as bf_05_performer_draft_ts,
    some(bf_06_performer_found_ts) as bf_06_performer_found_ts,
    some(bf_07_pickup_arrived_ts) as bf_07_pickup_arrived_ts,
    some(bf_08_ready_for_pickup_confirmation_ts) as bf_08_ready_for_pickup_confirmation_ts,
    some(bf_13_delivered_finish_ts) as bf_13_delivered_finish_ts,
    some(rf_04_returned_finish_ts) as rf_04_returned_finish_ts,

    some(cf_cancelled_by_client_free_ts) as cf_cancelled_by_client_free_ts,
    some(cf_cancelled_by_performer_ts) as cf_cancelled_by_performer_ts,
    some(cf_cancelled_by_client_paid_ts) as cf_cancelled_by_client_paid_ts,
    some(ff_performer_not_found_ts) as ff_performer_not_found_ts,
    some(ff_failed_ts) as ff_failed_ts,
    some(eda_flg) as eda_flg,
    some(postpayment_flg) as postpayment_flg,
from $claims_points_final as cpf
group by cpf.claim_id, cpf.claim_ref_id
);

insert into $insert_path with truncate
select * from $claims_points_final
;

insert into $insert_claims_path with truncate
select cf.*,
from $claims_final as cf
;
