-- когда и сколько получили денег от получателя

USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.UseNativeYtTypes;
PRAGMA yt.InferSchema = '1';


$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
--$B2B_DT_END = $date_month_format(CurrentUtcDate());
$DT_END = CurrentUtcDate();
$DT_START = Date('2021-05-01');

--YT input

-- YT constants for output data 
$insert_c_path = '//home/taxi-delivery/analytics/dev/drmks/claim_status_ts';
$insert_cp_path = '//home/taxi-delivery/analytics/dev/drmks/claim_point_status_ts';
--$insert_terminal_path = '//home/taxi-delivery/analytics/dev/drmks/claim_point_status_dttm';



$claim_terminal_status = (
    SELECT distinct
        claim_id, 
        max(event_time) as terminal_status_ts,
        max_by(statuses.old_status, event_time) as pre_terminal_status
        from
        `home/taxi/production/replica/postgres/cargo_claims/claims` as claims
        left outer join
        `home/taxi/production/replica/postgres/cargo_claims/claim_audit` as statuses
        on claims.id = statuses.claim_id and claims.status = statuses.new_status
        group by claims.id as claim_id
               
);


$claim_status = (
    select
        claim_id,

        max(bf_00_new_ts) as bf_00_new_ts,
        max(bf_01_estimating_ts) as bf_01_estimating_ts,
        max(bf_02_ready_for_approval_ts) as bf_02_ready_for_approval_ts,
        max(bf_03_accepted_ts) as bf_03_accepted_ts,
        max(bf_04_performer_lookup_ts) as bf_04_performer_lookup_ts,
        max(bf_05_performer_draft_ts) as bf_05_performer_draft_ts,
        max(bf_06_performer_found_ts) as bf_06_performer_found_ts,
        max(bf_07_pickup_arrived_ts) as bf_07_pickup_arrived_ts,
        max(bf_08_ready_for_pickup_confirmation_ts) as bf_08_ready_for_pickup_confirmation_ts,
        --max(bf_09_pickuped_ts) as bf_09_pickuped_ts,
        --max(bf_10_delivery_arrived_ts) as bf_10_delivery_arrived_ts,
        --max(bf_10a_pay_waiting_ts) as bf_10a_pay_waiting_ts,
        --max(bf_11_ready_for_delivery_confirmation_ts) as bf_11_ready_for_delivery_confirmation_ts,
        --max(bf_12_delivered_ts) as bf_12_delivered_ts,
        max(bf_13_delivered_finish_ts) as bf_13_delivered_finish_ts,
        max(rf_00_returning_ts) as rf_00_returning_ts,
        max(rf_01_return_arrived_ts) as rf_01_return_arrived_ts,
        max(rf_02_ready_for_return_confirmation_ts) as rf_02_ready_for_return_confirmation_ts,
        max(rf_03_returned_ts) as rf_03_returned_ts,
        max(rf_04_returned_finish_ts) as rf_04_returned_finish_ts,
        max(cf_cancelled_by_client_free_ts) as cf_cancelled_by_client_free_ts,
        max(cf_cancelled_by_client_paid_ts) as cf_cancelled_by_client_paid_ts,
        max(cf_cancelled_by_performer_ts) as cf_cancelled_by_performer_ts,
        max(ff_performer_not_found_ts) as ff_performer_not_found_ts,
        max(ff_failed_ts) as ff_failed_ts,
        from
        (SELECT
            claim_id,
            case when new_status == 'new' then time else null end as bf_00_new_ts,
            case when new_status == 'estimating' then time else null end as bf_01_estimating_ts,
            case when new_status == 'ready_for_approval' then time else null end as bf_02_ready_for_approval_ts,
            case when new_status == 'accepted' then time else null end as bf_03_accepted_ts,
            case when new_status == 'performer_lookup' then time else null end as bf_04_performer_lookup_ts,
            case when new_status == 'performer_draft' then time else null end as bf_05_performer_draft_ts,
            case when new_status == 'performer_found' then time else null end as bf_06_performer_found_ts,
            case when new_status == 'pickup_arrived' then time else null end as bf_07_pickup_arrived_ts,
            case when new_status == 'ready_for_pickup_confirmation' then time else null end as bf_08_ready_for_pickup_confirmation_ts,
            case when new_status == 'pickuped' then time else null end as bf_09_pickuped_ts,
            case when new_status == 'delivery_arrived' then time else null end as bf_10_delivery_arrived_ts,
            case when new_status == 'pay_waiting' then time else null end as bf_10a_pay_waiting_ts,
            case when new_status == 'ready_for_delivery_confirmation' then time else null end as bf_11_ready_for_delivery_confirmation_ts,
            case when new_status == 'delivered' then time else null end as bf_12_delivered_ts,
            case when new_status == 'delivered_finish' then time else null end as bf_13_delivered_finish_ts,
            case when new_status == 'returning' then time else null end as rf_00_returning_ts,
            case when new_status == 'return_arrived' then time else null end as rf_01_return_arrived_ts,
            case when new_status == 'ready_for_return_confirmation' then time else null end as rf_02_ready_for_return_confirmation_ts,
            case when new_status == 'returned' then time else null end as rf_03_returned_ts,
            case when new_status == 'returned_finish' then time else null end as rf_04_returned_finish_ts,
            case when new_status == 'cancelled_with_payment' then time else null end as cf_cancelled_by_client_paid_ts,
            case when new_status == 'cancelled' then time else null end as cf_cancelled_by_client_free_ts,
            case when new_status == 'cancelled_by_taxi' then time else null end as cf_cancelled_by_performer_ts,
            case when new_status == 'performer_not_found' then time else null end as ff_performer_not_found_ts,
            case when new_status == 'failed' then time else null end as ff_failed_ts,
            from
            (SELECT 
                claim_id, 
                new_status,
                max(event_time) as time
                from
                `home/taxi/production/replica/postgres/cargo_claims/claim_audit`
                group by claim_id, (new_status??'NULL') as new_status
            ) as s0
        ) as s1
        group by claim_id
);

$claim_point_status = (
    select
        claim_id,
        point_id,
        /*max(bf_00_new_ts) as bf_00_new_ts,
        max(bf_01_estimating_ts) as bf_01_estimating_ts,
        max(bf_02_ready_for_approval_ts) as bf_02_ready_for_approval_ts,
        max(bf_03_accepted_ts) as bf_03_accepted_ts,
        max(bf_04_performer_lookup_ts) as bf_04_performer_lookup_ts,
        max(bf_05_performer_draft_ts) as bf_05_performer_draft_ts,
        max(bf_06_performer_found_ts) as bf_06_performer_found_ts,*/
        --max(bf_07_pickup_arrived_ts) as bf_07_pickup_arrived_ts,
        --max(bf_08_ready_for_pickup_confirmation_ts) as bf_08_ready_for_pickup_confirmation_ts,
        max(bf_09_pickuped_ts) as bf_09_pickuped_ts,
        max(bf_10_delivery_arrived_ts) as bf_10_delivery_arrived_ts,
        max(bf_10a_pay_waiting_ts) as bf_10a_pay_waiting_ts,
        max(bf_11_ready_for_delivery_confirmation_ts) as bf_11_ready_for_delivery_confirmation_ts,
        max(bf_12_delivered_ts) as bf_12_delivered_ts,
        --max(bf_13_delivered_finish_ts) as bf_13_delivered_finish_ts,
        --max(rf_00_returning_ts) as rf_00_returning_ts,
        --max(rf_01_return_arrived_ts) as rf_01_return_arrived_ts,
        --max(rf_02_ready_for_return_confirmation_ts) as rf_02_ready_for_return_confirmation_ts,
        --max(rf_03_returned_ts) as rf_03_returned_ts,
        --max(rf_04_returned_finish_ts) as rf_04_returned_finish_ts,
        --max(cf_cancelled_by_client_free_ts) as cf_cancelled_by_client_free_ts,
        --max(cf_cancelled_by_client_paid_ts) as cf_cancelled_by_client_paid_ts,
        --max(cf_cancelled_by_performer_ts) as cf_cancelled_by_performer_ts,
        --max(ff_performer_not_found_ts) as ff_performer_not_found_ts,
        --max(ff_failed_ts) as ff_failed_ts,
        max(claim_point_terminal_ts) as claim_point_terminal_ts, 

        from
        (SELECT
            claim_id,
            point_id,
            case when new_status == 'new' then time else null end as bf_00_new_ts,
            case when new_status == 'estimating' then time else null end as bf_01_estimating_ts,
            case when new_status == 'ready_for_approval' then time else null end as bf_02_ready_for_approval_ts,
            case when new_status == 'accepted' then time else null end as bf_03_accepted_ts,
            case when new_status == 'performer_lookup' then time else null end as bf_04_performer_lookup_ts,
            case when new_status == 'performer_draft' then time else null end as bf_05_performer_draft_ts,
            case when new_status == 'performer_found' then time else null end as bf_06_performer_found_ts,
            case when new_status == 'pickup_arrived' then time else null end as bf_07_pickup_arrived_ts,
            case when new_status == 'ready_for_pickup_confirmation' then time else null end as bf_08_ready_for_pickup_confirmation_ts,
            case when new_status == 'pickuped' then time else null end as bf_09_pickuped_ts,
            case when new_status == 'delivery_arrived' then time else null end as bf_10_delivery_arrived_ts,
            case when new_status == 'pay_waiting' then time else null end as bf_10a_pay_waiting_ts,
            case when new_status == 'ready_for_delivery_confirmation' then time else null end as bf_11_ready_for_delivery_confirmation_ts,
            case when new_status == 'delivered' then time else null end as bf_12_delivered_ts,
            case when new_status == 'delivered_finish' then time else null end as bf_13_delivered_finish_ts,
            case when new_status == 'returning' then time else null end as rf_00_returning_ts,
            case when new_status == 'return_arrived' then time else null end as rf_01_return_arrived_ts,
            case when new_status == 'ready_for_return_confirmation' then time else null end as rf_02_ready_for_return_confirmation_ts,
            case when new_status == 'returned' then time else null end as rf_03_returned_ts,
            case when new_status == 'returned_finish' then time else null end as rf_04_returned_finish_ts,
            case when new_status == 'cancelled_with_payment' then time else null end as cf_cancelled_by_client_paid_ts,
            case when new_status == 'cancelled' then time else null end as cf_cancelled_by_client_free_ts,
            case when new_status == 'cancelled_by_taxi' then time else null end as cf_cancelled_by_performer_ts,
            case when new_status == 'performer_not_found' then time else null end as ff_performer_not_found_ts,
            case when new_status == 'failed' then time else null end as ff_failed_ts,
            claim_point_terminal_ts
            from
            ((SELECT s0.claim_id as claim_id,
            s0.point_id as point_id, 
            s0.new_status as new_status, time, 
            s00.claim_point_terminal_ts as claim_point_terminal_ts
            from (SELECT 
                claim_id, 
                point_id,
                new_status,
                max(event_time) as time
                from
                `home/taxi/production/replica/postgres/cargo_claims/claim_audit`
                group by claim_id, new_current_point as point_id, (new_status??'NULL') as new_status
            ) as s0 
            left join (SELECT 
                claim_id, 
                point_id,
                max(event_time) as claim_point_terminal_ts
                from
                `home/taxi/production/replica/postgres/cargo_claims/claim_audit`
                group by claim_id, old_current_point as point_id
            ) as s00
            on s0.claim_id = s00.claim_id and s0.point_id == s00.point_id))
            
        ) as s1
        group by claim_id, point_id
);

$b2b_status_cp_data = (
    select coalesce(b2b_point_status.claim_id, b2b_terminal.claim_id) as claim_id,
            b2b_point_status.point_id as claim_point_id,

    bf_00_new_ts,
    bf_01_estimating_ts,
    bf_02_ready_for_approval_ts,
    bf_03_accepted_ts,
    bf_04_performer_lookup_ts,
    bf_05_performer_draft_ts,
    bf_06_performer_found_ts,
    bf_07_pickup_arrived_ts,
    bf_08_ready_for_pickup_confirmation_ts,
    bf_09_pickuped_ts,
    bf_10_delivery_arrived_ts,
    bf_10a_pay_waiting_ts,
    bf_11_ready_for_delivery_confirmation_ts,
    bf_12_delivered_ts,
    bf_13_delivered_finish_ts,
    rf_00_returning_ts,
    rf_01_return_arrived_ts,
    rf_02_ready_for_return_confirmation_ts,
    rf_03_returned_ts,
    rf_04_returned_finish_ts,
    cf_cancelled_by_client_free_ts,
    cf_cancelled_by_performer_ts,
    cf_cancelled_by_client_paid_ts,
    ff_performer_not_found_ts,
    ff_failed_ts,

    claim_point_terminal_ts,
    terminal_status_ts,

        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_00_new_ts as Uint32))) as bf_00_new_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_01_estimating_ts as Uint32))) as bf_01_estimating_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_02_ready_for_approval_ts as Uint32))) as bf_02_ready_for_approval_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_03_accepted_ts as Uint32))) as bf_03_accepted_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_04_performer_lookup_ts as Uint32))) as bf_04_performer_lookup_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_05_performer_draft_ts as Uint32))) as bf_05_performer_draft_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_06_performer_found_ts as Uint32))) as bf_06_performer_found_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_07_pickup_arrived_ts as Uint32))) as bf_07_pickup_arrived_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_08_ready_for_pickup_confirmation_ts as Uint32))) as bf_08_ready_for_pickup_confirmation_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_09_pickuped_ts as Uint32))) as bf_09_pickuped_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_10_delivery_arrived_ts as Uint32))) as bf_10_delivery_arrived_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_10a_pay_waiting_ts as Uint32))) as bf_10a_pay_waiting_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_11_ready_for_delivery_confirmation_ts as Uint32))) as bf_11_ready_for_delivery_confirmation_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_12_delivered_ts as Uint32))) as bf_12_delivered_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_13_delivered_finish_ts as Uint32))) as bf_13_delivered_finish_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_00_returning_ts as Uint32))) as rf_00_returning_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_01_return_arrived_ts as Uint32))) as rf_01_return_arrived_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_02_ready_for_return_confirmation_ts as Uint32))) as rf_02_ready_for_return_confirmation_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_03_returned_ts as Uint32))) as rf_03_returned_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_04_returned_finish_ts as Uint32))) as rf_04_returned_finish_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.cf_cancelled_by_performer_ts as Uint32))) as cf_cancelled_by_performer_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.cf_cancelled_by_client_free_ts as Uint32))) as cf_cancelled_by_client_free_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.cf_cancelled_by_client_paid_ts as Uint32))) as cf_cancelled_by_client_paid_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.ff_failed_ts as Uint32))) as ff_failed_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.ff_performer_not_found_ts as Uint32))) as ff_performer_not_found_dttm,

        $datetime_format(DateTime::FromSeconds(CAST(b2b_terminal.terminal_status_ts as Uint32))) as terminal_status_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.claim_point_terminal_ts as Uint32))) as claim_point_terminal_dttm,

    from $claim_status as b2b_status
    left outer join $claim_point_status as b2b_point_status 
    on b2b_status.claim_id = b2b_point_status.claim_id 
    left outer join $claim_terminal_status as b2b_terminal 
    on b2b_point_status.claim_id = b2b_terminal.claim_id
);





insert into $insert_cp_path with truncate
select 
    claim_id,
    claim_point_id,
    bf_09_pickuped_ts,
    bf_10_delivery_arrived_ts,
    bf_10a_pay_waiting_ts,
    bf_11_ready_for_delivery_confirmation_ts,
    bf_12_delivered_ts,
    claim_point_terminal_ts,
    
    $datetime_format(DateTime::FromSeconds(CAST(bf_09_pickuped_ts as Uint32))) as bf_09_pickuped_dttm,
    $datetime_format(DateTime::FromSeconds(CAST(bf_10_delivery_arrived_ts as Uint32))) as bf_10_delivery_arrived_dttm,
    $datetime_format(DateTime::FromSeconds(CAST(bf_10a_pay_waiting_ts as Uint32))) as bf_10a_pay_waiting_dttm,
    $datetime_format(DateTime::FromSeconds(CAST(bf_11_ready_for_delivery_confirmation_ts as Uint32))) as bf_11_ready_for_delivery_confirmation_dttm,
    $datetime_format(DateTime::FromSeconds(CAST(bf_12_delivered_ts as Uint32))) as bf_12_delivered_dttm,
    $datetime_format(DateTime::FromSeconds(CAST(claim_point_terminal_ts as Uint32))) as claim_point_terminal_dttm,
from $b2b_status_cp_data as b2b_cp_status 
;

insert into $insert_c_path with truncate
select 
    b2b_status.claim_id as claim_id,
    bf_00_new_ts,
    bf_01_estimating_ts,
    bf_02_ready_for_approval_ts,
    bf_03_accepted_ts,
    bf_04_performer_lookup_ts,
    bf_05_performer_draft_ts,
    bf_06_performer_found_ts,
    bf_07_pickup_arrived_ts,
    bf_08_ready_for_pickup_confirmation_ts,
    --bf_09_pickuped_ts,
    --bf_10_delivery_arrived_ts,
    --bf_10a_pay_waiting_ts,
    --bf_11_ready_for_delivery_confirmation_ts,
    --bf_12_delivered_ts,
    bf_13_delivered_finish_ts,
    rf_00_returning_ts,
    rf_01_return_arrived_ts,
    rf_02_ready_for_return_confirmation_ts,
    rf_03_returned_ts,
    rf_04_returned_finish_ts,
    cf_cancelled_by_client_free_ts,
    cf_cancelled_by_performer_ts,
    cf_cancelled_by_client_paid_ts,
    ff_performer_not_found_ts,
    ff_failed_ts,

    terminal_status_ts,

        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_00_new_ts as Uint32))) as bf_00_new_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_01_estimating_ts as Uint32))) as bf_01_estimating_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_02_ready_for_approval_ts as Uint32))) as bf_02_ready_for_approval_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_03_accepted_ts as Uint32))) as bf_03_accepted_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_04_performer_lookup_ts as Uint32))) as bf_04_performer_lookup_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_05_performer_draft_ts as Uint32))) as bf_05_performer_draft_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_06_performer_found_ts as Uint32))) as bf_06_performer_found_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_07_pickup_arrived_ts as Uint32))) as bf_07_pickup_arrived_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_08_ready_for_pickup_confirmation_ts as Uint32))) as bf_08_ready_for_pickup_confirmation_dttm,
        --$datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_09_pickuped_ts as Uint32))) as bf_09_pickuped_dttm,
        --$datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_10_delivery_arrived_ts as Uint32))) as bf_10_delivery_arrived_dttm,
        --$datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_10a_pay_waiting_ts as Uint32))) as bf_10a_pay_waiting_dttm,
        --$datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_11_ready_for_delivery_confirmation_ts as Uint32))) as bf_11_ready_for_delivery_confirmation_dttm,
        --$datetime_format(DateTime::FromSeconds(CAST(b2b_point_status.bf_12_delivered_ts as Uint32))) as bf_12_delivered_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.bf_13_delivered_finish_ts as Uint32))) as bf_13_delivered_finish_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_00_returning_ts as Uint32))) as rf_00_returning_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_01_return_arrived_ts as Uint32))) as rf_01_return_arrived_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_02_ready_for_return_confirmation_ts as Uint32))) as rf_02_ready_for_return_confirmation_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_03_returned_ts as Uint32))) as rf_03_returned_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.rf_04_returned_finish_ts as Uint32))) as rf_04_returned_finish_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.cf_cancelled_by_performer_ts as Uint32))) as cf_cancelled_by_performer_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.cf_cancelled_by_client_free_ts as Uint32))) as cf_cancelled_by_client_free_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.cf_cancelled_by_client_paid_ts as Uint32))) as cf_cancelled_by_client_paid_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.ff_failed_ts as Uint32))) as ff_failed_dttm,
        $datetime_format(DateTime::FromSeconds(CAST(b2b_status.ff_performer_not_found_ts as Uint32))) as ff_performer_not_found_dttm,

        $datetime_format(DateTime::FromSeconds(CAST(terminal_status_ts as Uint32))) as terminal_status_dttm,
from $claim_status as b2b_status 
left outer join $claim_terminal_status as b2b_terminal 
    on b2b_status.claim_id = b2b_terminal.claim_id
;
