use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.UseNativeYtTypes;
PRAGMA yt.InferSchema = '1';
PRAGMA yson.DisableStrict;


$claims_path = '//home/taxi/production/replica/postgres/cargo_claims/claims';
$claim_points_path = '//home/taxi/production/replica/postgres/cargo_claims/claim_points';
$payment_on_delivery_path = '//home/taxi/production/replica/postgres/cargo_claims/payment_on_delivery';
$taxi_performer_info_path = '//home/taxi/production/replica/postgres/cargo_claims/taxi_performer_info';
$raw_taxi_performer_info_path = '//home/taxi/production/replica/postgres/cargo_claims/raw/taxi_performer_info';
$ods_taxi_performer_info_path ='//home/delivery-dwh/ods/cargo_claims/taxi_performer_info/taxi_performer_info';

$save_to_path = '//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/eda_claims_with_our_performers';

$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_format_dm_order = DateTime::Format("%Y-%m");
$date_format_first_day_month = DateTime::Format("%Y-%m-01");

/*
$executor_claims_data = (
    select claim_id,
        some(park_id) as park_taximeter_id,
        some(driver_id) as executor_profile_id,
        some(tariff_class) as tariff_class,
    from (select Yson::LookupInt64(doc, "claim_id") as claim_id,
        Yson::LookupString(doc, "park_id") as park_id,
        Yson::LookupString(doc, "driver_id") as driver_id,
        Yson::LookupString(doc, "tariff_class") as tariff_class,
        from $raw_taxi_performer_info_path
        where etl_updated >= "2021-05-01T00:00:00.000000")
    group by claim_id
);*/

$executor_claims_data = (
    select claim_id,
        some(park_taximeter_id) as park_taximeter_id,
        some(executor_profile_id) as executor_profile_id,
        some(tariff_class_code) as tariff_class,
    from $ods_taxi_performer_info_path
    group by claim_id
);



insert into $save_to_path with truncate
SELECT
    c.created_ts,
    $datetime_format(Datetime::FromSeconds(Cast(c.created_ts AS Uint32))) as claim_created_dttm,
    $date_format(Datetime::FromSeconds(Cast(c.created_ts AS Uint32)))  as claim_created_dt,
    c.uuid_id as claim_ref_id,
    c.corp_client_id as corp_client_id,
    c.status as claim_status,
    cp.visit_status as claim_point_visit_status,
    IF(c.status="returned_finish" AND visit_status="visited", "delivered_finish",
        IF(c.status='returned_finish' AND visit_status='skipped', 'returned_finish',
        IF(c.status='returned_finish' AND visit_status='pending', 'unknown',
        IF(c.status='delivered_finish' AND visit_status='skipped', 'unknown',
        IF(c.status='delivered_finish' AND visit_status='pending', 'unknown',
        IF(c.status='delivered_finish' AND visit_status='visited', 'delivered_finish',
        IF(c.status='performer_not_found' AND visit_status='visited', 'unknown',
        IF(c.status='cancelled' AND visit_status='visited', 'unknown',
        IF(c.status='cancelled' AND visit_status!='visited', 'cancelled_by_client_free',
        IF(c.status='cancelled_by_taxi', 'cancelled_by_performer',
        IF(c.status='cancelled_with_payment', 'cancelled_by_client_paid',
                c.status))))))))))) as claim_point_status,
    ex.tariff_class
FROM $claims_path as c
JOIN $claim_points_path as cp
    ON cp.claim_id = c.id
JOIN $payment_on_delivery_path as pay
    ON pay.claim_point_id = cp.id
JOIN $executor_claims_data as ex
    ON ex.claim_id = c.id
WHERE
    --pay.updated_ts > now() - interval '3 hours' and
    --c.zone_id = 'ekb' and
    pay.`flow` = 'external_payment'
    and ex.tariff_class in ['express', 'courier']
--order by c.created_ts DESC
;
