-- витринка по исполнителям для постоплаты 

 
USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- YT constants for input data.
$appmetrica_path = '//home/taxi-dwh/ods/appmetrica/taximeter';
$actual_tags_path = '//home/taxi/production/replica/postgres/tags/actual_tags';
$tag_event_log_path = '//home/taxi-dwh/ods/tags/tag_event_log';
$diagnostics_path = '//home/taxi/production/replica/postgres/cargo_payments/performer_agents';
$full_geo_path = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$fct_order_path = '//home/taxi-dwh/cdm/marketplace/fct_order';
$supply_state_hist = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';

-- Datetime constants.
$date_format = DateTime::Format("%Y-%m-%d");
$date_format_cube = DateTime::Format("%Y-%m-01");
$TODAY = CurrentUtcDate();
--$TODAY = CAST('2021-12-02' as Date);
$DAYS_AGO_30 = $TODAY - Interval('P30D');
$DAYS_AGO_14 = $TODAY - Interval('P14D');
$DAYS_AGO_1 = $TODAY - Interval('P1D');
$TODAY_STR = cast($TODAY as String);

$DT_START = $DAYS_AGO_30;
$DT_END = $DAYS_AGO_1;
--$DTTM_END = CAST($DT_END as Datetime);

$DT_START_STR = cast($DT_START as String);
$DT_END_STR = cast($DT_END as String);
$DTTM_END_STR = $DT_END_STR || ' 23:59:59';
$DRIVER_CUBE_START = $date_format_cube($DT_START);
$DRIVER_CUBE_END = $date_format_cube($DT_END);


-- Tagging config constants.
$LEN_DBID = 32;
$LEN_UUID = 32;


$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$diff_hours_dttm = (($end_dttm, $start_dttm) -> {
    $start = DateTime::MakeDatetime($datetime_parse($start_dttm));
    $end = DateTime::MakeDatetime($datetime_parse($end_dttm));
    RETURN 1.0*Datetime::ToSeconds($end - $start)/(60*60);
});

$TARIFF_LIST = ['express', 'courier'];


-- YT constants for output data 
$insert_path = '//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_executors_monthly/' || $date_format_cube($DT_END);


-- appmetrica data - правильная версия для прода 

$appmetrica_data = (
    select dbid_uuid,
        max_by(app_platform, utc_event_dttm) as app_platform,
        max_by(cast(os_version as Double), utc_event_dttm) as os_version,
        max_by(cast(app_version_name as Double), utc_event_dttm) as app_version_name,
        TryMember(mode(Geo::RoundRegionById(CAST(region_id AS Int32), "city").id)[0], "Value", null) as city_id,
        TryMember(mode(device_manufacturer || '_' || device_model )[0], "Value", null) as device_info,
    from RANGE($appmetrica_path, $DT_START_STR, $DT_END_STR) 
    where len(cast(park_taximeter_id as String))=$LEN_DBID
        and len(cast(executor_profile_id as String))=$LEN_UUID
        and event_name = "ui_event"
        --and os_version is not null 
    group by (park_taximeter_id || '_' || executor_profile_id) as dbid_uuid
);

$diagnostics_devices_data = (
    select 
        device_info,
        max_by(if(Yson::ConvertToBool(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(diagnostics_result)), '/has_nfc'))==True,1,0), diagnostics_ts) as device_has_nfc_flg,
        if(max_by(if(Yson::ConvertToBool(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(diagnostics_result)), '/has_nfc'))==True,1,0), diagnostics_ts) is not null, 1, 0) as device_diagnostics_flg
    from $diagnostics_path as d 
    right join $appmetrica_data as app 
    on app.dbid_uuid = (d.park_id || '_' || d.driver_id)
    group by app.device_info as device_info
);

/*
$appmetrica_facets_my = '//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_executors_supply_v1/' || $DT_END_STR;
-- ретроспективно
$appmetrica_data = (
    select dbid_uuid, app_platform, os_version, app_version_name, city_id 
    from $appmetrica_facets_my
);*/


-- tags info 
/*
$post_payment_tag = (
    select entity as dbid_uuid, 
        max(updated) as post_payment_updated_dttm, 
        1 as post_payment_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="post_payment"
    group by entity
);*/ 

$post_payment_tag = (
    select dbid_uuid,
    MAX_BY(if(deleted_flg and utc_expiration_dttm <= $DTTM_END_STR, 0, 1), utc_updated_dttm) as post_payment_flg,
    MAX_BY(deleted_flg, utc_updated_dttm) as deleted_flg_maxby,
    MAX(utc_updated_dttm) as post_payment_updated_dttm 
    from RANGE($tag_event_log_path, '2020-01-01', $DT_END_STR)
    where tag_code = 'post_payment' and 
        entity_code = 'executor_profile' and 
        utc_updated_dttm <= $DTTM_END_STR
group by entity_first_id || '_' || entity_second_id as dbid_uuid
);

/*
$auto_courier_tag = (
    select entity as dbid_uuid, 
        max(updated) as auto_courier_updated_dttm, 
        1 as auto_courier_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="auto_courier"
    group by entity
);*/ 

$auto_courier_tag = (
    select dbid_uuid,
    MAX_BY(if(deleted_flg and utc_expiration_dttm <= $DTTM_END_STR, 0, 1), utc_updated_dttm) as auto_courier_flg,
    MAX_BY(deleted_flg, utc_updated_dttm) as deleted_flg_maxby,
    MAX(utc_updated_dttm) as auto_courier_updated_dttm

    from RANGE($tag_event_log_path, '2020-01-01', $DT_END_STR)
    where tag_code = 'auto_courier' and 
        entity_code = 'executor_profile' and 
        utc_updated_dttm <= $DTTM_END_STR
group by entity_first_id || '_' || entity_second_id as dbid_uuid
);

/*
$walking_courier_tag = (
    select entity as dbid_uuid, 
        max(updated) as walking_courier_updated_dttm, 
        1 as walking_courier_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="walking_courier"
    group by entity
);*/ 

$walking_courier_tag = (
    select dbid_uuid,
    MAX_BY(if(deleted_flg and utc_expiration_dttm <= $DTTM_END_STR, 0, 1), utc_updated_dttm) as walking_courier_flg,
    MAX_BY(deleted_flg, utc_updated_dttm) as deleted_flg_maxby,
    MAX(utc_updated_dttm) as walking_courier_updated_dttm
    from RANGE($tag_event_log_path, '2020-01-01', $DT_END_STR)
    where tag_code = 'walking_courier' and 
        entity_code = 'executor_profile' and 
        utc_updated_dttm <= $DTTM_END_STR
group by entity_first_id || '_' || entity_second_id as dbid_uuid
);

/*
$allow_card_tag = (
    select entity as dbid_uuid, 
        max(updated) as allow_card_updated_dttm, 
        1 as allow_card_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="cargo_postpayment_diagnostics_allow_card"
    --and substring(updated, 0, 10) <= $DT_END_STR
    group by entity
);
*/

$allow_card_tag = (
    select dbid_uuid,
    MAX_BY(if(deleted_flg and utc_expiration_dttm <= $DTTM_END_STR, 0, 1), utc_updated_dttm) as allow_card_flg,
    MAX_BY(deleted_flg, utc_updated_dttm) as deleted_flg_maxby,
    MAX(utc_updated_dttm) as allow_card_updated_dttm
    from RANGE($tag_event_log_path, '2020-01-01', $DT_END_STR)
    where tag_code = 'cargo_postpayment_diagnostics_allow_card' and 
        entity_code = 'executor_profile' and 
        utc_updated_dttm <= $DTTM_END_STR
group by entity_first_id || '_' || entity_second_id as dbid_uuid
);


$thermobag_confirmed_tag = (
    select dbid_uuid,
    MAX_BY(if(deleted_flg and utc_expiration_dttm <= $DTTM_END_STR, 0, 1), utc_updated_dttm) as thermobag_confirmed_flg,
    MAX_BY(deleted_flg, utc_updated_dttm) as deleted_flg_maxby,
    MAX(utc_updated_dttm) as thermobag_confirmed_updated_dttm
    from RANGE($tag_event_log_path, '2020-01-01', $DT_END_STR)
    where tag_code = 'thermobag_confirmed' and 
        entity_code = 'executor_profile' and 
        utc_updated_dttm <= $DTTM_END_STR
group by entity_first_id || '_' || entity_second_id as dbid_uuid
);


$courier_knows_about_postpayment_tag = (
    select dbid_uuid,
    MAX_BY(if(deleted_flg and utc_expiration_dttm <= $DTTM_END_STR, 0, 1), utc_updated_dttm) as courier_knows_about_postpayment_flg,
    MAX_BY(deleted_flg, utc_updated_dttm) as deleted_flg_maxby,
    MAX(utc_updated_dttm) as courier_knows_about_postpayment_updated_dttm
    from RANGE($tag_event_log_path, '2020-01-01', $DT_END_STR)
    where tag_code = 'cargo_courier_knows_about_postpayment' and 
        entity_code = 'executor_profile' and 
        utc_updated_dttm <= $DTTM_END_STR
group by entity_first_id || '_' || entity_second_id as dbid_uuid
);





$diagnostics_data = (
    select dbid_uuid,
    1 as diagnostics_flg,
    max(created_ts) as created_ts,
    max(updated_ts) as updated_ts,
    max(diagnostics_ts) as diagnostics_ts,
    max_by(diagnostics_result, diagnostics_ts) as diagnostics_result,
    max(last_order_ts) as last_order_ts,
    max_by(if(Yson::ConvertToBool(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(diagnostics_result)), '/has_nfc'))==True,1,0), diagnostics_ts) as has_nfc_flg,
    max_by(if(Yson::ConvertToBool(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(diagnostics_result)), '/is_passed'))==True,1,0), diagnostics_ts) as is_passed_flg,
    max_by(if(Yson::ConvertToBool(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(diagnostics_result)), '/has_tap2go_installed'))==True,1,0), diagnostics_ts) as has_tap2go_installed_flg,
    max_by(if(diagnostics_allow_card==True,1,0), diagnostics_ts) as diagnostics_allow_card_flg,
    max_by(if(Yson::ConvertToBool(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(diagnostics_result)), '/has_google_play_services'))==True,1,0), diagnostics_ts) as has_google_play_services_flg,
    max_by(if(Yson::ConvertToBool(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(diagnostics_result)), '/has_required_android_ver'))==True,1,0), diagnostics_ts) as has_required_android_ver_flg
    --case when JSON_VALUE(diagnostics_result, '$.has_nfc') == 'true' then 1 else 0 end as has_nfc_flg,
    --case when JSON_VALUE(diagnostics_result, '$.is_passed') == 'true' then 1 else 0 end as is_passed_flg,
    --case when JSON_VALUE(diagnostics_result, '$.has_tap2go_installed') == 'true' then 1 else 0 end as has_tap2go_installed_flg
from $diagnostics_path
group by (park_id || '_' || driver_id) as dbid_uuid
);

/*
$geo = (
    SELECT 
        geobase_id, 
        SOME(country_name) AS country_name,
        SOME(agglomeration_name) AS agglomeration_name,
        SOME(population_group) as population_group
    FROM (
        SELECT
            CAST(a.geobase_id as Int32) as geobase_id,
            b.name_ru as agglomeration_name,
            a.tz_country_name_ru as country_name,
            a.population_group as population_group
        FROM $full_geo_path as a
        JOIN  $full_geo_path as b
        ON a.agglomeration_node_id = b.node_id
        WHERE a.geobase_id IS NOT NULL
    ) GROUP BY  geobase_id
);*/

$fct_order_by_executor_data = (
    select dbid_uuid,
        TryMember(mode(tariff_geo_zone_code)[0], "Value", null) as tz_mode_orders, 
        count(*) as orders_last_30_days_cnt,
        count_if(tariff_class_code = 'express') as orders_express_last_30_days_cnt,
        count_if(tariff_class_code = 'courier') as orders_courier_last_30_days_cnt,
        max(if(tariff_class_code in $TARIFF_LIST, utc_order_created_dttm, null)) as last_delivery_order_dttm,
        max(if(tariff_class_code in $TARIFF_LIST, utc_order_created_dt, null)) as last_delivery_order_dt,
        max(utc_order_created_dttm) as last_order_dttm,
        max(utc_order_created_dt) as last_order_dt,

    from RANGE($fct_order_path, $DRIVER_CUBE_START, $DRIVER_CUBE_END) as fo 
    where --tariff_class_code in $TARIFF_LIST
        utc_order_created_dt <= $DT_END_STR and utc_order_created_dt >= $DT_START_STR
    group by fo.taximeter_park_id || '_' || fo.executor_profile_id as dbid_uuid
);



$supply_state_hist_free_sh = (
    select dbid_uuid, dt,
        sum($diff_hours_dttm(utc_valid_to_dttm, utc_valid_from_dttm)) as sh_del_free,
        sum_if($diff_hours_dttm(utc_valid_to_dttm, utc_valid_from_dttm), 'express' in Yson::ConvertToStringList(enabled_tariff_class_code_list)) as sh_express_free,
        sum_if($diff_hours_dttm(utc_valid_to_dttm, utc_valid_from_dttm), 'courier' in Yson::ConvertToStringList(enabled_tariff_class_code_list)) as sh_courier_free,
    from RANGE($supply_state_hist, $DT_END_STR, $TODAY_STR) 
    where executor_status_code = 'free' 
        and 
        -- один из тарифов списка
        ListLength(SetIntersection(ToSet(Yson::ConvertToStringList(enabled_tariff_class_code_list)), ToSet($TARIFF_LIST))) > 0
        and substring(utc_valid_from_dttm, 0, 10) = $DT_END_STR
    group by park_taximeter_id || '_' || executor_profile_id as dbid_uuid,
        substring(utc_valid_from_dttm, 0, 10) as dt
);



$fct_order_del_data = (
    select taximeter_park_id || '_' || executor_profile_id as dbid_uuid, 
        order_id, tariff_class_code, 
        utc_order_created_dt,
    from RANGE($fct_order_path, $DRIVER_CUBE_START, $DRIVER_CUBE_END)
    where tariff_class_code in $TARIFF_LIST
        and utc_order_created_dt = $DT_END_STR
);


$supply_state_hist_orders_sh = (
    select dbid_uuid,
        dt,
        sum($diff_hours_dttm(utc_valid_to_dttm, utc_valid_from_dttm)) as sh_del_orders,
        sum_if($diff_hours_dttm(utc_valid_to_dttm, utc_valid_from_dttm), 'express' in Yson::ConvertToStringList(enabled_tariff_class_code_list)) as sh_express_orders,
        sum_if($diff_hours_dttm(utc_valid_to_dttm, utc_valid_from_dttm), 'courier' in Yson::ConvertToStringList(enabled_tariff_class_code_list)) as sh_courier_orders,
    from RANGE($supply_state_hist, $DT_END_STR, $TODAY_STR) as ssh 
    inner join $fct_order_del_data as fo 
    on fo.order_id == ssh.order_id
    where executor_status_code in ['driving', 'waiting', 'transporting']
        and 
        -- один из тарифов списка
        tariff_class_code in $TARIFF_LIST
        and 
        substring(utc_valid_from_dttm, 0, 10) = $DT_END_STR
    group by park_taximeter_id || '_' || executor_profile_id as dbid_uuid,
        substring(utc_valid_from_dttm, 0, 10) as dt
);

$full_geo = (
    select tariff_zone, some(population_group) as population_group, some(tz_country_name_ru) as country_name
    from $full_geo_path
    where root_node_id = 'br_root' 
    --and updated <= $datetime_format($DT_END)
    group by tariff_zone
);

$join_result = (
    select distinct $DT_END_STR as dt,
    fct_order_exec.dbid_uuid as dbid_uuid, fct_order_exec.tz_mode_orders as tz_mode_orders,
    geo.population_group as population_group, geo.country_name as country_name,

    orders_last_30_days_cnt,
    orders_express_last_30_days_cnt,
    orders_courier_last_30_days_cnt,
    last_delivery_order_dttm,
    last_delivery_order_dt,
    last_order_dttm,
    last_order_dt,

    app_version_name, app_platform, os_version,


    coalesce(sh_del_free, 0) as sh_del_free,
    coalesce(sh_express_free, 0) as sh_express_free,
    coalesce(sh_courier_free, 0) as sh_courier_free,

    coalesce(sh_del_orders, 0) as sh_del_orders,
    coalesce(sh_express_orders, 0) as sh_express_orders,
    coalesce(sh_courier_orders, 0) as sh_courier_orders,

    coalesce(sh_del_free, 0)+coalesce(sh_del_orders, 0) as sh_del, 
    coalesce(sh_express_free, 0)+coalesce(sh_express_orders, 0) as sh_express, 
    coalesce(sh_courier_free, 0)+coalesce(sh_courier_orders, 0) as sh_courier,

    
    /* postpayment data */
    coalesce(post_payment_flg, 0) as post_payment_flg,
    post_payment_updated_dttm,
    
    /* walking_courier data */
    coalesce(walking_courier_flg, 0) as walking_courier_flg,
    walking_courier_updated_dttm,

    /* auto_courier data */
    coalesce(auto_courier_flg, 0) as auto_courier_flg,
    auto_courier_updated_dttm,

    /* diagnostics data */
    coalesce(diagnostics_flg, 0) as diagnostics_flg,
    -- тут без coalesce, т.к. для людей не из этого списка мы просто ничего не знаем
    created_ts,
    updated_ts,
    diagnostics_ts,
    last_order_ts,
    has_nfc_flg,
    is_passed_flg,
    has_tap2go_installed_flg,
    diagnostics_allow_card_flg,
    has_google_play_services_flg,
    has_required_android_ver_flg,


    /* allow_card data */
    coalesce(allow_card_flg, 0) as allow_card_flg,
    allow_card_updated_dttm,
    coalesce(courier_knows_about_postpayment_flg, 0) as courier_knows_about_postpayment_flg,
    courier_knows_about_postpayment_updated_dttm,
    coalesce(thermobag_confirmed_flg, 0) as thermobag_confirmed_flg,
    thermobag_confirmed_updated_dttm,

    app.device_info as device_info,
    device_has_nfc_flg,


    from $fct_order_by_executor_data AS fct_order_exec 
    left join $supply_state_hist_orders_sh as ssh_orders 
    on ssh_orders.dbid_uuid == fct_order_exec.dbid_uuid
    left join $supply_state_hist_free_sh as ssh_free
    on ssh_free.dbid_uuid == fct_order_exec.dbid_uuid
    left join $post_payment_tag AS post_payment_tag_data
    on post_payment_tag_data.dbid_uuid == fct_order_exec.dbid_uuid
    left join $walking_courier_tag AS walking_courier_tag_data
    on walking_courier_tag_data.dbid_uuid == fct_order_exec.dbid_uuid
    left join $auto_courier_tag AS auto_courier_tag_data
    on auto_courier_tag_data.dbid_uuid == fct_order_exec.dbid_uuid
    left join $thermobag_confirmed_tag AS thermobag_confirmed_tag_data
    on thermobag_confirmed_tag_data.dbid_uuid == fct_order_exec.dbid_uuid
    left join $courier_knows_about_postpayment_tag AS courier_knows_about_postpayment_tag_data
    on courier_knows_about_postpayment_tag_data.dbid_uuid == fct_order_exec.dbid_uuid
    left join $diagnostics_data AS diagnostics_data
    on diagnostics_data.dbid_uuid == fct_order_exec.dbid_uuid
    left join $allow_card_tag AS allow_card_tag_data
    on allow_card_tag_data.dbid_uuid == fct_order_exec.dbid_uuid
    left join $full_geo as geo 
    on geo.tariff_zone == fct_order_exec.tz_mode_orders
    
    left join $appmetrica_data as app 
    on app.dbid_uuid == fct_order_exec.dbid_uuid
    left join $diagnostics_devices_data as diag_data 
    on diag_data.device_info == app.device_info
    where fct_order_exec.tz_mode_orders is not null
);


insert into $insert_path 
select * from $join_result;

insert into `//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_executors_supply_actual` with truncate
select * from $join_result;
