use chyt.hahn/taxi-delivery;

INSERT INTO "<append=%false>//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/tableau_supply_funnel_for_cities" 
--create table `//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/tableau_supply_funnel_for_cities` ENGINE=YtTable() as 
WITH tbl AS 
(select utc_date, 
    --'2021-06-09' as utc_date, 
    country_name, 
    population_group, tz_mode_orders,

    -- All 
    sum(1) as exec_cnt,
    --Наш саплай
    sum(case when auto_courier_flg == 1 or walking_courier_flg == 1 then 1 else 0 end) as exec_tags_cnt,

    --Активные курьеры (хотя бы один заказ за последние 14 дней)
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1 )
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm)) 
                then 1 else 0 end) as exec_active_last_week_cnt,

    --Android
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1 )
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                then 1 else 0 end) as exec_android_cnt,

    --Android >= 9
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1 )
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                then 1 else 0 end) as exec_os_version_9_or_more_cnt, 

    --App >= 9.89
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1) 
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                then 1 else 0 end) as exec_app_ver_9_89_or_more_cnt, 

    --Доступен для диспатча
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0) + coalesce(courier_knows_about_postpayment_flg,0)+coalesce(allow_card_flg,0) > 0 
                then 1 else 0 end) as exec_dispatch_available_cnt,


    --Включена постоплата
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0) == 1
                then 1 else 0 end) as exec_postpayment_cnt,

    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1) 
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND diagnostics_flg == 1
                AND coalesce(post_payment_flg, 0)  == 1
                AND (coalesce(has_nfc_flg, 0) == 0 or coalesce(has_nfc_flg,0)*coalesce(allow_card_flg,0)==1) 
                then 1 else 0 end) as exec_postpayment_diagnostics_complete_cnt,
    
    --NFC 
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1) 
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0)  == 1
                AND coalesce(has_nfc_flg, 0) == 1
                then 1 else 0 end) as exec_has_nfc_cnt,
    
    --Tap2Go
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1) 
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0)  == 1
                AND coalesce(has_nfc_flg, 0) == 1
                AND coalesce(has_tap2go_installed_flg, 0) == 1
                then 1 else 0 end) as exec_tap2go_cnt,

    --Allow card tag
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0)  == 1
                AND coalesce(has_nfc_flg, 0) == 1
                AND coalesce(has_tap2go_installed_flg, 0) == 1
                AND coalesce(allow_card_flg, 0) == 1
                then 1 else 0 end) as exec_allow_card_cnt,

    --thermobag!!!!
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0) + coalesce(courier_knows_about_postpayment_flg,0)+coalesce(allow_card_flg,0) > 0 
                AND coalesce(thermobag_confirmed_flg, 0) == 1
                then 1 else 0 end) as exec_dispatch_available_thermobag_cnt,

    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
                AND toDateTime(last_delivery_order_dttm) >= dateadd(WEEK, -2, toDateTime(last_delivery_order_dttm))
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0) + coalesce(courier_knows_about_postpayment_flg,0)+coalesce(allow_card_flg,0) > 0 
                AND coalesce(thermobag_confirmed_flg, 0) == 1
                AND coalesce(allow_card_flg, 0) == 1 
                then 1 else 0 end) as exec_allow_card_thermobag_cnt,


    --All 
    sum(sh_del) as exec_sh,
        --Наш саплай
    sum(case when auto_courier_flg == 1 or walking_courier_flg == 1 then sh_del else 0 end) as exec_tags_sh,

    --условие на активность бессмысленно здесь

    --Android
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1 )
        
                AND app_platform == 'android'
                then sh_del else 0 end) as exec_android_sh,

    --Android >= 9
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1 )
                
                AND app_platform == 'android'
                AND os_version >= 9
                then sh_del else 0 end) as exec_os_version_9_or_more_sh, 

    --App >= 9.89
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1) 
                
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                then sh_del else 0 end) as exec_app_ver_9_89_or_more_sh, 

    --Доступен для диспатча
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
                
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0) + coalesce(courier_knows_about_postpayment_flg,0)+coalesce(allow_card_flg,0) > 0 
                then sh_del else 0 end) as exec_dispatch_available_sh,


    --Включена постоплата
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
               
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0) == 1
                then sh_del else 0 end) as exec_postpayment_sh,

    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1) 
                
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND diagnostics_flg == 1
                AND coalesce(post_payment_flg, 0)  == 1
                AND (coalesce(has_nfc_flg, 0) == 0 or coalesce(has_nfc_flg,0)*coalesce(allow_card_flg,0)==1) 
                then sh_del else 0 end) as exec_postpayment_diagnostics_complete_sh,
    
    --NFC 
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1) 
               
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0)  == 1
                AND coalesce(has_nfc_flg, 0) == 1
                then sh_del else 0 end) as exec_has_nfc_sh,
    
    --Tap2Go
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1) 
              
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0)  == 1
                AND coalesce(has_nfc_flg, 0) == 1
                AND coalesce(has_tap2go_installed_flg, 0) == 1
                then sh_del else 0 end) as exec_tap2go_sh,

    --Allow card tag
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
                
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0)  == 1
                AND coalesce(has_nfc_flg, 0) == 1
                AND coalesce(has_tap2go_installed_flg, 0) == 1
                AND coalesce(allow_card_flg, 0) == 1
                then sh_del else 0 end) as exec_allow_card_sh,

    
    --thermobag!!!!
    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
                
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0) + coalesce(courier_knows_about_postpayment_flg,0)+coalesce(allow_card_flg,0) > 0 
                AND coalesce(thermobag_confirmed_flg, 0) == 1
                then sh_del else 0 end) as exec_dispatch_available_thermobag_sh,

    sum(case when (auto_courier_flg == 1 or walking_courier_flg == 1)
                
                AND app_platform == 'android'
                AND os_version >= 9
                AND app_version_name >= 9.89
                AND coalesce(post_payment_flg, 0) + coalesce(courier_knows_about_postpayment_flg,0)+coalesce(allow_card_flg,0) > 0 
                AND coalesce(thermobag_confirmed_flg, 0) == 1
                AND coalesce(allow_card_flg, 0) == 1 
                then sh_del else 0 end) as exec_allow_card_thermobag_sh


    --from "//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_executors_supply_actual" as abt 
    from concatYtTablesRange("//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_executors_monthly") as abt 
    --from "//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_executors_supply/2021-06-09" as abt
    group by  dt as utc_date, country_name, 
    population_group, tz_mode_orders
)

select * from tbl 
where country_name = 'Россия';




INSERT INTO "<append=%false>//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/tableau_supply_funnel_for_nfc_and_tazimeter_ver" 
--create table `//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/tableau_supply_funnel_for_nfc_and_tazimeter_ver` ENGINE=YtTable() as 
WITH tbl AS 
(select dt as utc_date, 
    --'2021-06-09' as utc_date, 
    country_name, 
    population_group, tz_mode_orders, 
    if(app_version_name <= 9.89, 'old', toString(app_version_name)) as taximeter_ver,
    if(device_has_nfc_flg=1, 'has nfc', 'no nfc') as nfc_info,
    app_platform,
    os_version,
    count(*) as executors_count
    
    from concatYtTablesRange("//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_executors_monthly") as abt 
    where auto_courier_flg == 1 or walking_courier_flg == 1
    group by dt as utc_date, 
    --'2021-06-09' as utc_date, 
    country_name, 
    population_group, tz_mode_orders, 
    if(app_version_name <= 9.89, 'old', toString(app_version_name)) as taximeter_ver,
    if(device_has_nfc_flg=1, 'has nfc', 'no nfc') as nfc_info,
    app_platform,
    os_version

)

select * from tbl 
where country_name = 'Россия';
