USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;


-- YT constants for input data.
$appmetrica_path = '//home/taxi-dwh/ods/appmetrica/taximeter';
$actual_tags_path = '//home/taxi/production/replica/postgres/tags/actual_tags';
$diagnostics_path = '//home/taxi/production/replica/postgres/cargo_payments/performer_agents';

-- Datetime constants.
$TODAY = CurrentUtcDate();
$DAYS_AGO_33 = $TODAY - Interval('P33D');
$DAYS_AGO_3 = $TODAY - Interval('P3D');


$DT_START = $DAYS_AGO_33;
$DT_END = $DAYS_AGO_3;

$DT_START_STR = cast($DT_START as String);
$DT_END_STR = cast($DT_END as String);

-- Tagging config constants.
$LEN_DBID = 32;
$LEN_UUID = 32;


-- appmetrica data 
$appmetrica_data = (
    select dbid_uuid,
        max_by(app_platform, utc_event_dttm) as app_platform,
        max_by(cast(os_version as Double), utc_event_dttm) as os_version,
        max_by(cast(app_version_name as Double), utc_event_dttm) as app_version_name,
        TryMember(mode(Geo::RoundRegionById(CAST(region_id AS Int32), "city").id)[0], "Value", null) as city_id,
        TryMember(mode(device_manufacturer || '_' || device_model )[0], "Value", null) as device_info,
    from RANGE($appmetrica_path, $DT_START_STR, $DT_END_STR) 
    where len(cast(park_taximeter_id as String))=$LEN_DBID
        and len(cast(executor_profile_id as String))=$LEN_UUID
    group by (park_taximeter_id || '_' || executor_profile_id) as dbid_uuid
);


-- tags info 
$post_payment_tag = (
    select entity as dbid_uuid, 
        max(updated) as post_payment_updated_dttm, 
        1 as post_payment_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="post_payment"
    group by entity
);


$auto_courier_tag = (
    select entity as dbid_uuid, 
        max(updated) as auto_courier_updated_dttm, 
        1 as auto_courier_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="auto_courier"
    group by entity
);

$postpayment_option_required_tag = (
    select entity as dbid_uuid, 
        max(updated) as postpayment_option_required_updated_dttm, 
        1 as postpayment_option_required_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="cargo_postpayment_option_required"
    --and substring(updated, 0, 10) <= $DT_END_STR
    group by entity
);


$walking_courier_tag = (
    select entity as dbid_uuid, 
        max(updated) as walking_courier_updated_dttm, 
        1 as walking_courier_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="walking_courier"
    group by entity
);


$allow_card_tag = (
    select entity as dbid_uuid, 
        max(updated) as allow_card_updated_dttm, 
        1 as allow_card_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="cargo_postpayment_diagnostics_allow_card"
    --and substring(updated, 0, 10) <= $DT_END_STR
    group by entity
);


$diagnostics_devices_data = (
    select 
        device_info,
        max_by(if(Yson::ConvertToBool(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(diagnostics_result)), '/has_nfc'))==True,1,0), diagnostics_ts) as device_has_nfc_flg,
        if(max_by(if(Yson::ConvertToBool(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(diagnostics_result)), '/has_nfc'))==True,1,0), diagnostics_ts) is not null, 1, 0) as device_diagnostics_flg
    from $diagnostics_path as d 
    right join $appmetrica_data as app 
    on app.dbid_uuid = (d.park_id || '_' || d.driver_id)
    group by app.device_info as device_info
);


$courier_knows_about_postpayment_tag = (
    select entity as dbid_uuid, 
        max(updated) as courier_knows_about_postpayment_updated_dttm, 
        1 as courier_knows_about_postpayment_flg
    from $actual_tags_path
    where active  and entity_type =="dbid_uuid"
    and tag="cargo_courier_knows_about_postpayment"
    --and substring(updated, 0, 10) <= $DT_END_STR
    group by entity
);

$executors_nfc_approximation = (
    select appmetrica_data.*,

        device_diagnostics_flg,
        device_has_nfc_flg,


        /* postpayment data */
        coalesce(post_payment_flg, 0) as post_payment_flg,
        post_payment_updated_dttm,
    
        /* walking_courier data */
        coalesce(walking_courier_flg, 0) as walking_courier_flg,
        walking_courier_updated_dttm,

        /* auto_courier data */
        coalesce(auto_courier_flg, 0) as auto_courier_flg,
        auto_courier_updated_dttm,

        coalesce(courier_knows_about_postpayment_flg, 0) as courier_knows_about_postpayment_flg,
        courier_knows_about_postpayment_updated_dttm,

        coalesce(postpayment_option_required_flg, 0) as postpayment_option_required_flg,
        postpayment_option_required_updated_dttm,

        /* allow_card data */
        coalesce(allow_card_flg, 0) as allow_card_flg,
        allow_card_updated_dttm,

    from $appmetrica_data as appmetrica_data 
    left join $diagnostics_devices_data as dd 
    on dd.device_info = appmetrica_data.device_info
    left join $post_payment_tag AS post_payment_tag_data
    on post_payment_tag_data.dbid_uuid == appmetrica_data.dbid_uuid
    left join $walking_courier_tag AS walking_courier_tag_data
    on walking_courier_tag_data.dbid_uuid == appmetrica_data.dbid_uuid
    left join $auto_courier_tag AS auto_courier_tag_data
    on auto_courier_tag_data.dbid_uuid == appmetrica_data.dbid_uuid
    left join $allow_card_tag AS allow_card_tag_data
    on allow_card_tag_data.dbid_uuid == appmetrica_data.dbid_uuid
    left join $postpayment_option_required_tag AS postpayment_option_required_tag_data
    on postpayment_option_required_tag_data.dbid_uuid == appmetrica_data.dbid_uuid
    left join $courier_knows_about_postpayment_tag AS courier_knows_about_postpayment_tag_data
    on courier_knows_about_postpayment_tag_data.dbid_uuid == appmetrica_data.dbid_uuid
);


insert into `//home/taxi-delivery/analytics/dev/product/postpayment/nfc_data/appmetrica_device_data` with truncate
select * from $appmetrica_data;

insert into `//home/taxi-delivery/analytics/dev/product/postpayment/nfc_data/diagnostics_nfc_data` with truncate
select * from $diagnostics_devices_data;

insert into `//home/taxi-delivery/analytics/dev/product/postpayment/nfc_data/nfc_appr` with truncate
select * from $executors_nfc_approximation;


$all_our_executors = (
    select count(*) as cnt_all
    from $executors_nfc_approximation
    where walking_courier_flg=1 or auto_courier_flg=1
);


insert into `//home/taxi-delivery/analytics/dev/product/postpayment/nfc_data/nfc_approximation_aggregation` with truncate 
select device_info, 
    count(*) as executors_cnt,
    1.0*count(*) / total.cnt_all as executors_frac,
    device_has_nfc_flg,
    device_diagnostics_flg,
from $executors_nfc_approximation as appr 
cross join $all_our_executors as total 
where walking_courier_flg=1 or auto_courier_flg=1
group by appr.device_info as device_info, 
    appr.device_has_nfc_flg as device_has_nfc_flg, 
    appr.device_diagnostics_flg as device_diagnostics_flg, 
    total.cnt_all 