use hahn;
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;


/*
В рамках задачи   TAXIMETER-13741 Протестировано [постоплата] Добавить обработку события SDK Tap2Go - успешная оплата megatron мы сделали возможность получения статуса платежа напрямую из SDK tap2go не дожидаясь стандартного колбека из бэкенда 2Can в бэкенд Яндекс, что должно ускорить обработку платежа в ПРО.
Но у нас есть страх, что курьеру начнут фродить, поэтому мы все равно в фоне контролируем получение колбека. Чтобы не кодить автоматизированный контроль курьера, прошу сделать табличку на УТ со следующими полями:


claim id
id курьера
время ответа SDK tap2go
время получения колбека от 2Can


В pg cargo_payments (есть реплика для YT) происходит следующее:
Когда переводим платеж в статус Оплачен (authorized) добавляем в таблицу payments поле transaction_data.
В случае который описан в тикете в transaction_data нету rrn (выглядит примерно так transaction_data: {"transaction_id": "SOME_ID"})
В случае когда переводим платеж в authorized через колбек выглядит примерно так transaction_data: {"transaction_id": "SOME_ID", "rrn": "SOME_RRN"}
Есть таблица payments_history в которую попадают изменения, от туда нужно вычленить ситуации первого вида, время ответа SDK в таком случае будет history_timestamp в status = authorized с transaction_data без rrn.

Факт прихода колбека кроме того фиксируется в таблице transactions.
Время прихода колбека: history_timestamp
Интересует транзакция с type = "payment" AND payment_id = payments.id*/

--cargo_claims folder 
$claims_path = '//home/taxi/production/replica/postgres/cargo_claims/claims';
$claim_points_path = '//home/taxi/production/replica/postgres/cargo_claims/claim_points';
$payment_on_delivery_path = '//home/taxi/production/replica/postgres/cargo_claims/payment_on_delivery';
$taxi_order_changes_path = '//home/taxi/production/replica/postgres/cargo_claims/taxi_order_changes';
$taxi_performer_info_path = '//home/taxi/production/replica/postgres/cargo_claims/taxi_performer_info';

--cargo_payments folder 
$transactions_path = '//home/taxi/production/replica/postgres/cargo_payments/transactions';
$payments_path = '//home/taxi/production/replica/postgres/cargo_payments/payments';
$payments_history_path = '//home/taxi/production/replica/postgres/cargo_payments/payments_history';
$payment_performers_path = '//home/taxi/production/replica/postgres/cargo_payments/payment_performers';

$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');

/*
$executor_claims_data = (
    select claim_id,
        some(park_id || '_' || driver_id) as dbid_uuid,
    from $taxi_performer_info_path
    group by claim_id
);
*/

insert into `//home/taxi-delivery/analytics/dev/product/postpayment/payment_process/sdk_tap2go_and_callback_2can` with truncate 
select payment_id, 
    
    /*transaction_data,
    if(Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/transaction_id')) is null, 0, 1) as transaction_id_flg,
    if(Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/rrn')) is null, 0, 1) as rrn_flg,*/ 

    max(case when status = 'confirmed' then ph.history_timestamp else null end) as confirmed_timestamp ,
    $datetime_format(Datetime::FromSeconds(CAST(max(case when status = 'confirmed' then ph.history_timestamp else null end) as Uint32))) as confirmed_datetime,

    max(case when status = 'authorized' 
            and Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/rrn')) is null -- rrn is null 
            and Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/transaction_id')) is not null --transaction id is not null 
            then ph.history_timestamp else null end) as sdk_tap2go_timestamp, 
    $datetime_format(Datetime::FromSeconds(CAST(max(case when status = 'authorized' 
            and Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/rrn')) is null -- rrn is null 
            and Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/transaction_id')) is not null --transaction id is not null 
            then ph.history_timestamp else null end) as Uint32))) as sdk_tap2go_datetime,
    
     
    /*max(case when status = 'authorized' 
            and Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/rrn')) is not null -- rrn is not null 
            and Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/transaction_id')) is not null --transaction id is not null 
            then ph.history_timestamp else null end) as timestamp_callback_2can_another_way, */
    max(tr.history_timestamp) as callback_2can_timestamp,
    $datetime_format(Datetime::FromSeconds(CAST(max(tr.history_timestamp) as Uint32))) as callback_2can_datetime,

    some(external_id) as external_id,
    some(SUBSTRING(external_id, NULL, COALESCE(FIND(external_id, '/'), 0))) as claim_ref_id,
    --SUBSTRING(external_id, COALESCE(FIND(external_id, '/'), LENGTH(external_id))+CAST(1 as Uint32)) as point_id_str,
    some(CAST(SUBSTRING(external_id, COALESCE(FIND(external_id, '/'), LENGTH(external_id))+CAST(1 as Uint32)) AS Int64)) as claim_point_id,
    some(park_id || '_' || driver_id) as dbid_uuid

from $payments_history_path as ph 
left join $transactions_path as tr 
on tr.payment_id = ph.id 
left join $payment_performers_path as pp 
on pp.payment_id = ph.id 
where tr.type = 'payment' --and virtual_client_id == '176a4fcc-90f3-4ddc-909f-a8acdd5fe818' --заказы Доставки
    and FIND(external_id, '/') is not null --external_id хороший
group by ph.id as payment_id
-- возможно добавим позже этот фильтр чтобы оставить только кейсы из тикета (пока таких кейсов нет и таблица получится пустой)
/*having max(case when status = 'authorized' 
            and Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/rrn')) is null -- rrn is null 
            and Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Yson::ConvertToString(transaction_data, Yson::Options(false as Strict))), '/transaction_id')) is not null --transaction id is not null 
            then ph.history_timestamp else null end) is not null */