use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.UseNativeYtTypes;
PRAGMA yt.InferSchema = '1';
PRAGMA yson.DisableStrict;


$ods_taxi_performer_info_path ='//home/delivery-dwh/ods/cargo_claims/taxi_performer_info';
$ods_payment_on_delivery_path = '//home/delivery-dwh/ods/cargo_claims/payment_on_delivery';
$ods_claim_path = '//home/delivery-dwh/ods/cargo_claims/claim';
$ods_claim_points_path = '//home/delivery-dwh/ods/cargo_claims/claim_point';
$ods_point_path = '//home/delivery-dwh/ods/cargo_claims/point';
$ods_billing_path = '//home/delivery-dwh/ods/cargo_payments/billing_task_log';
$ods_payment_path = '//home/delivery-dwh/ods/cargo_payments/payment';

$corp_clients = '//home/taxi/production/replica/mongo/struct/corp/corp_clients';


$save_to_path = '//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_demand/monitor_claim_points_and_cr';

$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_format_dm_order = DateTime::Format("%Y-%m");
$date_format_first_day_month = DateTime::Format("%Y-%m-01");
$date_format_first_day_year = DateTime::Format("%Y-01-01");

$start_dt = CurrentUtcDate() - Interval('P30D');

$cancel_list = ['cancelled','cancelled_with_payment','cancelled_by_taxi'];

$payments_eda_clients = ['4decd14f25424e8b82b6d3e4f56d23b2',
                           'b2dc2b2e96f8482ba2d1582bd1445184', -- есть
                           '87cda4c03d60416bb522e83fe24b3d50', -- есть, Казахстан. Будет еще Беларусь в еде
                           '162b9899216246f7a1ba9fc14a479e87', -- Беларусь, новый договор -  это все Еда
                           -- 'dc28c565829e48cca458b5feb161d5d6', -- Лавка
                           --'4ee0ceca18ce41e3895786796a967e78', -- Лавка
                           --'bfd05979e380486d9181b62fa05d1fc9' -- Лавка
];


$payments_accepted = (
    select String::RemoveAll(id, "-") as payment_id
    from `//home/taxi/production/replica/postgres/cargo_payments/payments`
);
/*
$executor_claims_data = (
    select claim_id,
        some(park_id) as park_taximeter_id,
        some(driver_id) as executor_profile_id,
        some(tariff_class) as tariff_class,
    from (select Yson::LookupInt64(doc, "claim_id") as claim_id,
        Yson::LookupString(doc, "park_id") as park_id,
        Yson::LookupString(doc, "driver_id") as driver_id,
        Yson::LookupString(doc, "tariff_class") as tariff_class,
        from $raw_taxi_performer_info_path
        where etl_updated >= "2021-05-01T00:00:00.000000")
    group by claim_id
);*/


$billing_data =(
select
    payment_id,
    meta_order_id,
    payment_method_code,
    refund_flg,
    tariff_code,
    transaction_lcy_amt,
    --billing_type,
    billing_status
from RANGE($ods_billing_path, $date_format_first_day_year($start_dt))
where billing_type == "user_on_delivery_payment" -- наложенный платеж
);



$corp_clients_data = (
    select client_id,
        maxby(name, created) as corp_client_name
    from $corp_clients
    group by id as client_id
);


$executor_claims_data = (
    select claim_id,
        some(park_taximeter_id) as park_taximeter_id,
        some(executor_profile_id) as executor_profile_id,
        some(tariff_class_code) as tariff_class,
    from RANGE($ods_taxi_performer_info_path, $date_format_first_day_month($start_dt))
    group by claim_id
);



insert into $save_to_path with truncate
SELECT
    c.utc_created_dttm as claim_created_dttm,
    substring(c.utc_created_dttm, 0, 10) as claim_created_dt,
    --$datetime_format(Datetime::FromSeconds(Cast(c.created_ts AS Uint32))) as claim_created_dttm,
    --$date_format(Datetime::FromSeconds(Cast(c.created_ts AS Uint32)))  as claim_created_dt,
    c.cargo_ref_id as claim_ref_id,
    c.corp_client_id as corp_client_id,
    c.status_code as claim_status,
    cp.visit_status as claim_point_visit_status,
    c.claim_id as claim_id,
    cp.claim_point_id as claim_point_id,
    ex.tariff_class as tariff_class,
    IF(c.status_code="returned_finish" AND visit_status="visited", "delivered_finish",
        IF(c.status_code='returned_finish' AND visit_status='skipped', 'returned_finish',
        IF(c.status_code='returned_finish' AND visit_status='pending', 'unknown',
        IF(c.status_code='delivered_finish' AND visit_status='skipped', 'unknown',
        IF(c.status_code='delivered_finish' AND visit_status='pending', 'unknown',
        IF(c.status_code='delivered_finish' AND visit_status='visited', 'delivered_finish',
        IF(c.status_code='performer_not_found' AND visit_status='visited', 'unknown',
        IF(c.status_code='cancelled' AND visit_status='visited', 'unknown',
        IF(c.status_code='cancelled' AND visit_status!='visited', 'cancelled_by_client_free',
        IF(c.status_code='cancelled_by_taxi', 'cancelled_by_performer',
        IF(c.status_code='cancelled_with_payment', 'cancelled_by_client_paid',
                c.status_code))))))))))) as claim_point_status,
    ex.tariff_class,
    --pay.`flow` = 'external_payment' as external_payment_flg,
    c.corp_client_id in $payments_eda_clients as external_payment_flg,
    city_name_ru as city, country_name_ru as country, corp_client_name,
    c.status_code in $cancel_list as cancel_flg,

    transaction_lcy_amt


FROM RANGE($ods_claim_path, $date_format_first_day_month($start_dt)) as c
LEFT JOIN RANGE($ods_claim_points_path, $date_format_first_day_month($start_dt)) as cp
    ON cp.claim_id = c.claim_id
--LEFT JOIN $payment_on_delivery_path as pay
LEFT JOIN RANGE($ods_payment_on_delivery_path, $date_format_first_day_month($start_dt)) as pay
    ON pay.claim_point_id = cp.claim_point_id
LEFT JOIN $executor_claims_data as ex
    ON ex.claim_id = c.claim_id
LEFT JOIN RANGE($ods_point_path, $date_format_first_day_month($start_dt)) as p
    ON p.point_id = cp.point_id
LEFT JOIN $corp_clients_data as corp
    ON c.corp_client_id == corp.client_id
left join $billing_data as b
    on b.payment_id == String::RemoveAll(pay.payment_id, '-')
WHERE
    --pay.updated_ts > now() - interval '3 hours' and
    --c.zone_id = 'ekb' and
    ((corp_client_id in $payments_eda_clients and ex.tariff_class in ['express', 'courier', 'cargo', 'cargocorp'])
    or (corp_client_id not in $payments_eda_clients))
    and String::RemoveAll(pay.payment_id, '-') in $payments_accepted
--order by c.created_ts DESC
;
