use hahn;

--хотим 
--Claim id/taxi order/номер обращения в саппорт/тематика 1 уровня/тематика 2 уровня/ тематика уровня Х/ текст обращения/решен ли тикет/ канал обращения/ время получения обращения/время начала обработки обращения/время закрытия тикета


-- список тегов от Лизы 
$logistics_couriers_pp_tags = ['логистика_макрос_постоплата_перевод_на_карту', 
'логистика_постоплата_ограничен_доступ_нужно_включить_опцию',
'логистика_макрос_постоплата_нет_оплаты',
'логистика_макрос_постоплата_проблемы_с_терминалом',
'логистика_макрос_постоплата_инфо_если_завис_терминал',
'логистика_макрос_постоплата_нет_денег_на_карте_хочет_оплатить_наличными',
'логистика_макрос_постоплата_не_приходит_ссылка_на_оплату',
'логистика_макрос_постоплата_платеж_не_подтверждён',
'логистика_макрос_постоплата_нельзя_сумма_свыше_десяти_тыс',
'логистика_макрос_постоплата_инфо_платежная_ссылка',
'логистика_макрос_постоплата_не_работает_приложение_или_модуль',
'логистика_макрос_постоплата_как_включить',
'логистика_макрос_постоплата_оплата_прошла_завершили_заказ',
'логистика_макрос_постоплата_отдал_без_оплаты_полиция',
'логистика_макрос_постоплата_клиент_просит_чек',
'логистика_макрос_постоплата_хочет_оплатить_двумя_картами',
'логистика_макрос_постоплата_не_хватает_денег_на_карте',
'логистика_макрос_постоплата_платеж_подтвержден',
'логистика_макрос_постоплата_инфо_как_это_увидеть_в_заказе',
'логистика_макрос_постоплата_инфо_терминал_на_айос',
'логистика_макрос_постоплата_хочет_отключить'];
/*
--как фильтровать по ним
--ListLength(SetIntersection(ToSet(Yson::ConvertToStringList(tags)), ToSet($logistics_pp_tags))) > 0

будем использовать более широкое условие: хотя бы один из тегов содержит слово "постоплата"
*/

--теги из эксельки от Кати 
$logistics_corp_pp_tags = ['ccd_order_contractor_not_found_cash_on_delivery',
'ccd_order_transport_requirements_mismatch_cash_on_delivery',
'ccd_order_item_not_delivered_cash_on_delivery',
'ccd_order_damaged_item_cash_on_delivery',
'ccd_order_not_all_items_delivered_cash_on_delivery',
'ccd_order_compensation_previously_lost_damaged_item_cash_on_delivery',
'ccd_order_asks_to_cancel_cash_on_delivery',
'ccd_order_asks_to_manually_complete_no_sms_cash_on_delivery',
'ccd_order_incorrect_price_waiting_cash_on_delivery',
'ccd_order_incorrect_price_billing_error_cash_on_delivery',
'ccd_order_incorrect_price_tariff_cash_on_delivery',
'ccd_courier_аsked_money_from_recipient_cash_on_delivery'
];
--тоже заменяем на более простое условие - хотя бы один из тегов содержит в себе 'cash_on_delivery'

--превращаем оба эти списка в структуру вида [AsStruct(list_element as tag), ...], чтобы потом превратить ее в таблицу
--с одним столбцом tag  с помощью функции AS_TABLE
$list_to_struct = ($y) -> {
    RETURN AsStruct($y as tag);
};

$tags_struct = ListMap(ListExtend($logistics_couriers_pp_tags, $logistics_corp_pp_tags), $list_to_struct);
--AS_TABLE($tags_struct) - таблица с одним столбцом со всеми тегами 


$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');

-- смотрим есть ли в теме слова "Наложенный платеж"
$filter_for_theme = ($y) -> {
    RETURN ($y like "%Наложенный платёж%");
};

--проверяем на слова постоплата и cash_on_delivery
$filter_for_tags = ($y) -> {
    --$key_word = "%наложенный_платеж%";
    RETURN ($y like "%постоплата%") or ($y like "%cash_on_delivery%");
};

--выгружаем все таксишные заказы с постоплатой 
$taxi_order_id_with_postpayment = (
    select taxi_order_id, some(claim_ref_id) as claim_ref_id, some(claim_id) as claim_id, 1 as postpayment_flg
    from `//home/taxi-delivery/analytics/dev/product/postpayment/postpayment_datamart/abt_demand/abt_claims_points_not_pp_only` as dels 
    where postpayment_flg = 1 
    group by taxi_order_id 
);

--выгрузка саппорта 
$support_final_data = (
    SELECT --st.*,
    --????
    city, country, 
    st.chatterbox_ticket as chatterbox_ticket,
    st.ticket_type as ticket_type,
    ticket_link,
    category,
    order_alias_id as order_alias_id,
    meta_category,

    dels.claim_id as claim_id,
    dels.claim_ref_id as claim_ref_id,
    order_id as taxi_order_id,
    
    st.ticket_id as ticket_id,
    theme_rus,
    theme_rus_1,
    theme_rus_2,
    theme_rus_3,
    theme_rus_4,
    ticket_channel_type,
    creation_dt,
    creation_dttm,
    $datetime_format(Datetime::FromSeconds(Datetime::ToSeconds(CAST(creation_dttm as Datetime))+CAST(sla_reply as Uint32))) as first_reply_dttm,
    solved_dttm,

    unique_driver_id, db_id, tariff_zone, 
    tags, -- все теги 
    ListFilter(tags, $filter_for_tags) as tags_pp, -- только теги содержащие слова постоплата и cash_on_delivery

    description, --текст обращения 
    dels.postpayment_flg as postpayment_flg, -- является ли соответствующий таксишный заказ постоплатным 
    
    if(ListLength(ListFilter(tags, $filter_for_tags)) > 0, 1, 0) as tags_pp_flg, -- есть ли теги содержащие в себе cash_on_delivery/постоплата 
    if(ListLength(SetIntersection(ToSet(tags), ToSet($logistics_couriers_pp_tags))) > 0, 1, 0) as courier_tags_flg, -- есть ли один из тегов от Лизы 
    if(ListLength(SetIntersection(ToSet(tags), ToSet($logistics_corp_pp_tags))) > 0, 1, 0) as corp_tags_flg, -- есть ли один из тегов от Кати

    FROM 
        `//home/taxi-analytics/hickinbottom/support/dwh/summary/support_tickets` as st --инфо о тикетах 
        left join `//home/taxi-analytics/hickinbottom/support/dwh/private/support_tickets_description` as descr
        on descr.ticket_id = st.ticket_id -- тексты обращений 
        --left join `//home/taxi/production/replica/postgres/cargo_claims/claims` as cl 
        --on cl.taxi_order_id = st.order_id -- вытаскиваем айди клейма (очень долго, поэтому будем вытаскивать только клеймы заказов с постоплатой)
        left join $taxi_order_id_with_postpayment as dels 
        on dels.taxi_order_id = st.order_id -- информация о том относится ли таксишный заказ к постоплатным 
    WHERE
        ListLength(ListFilter(tags, $filter_for_tags))>0 -- >=1 тегов содержит в себе либо слово постоплатa либо cash_on_delivery
        or $filter_for_theme(theme_rus) -- есть тема наложенный платеж 
        or (dels.postpayment_flg = 1) --таксишный заказ постоплатен (вдруг по какой-то причине забыли поставить один из тегов, но при этом обращение относится к постоплатному заказу)
);



--считаем вхождения тегов из списков выше 
$count_tags_data = (
    SELECT 
        tags_list.tag as tag, if(ListHas(source.tags, tags_list.tag), 1, 0) as tag_flg 
        from $support_final_data as source
        cross join AS_TABLE($tags_struct) as tags_list 
);


insert into `//home/taxi-delivery/analytics/dev/product/postpayment/support_data/postpayment_support_data_all` with truncate
SELECT *
from $support_final_data;

insert into `//home/taxi-delivery/analytics/dev/product/postpayment/support_data/postpayment_support_summary_data_all_tags_aggr`
select tag, sum(tag_flg) as tag_cnt
from $count_tags_data
group by tag 
    
