/*
LOGDATA-895

Есть гипотеза, что курьеры не видят пуши, которые им приходят для того, чтобы пройти ФК короба.
Также хочется понимать сколько курьеров с включенной опцией, но без пройденного ФК у нас в системе.
Хочется проверить в динамике сколько активных курьеров включили опцию Термокороб/термопакет, но не прошли ФК (то есть у них не стоит тег thermobox_on).
Активные курьеры это те, кто выполнил хотя бы 1 заказ за последний месяц.
Также нужно сделать дэш, на основе которого можно видеть как меняется % курьеров, которые включили опцию и прошли ФК короба и совершившие не менее 1 поездки за последний месяц.


dash: https://datalens.yandex-team.ru/9ugjs6g425ro2-termokorob-i-fk */

-- thermobox_on - прошел ФК короба
-- thermobag_confirmed - включил опцию термокороб


--табличка для подневного
--день | число активных в этот день | sh в этот день | число активных (sh) с включенной опцией | число активных (sh) с опцией и ФК

--для помесячной штуки
--дата | число активных курьеров за последний месяц | число активных у которых в последний день активности был термокороб | число активных у которых в последний день активности был термокороб с ФК

use hahn;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;
PRAGMA SimpleColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;


-- Используемые таблицы
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$CLAIM = '//home/delivery-dwh/ods/cargo_claims/claim';
$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$ACTUAL_TAGS = '//home/taxi/production/replica/postgres/tags/actual_tags';
$ORDER_PROC = '//home/taxi-dwh/raw/dbprocessing/order_proc';
$ORDER_CANDIDATE = '//home/taxi-dwh/ods/dbprocessing/order_candidate';
$CLAIM_SEGMENT = '//home/delivery-dwh/ods/cargo_claims/claim_segment';
$FCT_STATE_HIST = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$TAG_LIST_HIST = '//home/taxi-dwh/cdm/executor/dim_executor_profile_tag_list_hist';

--Используемые МОИ таблицы


-- Куда сохранить результат
$SAVE_TO = '//home/taxi-delivery/analytics/dev/product/supply_analytics/thermobox_on_and_thermobag_confirmed_daily';
$SAVE_TO2 = '//home/taxi-delivery/analytics/dev/product/supply_analytics/thermobox_on_and_thermobag_confirmed2_daily';
-- списки
$LOG_TARIFFS = (
    'courier'
    , 'express'
    --, 'cargo'
    --, 'ubernight'
    --, 'cargocorp'
);


--Парсинг и форматы времени
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_month_short_format = Datetime::Format('%Y-%m');
$date_year_format = Datetime::Format('%Y-01-01');


-- Константы для времени
--$START_DTTM = $datetime_parse('2021-09-15 00:00:00');
$START_DTTM = CurrentUtcDatetime()- Interval('P15D');
$END_DTTM = CurrentUtcDatetime()- Interval('P1D');

$START_DTTM_STR = $datetime_format($START_DTTM);
$START_DT_STR = $date_format($START_DTTM);
$START_MONTH_STR = $date_month_format($START_DTTM);
$START_MONTH_SHORT_STR = $date_month_short_format($START_DTTM);
$START_YEAR_STR = $date_year_format($START_DTTM);

$END_DTTM_STR = $datetime_format($END_DTTM);
$END_DT_STR = $date_format($END_DTTM);
$END_MONTH_STR = $date_month_format($END_DTTM);
$END_MONTH_SHORT_STR = $date_month_short_format($END_DTTM);
$END_YEAR_STR = $date_year_format($END_DTTM);



-- Функции
$get_datetime_from_timestamp_sec = ($x) ->
{RETURN DateTime::MakeDatetime(DateTime::FromSeconds(CAST($x as Uint32)))};

$dates = (
    select distinct TableName() as dt
    from RANGE('//home/logfeller/logs/taxi-tags-tag-event-log/1d', $START_DT_STR, $END_DT_STR)
);
/*
$data = (
SELECT
    dbid_uuid,
    utc_valid_from_dt,
    utc_valid_to_dt,

    max(ListHas(Yson::ConvertToStringList(tag_code_list), 'walking_courier')) as walking_courier_flg,
    max(ListHas(Yson::ConvertToStringList(tag_code_list), 'auto_courier')) as auto_courier_flg,
    max(ListHas(Yson::ConvertToStringList(tag_code_list), 'thermobox_option_on')) as thermobox_on_flg,
    max(ListHas(Yson::ConvertToStringList(tag_code_list), 'thermobag_confirmed')) as thermobox_confirmed_flg,

FROM RANGE($TAG_LIST_HIST, $START_MONTH_SHORT_STR, $END_MONTH_SHORT_STR) as tl
GROUP BY park_taximeter_id || '_' || executor_profile_id as dbid_uuid,
    SUBSTRING(utc_valid_from_dttm, 0, 10) as utc_valid_from_dt,
    SUBSTRING(utc_valid_to_dttm, 0, 10) as utc_valid_to_dt
    --utc_valid_from_dttm, utc_valid_to_dttm
);
*/

$fo_data = (
    select dbid_uuid, dt,
        max_by(ListHas(Yson::ConvertToStringList(tag_id_list), 'thermobag_confirmed'), utc_order_created_dt) as thermobox_confirmed_flg,
        max_by(ListHas(Yson::ConvertToStringList(tag_id_list), 'thermobox_option_on'), utc_order_created_dt) as thermobox_on_flg,
        max_by(ListHas(Yson::ConvertToStringList(tag_id_list), 'auto_courier'), utc_order_created_dt) as auto_courier_flg,
        max_by(ListHas(Yson::ConvertToStringList(tag_id_list), 'walking_courier'), utc_order_created_dt) as walking_courier_flg,
    from RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as fo
    left join RANGE($ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as oc
    on oc.order_id == fo.order_id
        and oc.park_taximeter_id == fo.taximeter_park_id
        and oc.executor_profile_id == fo.executor_profile_id
    cross join $dates as dates
    where dates.dt between $START_DT_STR and $END_DT_STR
        and DateTime::ToDays(CAST(dates.dt as Date)-CAST(utc_order_created_dt as Date)) between 0 and 0
    group by fo.taximeter_park_id || '_' || fo.executor_profile_id  as dbid_uuid, dates.dt as dt
);



$final = (
    SELECT dt as dt,
        count(distinct dbid_uuid) as dbid_uuid_cnt_distinct, --check
        count(dbid_uuid) as dbid_uuid_cnt,
        count_if(thermobox_on_flg) as thermobox_on_cnt,
        count_if(thermobox_confirmed_flg) as thermobox_confirmed_cnt,

        count_if(auto_courier_flg or walking_courier_flg) as dbid_uuid_logistics_cnt,
        count_if((auto_courier_flg or walking_courier_flg) and thermobox_on_flg) as thermobox_on_logistics_cnt,
        count_if((auto_courier_flg or walking_courier_flg) and thermobox_confirmed_flg) as thermobox_confirmed_logistics_cnt,
        count_if((auto_courier_flg or walking_courier_flg) and thermobox_confirmed_flg and thermobox_on_flg) as thermobox_confirmed2_logistics_cnt,

    FROM $fo_data as tbl
    GROUP BY dt
);

INSERT INTO $SAVE_TO2 WITH TRUNCATE
SELECT *
FROM $fo_data
WHERE dt >= $START_DT_STR
union all
select *
from $SAVE_TO2
where dt < $START_DT_STR;

INSERT INTO $SAVE_TO WITH TRUNCATE
SELECT *
FROM $final
WHERE dt >= $START_DT_STR
union all
select *
from $SAVE_TO
where dt < $START_DT_STR;;

SELECT * FROM $dates;
