use hahn;
PRAGMA yson.AutoConvert;
PRAGMA yson.DisableStrict;
PRAGMA SimpleColumns;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA OrderedColumns;
PRAGMA yt.pool='taxi-delivery';

--datasources 
$TAG_LIST_HIST = '//home/taxi-dwh/cdm/executor/dim_executor_profile_tag_list_hist';

$FCT_STATE_HIST = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$DM_ORDER = '//home/taxi-dwh/summary/dm_order';
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';
$DIM_PARK_HIST = '//home/taxi-dwh/cdm/supply/dim_park_hist/dim_park_hist';
$PARKS = '//home/taxi/production/replica/mongo/struct/parks';
$CONTRACTS = '//home/taxi-delivery/parks/contracts';
$ORDER_CANDIDATE = '//home/taxi-dwh/ods/dbprocessing/order_candidate';
$FCT_ORDER_CANDIDATE = '//home/taxi-dwh/cdm/supply/fct_order_candidate';
$APPMETRICA_FACETS = '//home/taxi-analytics/denchashch/driver_metrics_dashboard/appmetrica_facets';
$CARS_TABLE = '//home/taxi-dwh/raw/dbcars/cars/cars';
$PDA_CARS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_cars';
$PDA_DRIVERS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_drivers';
$PDA_PARKS = '//home/taxi/production/replica/mongo/struct/pda_private/pda_parks';
$CLAIM = '//home/taxi-dwh/ods/cargo_claims/claim';
$SUPPORT_TICKETS = '//home/taxi-analytics/hickinbottom/support/dwh/summary/support_tickets';
$FCT_SUBSIDY_PATH = '//home/taxi-dwh/dds/fct_subsidy_detail';
$DIM_CURRENCY_RATE = '//home/taxi-dwh/dds/dim_currency_rate';
$DIM_EXECUTOR_PROFILE_ACT = '//home/taxi-dwh/cdm/supply/dm_executor_profile_act/dm_executor_profile_act';
$DM_DRIVER_LICENSE_ACTIVITY_WINDOW_TICKET = '//home/taxi-dwh/cdm/supply/dm_driver_license_activity_window_ticket/dm_driver_license_activity_window_ticket';
$DM_DRIVER_LICENSE_ACTIVITY_WINDOW_TARIFF_CLASS = '//home/taxi-dwh/cdm/supply/dm_driver_license_activity_window_tariff_class/dm_driver_license_activity_window_tariff_class';
$LINK_UNIQUE_DRIVER_ID = '//home/taxi-dwh/cdm/supply/link_old_current_unique_driver_act/link_old_current_unique_driver_act';
$DM_EXECUTOR_PROFILE_HIST = '//home/taxi-dwh/cdm/supply/dim_executor_profile_hist'; -- 2022-06 



$date_type = 'utc_date'; 
$PARENT_FOLDER_PATH = '//home/taxi-delivery/analytics/production/product/supply_overview';



--Парсинг и форматы времени 
$datetime_parse = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$date_parse = DateTime::Parse("%Y-%m-%d");
$date_dots_parse = DateTime::Parse("%d.%m.%Y");
$datetime_format = Datetime::Format('%Y-%m-%d %H:%M:%S');
$date_format = Datetime::Format('%Y-%m-%d');
$date_month_format = Datetime::Format('%Y-%m-01');
$date_month_short_format = Datetime::Format('%Y-%m');
$date_year_format = Datetime::Format('%Y-01-01');



-- Константы для времени


--$START_DTTM = Datetime::MakeDatetime($datetime_parse($MONTH_STR || '-01 00:00:00'))- Interval('P8D');
--$END_DTTM = DateTime::MakeDatetime(DateTime::ShiftMonths($START_DTTM, 1))+ Interval('P8D');

--$START_DTTM = CurrentUtcDatetime()- Interval('P99D');
--$END_DTTM = CurrentUtcDatetime()-Interval('P0D');

-- так как есть недельный скейл, обязательно нужно смотреть предыдущие 7 дней 
$START_DTTM = Datetime::MakeDatetime(Datetime::StartOfMonth(Datetime::MakeDatetime(CurrentUtcDatetime()-Interval('P33D')))) - Interval('P8D');
--первый месяц, для которого у нас есть полные данные
$START_FIRST_FULL_MONTH_DTTM = Datetime::MakeDatetime(Datetime::StartOfMonth(Datetime::MakeDatetime(CurrentUtcDatetime()-Interval('P33D'))));
$END_DTTM = CurrentUtcDatetime()-Interval('P0D');

$START_DTTM_STR = $datetime_format($START_DTTM);
$START_DT_STR = $date_format($START_DTTM);
$START_MONTH_STR = $date_month_format($START_DTTM);
$START_MONTH_SHORT_STR = $date_month_short_format($START_DTTM);
$START_YEAR_STR = $date_year_format($START_DTTM);

$END_DTTM_STR = $datetime_format($END_DTTM);
$END_DT_STR = $date_format($END_DTTM);
$END_MONTH_STR = $date_month_format($END_DTTM);
$END_MONTH_SHORT_STR = $date_month_short_format($END_DTTM);
$END_YEAR_STR = $date_year_format($END_DTTM);



$to_int64  = ($data) -> {
    return Yson::ConvertToInt64($data)
};

$week = ($d) -> {
    return $date_format(DateTime::StartOfWeek($date_parse($d)));
};

$month = ($d) -> {
    return $date_format(DateTime::StartOfMonth($date_parse($d)));
};

$diff_sec = ($t1, $t2) -> {

        RETURN cast(cast(String::SplitToList($t1, ' ')[0] || 'T' || String::SplitToList($t1, ' ')[1] || 'Z' as DateTime) as double) - cast(cast(String::SplitToList($t2, ' ')[0] || 'T' || String::SplitToList($t2, ' ')[1] || 'Z' as DateTime) as double);
        
    };

$diff_hour = ($t1, $t2) -> {

        RETURN $diff_sec($t1, $t2)*1.0/3600 ;
        
    };

$make_lcl_dttm = ($t1, $diff) -> {

    $ts = cast(cast(String::SplitToList($t1, ' ')[0] || 'T' || String::SplitToList($t1, ' ')[1] || 'Z' as DateTime) as double) + $diff;
    $dt = String::SplitToList(cast(DateTime::FromSeconds(cast($ts as Uint32)) as string), 'Z')[0];

    RETURN String::SplitToList($dt, 'T')[0] || ' ' || String::SplitToList($dt, 'T')[1]

    };


$LOG_TARIFFS = AsList('express', 'courier', 'cargo', 'cargocorp', 'night', 'ubernight', 'sdd');
$TAXI_TARIFFS = AsList('comfort', 'business', 'business2', 'child_tariff', 'comfortplus', 
    'econom', 'maybach', 'minivan', 'mkk_antifraud', 'personal_driver', 'pool', 'premium_suv',
    'premium_van', 'promo', 'selfdriving', 'standart', 'start', 'suv', 'uberblack', 'uberkids',
    'uberlux', 'uberselect','uberselectplus', 'uberstart', 'ubervan', 'uberx', 'ultimate', 
    'universal', 'vezetbusiness', 'vezeteconom', 'vip');



$config_string = @@
{
  "lcv_flatbed": {
    "carrying_capacity_max_kg": 3000,
    "carrying_capacity_min_kg": 900,
    "height_max_cm": 30,
    "height_min_cm": 0,
    "length_max_cm": 500,
    "length_min_cm": 280,
    "width_max_cm": 220,
    "width_min_cm": 180
  },
  "lcv_l": {
    "carrying_capacity_max_kg": 6000,
    "carrying_capacity_min_kg": 1400,
    "height_max_cm": 250,
    "height_min_cm": 180,
    "length_max_cm": 601,
    "length_min_cm": 380,
    "requirement_value": 3,
    "width_max_cm": 250,
    "width_min_cm": 180
  },
  "lcv_m": {
    "carrying_capacity_max_kg": 6000,
    "carrying_capacity_min_kg": 700,
    "height_max_cm": 250,
    "height_min_cm": 150,
    "length_max_cm": 601,
    "length_min_cm": 260,
    "requirement_value": 2,
    "width_max_cm": 250,
    "width_min_cm": 130
  },
  "lcv_s": {
    "carrying_capacity_max_kg": 1000,
    "carrying_capacity_min_kg": 700,
    "height_max_cm": 180,
    "height_min_cm": 140,
    "length_max_cm": 279,
    "length_min_cm": 200,
    "width_max_cm": 220,
    "width_min_cm": 130
  },
  "lcv_xl": {
    "carrying_capacity_max_kg": 3500,
    "carrying_capacity_min_kg": 1500,
    "height_max_cm": 240,
    "height_min_cm": 180,
    "length_max_cm": 600,
    "length_min_cm": 400,
    "width_max_cm": 240,
    "width_min_cm": 190
  },
  "van": {
    "carrying_capacity_max_kg": 2001,
    "carrying_capacity_min_kg": 300,
    "height_max_cm": 201,
    "height_min_cm": 90,
    "length_max_cm": 290,
    "length_min_cm": 170,
    "requirement_value": 1,
    "width_max_cm": 201,
    "width_min_cm": 96
  }
}
@@;

$config = Yson::ParseJson($config_string);



/*
$hours = (
SELECT *
from (VALUES
    ('00:00:00', '08:00:00', 'night'),
    ('08:00:00', '12:00:00', 'morning'),
    ('12:00:00', '17:00:00', 'day'),
    ('17:00:00', '23:00:00', 'evening'),
    ('23:00:00', '23:59:59', 'night')
) as t (hour_from, hour_to, day_period_name)
);
*/


$hours = (
SELECT *
from (VALUES
    ('00:00:00', '01:00:00'),
    ('01:00:00', '02:00:00'),
    ('02:00:00', '03:00:00'),
    ('03:00:00', '04:00:00'),
    ('04:00:00', '05:00:00'),
    ('05:00:00', '06:00:00'),
    ('06:00:00', '07:00:00'),
    ('07:00:00', '08:00:00'),
    ('08:00:00', '09:00:00'),
    ('09:00:00', '10:00:00'),
    ('10:00:00', '11:00:00'),
    ('11:00:00', '12:00:00'),
    ('12:00:00', '13:00:00'),
    ('13:00:00', '14:00:00'),
    ('14:00:00', '15:00:00'),
    ('15:00:00', '16:00:00'),
    ('16:00:00', '17:00:00'),
    ('17:00:00', '18:00:00'),
    ('18:00:00', '19:00:00'),
    ('19:00:00', '20:00:00'),
    ('20:00:00', '21:00:00'),
    ('21:00:00', '22:00:00'),
    ('22:00:00', '23:00:00'),
    ('23:00:00', '23:59:59')
) as t (hour_from, hour_to)
);

$dates = (
select $date_format(Datetime::FromSeconds(ls)) as utc_date from (
SELECT ListFromRange(nvl(DateTime::ToSeconds($START_DTTM),0), nvl(DateTime::ToSeconds($END_DTTM),0),86400) as ls) 
flatten by ls 
);

$geo =
(
    select tariff_zone, some(population_group) as population_group,
    some(tz_country_name_ru) as tz_country_name_ru,
    some(name_ru) as agglomeration,
    some(time_zone_code) as time_zone_code
    from $GEO
    where root_node_id = 'br_root'
        and node_type = 'agglomeration'
    group by tariff_zone
);


$geo_node_id = (
    select node_id, some(time_zone_code) as time_zone_code, some(tariff_zone) as tariff_zone
    from $GEO 
    where time_zone_code is not null 
    group by node_id
);

$dim_exec_hist = (
    select park_taximeter_id, executor_profile_id,dh.park_taximeter_id || '_' || dh.executor_profile_id as  dbid_uuid,
        utc_valid_from_dttm,
        utc_valid_to_dttm,
        geo.time_zone_code as park_time_zone_code,
        geo.tariff_zone as park_tariff_zone,
        park_agglomeration_geo_node_id,
        $datetime_format(AddTimezone(Datetime::MakeDatetime($datetime_parse(utc_valid_from_dttm)), geo.time_zone_code)) as lcl_valid_from_dttm,
        $datetime_format(AddTimezone(Datetime::MakeDatetime($datetime_parse(utc_valid_to_dttm)), geo.time_zone_code)) as lcl_valid_to_dttm,
        --max(String::SplitToList(dh.utc_valid_from_dttm, ' ')[0]) as utc_valid_from_dt,
        --max(String::SplitToList(dh.utc_valid_to_dttm, ' ')[0]) as utc_valid_to_dt,
        --max_by(dh.old_unique_driver_id, utc_valid_from_dttm) as old_unique_driver_id, 
        --max_by(current_unique_driver_id, utc_valid_from_dttm) as current_unique_driver_id,
        dh.old_unique_driver_id as old_unique_driver_id,
        l.current_unique_driver_id as current_unique_driver_id,

        --car_profile_id,
        executor_employment_type,

        taximeter_locale_code, taximeter_platform, taximeter_version_code,
        phone_pd_id_list,
        phone_pd_id_list[0] as phone_pd_id_0,

    from RANGE($DM_EXECUTOR_PROFILE_HIST, $START_MONTH_SHORT_STR) as dh 
    left join $LINK_UNIQUE_DRIVER_ID as l
    on l.old_unique_driver_id == dh.old_unique_driver_id
    left join $geo_node_id as geo 
    on geo.node_id == dh.park_agglomeration_geo_node_id
    where dh.old_unique_driver_id is not null 
);

$exec_park_geo_data = (
    select dbid_uuid, park_taximeter_id, executor_profile_id, 
            utc_date, 

            max_by(park_time_zone_code, utc_valid_from_dttm) as park_time_zone_code,
            max_by(park_agglomeration_geo_node_id, utc_valid_from_dttm) as park_agglomeration_geo_node_id,
            max_by(park_tariff_zone, utc_valid_from_dttm) as park_agglomeration_tariff_zone,
            max_by(current_unique_driver_id, utc_valid_from_dttm) as current_unique_driver_id,
            max_by(old_unique_driver_id, utc_valid_from_dttm) as old_unique_driver_id,
            max_by(executor_employment_type, utc_valid_from_dttm) as executor_employment_type,
            max_by(taximeter_locale_code, utc_valid_from_dttm) as taximeter_locale_code,
            max_by(taximeter_platform, utc_valid_from_dttm) as taximeter_platform,
            max_by(taximeter_version_code, utc_valid_from_dttm) as taximeter_version_code,
            some(phone_pd_id_list) as phone_pd_id_list

    from $dim_exec_hist as d 
    cross join $dates as dt 
    where 1 == 1 
        -- and (ac.utc_activity_window_start_dt <= sh.utc_date or ac.utc_activity_window_start_dt is null) and
        and ((dt.utc_date || ' 23:59:59' >= d.utc_valid_from_dttm or dt.utc_date || ' 00:00:00' <= d.utc_valid_to_dttm) or d.utc_valid_to_dttm is null)
    group by d.dbid_uuid as dbid_uuid, 
        d.park_taximeter_id as park_taximeter_id, 
        d.executor_profile_id as executor_profile_id, 
        dt.utc_date as utc_date
);


$fct_order_filtered = (
    select executor_profile_id, taximeter_park_id as park_taximeter_id, 
        taximeter_park_id || '_' || executor_profile_id as dbid_uuid,
        utc_order_created_dt,
        utc_order_created_dttm,
        coalesce(lcl_order_created_dt, $date_format(AddTimezone(Datetime::MakeDatetime($datetime_parse(utc_order_created_dttm)), geo.time_zone_code))) as lcl_order_created_dt, 
        coalesce(lcl_order_created_dttm, $datetime_format(AddTimezone(Datetime::MakeDatetime($datetime_parse(utc_order_created_dttm)), geo.time_zone_code))) as lcl_order_created_dttm, 
        tariff_class_code,
        order_id
    from RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as fo 
    left join $geo as geo
    on geo.tariff_zone == fo.tariff_geo_zone_code
    where utc_order_created_dt between $START_DT_STR and $END_DT_STR 
);


$tags_data_raw = (
    select 
        sh.executor_profile_id as executor_profile_id,
        sh.park_taximeter_id as park_taximeter_id,
        sh.park_taximeter_id || '_' || sh.executor_profile_id as dbid_uuid,
        --link.current_unique_driver_id as unique_driver_id,
        substring(sh.utc_valid_from_dttm, 0, 10) as utc_date,
        tariff_geo_zone_code,

        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_fulltimer_core')
            then et.utc_valid_from_dttm
            else null
            end) as delivery_fulltimer_core_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_fulltimer_noncore')
            then et.utc_valid_from_dttm
            else null
            end) as  delivery_fulltimer_noncore_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_newbie_exclusive')
            then et.utc_valid_from_dttm
            else null
            end) as delivery_newbie_exclusive_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_newbie_mixed_delivery')
            then et.utc_valid_from_dttm
            else null
            end) as  delivery_newbie_mixed_delivery_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_newbie_mixed_taxi')
            then et.utc_valid_from_dttm
            else null
            end) as  delivery_newbie_mixed_taxi_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_experienced_exclusive')
            then et.utc_valid_from_dttm
            else null
            end) as  delivery_parttimer_experienced_exclusive_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_experienced_mixed_delivery')
            then et.utc_valid_from_dttm
            else null
            end) as delivery_parttimer_experienced_mixed_delivery_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_experienced_mixed_taxi')
            then et.utc_valid_from_dttm
            else null
            end) as  delivery_parttimer_experienced_mixed_taxi_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_inexperienced_exclusive')
            then et.utc_valid_from_dttm
            else null
            end) as  delivery_parttimer_inexperienced_exclusive_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_inexperienced_mixed_delivery')
            then et.utc_valid_from_dttm
            else null
            end) as  delivery_parttimer_inexperienced_mixed_delivery_dttm,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_inexperienced_mixed_taxi')
            then et.utc_valid_from_dttm
            else null
            end) as delivery_parttimer_inexperienced_mixed_taxi_dttm,

        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_fulltimer_core')
            then True
            else False
            end) as delivery_fulltimer_core,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_fulltimer_noncore')
            then True
            else False
            end) as  delivery_fulltimer_noncore,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_newbie_exclusive')
            then True
            else False
            end) as delivery_newbie_exclusive,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_newbie_mixed_delivery')
            then True
            else False
            end) as  delivery_newbie_mixed_delivery,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_newbie_mixed_taxi')
            then True
            else False
            end) as  delivery_newbie_mixed_taxi,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_experienced_exclusive')
            then True
            else False
            end) as  delivery_parttimer_experienced_exclusive,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_experienced_mixed_delivery')
            then True
            else False
            end) as delivery_parttimer_experienced_mixed_delivery,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_experienced_mixed_taxi')
            then True
            else False
            end) as  delivery_parttimer_experienced_mixed_taxi,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_inexperienced_exclusive')
            then True
            else False
            end) as  delivery_parttimer_inexperienced_exclusive,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_inexperienced_mixed_delivery')
            then True
            else False
            end) as  delivery_parttimer_inexperienced_mixed_delivery,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'delivery_parttimer_inexperienced_mixed_taxi')
            then True
            else False
            end) as delivery_parttimer_inexperienced_mixed_taxi,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'taxi_courier')
            then True
            else False
            end) as taxi_courier,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'auto_courier')
            then True
            else False
            end) as auto_courier,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'scooter_courier')
            then True
            else False
            end) as scooter_courier,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'bike_courier')
            then True
            else False
            end) as bike_courier,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'walking_courier')
            then True
            else False
            end) as walking_courier,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'thermobag_confirmed')
            then True
            else False
            end) as thermobag_confirmed,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'logistic_workshift_subscribed')
            then True
            else False
            end) as logistic_workshift_subscribed,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'post_payment')
            then True
            else False
            end) as post_payment,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'profi_courier')
            then True
            else False
            end) as profi_courier,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'allow_profi_courier')
            then True
            else False
            end) as allow_profi_courier,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'allow_heavy_delivery')
            then True
            else False
            end) as allow_heavy_delivery,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'thermopack_confirmed')
            then True
            else False
            end) as thermopack_confirmed,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'medical_card')
            then True
            else False
            end) as medical_card,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'medical_card_off')
            then True
            else False
            end) as medical_card_off,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'vaccination_enabled')
            then True
            else False
            end) as vaccination_enabled,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'vaccination_first')
            then True
            else False
            end) as vaccination_first,
        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'vaccination_second')
            then True
            else False
            end) as vaccination_second,

        (case 
            when ListHas(Yson::ConvertTo(tag_code_list, List<String?>?), 'offline_onboarding_visit')
            then True
            else False
            end) as offline_onboarding_visit,

    --sh_with_auto_courier
    --sh_with_delivery
    --sh_with_taxi

    min_of(sh.utc_valid_to_dttm, et.utc_valid_to_dttm) as utc_valid_to_dttm,
    max_of(sh.utc_valid_from_dttm, et.utc_valid_from_dttm) as utc_valid_from_dttm,

    CAST($diff_sec(sh.lcl_valid_from_dttm, sh.utc_valid_from_dttm)/3600 as Int64) as timezone_diff,


    not SetIsDisjoint(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS)) as with_delivery_tariff_flg,
    not SetIsDisjoint(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($TAXI_TARIFFS)) as with_taxi_tariff_flg,
    not SetIsDisjoint(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS)) 
        and ListLength(SetDifference(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS)))=0 as with_delivery_only_flg,


    FROM RANGE($FCT_STATE_HIST, $START_DT_STR, $END_DT_STR)  as sh 
    --FROM $FCT_STATE_HIST_S as sh
    LEFT JOIN RANGE($TAG_LIST_HIST, $START_MONTH_SHORT_STR, $END_MONTH_SHORT_STR) as et 
    ON sh.executor_profile_sk=et.executor_profile_sk 
    --LEFT JOIN $LINK_UNIQUE_DRIVER_ID as link 
    --on link.old_unique_driver_id == sh.old_unique_driver_id


    WHERE sh.utc_valid_from_dttm<et.utc_valid_to_dttm 
        AND et.utc_valid_from_dttm<sh.utc_valid_to_dttm
        and sh.profile_status_rank == 1
        and sh.executor_status_code in ('driving', 'waiting', 'transporting', 'free')
        and substring(sh.utc_valid_from_dttm, 0,10) between $START_DT_STR and $END_DT_STR
); 

$tags_data_raw_lcl1 = (
    SELECT t.*, 
        min_of(substring(utc_valid_to_dttm, 0, 10) || ' ' || hour_to, utc_valid_to_dttm) as utc_valid_to_dttm,
        max_of(substring(utc_valid_from_dttm, 0, 10) || ' ' || hour_from,utc_valid_from_dttm) as utc_valid_from_dttm,

        coalesce(t.tariff_geo_zone_code, ex_p.park_agglomeration_tariff_zone) as tariff_zone,

        t.tariff_geo_zone_code is null as tariff_geo_zone_code_by_park_flg,

        hour_from as utc_hour_from_str,
        CAST(substring(hour_from, 0, 2) as Int64) as utc_hour_from_int,

        park_time_zone_code, park_agglomeration_tariff_zone

        without t.utc_valid_from_dttm, t.utc_valid_to_dttm, t.timezone_diff
    from $tags_data_raw as t
    left join $exec_park_geo_data as ex_p 
    on ex_p.utc_date = t.utc_date and ex_p.dbid_uuid == t.dbid_uuid
    cross join $hours as h 
    where (substring(t.utc_valid_from_dttm, 0, 10) || ' ' || hour_from <= t.utc_valid_to_dttm and substring(t.utc_valid_to_dttm, 0, 10) || ' ' || hour_to >= t.utc_valid_from_dttm)
        --and substring(t.utc_valid_from_dttm, 0, 10) between $START_DT_STR and $END_DT_STR
);




$tags_data_raw_lcl2 = (
    select t.*, 
        coalesce(geo.time_zone_code, park_time_zone_code) as time_zone_code,
        $datetime_format(AddTimezone(Datetime::MakeDatetime($datetime_parse(utc_valid_from_dttm)), coalesce(geo.time_zone_code, park_time_zone_code))) as lcl_valid_from_dttm,
        $datetime_format(AddTimezone(Datetime::MakeDatetime($datetime_parse(utc_valid_to_dttm)), coalesce(geo.time_zone_code, park_time_zone_code))) as lcl_valid_to_dttm
    from $tags_data_raw_lcl1 as t 
    left join $geo as geo 
    on geo.tariff_zone == t.tariff_zone
);


$tags_data_raw_lcl3 = (
    select t.*, 
        CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64) as timezone_diff,
        (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 as lcl_hour_from,

        case when (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 between 0 and 7 then 'night'
        when (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 between 8 and 11 then 'morning'
        when (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 between 12 and 16 then 'day'
        when (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 between 17 and 23 then 'evening'
        else 'unknown' end as day_period_name,

        substring(lcl_valid_from_dttm, 0, 10) as lcl_date,

    from $tags_data_raw_lcl2 as t 
);



$tags_data_agg = (
    select executor_profile_id, park_taximeter_id, dbid_uuid, 
        --unique_driver_id, 
        _date,
        max(delivery_fulltimer_core_dttm) as delivery_fulltimer_core_dttm,
        max(delivery_fulltimer_noncore_dttm) as  delivery_fulltimer_noncore_dttm,
        max(delivery_newbie_exclusive_dttm) as delivery_newbie_exclusive_dttm,
        max(delivery_newbie_mixed_delivery_dttm) as  delivery_newbie_mixed_delivery_dttm,
        max(delivery_newbie_mixed_taxi_dttm) as  delivery_newbie_mixed_taxi_dttm,
        max(delivery_parttimer_experienced_exclusive_dttm) as  delivery_parttimer_experienced_exclusive_dttm,
        max(delivery_parttimer_experienced_mixed_delivery_dttm) as delivery_parttimer_experienced_mixed_delivery_dttm,
        max(delivery_parttimer_experienced_mixed_taxi_dttm) as  delivery_parttimer_experienced_mixed_taxi_dttm,
        max(delivery_parttimer_inexperienced_exclusive_dttm) as  delivery_parttimer_inexperienced_exclusive_dttm,
        max(delivery_parttimer_inexperienced_mixed_delivery_dttm) as  delivery_parttimer_inexperienced_mixed_delivery_dttm,
        max(delivery_parttimer_inexperienced_mixed_taxi_dttm) as delivery_parttimer_inexperienced_mixed_taxi_dttm,

        max(delivery_fulltimer_core) as delivery_fulltimer_core,
        max(delivery_fulltimer_noncore) as  delivery_fulltimer_noncore,
        max(delivery_newbie_exclusive) as delivery_newbie_exclusive,
        max(delivery_newbie_mixed_delivery) as  delivery_newbie_mixed_delivery,
        max(delivery_newbie_mixed_taxi) as  delivery_newbie_mixed_taxi,
        max(delivery_parttimer_experienced_exclusive) as  delivery_parttimer_experienced_exclusive,
        max(delivery_parttimer_experienced_mixed_delivery) as delivery_parttimer_experienced_mixed_delivery,
        max(delivery_parttimer_experienced_mixed_taxi) as  delivery_parttimer_experienced_mixed_taxi,
        max(delivery_parttimer_inexperienced_exclusive) as  delivery_parttimer_inexperienced_exclusive,
        max(delivery_parttimer_inexperienced_mixed_delivery) as  delivery_parttimer_inexperienced_mixed_delivery,
        max(delivery_parttimer_inexperienced_mixed_taxi) as delivery_parttimer_inexperienced_mixed_taxi,
        

        max(taxi_courier) as taxi_courier,
        max(auto_courier) as auto_courier,
        max(scooter_courier) as scooter_courier,
        max(bike_courier) as bike_courier,
        max(walking_courier) as walking_courier,
        max(thermobag_confirmed) as thermobag_confirmed,
        max(logistic_workshift_subscribed) as logistic_workshift_subscribed,
        max(post_payment) as post_payment,
        max(profi_courier) as profi_courier,
        max(allow_profi_courier) as allow_profi_courier,
        max(allow_heavy_delivery) as allow_heavy_delivery,
        max(thermopack_confirmed) as thermopack_confirmed,
        max(medical_card) as medical_card,
        max(medical_card_off) as medical_card_off,
        max(vaccination_enabled) as vaccination_enabled,
        max(vaccination_first) as vaccination_first,
        max(vaccination_second) as vaccination_second,
        max(offline_onboarding_visit) as offline_onboarding_visit,

    --sh_with_auto_courier
    --sh_with_delivery
    --sh_with_taxi

    sum_if(
            cast($diff_hour(utc_valid_to_dttm, utc_valid_from_dttm) as double),
            auto_courier
        ) as sh_with_auto_courier,

    sum_if(
            cast($diff_hour(utc_valid_to_dttm, utc_valid_from_dttm) as double),
            with_delivery_tariff_flg
        ) as sh_with_delivery,

    sum_if(
            cast($diff_hour(utc_valid_to_dttm, utc_valid_from_dttm) as double),
            with_taxi_tariff_flg
        ) as sh_with_taxi,

    sum_if(
            cast($diff_hour(utc_valid_to_dttm, utc_valid_from_dttm) as double),
            with_delivery_only_flg
        ) as sh_delivery_only,


    FROM $tags_data_raw_lcl3 
    WHERE utc_date between $START_DT_STR and $END_DT_STR
    GROUP BY executor_profile_id,
        park_taximeter_id,
        dbid_uuid,
        --unique_driver_id,
        TableRow().$date_type as _date
);

$sh_data_raw = (
    SELECT 
    a.park_taximeter_id || '_' || a.executor_profile_id as dbid_uuid,
    a.old_unique_driver_id as old_unique_driver_id,
    a.park_taximeter_id as park_taximeter_id,
    a.executor_profile_id as executor_profile_id,

    --link.current_unique_driver_id as unique_driver_id,

    substring(utc_valid_from_dttm, 0, 10) as utc_date,
    CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm)/3600 as Int64) as timezone_diff,

    tariff_geo_zone_code,
    executor_status_code,

    utc_valid_from_dttm,
    utc_valid_to_dttm,
    lcl_valid_from_dttm,
    lcl_valid_to_dttm,

    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'express') as tariff_express_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'courier') as tariff_courier_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'cargo') as tariff_cargo_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'cargocorp') as tariff_cargocorp_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'night') as tariff_night_on,
    ListHas(Yson::ConvertToStringList(enabled_tariff_class_code_list), 'ubernight') as tariff_ubernight_on,


    not SetIsDisjoint(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS)) as tariff_any_delivery_on,
    not SetIsDisjoint(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($TAXI_TARIFFS)) as tariff_any_taxi_on,
    not SetIsDisjoint(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS)) 
        and ListLength(SetDifference(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS)))>0 as tariff_any_other_tariff_on,

    --duration_sec,


    --substring(lcl_valid_from_dttm, 0, 10) || ' ' || hour_from as lcl_datetime_hour_from,
    --substring(lcl_valid_to_dttm, 0, 10) || ' ' || hour_to as lcl_datetime_hour_to,

    tariff_class_code,
    (not SetIsDisjoint(ToSet(Yson::ConvertTo(enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS)) and executor_status_code = 'free') 
        or (executor_status_code in ['transporting','driving','waiting'] and tariff_class_code in $LOG_TARIFFS) as sh_delivery_flg,


    from RANGE($FCT_STATE_HIST, $START_DT_STR, $END_DT_STR) as a
    --from $FCT_STATE_HIST_S as a 
    left join $fct_order_filtered as fo 
    on fo.order_id == a.order_id 
    --left join $tags_data_agg as tag 
    --on tag.executor_profile_id == a.executor_profile_id and tag.park_taximeter_id == a.park_taximeter_id and tag.utc_date == substring(a.utc_valid_from_dttm, 0, 10)
    --left join $LINK_UNIQUE_DRIVER_ID as link 
    --on link.old_unique_driver_id == a.old_unique_driver_id
    where a.profile_status_rank == 1
        and a.executor_status_code in ('driving', 'waiting', 'transporting', 'free')
        --and not SetIsDisjoint(ToSet(Yson::ConvertTo(a.enabled_tariff_class_code_list, List<String?>?)), ToSet($LOG_TARIFFS)) 
        and substring(utc_valid_from_dttm, 0, 10) between $START_DT_STR and $END_DT_STR
        --and executor_profile_id = 'bfcb419bfbd30b8ddb642b2393ef5187'
        --and executor_profile_id == ''
        --and (a.executor_status_code = 'free' 
                --or (a.order_id in (select order_id from $fct_order_filtered) and a.executor_status_code in ('driving', 'waiting', 'transporting')))
);


$sh_data_raw_lcl1 = (
    SELECT t.*, 
        min_of(substring(utc_valid_to_dttm, 0, 10) || ' ' || hour_to, utc_valid_to_dttm) as utc_valid_to_dttm,
        max_of(substring(utc_valid_from_dttm, 0, 10) || ' ' || hour_from,utc_valid_from_dttm) as utc_valid_from_dttm,

        coalesce(t.tariff_geo_zone_code, ex_p.park_agglomeration_tariff_zone) as tariff_zone,

        t.tariff_geo_zone_code is null as tariff_geo_zone_code_by_park_flg,

        hour_from as utc_hour_from_str,
        CAST(substring(hour_from, 0, 2) as Int64) as utc_hour_from_int,

        $diff_sec(min_of(substring(utc_valid_to_dttm, 0, 10) || ' ' || hour_to, utc_valid_to_dttm), max_of(substring(utc_valid_from_dttm, 0, 10) || ' ' || hour_from,utc_valid_from_dttm)) as duration_within_hour_sec,


        park_time_zone_code,
        park_agglomeration_geo_node_id,
        park_agglomeration_tariff_zone,
        current_unique_driver_id,
        ex_p.old_unique_driver_id as old_unique_driver_id,
        executor_employment_type,
        taximeter_locale_code,
        taximeter_platform,
        taximeter_version_code,
        phone_pd_id_list


        without t.utc_valid_from_dttm, t.utc_valid_to_dttm, t.timezone_diff, t.old_unique_driver_id
    from $sh_data_raw as t
    left join $exec_park_geo_data as ex_p 
    on ex_p.utc_date = t.utc_date and ex_p.dbid_uuid == t.dbid_uuid
    cross join $hours as h 
    where (substring(t.utc_valid_from_dttm, 0, 10) || ' ' || hour_from <= t.utc_valid_to_dttm and substring(t.utc_valid_to_dttm, 0, 10) || ' ' || hour_to >= t.utc_valid_from_dttm)
        and substring(t.utc_valid_from_dttm, 0, 10) between $START_DT_STR and $END_DT_STR
);

$sh_data_raw_lcl2 = (
    select t.*, 
        coalesce(geo.time_zone_code, park_time_zone_code) as time_zone_code,
        $datetime_format(AddTimezone(Datetime::MakeDatetime($datetime_parse(utc_valid_from_dttm)), coalesce(geo.time_zone_code, park_time_zone_code))) as lcl_valid_from_dttm,
        $datetime_format(AddTimezone(Datetime::MakeDatetime($datetime_parse(utc_valid_to_dttm)), coalesce(geo.time_zone_code, park_time_zone_code))) as lcl_valid_to_dttm
    without t.lcl_valid_from_dttm, t.lcl_valid_to_dttm
    from $sh_data_raw_lcl1 as t 
    left join $geo as geo 
    on geo.tariff_zone == t.tariff_zone

);


$sh_data_raw_lcl3 = (
    select t.*, 
        CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64) as timezone_diff,
        (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 as lcl_hour_from,

        case when (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 between 0 and 7 then 'night'
        when (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 between 8 and 11 then 'morning'
        when (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 between 12 and 16 then 'day'
        when (utc_hour_from_int + CAST($diff_sec(lcl_valid_from_dttm, utc_valid_from_dttm) / 3600 as Int64)) % 24 between 17 and 23 then 'evening'
        else 'unknown' end as day_period_name,

        substring(lcl_valid_from_dttm, 0, 10) as lcl_date,


    from $sh_data_raw_lcl2 as t 
);

$sh_data_raw_lcl4 = (select t.*, TableRow().$date_type as _date from $sh_data_raw_lcl3 as t);

$exec_geo_data = (
    select dbid_uuid, park_taximeter_id, executor_profile_id, 
        --old_unique_driver_id ,
        _date, 
        max_by(tariff_zone, sh_all) as tariff_geo_zone_code,
        from (select dbid_uuid, park_taximeter_id, executor_profile_id, _date, tariff_zone, sum(duration_within_hour_sec) as sh_all 
              from $sh_data_raw_lcl3 
              group by dbid_uuid, park_taximeter_id, executor_profile_id, TableRow().$date_type as _date, tariff_zone) as t
        group by dbid_uuid, park_taximeter_id, executor_profile_id,  _date 

);


$sh_data_agg = (
    select dbid_uuid, park_taximeter_id, executor_profile_id, 
        --utc_date, 
        _date,

        -- tariffs flg 
        max(tariff_cargo_on) as tariff_cargo_on_flg,
        MAX(tariff_cargocorp_on) as tariff_cargocorp_on_flg,
        max(tariff_courier_on) as tariff_courier_on_flg,
        max(tariff_express_on) as tariff_express_on_flg,
        max(tariff_night_on) as tariff_night_on_flg,
        max(tariff_ubernight_on) as tariff_ubernight_on_flg,
        max(tariff_any_delivery_on) as tariff_any_delivery_on_flg,
        --max(tariff_any_taxi_on) as tariff_any_taxi_on_flg,
        max(tariff_any_other_tariff_on) as tariff_any_other_tariff_on_flg,

        ex_geo.tariff_geo_zone_code as tariff_geo_zone_code,
        --
        SUM(duration_within_hour_sec)/3600.0 as sh_all,

        --sh by day period 
        SUM_IF(duration_within_hour_sec, day_period_name = 'evening')/3600.0 as sh_evening,
        SUM_IF(duration_within_hour_sec, day_period_name = 'night')/3600.0 as sh_night,
        SUM_IF(duration_within_hour_sec, day_period_name = 'morning')/3600.0 as sh_morning,
        SUM_IF(duration_within_hour_sec, day_period_name = 'day')/3600.0 as sh_day,
        SUM_IF(duration_within_hour_sec, day_period_name = 'unknown')/3600.0 as sh_unknown,

        --sh by executor_status_code
        SUM_IF(duration_within_hour_sec, executor_status_code = 'free')/3600.0 as sh_free,
        SUM_IF(duration_within_hour_sec, executor_status_code = 'driving')/3600.0 as sh_driving,
        SUM_IF(duration_within_hour_sec, executor_status_code = 'waiting')/3600.0 as sh_waiting,
        SUM_IF(duration_within_hour_sec, executor_status_code = 'transporting')/3600.0 as sh_transporting,

        --sh by day day_period_name and executor_status_code
        SUM_IF(duration_within_hour_sec, day_period_name = 'evening' and executor_status_code = 'free')/3600.0 as sh_free_evening,
        SUM_IF(duration_within_hour_sec, day_period_name = 'night' and executor_status_code = 'free')/3600.0 as sh_free_night,
        SUM_IF(duration_within_hour_sec, day_period_name = 'morning' and executor_status_code = 'free')/3600.0 as sh_free_morning,
        SUM_IF(duration_within_hour_sec, day_period_name = 'day' and executor_status_code = 'free')/3600.0 as sh_free_day,
        SUM_IF(duration_within_hour_sec, day_period_name = 'unknown' and executor_status_code = 'free')/3600.0 as sh_free_unknown,

        SUM_IF(duration_within_hour_sec, day_period_name = 'evening' and executor_status_code = 'transporting')/3600.0 as sh_transporting_evening,
        SUM_IF(duration_within_hour_sec, day_period_name = 'night' and executor_status_code = 'transporting')/3600.0 as sh_transporting_night,
        SUM_IF(duration_within_hour_sec, day_period_name = 'morning' and executor_status_code = 'transporting')/3600.0 as sh_transporting_morning,
        SUM_IF(duration_within_hour_sec, day_period_name = 'day' and executor_status_code = 'transporting')/3600.0 as sh_transporting_day,
        SUM_IF(duration_within_hour_sec, day_period_name = 'unknown' and executor_status_code = 'transporting')/3600.0 as sh_transporting_unknown,

        SUM_IF(duration_within_hour_sec, day_period_name = 'evening' and executor_status_code = 'driving')/3600.0 as sh_driving_evening,
        SUM_IF(duration_within_hour_sec, day_period_name = 'night' and executor_status_code = 'driving')/3600.0 as sh_driving_night,
        SUM_IF(duration_within_hour_sec, day_period_name = 'morning' and executor_status_code = 'driving')/3600.0 as sh_driving_morning,
        SUM_IF(duration_within_hour_sec, day_period_name = 'day' and executor_status_code = 'driving')/3600.0 as sh_driving_day,
        SUM_IF(duration_within_hour_sec, day_period_name = 'unknown' and executor_status_code = 'driving')/3600.0 as sh_driving_unknown,

        SUM_IF(duration_within_hour_sec, day_period_name = 'evening' and executor_status_code = 'waiting')/3600.0 as sh_waiting_evening,
        SUM_IF(duration_within_hour_sec, day_period_name = 'night' and executor_status_code = 'waiting')/3600.0 as sh_waiting_night,
        SUM_IF(duration_within_hour_sec, day_period_name = 'morning' and executor_status_code = 'waiting')/3600.0 as sh_waiting_morning,
        SUM_IF(duration_within_hour_sec, day_period_name = 'day' and executor_status_code = 'waiting')/3600.0 as sh_waiting_day,
        SUM_IF(duration_within_hour_sec, day_period_name = 'unknown' and executor_status_code = 'waiting')/3600.0 as sh_waiting_unknown,
        
        --delivery sh 
        SUM_IF(duration_within_hour_sec, sh_delivery_flg)/3600.0 as sh_delivery, 
        
        --delivery sh by day period 
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'evening')/3600.0 as sh_delivery_evening,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'night')/3600.0 as sh_delivery_night,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'morning')/3600.0 as sh_delivery_morning,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'day')/3600.0 as sh_delivery_day,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'unknown')/3600.0 as sh_delivery_unknown,

        --delivery sh by executor_status_code
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and executor_status_code = 'free')/3600.0 as sh_delivery_free,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and executor_status_code = 'driving')/3600.0 as sh_delivery_driving,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and executor_status_code = 'waiting')/3600.0 as sh_delivery_waiting,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and executor_status_code = 'transporting')/3600.0 as sh_delivery_transporting,

        --delivery sh by day day_period_name and executor_status_code
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'evening' and executor_status_code = 'free')/3600.0 as sh_delivery_free_evening,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'night' and executor_status_code = 'free')/3600.0 as sh_delivery_free_night,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'morning' and executor_status_code = 'free')/3600.0 as sh_delivery_free_morning,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'day' and executor_status_code = 'free')/3600.0 as sh_delivery_free_day,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'unknown' and executor_status_code = 'free')/3600.0 as sh_delivery_free_unknown,

        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'evening' and executor_status_code = 'transporting') /3600.0 as sh_delivery_transporting_evening,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'night' and executor_status_code = 'transporting')/3600.0 as sh_delivery_transporting_night,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'morning' and executor_status_code = 'transporting')/3600.0 as sh_delivery_transporting_morning,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'day' and executor_status_code = 'transporting')/3600.0 as sh_delivery_transporting_day,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'unknown' and executor_status_code = 'transporting')/3600.0 as sh_delivery_transporting_unknown,

        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'evening' and executor_status_code = 'driving')/3600.0 as sh_delivery_driving_evening,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'night' and executor_status_code = 'driving')/3600.0 as sh_delivery_driving_night,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'morning' and executor_status_code = 'driving')/3600.0 as sh_delivery_driving_morning,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'day' and executor_status_code = 'driving')/3600.0 as sh_delivery_driving_day,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'unknown' and executor_status_code = 'driving')/3600.0 as sh_delivery_driving_unknown,

        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'evening' and executor_status_code = 'waiting')/3600.0 as sh_delivery_waiting_evening,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'night' and executor_status_code = 'waiting')/3600.0 as sh_delivery_waiting_night,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'morning' and executor_status_code = 'waiting')/3600.0 as sh_delivery_waiting_morning,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'day' and executor_status_code = 'waiting')/3600.0 as sh_delivery_waiting_day,
        SUM_IF(duration_within_hour_sec, sh_delivery_flg and day_period_name = 'unknown' and executor_status_code = 'waiting')/3600.0 as sh_delivery_waiting_unknown,

        max_by(park_time_zone_code, utc_valid_from_dttm) as park_time_zone_code,
        max_by(park_agglomeration_geo_node_id, utc_valid_from_dttm) as park_agglomeration_geo_node_id,
        max_by(park_agglomeration_tariff_zone, utc_valid_from_dttm) as park_agglomeration_tariff_zone,
        max_by(current_unique_driver_id, utc_valid_from_dttm) as current_unique_driver_id,
        max_by(old_unique_driver_id, utc_valid_from_dttm) as old_unique_driver_id,
        max_by(executor_employment_type, utc_valid_from_dttm) as executor_employment_type,
        max_by(taximeter_locale_code, utc_valid_from_dttm) as taximeter_locale_code,
        max_by(taximeter_platform, utc_valid_from_dttm) as taximeter_platform,
        max_by(taximeter_version_code, utc_valid_from_dttm) as taximeter_version_code,
        max_by(phone_pd_id_list, utc_valid_from_dttm) as phone_pd_id_list,


    from --`//home/taxi-delivery/analytics/dev/product/adhocs/sh_data_raw` 
        $sh_data_raw_lcl4 as t 
    left join $exec_geo_data as ex_geo 
    on ex_geo.dbid_uuid == t.dbid_uuid and ex_geo._date == t._date
    group by t.dbid_uuid as dbid_uuid, t.park_taximeter_id as park_taximeter_id, t.executor_profile_id as executor_profile_id, 
        --old_unique_driver_id, 
        t._date as _date, ex_geo.tariff_geo_zone_code
        --unique_driver_id

);


/* 

case 
    WHEN medical_card and not medical_card_off 
        then True
    else False  
end as has_medical_card,
case 
    when thermobag_confirmed
        then True
    else False
end as has_thermobag,
case 
    when thermopack_confirmed
        then True
    else False
end as has_thermopack,
case
    when vaccination_first and vaccination_second
        then True
    else False
end as is_vaccinated,
case 
    when profi_courier
        then True
    else False
end as is_courier_plus

case
    when max(delivery_fulltimer_core) over w then 'delivery_fulltimer_core'
    when max(delivery_fulltimer_noncore) over w then 'delivery_fulltimer_noncore'
    when max(delivery_newbie_exclusive) over w then 'delivery_newbie_exclusive'
    when max(delivery_newbie_mixed_delivery) over w then 'delivery_newbie_mixed_delivery'
    when max(delivery_newbie_mixed_taxi) over w then 'delivery_newbie_mixed_taxi'
    when max(delivery_parttimer_experienced_exclusive) over w then 'delivery_parttimer_experienced_exclusive'
    when max(delivery_parttimer_experienced_mixed_delivery) over w then 'delivery_parttimer_experienced_mixed_delivery'
    when max(delivery_parttimer_experienced_mixed_taxi) over w then 'delivery_parttimer_experienced_mixed_taxi'
    when max(delivery_parttimer_inexperienced_exclusive) over w then 'delivery_parttimer_inexperienced_exclusive'
    when max(delivery_parttimer_inexperienced_mixed_delivery) over w then 'delivery_parttimer_inexperienced_mixed_delivery'
    when max(delivery_parttimer_inexperienced_mixed_taxi) over w then 'delivery_parttimer_inexperienced_mixed_taxi'
    else 'other'
end as courier_segmentation_label,


--courier_segmentation_label,
    --has_medical_card,
    --has_thermobag,
    --has_thermopack,
    --is_courier_plus,
    --is_vaccinated,

*/ 






$fct_order_data_raw = (

select 
    taximeter_park_id || '_' || executor_profile_id as dbid_uuid,
    taximeter_park_id as park_taximeter_id, executor_profile_id,
    order_id,
    utc_order_created_dttm,
    utc_order_created_dt as utc_date,
    tariff_class_code,
    tariff_geo_zone_code,
    success_order_flg as success_order_flg,
    tariff_class_code in $LOG_TARIFFS as order_is_delivery_flg,
    currency_rate,

    lcl_order_created_dttm,
    lcl_order_created_dt as lcl_date,

    CASE 
        WHEN b.corp_order_flg and b.success_order_flg 
            THEN b.decoupling_driver_cost*b.currency_rate
        WHEN b.success_order_flg 
            THEN b.order_cost*b.currency_rate
        else 0 
    end as driver_cost,

    b.order_cost*b.currency_rate as order_cost,

    CASE 
        WHEN success_order_flg OR b.paid_cancel_order_flg 
            THEN (b.driver_cost + subsidy_value + b.holded_subsidy_value + subsidy_commission_discount_value - order_commission_w_discount_wo_vat_value - order_commission_vat_value - shift_commission_w_vat_value - call_center_commission_w_vat_value - childchair_rent_w_vat_value - voucher_commission_wo_vat_value - holded_subsidy_commission_value - subsidy_commission_value - driver_fix_comission_wo_vat_amt - driver_fix_comission_for_fraud_wo_vat_amt - acquiring_commission_value - rebate_w_vat_value - agency_commission_w_vat_value) * b.currency_rate
        ELSE 0 
    END AS driver_net_income,
    CASE 
        WHEN b.success_order_flg 
            THEN (b.subsidy_value + b.holded_subsidy_value + b.dms_value + 
                b.holded_dms_value + b.subsidy_commission_discount_value - b.subsidy_commission_value) * b.currency_rate
        ELSE 0 
    END AS subsidy_value,
    CASE WHEN b.success_order_flg THEN 
        (b.order_commission_w_discount_wo_vat_value + b.order_commission_discount_wo_vat_value + b.shift_commission_wo_vat_value +
        b.acquiring_commission_value + b.agency_commission_wo_vat_value + b.call_center_commission_wo_vat_value + 
        b.hiring_commission_wo_vat_value + b.hiring_shift_commission_wo_vat_value + b.childchair_rent_wo_vat_value +
        b.driver_fix_comission_wo_vat_amt + b.driver_fix_comission_for_fraud_wo_vat_amt + b.rebate_w_vat_value + 
        b.voucher_commission_wo_vat_value) * b.currency_rate
            ELSE 0 
    END as commission,

from 
RANGE($FCT_ORDER, $START_MONTH_STR, $END_MONTH_STR) as b
where utc_order_created_dt between $START_DT_STR and $END_DT_STR
);

$fct_order_agg = (
    select dbid_uuid, executor_profile_id, park_taximeter_id, _date,

        sum(driver_cost) as driver_cost,
        sum_if(driver_cost, order_is_delivery_flg) as driver_cost_delivery,

        sum(driver_net_income) as driver_net_income,
        sum_if(driver_net_income, tariff_class_code not in $LOG_TARIFFS) as driver_net_income_not_delivery,
        sum_if(driver_net_income, tariff_class_code in $LOG_TARIFFS) as driver_net_income_delivery,
        sum_if(driver_net_income, tariff_class_code = 'courier') as driver_net_income_courier,
        sum_if(driver_net_income, tariff_class_code = 'express') as driver_net_income_express,
        sum_if(driver_net_income, tariff_class_code in ['cargo']) as driver_net_income_cargo, 
        sum_if(driver_net_income, tariff_class_code in ['cargocorp']) as driver_net_income_cargocorp, 
        sum_if(driver_net_income, tariff_class_code in ['cargo', 'cargocorp']) as driver_net_income_cargo_all, 
        sum_if(driver_net_income, tariff_class_code in $LOG_TARIFFS and tariff_class_code not in ['express','courier','cargo','cargocorp']) as driver_net_income_delivery_other,

        SUM(commission) as commission,
        SUM_IF(commission, order_is_delivery_flg) as commission_delivery,

        sum(order_cost) as GMV,
        sum_if(order_cost, tariff_class_code not in $LOG_TARIFFS) as GMV_not_delivery,
        sum_if(order_cost, tariff_class_code in $LOG_TARIFFS) as GMV_delivery,
        sum_if(order_cost, tariff_class_code = 'courier') as GMV_courier,
        sum_if(order_cost, tariff_class_code = 'express') as GMV_express,
        sum_if(order_cost, tariff_class_code in ['cargo']) as GMV_cargo, 
        sum_if(order_cost, tariff_class_code in ['cargocorp']) as GMV_cargocorp, 
        sum_if(order_cost, tariff_class_code in ['cargo', 'cargocorp']) as GMV_cargo_all, 
        sum_if(order_cost, tariff_class_code in $LOG_TARIFFS and tariff_class_code not in ['express','courier','cargo','cargocorp']) as GMV_delivery_other,

        count(order_id) as orders_cnt,
        count_if(tariff_class_code not in $LOG_TARIFFS) as orders_not_delivery_cnt,
        count_if(tariff_class_code in $LOG_TARIFFS) as orders_delivery_cnt,
        count_if(tariff_class_code = 'courier') as orders_courier_cnt,
        count_if(tariff_class_code = 'express') as orders_express_cnt,
        count_if(tariff_class_code in ['cargo']) as orders_cargo_cnt, 
        count_if(tariff_class_code in ['cargocorp']) as orders_cargocorp_cnt, 
        count_if(tariff_class_code in ['cargo', 'cargocorp']) as orders_cargo_all_cnt, 
        count_if(tariff_class_code in $LOG_TARIFFS and tariff_class_code not in ['express','courier','cargo','cargocorp']) as orders_delivery_other_cnt,

        count_if(success_order_flg) as trips_cnt,
        count_if(success_order_flg and tariff_class_code not in $LOG_TARIFFS) as trips_not_delivery_cnt,
        count_if(success_order_flg and tariff_class_code in $LOG_TARIFFS) as trips_delivery_cnt,
        count_if(success_order_flg and tariff_class_code = 'courier') as trips_courier_cnt,
        count_if(success_order_flg and tariff_class_code = 'express') as trips_express_cnt,
        count_if(success_order_flg and tariff_class_code in ['cargo']) as trips_cargo_cnt, 
        count_if(success_order_flg and tariff_class_code in ['cargocorp']) as trips_cargocorp_cnt, 
        count_if(success_order_flg and tariff_class_code in ['cargo', 'cargocorp']) as trips_cargo_all_cnt, 
        count_if(success_order_flg and tariff_class_code in $LOG_TARIFFS and tariff_class_code not in ['express','courier','cargo','cargocorp']) as trips_delivery_other_cnt,

        sum(subsidy_value) as subsidy_value,
        sum_if(subsidy_value, tariff_class_code in $LOG_TARIFFS) as subsidy_value_delivery,


    from $fct_order_data_raw 
    group by dbid_uuid, executor_profile_id, park_taximeter_id, 
    --utc_date
    TableRow().$date_type as _date



);



$fct_order_candidate_raw = (
    select foc.order_id as order_id, foc.executor_profile_id as executor_profile_id, 
            foc.park_taximeter_id as park_taximeter_id, 
            foc.park_taximeter_id || '_' || foc.executor_profile_id as dbid_uuid,
            tariff_class_code,
            utc_offered_dttm, utc_seen_dttm, utc_assigned_dttm, utc_date,
            utc_offered_dttm is not null as offer_flg,

            lcl_date,
    from RANGE($FCT_ORDER_CANDIDATE, $START_MONTH_STR, $END_MONTH_STR) as foc 
    left join $fct_order_data_raw as fo 
    on fo.order_id == foc.order_id
    where utc_date between $START_DT_STR and $END_DT_STR

);


$fct_order_candidate_agg = (
    select _date, executor_profile_id, park_taximeter_id, dbid_uuid,

        count(order_id) as offers_cnt,
        count_if(offer_flg and tariff_class_code not in $LOG_TARIFFS) as offers_not_delivery_cnt,
        count_if(offer_flg and tariff_class_code in $LOG_TARIFFS) as offers_delivery_cnt,
        count_if(offer_flg and tariff_class_code = 'courier') as offers_courier_cnt,
        count_if(offer_flg and tariff_class_code = 'express') as offers_express_cnt,
        count_if(offer_flg and tariff_class_code in ['cargo']) as offers_cargo_cnt, 
        count_if(offer_flg and tariff_class_code in ['cargocorp']) as offers_cargocorp_cnt, 
        count_if(offer_flg and tariff_class_code in ['cargo', 'cargocorp']) as offers_cargo_all_cnt, 
        count_if(offer_flg and tariff_class_code in $LOG_TARIFFS and tariff_class_code not in ['express','courier','cargo','cargocorp']) as offers_delivery_other_cnt,
    from $fct_order_candidate_raw
    where utc_date between $START_DT_STR and $END_DT_STR
    group by --utc_date, 
       TableRow().$date_type as _date, executor_profile_id, park_taximeter_id, park_taximeter_id || '_' || executor_profile_id as dbid_uuid
);







$fct_subsidy_data_raw = (


Select 
    fs.db_id as park_taximeter_id,
    fs.driver_id as executor_profile_id,
    fs.utc_created_dt as utc_date,
    fs.db_id || '_' || fs.driver_id as dbid_uuid,
    fs.tariff_zone as tariff_geo_zone_code,

    curr.rate as currency_rate,

    fo.tariff_class_code as tariff_class_code,
    fo.tariff_class_code in $LOG_TARIFFS as order_is_delivery_flg,
    fo.tariff_geo_zone_code as tariff_geo_zone_code_fo, 
    fo.currency_rate as currency_rate_fo, 


    fs.value_w_commission as value_w_commission,
    fs.detailed_product_name as detailed_product_name,


    substring($datetime_format(AddTimezone(Datetime::MakeDatetime($datetime_parse(utc_created_dttm)), time_zone_code)),0,10) as lcl_date,


from RANGE($FCT_SUBSIDY_PATH, $START_MONTH_STR, $END_MONTH_STR) as fs
left join $fct_order_data_raw as fo 
    on fs.order_id == fo.order_id
left join $DIM_CURRENCY_RATE as curr 
    on fs.currency_code == curr.source_cur
    and fs.utc_created_dt == curr.`date`
left join $geo as geo 
on geo.tariff_zone == fs.tariff_zone
where curr.target_cur == 'RUB'
--where b.tariff_class_code in ('courier', 'express', 'cargo', 'cargocorp', 'night', 'ubernight')
);



$fct_subsidy_data_agg = (

        select dbid_uuid, executor_profile_id, park_taximeter_id, _date,
        sum(case when a.detailed_product_name == 'subsidy_do_x_get_y' and order_is_delivery_flg then value_w_commission * currency_rate_fo else Null end) as subsidy_doxgety_net_value,
        sum(case when a.detailed_product_name == 'subsidy_mfg' and order_is_delivery_flg  then a.value_w_commission * currency_rate_fo else Null end) as subsidy_mfg_net_value,
        sum(case when a.detailed_product_name == 'subsidy_mfg_geo' and order_is_delivery_flg  then a.value_w_commission * currency_rate_fo else Null end) as subsidy_mfg_geo_net_value,
        sum(case when a.detailed_product_name == 'subsidy_misc' and order_is_delivery_flg  then a.value_w_commission * currency_rate_fo else Null end) as subsidy_misc_net_value,
        sum(case when a.detailed_product_name == 'subsidy_nmfg' and order_is_delivery_flg  then a.value_w_commission * currency_rate_fo else Null end) as subsidy_nmfg_net_value,
        sum(case when a.detailed_product_name == 'subsidy_booking_geo_guarantee'  then a.value_w_commission * currency_rate else Null end) as subsidy_booking_geo_guarantee_net_value,
        FROM $fct_subsidy_data_raw  as a 
        group by dbid_uuid, executor_profile_id, park_taximeter_id, --utc_date
           TableRow().$date_type as _date

);










$cars_raw  =(
SELECT
    Yson::ConvertToString(doc.park_id) || "_" || Yson::ConvertToString(doc.car_id) as park_car_id
    , Yson::ConvertToInt64(doc.carrying_capacity) as cc
    , Yson::ConvertToInt64(doc.cargo_hold_dimensions.height) as h
    , Yson::ConvertToInt64(doc.cargo_hold_dimensions.length) as l
    , Yson::ConvertToInt64(doc.cargo_hold_dimensions.width) as w
FROM $CARS_TABLE
WHERE Yson::ConvertToBool(doc.category.cargo) = true
);

$cars_labeled = (
select distinct c.*
    , CASE 
        when (
            (cc between $to_int64($config.lcv_l.carrying_capacity_min_kg) and $to_int64($config.lcv_l.carrying_capacity_max_kg))
            AND
            (h between $to_int64($config.lcv_l.height_min_cm) and $to_int64($config.lcv_l.height_max_cm))
            AND 
            (l between $to_int64($config.lcv_l.length_min_cm) and $to_int64($config.lcv_l.length_max_cm))
            AND
            (w between $to_int64($config.lcv_l.width_min_cm) and $to_int64($config.lcv_l.width_max_cm))
            
        )
        then 'cargo_size_large'
        when (
            (cc between $to_int64($config.lcv_m.carrying_capacity_min_kg) and $to_int64($config.lcv_m.carrying_capacity_max_kg))
            AND
            (h between $to_int64($config.lcv_m.height_min_cm) and $to_int64($config.lcv_m.height_max_cm))
            AND 
            (l between $to_int64($config.lcv_m.length_min_cm) and $to_int64($config.lcv_m.length_max_cm))
            AND
            (w between $to_int64($config.lcv_m.width_min_cm) and $to_int64($config.lcv_m.width_max_cm))
            
        )
        then 'cargo_size_medium'
        when (
            (cc between $to_int64($config.van.carrying_capacity_min_kg) and $to_int64($config.van.carrying_capacity_max_kg))
            AND
            (h between $to_int64($config.van.height_min_cm) and $to_int64($config.van.height_max_cm))
            AND 
            (l between $to_int64($config.van.length_min_cm) and $to_int64($config.van.length_max_cm))
            AND
            (w between $to_int64($config.van.width_min_cm) and $to_int64($config.van.width_max_cm))
            
        ) 
        then 'cargo_size_van'
        else 'error'
    END as car_size,
    d.cargo_loaders_amount as cargo_loaders_amount

from $cars_raw as c
inner join 

(select park_id, car_id, max(cargo_loaders_amount) as cargo_loaders_amount from $PDA_CARS group by park_id, car_id) as d

on c.park_car_id == d.park_id || '_' || d.car_id
);



$pda_drivers = (select distinct park_id, car_id, driver_id from $PDA_DRIVERS);


$courier_type_and_transport_type_data = (
    select distinct sh.dbid_uuid as dbid_uuid, 
        sh.park_taximeter_id as park_taximeter_id, 
        sh.executor_profile_id as executor_profile_id, 
        sh._date as _date,
        sh.tariff_geo_zone_code as tariff_geo_zone_code,

        $week(sh._date) as _week_dt,
        $month(sh._date) as _month_dt,

        case 
    when (tariff_cargo_on_flg or tariff_cargocorp_on_flg) and c.car_size == 'cargo_size_van'
        then 'cargo_van'
    when (tariff_cargo_on_flg or tariff_cargocorp_on_flg) and c.car_size == 'cargo_size_medium'
        then 'cargo_medium'
    when (tariff_cargo_on_flg or tariff_cargocorp_on_flg) and c.car_size == 'cargo_size_large'
        then 'cargo_large'
    when (tariff_cargo_on_flg or tariff_cargocorp_on_flg)
        then 'cargo_unknown_size'
    when bike_courier
        then 'bike_courier'
    when scooter_courier
        then 'scooter_courier'
    when walking_courier
        then 'walking_courier'


    when (sh_with_auto_courier)/sh_all >= 0.95
        then 'strictly_auto_courier'

    when sh_delivery/sh_all >= 0.5
        then 'more_likely_auto_courier'
    else 
    'more_likely_taxi'

    end as courier_type,

    case 
    when (tariff_cargo_on_flg or tariff_cargocorp_on_flg) and c.car_size == 'cargo_size_van'
        then 'Грузовой_маленький'
    when (tariff_cargo_on_flg or tariff_cargocorp_on_flg) and c.car_size == 'cargo_size_medium'
        then 'Грузовой_средний'
    when (tariff_cargo_on_flg or tariff_cargocorp_on_flg) and c.car_size == 'cargo_size_large'
        then 'Грузовой_большой'
    when (tariff_cargo_on_flg or tariff_cargocorp_on_flg)
        then 'Грузовой_нет_размера'
    when bike_courier
        then 'Мотоцикл'
    when scooter_courier
        then 'Велосипед'
    when walking_courier
        then 'Пешеход'

    when (sh_with_auto_courier)/sh_all >= 0.95
        then 'Строго Авто-Курьер'

    when sh_delivery/sh_all >= 0.5
        then 'Скорее Авто-Курьер'
    else 
    'Скорее Такси'

    end as transport_type,
    cargo_loaders_amount,


from $sh_data_agg as sh 
    left join $tags_data_agg as tags 
    on tags.dbid_uuid == sh.dbid_uuid and tags._date == sh._date --and sh.unique_driver_id == tags.unique_driver_id 
        and tags.executor_profile_id == sh.executor_profile_id and tags.park_taximeter_id == sh.park_taximeter_id
    left join 
    $pda_drivers as drivers
    on sh.dbid_uuid == drivers.park_id || '_' || drivers.driver_id
    left join
    $cars_labeled as c
    on drivers.park_id || '_' || drivers.car_id == c.park_car_id 
);



$courier_type_and_transport_type_weekly_data = (

SELECT

dbid_uuid,
executor_profile_id, park_taximeter_id,
_week_dt,

case 
    when cargo_large_days > 0 then 'cargo_large'
    when cargo_medium_days > 0 then 'cargo_medium'
    when cargo_van_days > 0 then 'cargo_van'
    when bike_courier_days > 0 then 'bike_courier'
    when scooter_courier_days > 0 and scooter_courier_days >= walking_courier_days then 'scooter_courier'
    when walking_courier_days > 0 then 'walking_courier'
    when strictly_auto_courier_days > more_likely_auto_courier_days and strictly_auto_courier_days > more_likely_taxi_days then 'strictly_auto_courier'
    when more_likely_auto_courier_days >= strictly_auto_courier_days and more_likely_auto_courier_days >= strictly_auto_courier_days then 'more_likely_auto_courier'
    else 'more_likely_taxi'
    end as courier_type_weekly


from


(SELECT
dbid_uuid,
executor_profile_id, park_taximeter_id,
_week_dt,

count(distinct case when courier_type == 'cargo_van' then _date else Null end) as cargo_van_days,
count(distinct case when courier_type == 'cargo_medium' then _date else Null end) as cargo_medium_days,
count(distinct case when courier_type == 'cargo_large' then _date else Null end) as cargo_large_days,
count(distinct case when courier_type == 'cargo_unknown_size' then _date else Null end) as cargo_unknown_size_days,
count(distinct case when courier_type == 'bike_courier' then _date else Null end) as bike_courier_days,
count(distinct case when courier_type == 'scooter_courier' then _date else Null end) as scooter_courier_days,
count(distinct case when courier_type == 'walking_courier' then _date else Null end) as walking_courier_days,
count(distinct case when courier_type == 'strictly_auto_courier' then _date else Null end) as strictly_auto_courier_days,
count(distinct case when courier_type == 'more_likely_auto_courier' then _date else Null end) as more_likely_auto_courier_days,
count(distinct case when courier_type == 'more_likely_taxi' then _date else Null end) as more_likely_taxi_days,
count(distinct _date) as all_days,


from

$courier_type_and_transport_type_data

group by dbid_uuid, executor_profile_id, park_taximeter_id, --utc_week_dt)
    _week_dt)

);


$courier_type_and_transport_type_monthly_data = (

SELECT

dbid_uuid,
executor_profile_id, park_taximeter_id,
_month_dt,

case 
    when cargo_large_days > 0 then 'cargo_large'
    when cargo_medium_days > 0 then 'cargo_medium'
    when cargo_van_days > 0 then 'cargo_van'
    when bike_courier_days > 0 then 'bike_courier'
    when scooter_courier_days > 0 and scooter_courier_days >= walking_courier_days then 'scooter_courier'
    when walking_courier_days > 0 then 'walking_courier'
    when strictly_auto_courier_days > more_likely_auto_courier_days and strictly_auto_courier_days > more_likely_taxi_days then 'strictly_auto_courier'
    when more_likely_auto_courier_days >= strictly_auto_courier_days and more_likely_auto_courier_days >= strictly_auto_courier_days then 'more_likely_auto_courier'
    else 'more_likely_taxi'
    end as courier_type_monthly


from


(SELECT
dbid_uuid,
executor_profile_id, park_taximeter_id,
_month_dt,

count(distinct case when courier_type == 'cargo_van' then _date else Null end) as cargo_van_days,
count(distinct case when courier_type == 'cargo_medium' then _date else Null end) as cargo_medium_days,
count(distinct case when courier_type == 'cargo_large' then _date else Null end) as cargo_large_days,
count(distinct case when courier_type == 'cargo_unknown_size' then _date else Null end) as cargo_unknown_size_days,
count(distinct case when courier_type == 'bike_courier' then _date else Null end) as bike_courier_days,
count(distinct case when courier_type == 'scooter_courier' then _date else Null end) as scooter_courier_days,
count(distinct case when courier_type == 'walking_courier' then _date else Null end) as walking_courier_days,
count(distinct case when courier_type == 'strictly_auto_courier' then _date else Null end) as strictly_auto_courier_days,
count(distinct case when courier_type == 'more_likely_auto_courier' then _date else Null end) as more_likely_auto_courier_days,
count(distinct case when courier_type == 'more_likely_taxi' then _date else Null end) as more_likely_taxi_days,
count(distinct _date) as all_days,


from

$courier_type_and_transport_type_data

group by dbid_uuid, executor_profile_id, park_taximeter_id, _month_dt)

);



$pda_parks_data = (
    select distinct id as park_taximeter_id, name as park_name,
        case 
    when ListHas(Yson::ConvertToStringList(park_specifications), 'delivery') and ListHas(Yson::ConvertToStringList(park_specifications), 'taxi')
        then 'delivery_and_taxi'
    when ListHas(Yson::ConvertToStringList(park_specifications), 'delivery')
        then 'delivery'
    when ListHas(Yson::ConvertToStringList(park_specifications), 'taxi')
        then 'taxi'
    else 'other'
    end as park_specification,
    CASE 
    when driver_partner_source == 'selfemployed_fns'
        then 'selfemployed'
    when org_name like '%Индивидуальный предприниматель%' or org_name like '%ИП %' or name like '%ИП %'
        then 'individual_entrepreneur'
    else 
        'other'
    end as park_type
    from $PDA_PARKS
);


$park_exec_cnt_data = (

    select 
    _date,
    tariff_geo_zone_code,
    park_taximeter_id,
    count(distinct case when transport_type != 'Такси' then executor_profile_id else Null end) as park_delivery_executors_cnt,

    from $courier_type_and_transport_type_data as a 

    group by  _date, a.tariff_geo_zone_code as tariff_geo_zone_code, a.park_taximeter_id as park_taximeter_id


);




$activity_window_first_delivey_order_data = (

select
distinct 
unique_driver_id,
activity_window_seq,
min_by(agglomeration_geo_node_name_ru, utc_first_order_tariff_dttm) as agglomeration_first_delivery_order,
String::SplitToList(min(utc_first_order_tariff_dttm), ' ')[0] as utc_first_order_delivery_dt
FROM $DM_DRIVER_LICENSE_ACTIVITY_WINDOW_TARIFF_CLASS 

where tariff_class_code in $LOG_TARIFFS

group by 
unique_driver_id,
activity_window_seq
);




$activity_window_data_raw = (
    select w.executor_profile_id as executor_profile_id,
        w.park_taximeter_id as park_taximeter_id, 
        w.unique_driver_id as unique_driver_id, 
        w.activity_window_seq as activity_window_seq,

        w.agglomeration_geo_node_name_ru as agglomeration_geo_node_name_ru,
        last_acquisition_medium_code,
        SUBSTRING(utc_activity_window_start_dttm,0,10) as utc_activity_window_start_dt,
        utc_activity_window_start_dttm,

        --join 
        agglomeration_first_delivery_order,
        utc_first_order_delivery_dt,

        from $DM_DRIVER_LICENSE_ACTIVITY_WINDOW_TICKET as w 
        left join $activity_window_first_delivey_order_data as od 
        on w.unique_driver_id == od.unique_driver_id and w.activity_window_seq == od.activity_window_seq


);




$activity_window_data_daily_with_windows = (
    select dbid_uuid, _date, --executor_profile_id, park_taximeter_id, 
    

        if(max(utc_activity_window_start_dt)>_date, null, max(utc_activity_window_start_dt)) as utc_activity_window_start_dt,
        max_by(ac.last_acquisition_medium_code, if(utc_activity_window_start_dt>_date, null, utc_activity_window_start_dttm)) as last_acquisition_medium_code,
        max_by(activity_window_seq, if(utc_activity_window_start_dt > _date, null, utc_activity_window_start_dttm)) as activity_window_number,

        min_by(agglomeration_geo_node_name_ru, if(utc_activity_window_start_dt>_date, null, utc_activity_window_start_dttm)) as agglomeration_first_order_ever,
        if(min(utc_activity_window_start_dt)>_date, null, min(utc_activity_window_start_dt)) as utc_first_order_ever_dt,

        min_by(agglomeration_first_delivery_order, if(utc_activity_window_start_dt>_date, null, utc_activity_window_start_dttm)) as agglomeration_first_delivery_order,
        if(min(utc_first_order_delivery_dt)>_date, null, min(utc_first_order_delivery_dt)) as utc_first_order_delivery_dt, 

    from $sh_data_agg as d 
    left join $activity_window_data_raw as ac 
    on d.old_unique_driver_id == ac.unique_driver_id
    group by d.dbid_uuid as dbid_uuid, 
        d._date as _date
        --d.executor_profile_id as executor_profile_id, 
        --d.park_taximeter_id as park_taximeter_id,
        
);






$all_data = (
    select sh.dbid_uuid as dbid_uuid, 
        sh.park_taximeter_id as park_taximeter_id, 
        sh.executor_profile_id as executor_profile_id, 
        sh._date as utc_date,
        sh.old_unique_driver_id as unique_driver_id,
    --sh
    coalesce(sh_all, 0) as sh_all,
    coalesce(sh_delivery_free, 0) as sh_delivery_free,
    coalesce(sh_delivery_waiting, 0) as sh_delivery_waiting,
    coalesce(sh_delivery_driving, 0) as sh_delivery_driving,
    coalesce(sh_delivery_transporting,0) as sh_delivery_transporting,
    coalesce(sh_delivery_driving_day,0) as sh_delivery_driving_day,
    coalesce(sh_delivery_driving_evening,0) as sh_delivery_driving_evening,
    coalesce(sh_delivery_driving_morning,0) as sh_delivery_driving_morning,
    coalesce(sh_delivery_driving_night,0) as sh_delivery_driving_night,
    coalesce(sh_delivery_driving_unknown,0) as sh_delivery_driving_unknown,
    coalesce(sh_delivery_free_day,0) as sh_delivery_free_day,
    coalesce(sh_delivery_free_evening,0) as sh_delivery_free_evening,
    coalesce(sh_delivery_free_morning,0) as sh_delivery_free_morning,
    coalesce(sh_delivery_free_night,0) as sh_delivery_free_night,
    coalesce(sh_delivery_free_unknown,0) as sh_delivery_free_unknown,
    coalesce(sh_delivery_day,0) as sh_delivery_day,
    coalesce(sh_delivery_evening,0) as sh_delivery_evening,
    coalesce(sh_delivery_morning,0) as sh_delivery_morning,
    coalesce(sh_delivery_night,0) as sh_delivery_night,
    coalesce(sh_delivery_unknown,0) as sh_delivery_unknown,
    coalesce(sh_delivery_transporting_day,0) as sh_delivery_transporting_day,
    coalesce(sh_delivery_transporting_evening,0) as sh_delivery_transporting_evening,
    coalesce(sh_delivery_transporting_morning,0) as sh_delivery_transporting_morning,
    coalesce(sh_delivery_transporting_night,0) as sh_delivery_transporting_night,
    coalesce(sh_delivery_transporting_unknown,0) as sh_delivery_transporting_unknown,
    coalesce(sh_delivery_waiting_day,0) as sh_delivery_waiting_day,
    coalesce(sh_delivery_waiting_evening,0) as sh_delivery_waiting_evening,
    coalesce(sh_delivery_waiting_morning,0) as sh_delivery_waiting_morning,
    coalesce(sh_delivery_waiting_night,0) as sh_delivery_waiting_night,
    coalesce(sh_delivery_waiting_unknown,0) as sh_delivery_waiting_unknown,
    coalesce(sh_driving_day,0) as sh_driving_day,
    coalesce(sh_driving_evening,0) as sh_driving_evening,
    coalesce(sh_driving_morning,0) as sh_driving_morning,
    coalesce(sh_driving_night,0) as sh_driving_night,
    coalesce(sh_driving_unknown,0) as sh_driving_unknown,
    coalesce(sh_driving,0) as sh_driving,
    coalesce(sh_free_day,0) as sh_free_day,
    coalesce(sh_free_evening,0) as sh_free_evening,
    coalesce(sh_free_morning,0) as sh_free_morning,
    coalesce(sh_free_night,0) as sh_free_night,
    coalesce(sh_free_unknown,0) as sh_free_unknown,
    coalesce(sh_free,0) as sh_free,
    coalesce(sh_delivery,0) as sh_delivery,
    coalesce(tariff_any_delivery_on_flg, False) as tariff_any_delivery_on_flg,
    coalesce(sh_day,0) as sh_day,
    coalesce(sh_evening,0) as sh_evening,
    coalesce(sh_morning,0) as sh_morning,
    coalesce(sh_night,0) as sh_night, 
    coalesce(sh_unknown,0) as sh_unknown,
    coalesce(tariff_cargo_on_flg,False) as tariff_cargo_on_flg,
    coalesce(tariff_cargocorp_on_flg,False) as tariff_cargocorp_on_flg,
    coalesce(tariff_courier_on_flg,False) as tariff_courier_on_flg,
    coalesce(tariff_express_on_flg,False) as tariff_express_on_flg,
    coalesce(tariff_night_on_flg,False) as tariff_night_on_flg,
    coalesce(tariff_ubernight_on_flg,False) as tariff_ubernight_on_flg,
    coalesce(tariff_any_other_tariff_on_flg,False) as tariff_any_other_tariff_on_flg,
    coalesce(sh.tariff_geo_zone_code, 'unknown') as tariff_geo_zone_code,
    coalesce(sh_transporting_day, 0) as sh_transporting_day,
    coalesce(sh_transporting_evening, 0) as sh_transporting_evening,
    coalesce(sh_transporting_morning, 0) as sh_transporting_morning,
    coalesce(sh_transporting_night, 0) as sh_transporting_night,
    coalesce(sh_transporting_unknown, 0) as sh_transporting_unknown,
    coalesce(sh_transporting, 0) as sh_transporting,
    coalesce(sh_waiting_day, 0) as sh_waiting_day,
    coalesce(sh_waiting_evening,0) as sh_waiting_evening,
    coalesce(sh_waiting_morning,0) as sh_waiting_morning,
    coalesce(sh_waiting_night,0) as sh_waiting_night,
    coalesce(sh_waiting_unknown,0) as sh_waiting_unknown,
    coalesce(sh_waiting, 0) as sh_waiting,
    

    --sh and tags 
    coalesce(allow_heavy_delivery,False) as allow_heavy_delivery,
    coalesce(allow_profi_courier,False) as allow_profi_courier,
    coalesce(auto_courier,False) as auto_courier,
    coalesce(bike_courier,False) as bike_courier,
    coalesce(logistic_workshift_subscribed,False) as logistic_workshift_subscribed,
    coalesce(medical_card,False) as medical_card,
    coalesce(medical_card_off,False) as medical_card_off,
    coalesce(post_payment,False) as post_payment, 
    coalesce(profi_courier,False) as profi_courier,
    coalesce(scooter_courier,False) as scooter_courier,
    coalesce(offline_onboarding_visit, False) as offline_onboarding_visit,

    coalesce(sh_with_auto_courier,0) as sh_with_auto_courier,
    coalesce(sh_with_delivery,0) as sh_with_delivery, 
    coalesce(sh_with_taxi,0) as sh_with_taxi,
    coalesce(sh_delivery_only,0) as sh_delivery_only,

    coalesce(taxi_courier,False) as taxi_courier,
    coalesce(thermobag_confirmed,False) as thermobag_confirmed,
    coalesce(thermopack_confirmed,False) as thermopack_confirmed,
    coalesce(vaccination_enabled,False) as vaccination_enabled,
    coalesce(vaccination_first,False) as vaccination_first,
    coalesce(vaccination_second,False) as vaccination_second,
    coalesce(walking_courier,False) as walking_courier,
    coalesce(delivery_fulltimer_core,False) as delivery_fulltimer_core,
    coalesce(delivery_fulltimer_noncore,False) as delivery_fulltimer_noncore,
    coalesce(delivery_newbie_exclusive,False) as delivery_newbie_exclusive,
    coalesce(delivery_newbie_mixed_delivery,False) as delivery_newbie_mixed_delivery,
    coalesce(delivery_newbie_mixed_taxi,False) as delivery_newbie_mixed_taxi,
    coalesce(delivery_parttimer_experienced_exclusive,False) as delivery_parttimer_experienced_exclusive,
    coalesce(delivery_parttimer_experienced_mixed_delivery,False) as delivery_parttimer_experienced_mixed_delivery,
    coalesce(delivery_parttimer_experienced_mixed_taxi,False) as delivery_parttimer_experienced_mixed_taxi,
    coalesce(delivery_parttimer_inexperienced_exclusive,False) as delivery_parttimer_inexperienced_exclusive,
    coalesce(delivery_parttimer_inexperienced_mixed_delivery,False) as delivery_parttimer_inexperienced_mixed_delivery,
    coalesce(delivery_parttimer_inexperienced_mixed_taxi,False) as delivery_parttimer_inexperienced_mixed_taxi,

    case 
        WHEN medical_card and not medical_card_off 
            then True
        else False  
    end as has_medical_card,
    case 
        when thermobag_confirmed
            then True
        else False
    end as has_thermobag,
    case 
        when thermopack_confirmed
            then True
        else False
    end as has_thermopack,
    case
        when vaccination_first and vaccination_second
            then True
        else False
    end as is_vaccinated,
    case 
        when profi_courier
            then True
        else False
    end as is_courier_plus,
    case
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_fulltimer_core_dttm then 'delivery_fulltimer_core'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_fulltimer_noncore_dttm then 'delivery_fulltimer_noncore'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_newbie_exclusive_dttm then 'delivery_newbie_exclusive'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_newbie_mixed_delivery_dttm then 'delivery_newbie_mixed_delivery'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_newbie_mixed_taxi_dttm then 'delivery_newbie_mixed_taxi'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm ,'0000-00-00 00:00:00'))=delivery_parttimer_experienced_exclusive_dttm then 'delivery_parttimer_experienced_exclusive'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_parttimer_experienced_mixed_delivery_dttm then 'delivery_parttimer_experienced_mixed_delivery'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_parttimer_experienced_mixed_taxi_dttm then 'delivery_parttimer_experienced_mixed_taxi'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_parttimer_inexperienced_exclusive_dttm then 'delivery_parttimer_inexperienced_exclusive'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_parttimer_inexperienced_mixed_delivery_dttm then 'delivery_parttimer_inexperienced_mixed_delivery'
        when max_of(coalesce(delivery_fulltimer_core_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_fulltimer_noncore_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_newbie_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_experienced_mixed_taxi_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_exclusive_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_delivery_dttm, '0000-00-00 00:00:00'),
                    coalesce(delivery_parttimer_inexperienced_mixed_taxi_dttm, '0000-00-00 00:00:00'))=delivery_parttimer_inexperienced_mixed_taxi_dttm then 'delivery_parttimer_inexperienced_mixed_taxi'
        else 'other'
    end as courier_segmentation_label,




    -- fct order 
    coalesce(driver_cost,0) as driver_cost,
    coalesce(driver_cost_delivery,0) as driver_cost_delivery,

    coalesce(driver_net_income,0) as driver_net_income,
    coalesce(driver_net_income_not_delivery,0) as driver_net_income_not_delivery,
    coalesce(driver_net_income_delivery,0) as driver_net_income_delivery,
    coalesce(driver_net_income_courier,0) as driver_net_income_courier,
    coalesce(driver_net_income_express,0) as driver_net_income_express,
    coalesce(driver_net_income_cargo, 0) as driver_net_income_cargo,
    coalesce(driver_net_income_cargocorp, 0) as driver_net_income_cargocorp,
    coalesce(driver_net_income_cargo_all, 0) as driver_net_income_cargo_all,
    coalesce(driver_net_income_delivery_other,0) as driver_net_income_delivery_other,

    coalesce(commission,0) as commission,
    coalesce(commission_delivery,0) as commission_delivery,

    coalesce(GMV,0) as GMV,
    coalesce(GMV_not_delivery,0) as GMV_not_delivery,
    coalesce(GMV_delivery,0) as GMV_delivery,
    coalesce(GMV_courier,0) as GMV_courier,
    coalesce(GMV_express,0) as GMV_express,
    coalesce(GMV_cargo, 0) as GMV_cargo,
    coalesce(GMV_cargocorp, 0) as GMV_cargocorp,
    coalesce(GMV_cargo_all, 0) as GMV_cargo_all,
    coalesce(GMV_delivery_other,0) as GMV_delivery_other,

    coalesce(orders_cnt,0) as orders_cnt,
    coalesce(orders_not_delivery_cnt,0) as orders_not_delivery_cnt,
    coalesce(orders_delivery_cnt,0) as orders_delivery_cnt,
    coalesce(orders_courier_cnt,0) as orders_courier_cnt,
    coalesce(orders_express_cnt,0) as orders_express_cnt,
    coalesce(orders_cargo_cnt, 0) as orders_cargo_cnt,
    coalesce(orders_cargocorp_cnt, 0) as orders_cargocorp_cnt,
    coalesce(orders_cargo_all_cnt, 0) as orders_cargo_all_cnt,
    coalesce(orders_delivery_other_cnt,0) as orders_delivery_other_cnt,

    coalesce(trips_cnt,0) as trips_cnt,
    coalesce(trips_not_delivery_cnt,0) as trips_not_delivery_cnt,
    coalesce(trips_delivery_cnt,0) as trips_delivery_cnt,
    coalesce(trips_courier_cnt,0) as trips_courier_cnt,
    coalesce(trips_express_cnt,0) as trips_express_cnt,
    coalesce(trips_cargo_cnt, 0) as trips_cargo_cnt,
    coalesce(trips_cargocorp_cnt, 0) as trips_cargocorp_cnt,
    coalesce(trips_cargo_all_cnt, 0) as trips_cargo_all_cnt,
    coalesce(trips_delivery_other_cnt,0) as trips_delivery_other_cnt,

    coalesce(subsidy_value,0) as subsidy_value,
    coalesce(subsidy_value_delivery,0) as subsidy_value_delivery,

    -- offers 
    coalesce(offers_cnt,0) as offers_cnt,
    coalesce(offers_not_delivery_cnt,0) as offers_not_delivery_cnt,
    coalesce(offers_delivery_cnt,0) as offers_delivery_cnt,
    coalesce(offers_courier_cnt,0) as offers_courier_cnt,
    coalesce(offers_express_cnt,0) as offers_express_cnt,
    coalesce(offers_cargo_cnt, 0) as offers_cargo_cnt,
    coalesce(offers_cargocorp_cnt, 0) as offers_cargocorp_cnt,
    coalesce(offers_cargo_all_cnt, 0) as offers_cargo_all_cnt,
    coalesce(offers_delivery_other_cnt,0) as offers_delivery_other_cnt,


    --subsidy 
    coalesce(subsidy_booking_geo_guarantee_net_value,0) as subsidy_booking_geo_guarantee_net_value,
    coalesce(subsidy_doxgety_net_value,0) as subsidy_doxgety_net_value,
    coalesce(subsidy_mfg_geo_net_value,0) as subsidy_mfg_geo_net_value,
    coalesce(subsidy_mfg_net_value,0) as subsidy_mfg_net_value,
    coalesce(subsidy_misc_net_value,0) as subsidy_misc_net_value,
    coalesce(subsidy_nmfg_net_value,0) as subsidy_nmfg_net_value,

    --geo 
    tz_country_name_ru as country,
    population_group,
    agglomeration,


    --courier type and transport type + weekly monthly 
    courier_type,
    transport_type,
    cargo_loaders_amount,
    courier_type_weekly,
    courier_type_monthly,

    --park
    park_delivery_executors_cnt,
    park_name,
    park_specification,
    park_type,

    --activity window 
    utc_activity_window_start_dt,
    last_acquisition_medium_code,
    activity_window_number,
    agglomeration_first_order_ever,
    utc_first_order_ever_dt,
    agglomeration_first_delivery_order,
    utc_first_order_delivery_dt,
    taximeter_locale_code, 
    taximeter_platform, 
    taximeter_version_code,
    String::SplitToList(taximeter_version_code, ' ')[0] as taximeter_version,
    phone_pd_id_list,
    executor_employment_type,


    from $sh_data_agg as sh 
    left join $tags_data_agg as tag 
    on tag.dbid_uuid == sh.dbid_uuid 
        and tag.park_taximeter_id == sh.park_taximeter_id 
        and tag.executor_profile_id == sh.executor_profile_id 
        and tag._date == sh._date
    left join $fct_order_agg as fo
     on fo.dbid_uuid == sh.dbid_uuid 
        and fo.park_taximeter_id == sh.park_taximeter_id 
        and fo.executor_profile_id == sh.executor_profile_id 
        and fo._date == sh._date
    left join $fct_order_candidate_agg as foc 
    on foc.dbid_uuid == sh.dbid_uuid 
        and foc.park_taximeter_id == sh.park_taximeter_id 
        and foc.executor_profile_id == sh.executor_profile_id 
        and foc._date == sh._date
    left join $fct_subsidy_data_agg as fs 
    on fs.dbid_uuid == sh.dbid_uuid 
        and fs.park_taximeter_id == sh.park_taximeter_id 
        and fs.executor_profile_id == sh.executor_profile_id 
        and fs._date == sh._date
    left join $geo as geo 
    on geo.tariff_zone == sh.tariff_geo_zone_code
    left join $courier_type_and_transport_type_data as type 
    on type.dbid_uuid == sh.dbid_uuid 
        and type.park_taximeter_id == sh.park_taximeter_id 
        and type.executor_profile_id == sh.executor_profile_id 
        and type._date == sh._date
    left join $courier_type_and_transport_type_weekly_data as typew 
    on typew.dbid_uuid == sh.dbid_uuid 
        and typew.park_taximeter_id == sh.park_taximeter_id 
        and typew.executor_profile_id == sh.executor_profile_id 
        and typew._week_dt == $week(sh._date)
    left join $courier_type_and_transport_type_monthly_data as typem 
    on typem.dbid_uuid == sh.dbid_uuid 
        and typem.park_taximeter_id == sh.park_taximeter_id 
        and typem.executor_profile_id == sh.executor_profile_id 
        and typem._month_dt == $month(sh._date)
    left join $park_exec_cnt_data as park_cnt  
    on park_cnt.park_taximeter_id == sh.park_taximeter_id 
        and park_cnt._date == sh._date 
        and park_cnt.tariff_geo_zone_code == sh.tariff_geo_zone_code
    left join $pda_parks_data as park_pda
    on park_pda.park_taximeter_id == sh.park_taximeter_id 
    left join $activity_window_data_daily_with_windows as ac 
    on ac.dbid_uuid == sh.dbid_uuid
        and ac._date == sh._date 
    --where sh_delivery > 0
    where 1==1
        and sh_delivery > 0 

);


$all_data2 = (
select 
utc_date,

GMV_cargo,
GMV_courier,
GMV_express,
GMV_delivery_other as GMV_other_delivery, 
GMV_not_delivery as GMV_taxi,
activity_window_number,
utc_activity_window_start_dt as activity_window_start_date,
agglomeration,
sh_all as all_sh,
allow_heavy_delivery,
allow_profi_courier,
auto_courier,
bike_courier,
cargo_loaders_amount,
commission,
country,
courier_segmentation_label,
courier_type,
dbid_uuid,
park_delivery_executors_cnt as delivery_drivers_in_park,

sh_delivery_driving_day as delivery_driving_sh_day,
sh_delivery_driving_evening as delivery_driving_sh_evening,
sh_delivery_driving_morning as delivery_driving_sh_morning,
sh_delivery_driving_night as delivery_driving_sh_night,
sh_delivery_driving_unknown as delivery_driving_sh_unknown,
sh_delivery_driving as delivery_sh_driving,

sh_delivery_free_day as delivery_free_sh_day,
sh_delivery_free_evening as delivery_free_sh_evening,
sh_delivery_free_morning as delivery_free_sh_morning,
sh_delivery_free_night as delivery_free_sh_night,
sh_delivery_free_unknown as delivery_free_sh_unknown,
sh_delivery_free as delivery_sh_free,


sh_delivery_day as delivery_sh_day,
sh_delivery_evening as delivery_sh_evening,
sh_delivery_morning as delivery_sh_morning,
sh_delivery_night as delivery_sh_night,
sh_delivery_unknown as delivery_sh_unknown,
sh_delivery as delivery_sh,

agglomeration_first_delivery_order as  delivery_start_agglomeration,
utc_first_order_delivery_dt as delivery_start_utc_dt,

sh_delivery_transporting_day as delivery_transporting_sh_day,
sh_delivery_transporting_evening as delivery_transporting_sh_evening,
sh_delivery_transporting_morning as delivery_transporting_sh_morning,
sh_delivery_transporting_night as delivery_transporting_sh_night,
sh_delivery_transporting_unknown as delivery_transporting_sh_unknown,
sh_delivery_transporting as sh_delivery_transporting,

sh_delivery_waiting_day as delivery_waiting_sh_day,
sh_delivery_waiting_evening as delivery_waiting_sh_evening,
sh_delivery_waiting_morning as delivery_waiting_sh_morning,
sh_delivery_waiting_night as delivery_waiting_sh_night,
sh_delivery_waiting_unknown as delivery_waiting_sh_unknown,
sh_delivery_waiting as sh_delivery_waiting,
driver_cost,

driver_net_income_cargo,
driver_net_income_courier,
driver_net_income_express,
driver_net_income_delivery_other as driver_net_income_other_delivery,
driver_net_income_not_delivery as driver_net_income_taxi,

sh_driving_day as driving_sh_day,
sh_driving_evening as driving_sh_evening,
sh_driving_morning as driving_sh_morning,
sh_driving_night as driving_sh_night,
sh_driving_unknown as driving_sh_unknown,
sh_driving as driving_sh,

tariff_geo_zone_code as fct_tariff_zone,
agglomeration_first_order_ever as first_ever_order_agglomeration,
utc_first_order_ever_dt as first_ever_order_utc_dt,

sh_free_day as free_sh_day,
sh_free_evening as free_sh_evening,
sh_free_morning as free_sh_morning,
sh_free_night as free_sh_night,
sh_free_unknown as free_sh_unknown, 
sh_free as free_sh,
has_medical_card,
has_thermobag,
has_thermopack,
is_courier_plus,
is_vaccinated,
last_acquisition_medium_code,
logistic_workshift_subscribed,
medical_card,
medical_card_off,
courier_type_monthly as monthly_courier_type,
offers_cargo_all_cnt as number_of_offers_cargo,
offers_courier_cnt as number_of_offers_courier,
offers_express_cnt as number_of_offers_express,
offers_delivery_other_cnt as number_of_offers_other_delivery,
offers_not_delivery_cnt as number_of_offers_taxi,

orders_cargo_all_cnt as number_of_orders_cargo,
orders_courier_cnt as number_of_orders_courier,
orders_express_cnt as number_of_orders_express,
orders_delivery_other_cnt as number_of_orders_other_delivery,
orders_not_delivery_cnt as number_of_orders_taxi,
trips_cargo_all_cnt as number_of_trips_cargo,
trips_courier_cnt as number_of_trips_courier,
trips_express_cnt as number_of_trips_express,
trips_delivery_other_cnt as number_of_trips_other_delivery,
trips_not_delivery_cnt as number_of_trips_taxi,

sh_delivery_only as only_delivery_sh,
tariff_any_other_tariff_on_flg as other_tariffs_on,
park_taximeter_id as park_id,
park_name,
park_specification,
park_type,
population_group,
post_payment,
profi_courier,
scooter_courier,
sh_day,
sh_evening,
sh_morning,
sh_night,
sh_with_auto_courier,
sh_with_delivery,
sh_with_taxi,
subsidy_booking_geo_guarantee_net_value,
subsidy_doxgety_net_value,
subsidy_mfg_geo_net_value,
subsidy_mfg_net_value,
subsidy_misc_net_value,
subsidy_nmfg_net_value,
subsidy_value,
tariff_cargo_on_flg as tariff_cargo_on,
tariff_cargocorp_on_flg as tariff_cargocorp_on,
tariff_courier_on_flg as tariff_courier_on,
tariff_express_on_flg as tariff_express_on,
tariff_night_on_flg as tariff_night_on,
tariff_ubernight_on_flg as tariff_ubernight_on,
tariff_geo_zone_code as tariff_zone,
taxi_courier,
thermobag_confirmed,
thermopack_confirmed,
transport_type,
sh_transporting_day as transporting_sh_day,
sh_transporting_evening as transporting_sh_evening,
sh_transporting_morning as transporting_sh_morning,
sh_transporting_night as transporting_sh_night,
sh_transporting_unknown as transporting_sh_unknown,
sh_transporting as transporting_sh,

vaccination_enabled,
vaccination_first,
vaccination_second,
sh_waiting_day as waiting_sh_day,
sh_waiting_evening as waiting_sh_evening,
sh_waiting_morning as waiting_sh_morning,
sh_waiting_night as waiting_sh_night,
walking_courier,
courier_type_weekly as weekly_courier_type ,

offline_onboarding_visit,

unique_driver_id,

taximeter_locale_code, 
taximeter_platform, 
taximeter_version_code,
taximeter_version,
phone_pd_id_list,

executor_employment_type,

from $all_data
);


--SAVE 


$get_table_name = ($datetime) -> (
    substring(cast($datetime as String), 0, 10)
);

$get_month_interval_len = ($end_month, $start_month) -> (
	(DateTime::GetYear($end_month) - DateTime::GetYear($start_month)) * 12
	+ (DateTime::GetMonth($end_month) - DateTime::GetMonth($start_month))
);

$months_from_range = ($start_month, $end_month) -> {
    return ListMap(
        ListFromRange(0, $get_month_interval_len($end_month, $start_month) + 1 ?? 0),
        ($d) -> (DateTime::MakeDate(DateTime::ShiftMonths($start_month, $d)))
    );
};

define action $split_data($PARENT_FOLDER_PATH, $start_month, $end_month) as
    evaluate for $date in $months_from_range($start_month, $end_month) do begin
        $dir = $PARENT_FOLDER_PATH || "/" || $get_table_name($date);

		insert into $dir with truncate
		select
			*
		from $all_data2 as t
		where substring(utc_date, 0, 7) == substring($get_table_name($date),0,7);

    end do;
end define;


DO $split_data($PARENT_FOLDER_PATH, $START_FIRST_FULL_MONTH_DTTM, $END_DTTM);
