use hahn;
PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma SimpleColumns;

$FCT_ORDER = '//home/taxi-dwh/cdm/marketplace/fct_order';
$GEO = '//home/taxi-dwh/cdm/geo/v_dim_full_geo_hierarchy/v_dim_full_geo_hierarchy';

$SAVE_TO = '//home/taxi-delivery/analytics/production/smb_model/users_features';

$DELIVERY_TARIFFS = (
    'express'
    , 'courier'
);

$ORDER_SOURCES = (
    'yandex'
    , 'cargo'
);

$APP_PALTFORMS = (
    'android'
    , 'iphone'
);

$today = CurrentUtcDate();
$yesterday = cast($today - Interval('P1D') as String);
$days_before_364 =  cast($today - 52*Interval('P1W') as String); -- almost 1 year without seasonality

$start_month_fo = substring($days_before_364, 0, 7) || '-01';
$end_month_fo = substring($yesterday, 0, 7) || '-01';

$WORKING_HOURS_MIN = 9;
$WORKING_HOURS_MAX = 17;
$WORKING_DAYS_MIN = 1;
$WORKING_DAYS_MAX = 5;

$last_week_start = cast(cast($yesterday as Date) - 6*Interval('P1D') as String);
$last_4weeks_start = cast(cast($yesterday as Date) - (4*7 - 1)*Interval('P1D') as String);

$last_8weeks_start = cast(cast($yesterday as Date) - (8*7 - 1)*Interval('P1D') as String);
$last_8weeks_4weeks_end = cast(cast($yesterday as Date) - (4*7)*Interval('P1D') as String);

$last_12weeks_start = cast(cast($yesterday as Date) - (12*7 - 1)*Interval('P1D') as String);
$last_12weeks_4weeks_end = cast(cast($yesterday as Date) - (8*7)*Interval('P1D') as String);

$last_16weeks_start = cast(cast($yesterday as Date) - (16*7 - 1)*Interval('P1D') as String);
$last_16weeks_4weeks_end = cast(cast($yesterday as Date) - (12*7)*Interval('P1D') as String);

$last_20weeks_start = cast(cast($yesterday as Date) - (20*7 - 1)*Interval('P1D') as String);
$last_20weeks_4weeks_end = cast(cast($yesterday as Date) - (16*7)*Interval('P1D') as String);

$last_24weeks_start = cast(cast($yesterday as Date) - (24*7 - 1)*Interval('P1D') as String);
$last_24weeks_4weeks_end = cast(cast($yesterday as Date) - (20*7)*Interval('P1D') as String);

$last_28weeks_start = cast(cast($yesterday as Date) - (28*7 - 1)*Interval('P1D') as String);
$last_28weeks_4weeks_end = cast(cast($yesterday as Date) - (24*7)*Interval('P1D') as String);

$last_32weeks_start = cast(cast($yesterday as Date) - (32*7 - 1)*Interval('P1D') as String);
$last_32weeks_4weeks_end = cast(cast($yesterday as Date) - (28*7)*Interval('P1D') as String);

$last_36weeks_start = cast(cast($yesterday as Date) - (36*7 - 1)*Interval('P1D') as String);
$last_36weeks_4weeks_end = cast(cast($yesterday as Date) - (32*7)*Interval('P1D') as String);

$last_40weeks_start = cast(cast($yesterday as Date) - (40*7 - 1)*Interval('P1D') as String);
$last_40weeks_4weeks_end = cast(cast($yesterday as Date) - (36*7)*Interval('P1D') as String);

$last_44weeks_start = cast(cast($yesterday as Date) - (44*7 - 1)*Interval('P1D') as String);
$last_44weeks_4weeks_end = cast(cast($yesterday as Date) - (40*7)*Interval('P1D') as String);

$last_48weeks_start = cast(cast($yesterday as Date) - (48*7 - 1)*Interval('P1D') as String);
$last_48weeks_4weeks_end = cast(cast($yesterday as Date) - (44*7)*Interval('P1D') as String);

$last_52weeks_start = cast(cast($yesterday as Date) - (52*7 - 1)*Interval('P1D') as String);
$last_52weeks_4weeks_end = cast(cast($yesterday as Date) - (48*7)*Interval('P1D') as String);

$parse = DateTime::Parse('%Y-%m-%d %H:%M:%S');

$THERMOBAG_REQUIREMENT = '%thermobag_covid%';
$DOORTODOOR_REQUIREMENT = '%door_to_door%';

$distinct_users = (
    select distinct user_phone_pd_id
    from range($FCT_ORDER, $start_month_fo, $end_month_fo)
    where 1=1
        and not fake_order_flg
        and not user_fraud_flg
        and not mqc_order_flg
        and not corp_order_flg
        and tariff_class_code in $DELIVERY_TARIFFS
        and order_source_code in $ORDER_SOURCES
        and app_platform_name in $APP_PALTFORMS
        and user_phone_pd_id is not null 
        and success_order_flg
        and utc_order_created_dt >= $days_before_364
);

$users_orders = (
    select user_phone_pd_id
        , source_geohash
        , destination_plan_geohash
        , lcl_order_created_dttm
        , corp_order_flg
        , case
            when user_status='cancelled' and executor_profile_sk is null then 'cancelled_by_client_before'
            when user_status='cancelled' and executor_profile_sk is not null then 'cancelled_by_client_after'
            when user_status='finished' and driver_status='complete' then 'success'
            when user_status='finished' and driver_status='cancelled' then 'cancelled_by_operator'
            when user_status='finished' and driver_status='failed' then 'cancelled_by_driver'
            when user_status='finished' and driver_status='expired' then 'expired'
            else 'not_finished_yet'
        end as human_status 
        , delivery_plan_point_cnt
        , order_requirement_list
        , agglomeration_node_id
        , tariff_class_code
        , order_id
        , tariff_geo_zone_code
    from range($FCT_ORDER, $start_month_fo, $end_month_fo)
    where 1=1
        and user_phone_pd_id in $distinct_users
        and not fake_order_flg
        and not user_fraud_flg
        and not mqc_order_flg 
);

$delivery = (
    select user_phone_pd_id
    
        , count(distinct o.source_geohash) as delivery_uniq_a
        , count(distinct o.destination_plan_geohash) as delivery_uniq_b
        , TryMember(mode(o.source_geohash)[0], 'Value', null) as top_freq_a
        , TryMember(mode(o.destination_plan_geohash)[0], 'Value', null) as top_freq_b

        , count_if(
            (cast(substring(o.lcl_order_created_dttm, 11, 2) as Int32) between $WORKING_HOURS_MIN and $WORKING_HOURS_MAX) 
            and 
            (DateTime::GetDayOfWeek($parse(o.lcl_order_created_dttm)) between $WORKING_DAYS_MIN and $WORKING_DAYS_MAX)
        ) as delivery_orders_in_working_time_cnt
        , count_if(
            DateTime::GetDayOfWeek($parse(o.lcl_order_created_dttm)) between $WORKING_DAYS_MIN and $WORKING_DAYS_MAX
        ) as delivery_orders_in_working_days_cnt

        , count_if(not o.corp_order_flg) as delivery_orders
        , count_if(o.human_status = 'success' and not o.corp_order_flg) as delivery_trips
        , count_if(o.human_status = 'cancelled_by_client_before' and not o.corp_order_flg) as delivery_cancelled_by_client_before
        , count_if(o.human_status = 'cancelled_by_client_after' and not o.corp_order_flg) as delivery_cancelled_by_client_after

        , count_if(o.corp_order_flg) as corp_delivery_orders
        , count_if(o.human_status = 'success' and o.corp_order_flg) as corp_delivery_trips
        , count_if(o.human_status = 'cancelled_by_client_before' and o.corp_order_flg) as corp_delivery_cancelled_by_client_before
        , count_if(o.human_status = 'cancelled_by_client_after' and o.corp_order_flg) as corp_delivery_cancelled_by_client_after

        , count(distinct substring(o.lcl_order_created_dttm, 0, 10)) as delivery_active_days

        , avg(o.delivery_plan_point_cnt) as total_avg_points_in_order
        , count_if(o.order_requirement_list like $THERMOBAG_REQUIREMENT) as total_thermobag_cnt 
        , count_if(o.order_requirement_list like $DOORTODOOR_REQUIREMENT) as total_doortodoor_cnt 

        , count_if(o.lcl_order_created_dttm between $last_week_start and $yesterday) as total_delivery_last_week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_week_start and $yesterday)) as total_delivery_last_week_trips

        , count_if(o.lcl_order_created_dttm between $last_4weeks_start and $yesterday) as total_delivery_4week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_4weeks_start and $yesterday)) as total_delivery_4week_trips

        , count_if(o.lcl_order_created_dttm between $last_8weeks_start and $last_8weeks_4weeks_end) as total_delivery_8week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_8weeks_start and $last_8weeks_4weeks_end)) as total_delivery_8week_trips

        , count_if(o.lcl_order_created_dttm between $last_12weeks_start and $last_12weeks_4weeks_end) as total_delivery_12week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_12weeks_start and $last_12weeks_4weeks_end)) as total_delivery_12week_trips

        , count_if(o.lcl_order_created_dttm between $last_16weeks_start and $last_16weeks_4weeks_end) as total_delivery_16week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_16weeks_start and $last_16weeks_4weeks_end)) as total_delivery_16week_trips

        , count_if(o.lcl_order_created_dttm between $last_20weeks_start and $last_20weeks_4weeks_end) as total_delivery_20week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_20weeks_start and $last_20weeks_4weeks_end)) as total_delivery_20week_trips

        , count_if(o.lcl_order_created_dttm between $last_24weeks_start and $last_24weeks_4weeks_end) as total_delivery_24week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_24weeks_start and $last_24weeks_4weeks_end)) as total_delivery_24week_trips

        , count_if(o.lcl_order_created_dttm between $last_28weeks_start and $last_28weeks_4weeks_end) as total_delivery_28week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_28weeks_start and $last_28weeks_4weeks_end)) as total_delivery_28week_trips

        , count_if(o.lcl_order_created_dttm between $last_32weeks_start and $last_32weeks_4weeks_end) as total_delivery_32week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_32weeks_start and $last_32weeks_4weeks_end)) as total_delivery_32week_trips

        , count_if(o.lcl_order_created_dttm between $last_36weeks_start and $last_36weeks_4weeks_end) as total_delivery_36week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_36weeks_start and $last_36weeks_4weeks_end)) as total_delivery_36week_trips

        , count_if(o.lcl_order_created_dttm between $last_40weeks_start and $last_40weeks_4weeks_end) as total_delivery_40week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_40weeks_start and $last_40weeks_4weeks_end)) as total_delivery_40week_trips

        , count_if(o.lcl_order_created_dttm between $last_44weeks_start and $last_44weeks_4weeks_end) as total_delivery_44week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_44weeks_start and $last_44weeks_4weeks_end)) as total_delivery_44week_trips

        , count_if(o.lcl_order_created_dttm between $last_48weeks_start and $last_48weeks_4weeks_end) as total_delivery_48week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_48weeks_start and $last_48weeks_4weeks_end)) as total_delivery_48week_trips

        , count_if(o.lcl_order_created_dttm between $last_52weeks_start and $last_52weeks_4weeks_end) as total_delivery_52week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_52weeks_start and $last_52weeks_4weeks_end)) as total_delivery_52week_trips

        , TryMember(mode(g.name_ru)[0], 'Value', null) as city_name_ru
        , TryMember(mode(g.population_group)[0], 'Value', null) as population_group
    from $users_orders as o 
    left join $GEO as g on o.tariff_geo_zone_code = g.tariff_zone
    where 1=1
        and o.tariff_class_code in $DELIVERY_TARIFFS
        and g.node_type = 'agglomeration'
        and g.root_node_id = 'br_root'
    group by o.user_phone_pd_id as user_phone_pd_id
);

$not_delivery = (
    select user_phone_pd_id
    
        , count(o.order_id) as not_delivery_orders
        , count_if(o.human_status = 'success') as not_delivery_trips
        , count_if(o.human_status = 'cancelled_by_client_before') as not_delivery_cancelled_by_client_before
        , count_if(o.human_status = 'cancelled_by_client_after') as not_delivery_cancelled_by_client_after

        , count_if(o.lcl_order_created_dttm between $last_week_start and $yesterday) as not_delivery_last_week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_week_start and $yesterday)) as not_delivery_last_week_trips

        , count_if(o.lcl_order_created_dttm between $last_4weeks_start and $yesterday) as not_delivery_4week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_4weeks_start and $yesterday)) as not_delivery_4week_trips

        , count_if(o.lcl_order_created_dttm between $last_8weeks_start and $last_8weeks_4weeks_end) as not_delivery_8week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_8weeks_start and $last_8weeks_4weeks_end)) as not_delivery_8week_trips

        , count_if(o.lcl_order_created_dttm between $last_12weeks_start and $last_12weeks_4weeks_end) as not_delivery_12week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_12weeks_start and $last_12weeks_4weeks_end)) as not_delivery_12week_trips

        , count_if(o.lcl_order_created_dttm between $last_16weeks_start and $last_16weeks_4weeks_end) as not_delivery_16week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_16weeks_start and $last_16weeks_4weeks_end)) as not_delivery_16week_trips

        , count_if(o.lcl_order_created_dttm between $last_20weeks_start and $last_20weeks_4weeks_end) as not_delivery_20week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_20weeks_start and $last_20weeks_4weeks_end)) as not_delivery_20week_trips

        , count_if(o.lcl_order_created_dttm between $last_24weeks_start and $last_24weeks_4weeks_end) as not_delivery_24week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_24weeks_start and $last_24weeks_4weeks_end)) as not_delivery_24week_trips

        , count_if(o.lcl_order_created_dttm between $last_28weeks_start and $last_28weeks_4weeks_end) as not_delivery_28week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_28weeks_start and $last_28weeks_4weeks_end)) as not_delivery_28week_trips

        , count_if(o.lcl_order_created_dttm between $last_32weeks_start and $last_32weeks_4weeks_end) as not_delivery_32week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_32weeks_start and $last_32weeks_4weeks_end)) as not_delivery_32week_trips

        , count_if(o.lcl_order_created_dttm between $last_36weeks_start and $last_36weeks_4weeks_end) as not_delivery_36week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_36weeks_start and $last_36weeks_4weeks_end)) as not_delivery_36week_trips

        , count_if(o.lcl_order_created_dttm between $last_40weeks_start and $last_40weeks_4weeks_end) as not_delivery_40week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_40weeks_start and $last_40weeks_4weeks_end)) as not_delivery_40week_trips

        , count_if(o.lcl_order_created_dttm between $last_44weeks_start and $last_44weeks_4weeks_end) as not_delivery_44week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_44weeks_start and $last_44weeks_4weeks_end)) as not_delivery_44week_trips

        , count_if(o.lcl_order_created_dttm between $last_48weeks_start and $last_48weeks_4weeks_end) as not_delivery_48week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_48weeks_start and $last_48weeks_4weeks_end)) as not_delivery_48week_trips

        , count_if(o.lcl_order_created_dttm between $last_52weeks_start and $last_52weeks_4weeks_end) as not_delivery_52week_orders
        , count_if(o.human_status = 'success' and (o.lcl_order_created_dttm between $last_52weeks_start and $last_52weeks_4weeks_end)) as not_delivery_52week_trips
    from $users_orders as o
    where 1=1
        and o.tariff_class_code not in $DELIVERY_TARIFFS
    group by o.user_phone_pd_id as user_phone_pd_id
);

insert into $SAVE_TO with truncate
select users.*
    , t1.*
    , t2.*
from $distinct_users as users
left join $delivery as t1 on users.user_phone_pd_id=t1.user_phone_pd_id
left join $not_delivery as t2 on users.user_phone_pd_id=t2.user_phone_pd_id;
