use hahn;
PRAGMA yt.Pool = "taxi-delivery";
PRAGMA SimpleColumns;

$PROBAS = "//home/taxi-delivery/analytics/production/smb_model/users_probas";
$QUALITY = "//home/taxi-delivery/analytics/production/smb_model/model_quality_hist";
$SAVE_TO = "//home/taxi-delivery/analytics/production/smb_model/users_smb_flgs/for_dashboards_f1_max";

$threshold = (
    select version
        , max_by(threshold, 2 * (precision * recall) / (precision + recall)) as threshold
    from $QUALITY
    group by version
);

$users_with_flg = (
    select p.user_phone_pd_id as user_phone_pd_id
        , p.utc_prediction_dt as utc_prediction_dt
        , if(p.smb_proba >= t.threshold, 1, 0) as is_smb
    from $PROBAS as p
    left join $threshold as t on p.model_version=t.version
);

$history = (
    select t.user_phone_pd_id
        , t.is_smb
        , t.utc_prediction_dt as utc_valid_from_dt
        , some(utc_prediction_dt) OVER w ?? '9999-12-31' as utc_valid_to_dt
    from $users_with_flg as t
    WINDOW w AS (
        PARTITION BY user_phone_pd_id
        ORDER BY utc_prediction_dt
        ROWS BETWEEN 1 FOLLOWING AND 1 FOLLOWING
    )
);
                 
$first_scoring = (
    select user_phone_pd_id
        , min_by(is_smb, utc_valid_from_dt) as is_smb
        , '1970-01-01' as utc_valid_from_dt
        , min(utc_valid_from_dt) as utc_valid_to_dt
    from $history
    group by user_phone_pd_id
);

insert into $SAVE_TO WITH TRUNCATE 
select * 
from $history
where is_smb = 1
union all
select *
from $first_scoring
where is_smb = 1;
