use hahn;
PRAGMA yt.Pool = "taxi-delivery";
PRAGMA SimpleColumns;

$USER_PROBAS = "//home/taxi-delivery/analytics/production/smb_model/users_probas";
$QUALITY = "//home/taxi-delivery/analytics/production/smb_model/catboost_v0_quality";

$SAVE_TO = "//home/taxi-delivery/analytics/production/smb_model/users_smb_flgs/for_support_tag";

$threshold = (
    select threshold
    from $QUALITY
    where 1=1
        and threshold >= 0.55
    order by threshold
    limit 1
);

$last_scoring_date = (
    select max(utc_prediction_dt) as utc_last_prediction_dt
    from $USER_PROBAS
);

insert into $SAVE_TO WITH TRUNCATE 
select user_phone_pd_id
    , 'is_smb' as smb_flag
from $USER_PROBAS
where 1=1
    and smb_proba >= $threshold
    and utc_prediction_dt = $last_scoring_date;