pragma yson.DisableStrict;

$lucky =
(select value_string, count(*) as success_exam_attempts
from `//home/forms/answers/forms_ext/production/10026794/data`
where answer.data.answer_short_text_10344949.value is not null
and Yson::ConvertToString(answer.quiz.title) = 'Тестирование сдано'
group by Yson::ConvertToString(answer.data.answer_short_text_10344949.value) as value_string
);

$raw_sessions =
select license,
    ListConcat(AGGREGATE_LIST_DISTINCT(Yson::ConvertToString(doc.state)), "; ") as tqc_state
from `//home/taxi-dwh/raw/education/online_sessions/online_sessions`
where Yson::ConvertToString(doc.program) = "«Центр Доставки»"
and Yson::ConvertToString(doc.state) in ("completed", "cancelled", "waiting_briefing_registration")
    group by Yson::ConvertToString(doc.license) as license
;


select a.*
        , case when l.value_string is not null
                then True
                else False
                end as success_exam_flg
        , tqc_state
from (
        select value_string
            , driver_license
            , name
            , max(driver_uuid) as driver_uuid
            , max(city) as city
            , max(center_name) as center_name
            , max(learning_attempts) as learning_attempts
            , max(exam_attempts) as exam_attempts
            , max(max_learning_dt) as max_learning_dt
            , max(max_exam_dt) as max_exam_dt
        from `//home/delivery-dwh/export/logistics/courier_training/courier_training`
        GROUP BY phone as value_string, driver_license, name) as a
left join $lucky as l on a.value_string = l.value_string
left join $raw_sessions as rs on a.driver_license = rs.license
;
