from business_models import hahn, greenplum
import pandas as pd
import numpy as np
import os



commerce = greenplum("""

select
        date,
        tariff,
        tier,
        city,
        industry,
        sum(deliveries) as deliveries,
        sum(gmv) as gmv,
        sum(net_inflow) as net_inflow
from snb_delivery.data_growth_olap_by_city
where
    city in ('Voronezh','Ekaterinburg','Nizhny Novgorod','Ufa','Samara','Kazan','Perm')
    and date >= '2022-01-01'
group by 1,2,3,4,5

""")



operations = hahn("""

PRAGMA yt.Pool = 'taxi-delivery';
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

SELECT
    agglomeration,
    utc_date,
    transport_type,
    count(distinct unique_driver_id) as couriers,
    COUNT(distinct if(has_thermobag, unique_driver_id, null)) as couriers_with_thermobags,
    sum(driver_net_income_cargo
        +driver_net_income_courier
        +driver_net_income_express
        +driver_net_income_other_delivery
        +driver_net_income_taxi) as driver_net_income,
    sum(sh_day+sh_night+sh_evening+sh_morning) as SH,
    sum(number_of_trips_cargo
        + number_of_trips_courier
        + number_of_trips_express
        + number_of_trips_other_delivery
        + number_of_trips_taxi) as trips,
    sum(sh_day+sh_night+sh_evening+sh_morning
        - free_sh_morning
        - free_sh_day
        - free_sh_evening
        - free_sh_night) as SH_utilized
from
    range('//home/taxi-delivery/analytics/production/product/supply_overview','2022-01-01')
where
    agglomeration in ('Воронеж','Екатеринбург','Нижний Новгород','Казань','Уфа','Самара','Пермь')
group by
    agglomeration,
    utc_date,
    transport_type
"""
)



cr = greenplum("""

select
    (fo.utc_order_created_dttm + interval '3 hours')::date as order_date,
    geo.name_ru as city,
    case
        when fo.success_order_flg
        then 'order success'
        else case when user_status = 'cancelled' then 'cancelled by user' else 'cancelled by driver' end
        end as order_status,
    count(1) as orders
from
    taxi_cdm_marketplace.fct_order fo
    left join snb_delivery.self_orders so
        on so.order_id = fo.order_id
    left join
    (
        select distinct node_id, name_ru, population_group
        from core_cdm_geo.dim_full_geo_hierarchy
        where node_type = 'agglomeration'
    )
        as geo on geo.node_id = fo.agglomeration_node_id
where
    fo.utc_order_created_dttm >= '2022-01-01' AT TIME ZONE 'Europe/Moscow' AT TIME ZONE 'UTC'
    and (fo.tariff_class_code in ('cargo', 'express', 'courier', 'cargocorp')
        or (fo.tariff_class_code = 'ubernight' and fo.utc_order_created_dttm >= '2021-09-01')
        or (fo.tariff_class_code = 'uberlux' and fo.utc_order_created_dttm >= '2022-03-01'))
    and not fo.fake_order_flg
    and not fo.mqc_order_flg
    and not fo.user_fraud_flg
    and so.order_id is null
    and geo.name_ru in ('Воронеж','Екатеринбург','Нижний Новгород','Казань','Уфа','Самара','Пермь')
group by 1,2,3

""")



ref_list = [(commerce, 'commerce.xlsx'),
           (operations, 'operations.xlsx'),
           (cr, 'cr.xlsx')]

dataframes = list(map(lambda x: x[0], ref_list))
filenames = list(map(lambda x: x[1], ref_list))

for name, filename in ref_list:
    name.to_excel(filename)



from business_models.startrek import StartrekWrapper

st = StartrekWrapper()

st.comment('LOGDATA-2203',
           text=u"Выгрузка готова",
           attachments=filenames,
           summonees=['alekskrasnov'])

for dataframe, filename in zip(dataframes, filenames):
    os.remove(filename)
    del(dataframe)
