use hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$script = @@
def return_needed_tags(tag_list):
    all_tags = [
        'order_cancellation_after_acceptance',
        'rough_treatment_of_customers',
        'no_heat_capacity_in_the_presence_of_the_tag',
        'undelivered_package',
        'package_theft',
        'drunk_courier',
        'use_of_customer_data_for_personal_purposes',
        'didnt_deliver_it_to_the_door',
        'brought_an_incomplete_or_damaged_package',
        'no_protective_equipment',
        'order_cancellation_after_acceptance_fine',
        'order_cancellation_after_acceptance_not_fine',
        'rough_treatment_of_customers_fine',
        'rough_treatment_of_customers_not_fine',
        'no_heat_capacity_in_the_presence_of_the_tag_fine',
        'no_heat_capacity_in_the_presence_of_the_tag_not_fine',
        'undelivered_package_fine',
        'undelivered_package_not_fine',
        'package_theft_fine',
        'package_theft_not_fine',
        'drunk_courier_fine',
        'drunk_courier_not_fine',
        'use_of_customer_data_for_personal_purposes_fine',
        'use_of_customer_data_for_personal_purposes_not_fine',
        'didnt_deliver_it_to_the_door_fine',
        'didnt_deliver_it_to_the_door_not_fine',
        'brought_an_incomplete_or_damaged_package_fine',
        'brought_an_incomplete_or_damaged_package_not_fine',
        'fine',
        'not_fine',
        'demanded_money_for_the_order_delivery',
        'demanded_money_for_the_order_delivery_fine',
        'demanded_money_for_the_order_delivery_not_fine'
    ]

    answer_list=[]
    for x in tag_list:
        if x in all_tags:
            answer_list.append(x)
    answer_list = sorted(answer_list)
    ans_string = ''
    for x in answer_list:
      ans_string += x + ', '
    return ans_string
@@;

$filter_tags = Python2::return_needed_tags(
    Callable<(List<String>?) -> String>,
    $script
);

$base =
select $filter_tags(a.tags) as tags
        , a.line as line
        , SUBSTRING(solved_dttm, 0, 10) as solved_dt
        , a.creation_dt as creation_dt
        , String::SplitToList(b.description, "\n")[1] as client
        , a.ticket_id as ticket_id
        , a.chatterbox_ticket as chatterbox_ticket
        , a.order_id as order_id
from `//home/taxi-analytics/hickinbottom/support/dwh/summary/support_tickets` as a
left join `//home/taxi-analytics/hickinbottom/support/dwh/private/support_tickets_description` as b
on a.ticket_id = b.ticket_id
where a.line in ('taxi_logistics_penalty', 'taxi_logistics_challenge')
;

$super_user =
SELECT
    ticket_id,
    substring(created_dttm,0,10) as created_dt,
    comment
FROM `home/taxi-analytics/hickinbottom/support/dwh/private/chatterbox_history`
WHERE
    meta_action == 'close'
    AND login == 'superuser'
    AND line IN ('taxi_logistics_penalty', 'taxi_logistics_challenge')
;

INSERT INTO `home/taxi-delivery/analytics/alena-lukina/delivery/fines/ticket_base`
WITH TRUNCATE
select b.ticket_id as ticket_id
, b.order_id as order_id
, line
, solved_dt
, coalesce(b.creation_dt, su.created_dt) as created_dt
, tags
, client
, case when su.ticket_id is not null then True else False end as super_user_flg
, su.comment as super_user_comment
from $base as b
left join $super_user as su on b.chatterbox_ticket == su.ticket_id
;