-- Claims

drop table if exists date_start;
drop table if exists executors;
drop table if exists claims;
drop table if exists b2b_deliveries;
drop table if exists old_o;
drop table if exists fct;
drop table if exists client_guide;
drop table if exists claim_cancels;

-- Шаг 1: Задаем дату начала и базу заказов корпов

create temporary table date_start as (
    select (date_trunc('month', current_date)::date - interval '4 week')::date as date_start
)
;

-- Шаг 2: fct_order
create temporary table fct as (
    select order_id, order_tariff, corp_client_name
    from summary.dm_order
    where utc_order_dt >= (select date_start from date_start)
      and order_tariff in ('courier', 'express', 'cargo', 'cargocorp')
      and not mqc_order_flg
      and corp_order_flg
      and corp_client_id not in
          (
           '4decd14f25424e8b82b6d3e4f56d23b2',
           'b2dc2b2e96f8482ba2d1582bd1445184',
           '87cda4c03d60416bb522e83fe24b3d50',
           'dc28c565829e48cca458b5feb161d5d6'
              )
)
;

-- Шаг 3: справочник B2B
create temporary table client_guide as (
    select corp_client_id,
           max(corp_client_name) as corp_client_name
    from summary.dm_order
    where utc_order_dt >= (select date_start from date_start)
      and order_tariff in ('courier', 'express', 'cargo', 'cargocorp')
    group by 1
    order by 1
);

-- Шаг 4: Собираем данные о заявках
create temporary table claims as (
    select *
    from delivery_ods_cargo_claims.claim as a
    where claim_id is not null
      and utc_created_dttm >= (select date_start from date_start)
      and corp_client_id not in
          (
           '4decd14f25424e8b82b6d3e4f56d23b2',
           'b2dc2b2e96f8482ba2d1582bd1445184',
           '87cda4c03d60416bb522e83fe24b3d50',
           'dc28c565829e48cca458b5feb161d5d6'
              )
);

-- Шаг 5: Собираем кол-во B2B мультиточек
create temporary table b2b_deliveries as (
    select claim_id,
           count(distinct claim_point_id) filter ( where csp.point_status = 'visited'
               and csp.point_type = 'destination' )                                       as b2b_deliveries,
           count(distinct claim_point_id) filter ( where csp.point_type = 'destination' ) as b2b_potential_deliveries
    from delivery_ods_cargo_claims.claim_segment as cs
             left join delivery_ods_cargo_claims.claim_segment_point as csp on cs.claim_segment_id = csp.claim_segment_id
    where csp.point_type = 'destination'
      and cs.claim_segment_id is not null
      and cs.utc_created_dttm >= (select date_start from date_start)
    group by 1
)
;

create temporary table claim_cancels as (
    with t1 as (
        select claim_id,
               min(utc_created_dttm) filter ( where new_claim_status = 'accepted')         as utc_accepted_dttm,
               min(utc_created_dttm) filter ( where new_claim_status = 'performer_lookup') as utc_performer_lookup_dttm,
               min(utc_created_dttm) filter ( where new_claim_status = 'performer_found')  as utc_performer_found_dttm,
               count(*) filter ( where new_claim_status = 'performer_lookup')              as for_reorder_cnt,
               min(utc_created_dttm) filter ( where new_claim_status
                                                        in ('cancelled',
                                                            'cancelled_with_payment',
                                                            'cancelled_with_items_on_hands')
                   and support_ticket_code is null)                                        as utc_user_cancel_dttm
        from delivery_ods_cargo_claims.claim_status_log
        where utc_created_dttm >= (date_trunc('month', current_date)::date - interval '4 week')::date
        group by 1
        order by 1
    )
    select claim_id,
           case
               when utc_accepted_dttm is not null and utc_user_cancel_dttm is not null
                   then (1.0 *
                         (EXTRACT(hour FROM (utc_user_cancel_dttm - utc_accepted_dttm)) *
                          60 * 60
                             +
                          EXTRACT(minutes FROM (utc_user_cancel_dttm - utc_accepted_dttm)) *
                          60
                             + EXTRACT(seconds FROM
                                       (utc_user_cancel_dttm - utc_accepted_dttm))) / 60)
               else Null end                                                        as from_accept_to_cancel_time_min,
           case
               when utc_performer_lookup_dttm is not null and utc_user_cancel_dttm is not null
                   then (1.0 *
                         (EXTRACT(hour FROM (utc_user_cancel_dttm - utc_performer_lookup_dttm)) *
                          60 * 60
                             +
                          EXTRACT(minutes FROM (utc_user_cancel_dttm - utc_performer_lookup_dttm)) *
                          60
                             + EXTRACT(seconds FROM
                                       (utc_user_cancel_dttm - utc_performer_lookup_dttm))) / 60)
               else Null end                                                        as from_lookup_to_cancel_time_min,
           case when for_reorder_cnt > 1 then True else False end                   as reorder_flg,
           case when utc_performer_lookup_dttm is not null then True else False end as performer_lookup_flg,
           case when utc_performer_found_dttm is not null then True else False end  as performer_found_flg,
           case when utc_user_cancel_dttm is not null then True else False end      as user_cancel_flg
    from t1
    where utc_accepted_dttm is not null
);

delete
from snb_taxi.ellenl_b2b_oper_dash_claims
where utc_created_dttm is null
   or utc_created_dttm >= (select date_start from date_start);


insert into snb_taxi.ellenl_b2b_oper_dash_claims (
    select claims.*
            ,
           b2b_deliveries
            ,
           b2b_potential_deliveries
            ,
           coalesce(order_tariff, 'not found')                              as order_tariff
            ,
           aggl_name_ru
            ,
           tz_country_name_ru
            ,
           case
               when claims.corp_client_id in (
                                              'b5e2e85dc2b4408e8a8f140313c2fd8b',
                                              'dca7971b1b62480cbb9441f165e73080'
                   ) then 'Яндекс.Маркет'
               when claims.corp_client_id in ('efd53f1437f7468fa55460fa58291648',
                                              '27751a2d0b534affb80d243bc2f68981',
                                              '51d9772dc9424a14b257920adc1b79fd') then 'ВкусВилл'
               when claims.corp_client_id = '287ba434c1724fdabf64f65393f00a2c' then 'Детский мир'
               when claims.corp_client_id in (
                                              'c092a390e4824110990bbe47c4e82994',
                                              '09174be32f2c4f1784d6428816957ff9'
                   ) then 'X5'
               when claims.corp_client_id in ('b57e4179dff24b00be2f8b505885a180') then 'SaveTime'
               when claims.corp_client_id in (
                                              '62c57fd1d95a484ea5214941f8a86f5c',
                                              'ec4181d4bf4b4668ba0ff8bfc0035514',
                                              '0a835ce6f7f442ee8a0979a254e518a7',
                                              '6abfa67fb37c451a99b50b9013304d2d',
                                              '3d0154c2ea084be6bcda5993d7b22f9a',
                                              '42f1aba9f0d7433283ada5e9d33721bb',
                                              '6c90ec14e5bd45fbb529075cf4aa3448',
                                              '8ecd46e1c2114b0abb372aa955fb4249',
                                              '8d3a1a128aef4c8496111c611e905db5',
                                              'f89efc3077244aab8e9e00dc7820310e',
                                              'a8a72b0eb4394542aae49ea3a5e3ca75',
                                              '02e89816627746078b18735d4565cea5',
                                              '1711a268651a489b913aad3e44c704d6',
                                              'e53d93f66ab8493896343357cee13c09',
                                              'c9116f5b5d804fd886bf81160ef17828',
                                              '17e1006bd0934dcea7d7dc7169ef88c2',
                                              'fc664815ee5049d59aa6d27ed07bd63a'
                   ) then 'Папа Джонс'
               when claims.corp_client_id in (
                                              'b7c7ea66c6b845949f8d99c82d74a123',
                                              '701418587a1b4904bbaedbe0bf0f2184',
                                              '9891e7167c8a431a84760c328b0c350d',
                                              'c9a72a8646f94f74b745dd61224385c2',
                                              '0bb21e6819204a339da73c964262f004',
                                              '5a669a1559604008b21cacde2e10575f',
                                              '59ff10b4b4794f6386c0d7ef299983a3',
                                              'd34f91d12a394faf983421f7fa2a1b2a',
                                              '23dd729f130c4efb843d046488689d2c',
                                              'ed541960f21e414bbec71ef44fa687fd',
                                              '5d2f32e85a7941ddbab5ae4c21a42381',
                                              'c7f9cf2ae0634da78cd43063ac9c093b',
                                              '5af5c0ec7fbf469c851b87374788773c',
                                              'a177c17c344f4733a16b2998f6936471',
                                              '8a6900e9f8d2496cb8ce81e44fa6dd4f',
                                              'b60c9a43d4fe4cba9af51f4d7bf94adb',
                                              '0ee87ed92995477aa0ee8bd226ff9d57',
                                              'd5a918c1a3154b128eb82405756126d6',
                                              '6be28076eb8743e18a343abc1e4e66e5',
                                              '20bc050114c54bbc8eef86d9fa028da1',
                                              'ed9f644cde934e3ea3cb6046537f12f9',
                                              '0e04432fb0134bc98207a96059865039',
                                              '54435221af934342bfcff0411bd9eaaf',
                                              '62f2cebe83d74d16b82d23fcfbc734ba',
                                              'd1ebe6c044954fd78e07c6e7b9b787ff',
                                              'ba5c7803d27743b1b95def44f0831e34',
                                              'ab78962ea3504e52abc0ba50ce89cc09',
                                              '68dfe2b571674ab785ffdb10d7c3be9d',
                                              '2776ca80857e4c5c80918b7e05d05742',
                                              '98736566b1c1430f82359b6a772a94b9',
                                              '65c5a6b442104082a86c2e0c6c8c6f11',
                                              'f40840cfbfbb4063a0d5177630b7f68a',
                                              '60e41fa079444b1db5f5230dd05c09f6',
                                              'f59e12053b194aec854cf1ba32cf5cab',
                                              'f4e7ec0fdb43438392075ad7143cf90b',
                                              '3702b54d33364d6393bf6be9454060af',
                                              'bb32fe14c86449f2baf18bbfc179d8cb',
                                              'b1fb21b5818f4e2e91e05f37dd665b2f',
                                              '8c621f1378e54fe7957ff387c415807e',
                                              'cfcd00b6c86741ae8040aff30f004da7',
                                              '095ca4fda0a949d6b9fb1bfe1e5b2ec6',
                                              '3195525e8e0342d397c20a13b41a6f4a',
                                              '0e055721818a43ac89b65ddbd1c9d795'
                   ) then 'Subway'
               else coalesce(fct.corp_client_name, cg.corp_client_name) end as corp_client_name,
           from_accept_to_cancel_time_min,
           from_lookup_to_cancel_time_min,
           reorder_flg,
           performer_lookup_flg,
           performer_found_flg,
           user_cancel_flg
    from claims
             left join b2b_deliveries b2bd on claims.claim_id = b2bd.claim_id
             left join (SELECT distinct tariff_zone, name_ru as aggl_name_ru, tz_country_name_ru
                        FROM taxi_cdm_geo.v_dim_op_geo_hierarchy
                        WHERE node_type = 'agglomeration') as geo on claims.tariff_zone = geo.tariff_zone
             left join fct on claims.taxi_order_id = fct.order_id
             left join client_guide as cg on cg.corp_client_id = claims.corp_client_id
             left join claim_cancels cc on claims.claim_id = cc.claim_id
);

