-- ОПЕРАЦИОННЫЙ ДЭШ ДОСТАВКИ
drop table if exists date_start;
drop table if exists executors;
drop table if exists claims;
drop table if exists b2b_deliveries;
drop table if exists old_o;
drop table if exists fct;
drop table if exists complaints_rating;
drop table if exists supply_plan;

-- Шаг 1: Задаем дату начала и базу заказов корпов

create temporary table date_start as (
    select (date_trunc('month', current_date)::date - interval '4 week')::date as date_start
)
;

create temporary table fct as (
    select distinct order_id
    from taxi_cdm_marketplace.fct_order
    where utc_order_created_dt >= (select date_start from date_start)
      and tariff_class_code in ('courier', 'express', 'cargo', 'cargocorp')
      and not mqc_order_flg
      and corp_order_flg
      and corp_client_id not in
          (
           '4decd14f25424e8b82b6d3e4f56d23b2',
           'b2dc2b2e96f8482ba2d1582bd1445184',
           '87cda4c03d60416bb522e83fe24b3d50',
           'dc28c565829e48cca458b5feb161d5d6'
              )
)
;

-- Шаг 2: Собираем информацию по исполнителям
create temporary table executors as (
    with raw_drivers as (
        select order_id,           -- case when candidate_status = 'expired' then True else False end as executor_not_found_flg,
               time_to_dest_sec,   -- Время до точки подачи по маршрутизатору, секунды
               utc_cancelled_dttm, -- Дата и время отмены заказа пользователем
               router_dist_m,      -- Расстояние до точки подачи по маршрутизатору, в метрах
               park_taximeter_id || '_' || executor_profile_id as dbid_uuid

        from taxi_cdm_supply.fct_order_candidate
        where order_id in (select order_id from fct)
    )
    select order_id                         as taxi_order_id
         , count(distinct dbid_uuid)        as potencial_executors_cnt
         , 1.0 * avg(time_to_dest_sec) / 60 as avg_time_to_a_min
         , 1.0 * avg(router_dist_m) / 1000  as avg_router_a_km
         , max(utc_cancelled_dttm)          as utc_cancelled_dttm
    from raw_drivers
    group by 1
);

-- Шаг 3: Собираем данные о заявках
create temporary table claims as (
    with t1 as (
        select claim_id, taxi_order_id, status_code
        from delivery_ods_cargo_claims.claim
        where taxi_order_id in (select order_id from fct)
          and taxi_order_id is not null
          and claim_id is not null
    )
    select taxi_order_id,
           count(claim_id)                                      as claims_cnt,
           count(claim_id)
           filter ( where status_code in ('delivered_finish') ) as claims_success_cnt,
           1.0 * count(claim_id)
                 filter ( where status_code in ('delivered_finish') ) /
           count(claim_id)                                      as claims_success_share
    from t1
    group by 1
);

-- Шаг 4: Собираем кол-во B2B мультиточек
create temporary table b2b_deliveries as (
    select taxi_order_id, count(distinct claim_point_id) as b2b_deliveries
    from delivery_ods_cargo_claims.claim_segment as cs
             left join delivery_ods_cargo_claims.claim_segment_point as csp on cs.claim_segment_id = csp.claim_segment_id
    where csp.point_status = 'visited'
      and csp.point_type = 'destination'
      and cs.taxi_order_id is not null
      and cs.taxi_order_id in (select order_id from fct)
      and cs.claim_segment_id is not null
    group by taxi_order_id
)
;

-- Шаг 5: Реордер по клеймам -- пока не умею считать

-- Шаг 6: supply_планы

create temporary table supply_plan as (
    select distinct order_id
                  , order_supply_plan
    from snb_taxi.ellenl_orders_export_gp as a
    where utc_order_dttm::date >= (select date_start from date_start)
      and order_id in (select order_id from fct)
);

-- Шаг 7: complaints
create temporary table complaints_rating as (
    with t1 as (
        select order_id,
               user_rating_value,
               courier_rating_value,
               case
                   when defect_reason_code = 'review_rules' then coalesce(complaint_category_list, defect_reason_code)
                   when complaint_category_list = 'Другое' then 'Другое: расшифровки нет'
                   else defect_reason_code end as defect_reason_code_corrected
        from snb_taxi.ellenl_operdash_orders_support
    )
    select order_id,
           user_rating_value,
           courier_rating_value,
           defect_reason_code_corrected,
           case
               when defect_reason_code_corrected not in ('review_rules') then True
               else False end
               as complaint_order_flg
    from t1
)
;

-- Шаг 8: Собираем данные из старого dm_order
create temporary table old_o as (
    select order_id                          as taxi_order_id,
           corp_client_name,
           utc_start_transporting_dttm,
           utc_start_waiting_dttm,
           utc_order_complete_dttm,
           case
               when utc_start_waiting_dttm is not null and utc_order_dttm is not null
                   and order_type = 'soon'
                   then (1.0 *
                         (EXTRACT(hour FROM (utc_start_waiting_dttm - utc_order_dttm)) *
                          60 * 60
                             +
                          EXTRACT(minutes FROM (utc_start_waiting_dttm - utc_order_dttm)) *
                          60
                             + EXTRACT(seconds FROM
                                       (utc_start_waiting_dttm - utc_order_dttm))) / 60)
               else Null end                 as eta_min,
           case
               when utc_start_transporting_dttm is not null and utc_start_waiting_dttm is not null
                   then (1.0 *
                         (EXTRACT(hour FROM (utc_start_transporting_dttm - utc_start_waiting_dttm)) *
                          60 * 60
                             +
                          EXTRACT(minutes FROM (utc_start_transporting_dttm - utc_start_waiting_dttm)) *
                          60
                             + EXTRACT(seconds FROM
                                       (utc_start_transporting_dttm - utc_start_waiting_dttm))) / 60)
               else Null end                 as waiting_time_min,
           case
               when utc_start_transporting_dttm is not null and utc_order_complete_dttm is not null
                   then (1.0 *
                         (EXTRACT(hour FROM (utc_order_complete_dttm - utc_start_transporting_dttm)) *
                          60 * 60
                             +
                          EXTRACT(minutes FROM (utc_order_complete_dttm - utc_start_transporting_dttm)) *
                          60
                             + EXTRACT(seconds FROM
                                       (utc_order_complete_dttm - utc_start_transporting_dttm))) / 60)
               else Null end                 as transporting_time_min,
           order_cost * currency_rate        as gmv,
           net_inflow * currency_rate        as net_inflow,
           driver_net_income * currency_rate as driver_net_income
    from summary.dm_order
    where utc_order_dt >= (select date_start from date_start)
      and order_id in (select order_id from fct)
);

delete
from snb_taxi.ellenl_b2b_operational_dash
where utc_order_created_dt >= (select date_start from date_start)
;

-- Шаг 9: Собираем базу по заказу Такси
insert into snb_taxi.ellenl_b2b_operational_dash (
    select o.order_id
         , c.claims_cnt                                                                  as claims_cnt
         , c.claims_success_cnt                                                          as claims_success_cnt
         , c.claims_success_share                                                        as claims_success_share
         , success_order_flg
         , user_status
         , driver_status
         , case
               when
                   user_status = 'cancelled' then True
               else False end                                                            as user_cancel_flg
         , case
               when
                   user_status = 'finished' and driver_status = 'failed'
                   then True
               else False end                                                            as driver_cancel_flg
         , paid_supply_flg                                                                                          -- -- проверить логику с Витей
--     ,                                                                                          -- скольких рассматривали
         , coalesce(potencial_executors_cnt, 0)                                          as potencial_executors_cnt -- скольким предложили оффер
         , avg_time_to_a_min                                                                                        -- среднее время подачи
         , avg_router_a_km                                                                                          -- среднее расстояние подачи до кандидатов
         , case
               when utc_cancelled_dttm is not null
                   then (1.0 * (EXTRACT(hour FROM (utc_cancelled_dttm - utc_order_created_dttm)) * 60 * 60
                   + EXTRACT(minutes FROM (utc_cancelled_dttm - utc_order_created_dttm)) * 60
                   + EXTRACT(seconds FROM (utc_cancelled_dttm - utc_order_created_dttm))) / 60)
               else Null end                                                             as time_before_cancel_min  -- сколько времени прошло до отмены пользователем с момента создания заказа
         , source_geohash                                                                                           -- координаты -- жду ответ от Лили (как быть с батчами?)
         , split_part(trim(both '()' from (trim('POINT' from (ST_AsText(ST_PointFromGeoHash(source_geohash)))))), ' ',
                      1)                                                                 as source_lon
         , split_part(trim(both '()' from (trim('POINT' from (ST_AsText(ST_PointFromGeoHash(source_geohash)))))), ' ',
                      2)                                                                 as source_lat
         , source_address
         , coalesce(order_supply_plan,
                    trim(both '{}' from order_requirement_list))                         as supply_plans            -- проверить логику с Витей
         , case when a.taxi_order_id is not null then True else False end                as reorder_flg             -- flg является ли заказ реордером
         , expired_order_flg                                                                                        -- expired - на найден исполнитель на заказ
         , paid_cancel_order_flg                                                                                    -- плтаная отмена
         , tariff_class_fallback_flg
         , o.corp_client_id
         , case
               when o.corp_client_id in (
                                         'b5e2e85dc2b4408e8a8f140313c2fd8b',
                                         'dca7971b1b62480cbb9441f165e73080'
                   ) then 'Яндекс.Маркет'
               when o.corp_client_id in ('efd53f1437f7468fa55460fa58291648',
                                        '27751a2d0b534affb80d243bc2f68981',
                                        '51d9772dc9424a14b257920adc1b79fd') then 'ВкусВилл'
               when o.corp_client_id = '287ba434c1724fdabf64f65393f00a2c' then 'Детский мир'
               when o.corp_client_id in (
                                        'c092a390e4824110990bbe47c4e82994',
                                        '09174be32f2c4f1784d6428816957ff9'
                                        ) then 'X5'
               when o.corp_client_id in ('b57e4179dff24b00be2f8b505885a180') then 'SaveTime'
               when o.corp_client_id in (
                                         '62c57fd1d95a484ea5214941f8a86f5c',
                                         'ec4181d4bf4b4668ba0ff8bfc0035514',
                                         '0a835ce6f7f442ee8a0979a254e518a7',
                                         '6abfa67fb37c451a99b50b9013304d2d',
                                         '3d0154c2ea084be6bcda5993d7b22f9a',
                                         '42f1aba9f0d7433283ada5e9d33721bb',
                                         '6c90ec14e5bd45fbb529075cf4aa3448',
                                         '8ecd46e1c2114b0abb372aa955fb4249',
                                         '8d3a1a128aef4c8496111c611e905db5',
                                         'f89efc3077244aab8e9e00dc7820310e',
                                         'a8a72b0eb4394542aae49ea3a5e3ca75',
                                         '02e89816627746078b18735d4565cea5',
                                         '1711a268651a489b913aad3e44c704d6',
                                         'e53d93f66ab8493896343357cee13c09',
                                         'c9116f5b5d804fd886bf81160ef17828',
                                         '17e1006bd0934dcea7d7dc7169ef88c2',
                                         'fc664815ee5049d59aa6d27ed07bd63a'
                   ) then 'Папа Джонс'
               when o.corp_client_id in (
                                         'b7c7ea66c6b845949f8d99c82d74a123',
                                         '701418587a1b4904bbaedbe0bf0f2184',
                                         '9891e7167c8a431a84760c328b0c350d',
                                         'c9a72a8646f94f74b745dd61224385c2',
                                         '0bb21e6819204a339da73c964262f004',
                                         '5a669a1559604008b21cacde2e10575f',
                                         '59ff10b4b4794f6386c0d7ef299983a3',
                                         'd34f91d12a394faf983421f7fa2a1b2a',
                                         '23dd729f130c4efb843d046488689d2c',
                                         'ed541960f21e414bbec71ef44fa687fd',
                                         '5d2f32e85a7941ddbab5ae4c21a42381',
                                         'c7f9cf2ae0634da78cd43063ac9c093b',
                                         '5af5c0ec7fbf469c851b87374788773c',
                                         'a177c17c344f4733a16b2998f6936471',
                                         '8a6900e9f8d2496cb8ce81e44fa6dd4f',
                                         'b60c9a43d4fe4cba9af51f4d7bf94adb',
                                         '0ee87ed92995477aa0ee8bd226ff9d57',
                                         'd5a918c1a3154b128eb82405756126d6',
                                         '6be28076eb8743e18a343abc1e4e66e5',
                                         '20bc050114c54bbc8eef86d9fa028da1',
                                         'ed9f644cde934e3ea3cb6046537f12f9',
                                         '0e04432fb0134bc98207a96059865039',
                                         '54435221af934342bfcff0411bd9eaaf',
                                         '62f2cebe83d74d16b82d23fcfbc734ba',
                                         'd1ebe6c044954fd78e07c6e7b9b787ff',
                                         'ba5c7803d27743b1b95def44f0831e34',
                                         'ab78962ea3504e52abc0ba50ce89cc09',
                                         '68dfe2b571674ab785ffdb10d7c3be9d',
                                         '2776ca80857e4c5c80918b7e05d05742',
                                         '98736566b1c1430f82359b6a772a94b9',
                                         '65c5a6b442104082a86c2e0c6c8c6f11',
                                         'f40840cfbfbb4063a0d5177630b7f68a',
                                         '60e41fa079444b1db5f5230dd05c09f6',
                                         'f59e12053b194aec854cf1ba32cf5cab',
                                         'f4e7ec0fdb43438392075ad7143cf90b',
                                         '3702b54d33364d6393bf6be9454060af',
                                         'bb32fe14c86449f2baf18bbfc179d8cb',
                                         'b1fb21b5818f4e2e91e05f37dd665b2f',
                                         '8c621f1378e54fe7957ff387c415807e',
                                         'cfcd00b6c86741ae8040aff30f004da7',
                                         '095ca4fda0a949d6b9fb1bfe1e5b2ec6',
                                         '3195525e8e0342d397c20a13b41a6f4a',
                                         '0e055721818a43ac89b65ddbd1c9d795'
                   ) then 'Subway'
               else corp_client_name end                                                 as corp_client_name
         , work_mode_code
         , transporting_distance_plan_km
         , old_o.waiting_time_min                                                        as waiting_time_min
         , old_o.transporting_time_min                                                   as transporting_min
         , 25                                                                            as driving_time_min
         , order_comment                                                                 as comment_in_a
         , 'random_text B'                                                               as comment_in_b
         , case
               when b2b.taxi_order_id is not null then
                   coalesce(b2b.b2b_deliveries, 1)
               when o.destination_plan_geohash_cnt >= 1 then
                   o.destination_plan_geohash_cnt
               else 1 end                                                                as deliveries_cnt
         , utc_order_created_dttm
         , utc_order_created_dt
         , utc_order_created_dttm + interval '3 hours'                                   as moscow_order_dttm
         , first_yandex_order_flg
         , old_o.gmv                                                                     as gmv
         , old_o.net_inflow                                                              as net_inflow
         , old_o.driver_net_income                                                       as driver_net_income
         , country_name_ru
         , geo.aggl_name_ru                                                              as aggl_name_ru
         , tariff_geo_zone_code
         , tariff_class_code
         , order_type
         , eta_min
         , coalesce(user_rating_value::double precision, rating_value::double precision) as user_rating_value
         , courier_rating_value::double precision                                        as courier_rating_value
         , coalesce(defect_reason_code_corrected::text, rating_reason_list::text)        as defect_reason_code_corrected
         , complaint_order_flg
         , coalesce(delivery_contract_flg, False)                                        as delivery_contract_flg
    from taxi_cdm_marketplace.fct_order as o
             left join (select distinct order_id as taxi_order_id
                        from ods.mdb_order_status_update
                        where utc_order_created_dttm >= (select date_start from date_start)
                          and status in ('reorder', 'autoreorder')) as a
                       on o.order_id = a.taxi_order_id
             left join executors as e on o.order_id = e.taxi_order_id
             left join claims as c on o.order_id = c.taxi_order_id
             left join b2b_deliveries as b2b on o.order_id = b2b.taxi_order_id
             left join old_o on o.order_id = old_o.taxi_order_id
             left join (SELECT distinct node_id, name_ru as aggl_name_ru
                        FROM taxi_cdm_geo.v_dim_op_geo_hierarchy
                        WHERE node_type = 'agglomeration') as geo on o.agglomeration_node_id = geo.node_id
             left join complaints_rating as support on o.order_id = support.order_id
             left join supply_plan as sp on o.order_id = sp.order_id
             left join snb_taxi.ellenl_operdash_delivery_contacts as dc on dc.corp_client_id = o.corp_client_id

    where utc_order_created_dt >= (select date_start from date_start)
      and o.order_id in (select order_id from fct)
)
;
