import sys
import os
import pandas as pd
import numpy as np
import requests
import json
from business_models import hahn
from business_models.greenplum import GreenplumManager

if __name__=='__main__':

    with open('support_base.sql', 'r') as reader:
        query = reader.read()
    hahn(query, syntax_version=1)

    greenplum = GreenplumManager(user='alena-lukina',
                                 token=str(os.environ['GP_TOKEN']),
                                 connect_args={'sslmode': 'require'})

    greenplum.replicate(yt_path='//home/taxi-delivery/analytics/alena-lukina/delivery/oper_dash/order_base',
                        table_name='snb_taxi.ellenl_operdash_orders_support',
                        if_exists='replace')
    greenplum(
        'GRANT all privileges ON snb_taxi.ellenl_operdash_orders_support TO "alena-lukina", "robot-taxi-business"'
    )

    greenplum('GRANT SELECT ON snb_taxi.ellenl_operdash_orders_support TO analyst')

    with open('delivery_contracts.sql', 'r') as reader1:
        query1 = reader1.read()
    hahn(query1, syntax_version=1)

    greenplum.replicate(yt_path='//home/taxi-delivery/analytics/alena-lukina/delivery/oper_dash/delivery_contracts',
                        table_name='snb_taxi.ellenl_operdash_delivery_contacts',
                        if_exists='replace')
    greenplum(
        'GRANT all privileges ON snb_taxi.ellenl_operdash_delivery_contacts TO "alena-lukina", "robot-taxi-business"'
    )

    greenplum('GRANT SELECT ON snb_taxi.ellenl_operdash_delivery_contacts TO analyst')

    with open('orders.sql') as o:
        sql = o.read()
    greenplum(sql)

    with open('claims.sql') as c:
        sql1 = c.read()
    greenplum(sql1)
